/*
 * detect.c
 *
 * autodetect the modemtype we are connected to.
 *
 */

#include "../include/voice.h"

char *libvoice_detect_c = "$Id: detect.c,v 1.6 1996/08/06 19:50:27 marc Exp $";

struct modem_type_struct
     {
     char *ati_code;
     int modem_type;
     };

static struct modem_type_struct modem_database[] =
     {
     {"1.04",  CIRRUS_LOGIC},
     {"144",   UMC},
     {"282",   ELSA},
     {"1443",  DOLPHIN},
     {"1445",  US_ROBOTICS},
     {"1496",  ZYXEL_1496},
     {"2864",  ZYXEL_2864},
     {"2886",  US_ROBOTICS},
     {"3361",  US_ROBOTICS},
     {"3366",  US_ROBOTICS},
     {"14400", ROCKWELL},
     {"28641",  ZYXEL_2864},
     {"28642",  ZYXEL_2864},
     {"28643",  ZYXEL_2864},
     {"28800", DR_NEUHAUS},
     {NULL,    0}
     };

int voice_detect_modemtype _P0(void)
     {
     char buffer[VOICE_BUF_LEN];

     lprintf(L_MESG, "detecting voice modem type");

     /*
      * Do we have to probe for a voice modem or was it preset?
      */

     if (voice_modem != SERIAL_PORT)
          {
          lprintf(L_NOISE, "voice modem type was set directly");
          return(OK);
          }
     else
          {
          int i;

          /*
           * First of all, let's see if a modem is connected and answering
           * and also initialize the modem to echo the commands back to the
           * host.
           */

          if ((voice_command("ATE1", "OK|ATE1") & VMA_USER) == VMA_USER)
               {
               voice_flush(1);
               voice_modem = GENERIC_MODEM;
               voice_modem_name = "modem";
               lprintf(L_NOISE, "modem detected");
               }
          else
               {
               lprintf(L_FATAL, "modem detection failed");
               exit(FAIL);
               };

          /*
           * What does the modem answer to the ATI command?
           */

          voice_command("ATI", "");

          do
               {
               voice_read(buffer);

               for (i = 0; ((modem_database[i].ati_code != NULL) &&
                (voice_modem == GENERIC_MODEM)); i++)

                    if (strcmp(buffer, modem_database[i].ati_code) == 0)
                         voice_modem = modem_database[i].modem_type;

               }
          while ((voice_modem == GENERIC_MODEM) && (voice_analyze(buffer,
           "") != VMA_FAIL));

          voice_flush(1);
          };

     /*
      * Fix me! Ugly hack to distinguish between Dr. Neuhaus and
      * Rockwell modems reporting both 28800 on ATI
      */

     if ((voice_modem == DR_NEUHAUS) &&
      (voice_command("ATI6", "OK|RCV288") == VMA_USER_2))
          {
          voice_flush(1);
          voice_modem = ROCKWELL;
          };

     switch (voice_modem)
          {
          case CIRRUS_LOGIC:

               /*
                * It's a Cirrus Logic based modem
                */

               voice_modem_name = "Cirrus Logic";
               voice_modem_handle_event = Cirrus_Logic_handle_event;
               voice_modem_type = "Cirrus Logic";
               lprintf(L_MESG, "Cirrus Logic modem detected");
               return(OK);

          case DOLPHIN:

               /*
                * It's a Dolphin
                */

               voice_modem_name = "Dolphin";
               voice_modem_handle_event = Dolphin_handle_event;
               voice_modem_type = "Dolphin";
               lprintf(L_MESG, "Dolphin modem detected");
               return(OK);

          case DR_NEUHAUS:

               /*
                * It's a Dr. Neuhaus Cybermod 28.8 V.34
                */

               voice_modem_name = "Dr. Neuhaus Cybermod";
               voice_modem_handle_event = Dr_Neuhaus_handle_event;
               voice_modem_type = "Dr. Neuhaus";
               lprintf(L_MESG, "Dr. Neuhaus Cybermod detected");
               return(OK);

          case ELSA:

               /*
                * It's an Elsa MicroLink 28.8 TQV
                */

               voice_modem_name = "Elsa MicroLink 28.8 TQV";
               voice_modem_handle_event = Elsa_handle_event;
               voice_modem_type = "Elsa MicroLink";
               lprintf(L_MESG, "Elsa MicroLink 28.8 TQV detected");
               return(OK);

          case ROCKWELL:

               /*
                * It's a Rockwell based modem
                */

               voice_modem_name = "Rockwell";
               voice_modem_handle_event = Rockwell_handle_event;
               voice_modem_type = "Rockwell";
               lprintf(L_MESG, "Rockwell modem detected");
               return(OK);

          case UMC:

               /*
                * It's an UMC V.32bis/FAX/VOICE MODEM (UM92144EF),
                * e.g. Creatix PhoneMaster 144VFi
                */

               if (voice_command("ati4","UMC V.32bis/FAX/VOICE MODEM") ==
                VMA_USER_1)
                    {
                    voice_modem_name = "Creatix PhoneMaster 144VFi";
                    voice_modem_handle_event = UMC_handle_event;
                    voice_modem_type = "UMC:UM92144EF";
                    lprintf(L_MESG, "Creatix PhoneMaster 144VFi detected");
                    return(OK);
                    };

               break;

          case US_ROBOTICS:

               /*
                * It's a US Robotics based modem
                */

               voice_modem_name = "US Robotics";
               voice_modem_handle_event = US_Robotics_handle_event;
               voice_modem_type = "US Robotics";
               lprintf(L_MESG, "US Robotics modem detected");
               return(OK);

          case ZYXEL_1496:

               /*
                * It's a ZyXEL 1496
                */

               voice_command("ATI1", "");
               voice_read(buffer);
               voice_read(buffer);
               voice_flush(1);
               voice_modem_name = malloc(20);
               voice_modem_handle_event = ZyXEL_1496_handle_event;
               sprintf(voice_modem_name, "ZyXEL %c%c%c%c%c%c", buffer[0],
                buffer[1], buffer[2], buffer[3], buffer[4], buffer[5]);
               rom_release = 100 * (buffer[10] - '0') + 10 *
                (buffer[12] - '0') + (buffer[13] - '0');
               voice_modem_type = "ZyXEL 1496";
               lprintf(L_MESG, "%s with rom release %4.2f detected",
                voice_modem_name, rom_release / 100.0);
               return(OK);

          case ZYXEL_2864:

               /*
                * It's a ZyXEL 2864
                */

               voice_modem_name = "ZyXEL 2864";
               voice_modem_handle_event = ZyXEL_2864_handle_event;
               voice_modem_type = "ZyXEL 2864";
               lprintf(L_MESG, "ZyXEL 2864 detected");
               return(OK);

          };

     voice_flush(1);
     voice_modem = SERIAL_PORT;
     lprintf(L_ERROR, "no voice modem detected");
     return(FAIL);
     };
