/*
 * sine.c
 *
 */

#include "../include/voice.h"

char *libpvf_sine_c = "$Id: sine.c,v 1.2 1996/07/25 19:22:07 marc Exp $";

int
pvfsine _P2((argc, argv), int argc, char **argv ) {
    FILE *out=stdout;
    double freq;
    int time, i;

    if( argc<=2 ) USAGE("<time> <frequency>");

    time=(int)(RATE*atof(argv[1]));
    freq=atof(argv[2]);

    if( !time || !freq ) USAGE("<time> <frequency>");

    for(i=0; i<time; i++ ) {
     int d;

     d=(int)(sin((double)i *2*M_PI * freq / RATE)*0x7fff);
     zput(d, out );
    }
    return 0;
}

