/******************************************************************************/
/*      Definitions of types and constants used by latex2lyx                  */
/******************************************************************************/

#include <stdio.h>

/*============================================================================*/
/*      Node - All tree nodes are composed of this type                       */
/*============================================================================*/

typedef struct _node_ {
    int      	   last;  /* if != 0 next is pointing to his father           */
    struct _node_  *next; /* points to his brother at right or to his father  */
    struct _node_  *down; /* points to his son                                */
    struct _node_  *lson; /* points to the last son			      */
    int   	   token; /* define what this node represent                  */
    union NodeSpecificData {
        char           *ptr;   /* Used to hold Constants buffer pointers      */
        int	       spec;   /* Or to specify which latex command	      */
    } data;
} Node;

/*============================================================================*/
/*      Nonterminals - Constants definitions                                  */
/*============================================================================*/

#define         L_latex         300
#define         L_word_list     301
#define         L_latex_nop	302
#define         L_latex_1op	303
#define         L_latex_2op	304
#define         L_latex_3op	305
#define         L_latex_4op	306
#define 	L_optional_spec 307



/*============================================================================*/
/*      Global variables and constants                                        */  
/*============================================================================*/

extern int 	linecounter;     /* To indicate location of erros             */
extern int 	errorcounter;    /* Nunber of error detected during comp.     */
extern char 	*DocStyleName[];
extern char	*HeadingName[];
extern char 	*FontShapeName[];
extern char 	*FontShapeMathName[];
extern char	*FontSizeName[];
extern char 	*EnvironmentName[];
extern char 	*MathGreekName[];
extern char  	*MathSymbolName[];
extern char 	*MathDelimName[];
extern char	*CommandName[];
extern int	fam_stack[], ser_stack[], shp_stack[], siz_stack[], bar_stack[];
extern int	fam_top, ser_top, shp_top, siz_top, bar_top;
extern int	family,  series,  shape,   size,    bar;

typedef enum {
    ARTICLE, BOOK, REPORT, LETTER} DocStyle;
typedef enum {
    PART, CHAPTER, SECTION, SUBSEC, SUBSUB, PARAGRAPH, SUBPARA} Heading;
typedef enum {
    EM, TT, SC, SL, SF, BF, RM, IT, UP, MD, CAL} FontShape;
typedef enum {
    TINY, SCRIPTSIZE, FOOTNOTESIZE, SMALL, NORMALSIZE, LARGE, LARGER, LARGEST,
    HUGE, HUGER} FontSize;
typedef enum {
    ABSTRACT, ARRAY, CENTER, DESCRIPTION, DISPLAYMATH, DOCUMENT, ENUMERATE, 
    EQNARRAY, EQNARRAYs, EQUATION, FIGURE, FLUSHLEFT, FLUSHRIGHT, ITEMIZE,
    LIST, MATH, MINIPAGE, PICTURE, QUOTATION, QUOTE, SLOPPYPAR, TABBING, 
    TABLE, TABULAR, THEBIBLIOGRAPHY, THEINDEX, TITLEPAGE, TRIVLIST, 
    VERBATIN, VERSE} Environment;
typedef enum {
    ALPHA, BETA, GAMMA, DELTA, EPSILON, VAREPSILON, ZETA, ETA, THETA, VARTHETA,
    IOTA, KAPPA, LAMBDA, MU, NU, XI, PI, VARPI, RHO, VARRHO, SIGMA, VARSIGMA,
    TAU, UPSILON, PHI, VARPHI, CHI, PSI, OMEGA, uGAMMA, uDELTA, uTHETA, uLAMBDA, 
    uXI, uPI, uSIGMA, uUPSILON, uPHI, uPSI, uOMEGA} MathGreek;
typedef enum {
    LDOTS, VDOTS, CDOTS, DDOTS, PM, MP, TIMES, DIV, AST, STAR, CIRC, BULLET, 
    CDOT, CAP, CUP, UPLUS, SQCAP, SQCUP, VEE, WEDGE, SETMINUS, WR, DIAMOND,
    BIGTRIANGLEUP, BIGTRIANGLEDOWN, TRIANGLELEFT, TRIANGLERIGHT, LHD, RHD,
    UNLHD, UNRHD, OPLUS, OMINUS, OTIMES, OSLASH, ODOT, BIGCIRC, DAGGER,
    DDAGGER, AMALG, LEQ, PREQ, PRECEQ, LL, SUBSET, SUBSETEQ, SQSUBSET, 
    SQSUBSETEQ, IN, VDASH, GEQ, SUCC, SUCEQ, GG, SUPSET, SUPSETEQ, SQSUPSET,
    SQSUPSETEQ, NI, DASHV, EQUIV, SIM, SIMEQ, ASYMP, APPROX, CONG, NEQ, DOTEQ,
    PROPTO, MODELS, PERP, MID, PARALLEL, BOWTIE, uJOIN, SMILE, FROWN,
    LEFTARROW, uLEFTARROW, RIGHTARROW, uRIGHTARROW, LEFRIGHTTARROW, 
    uLEFRIGHTTARROW, LONGLEFTARROW, uLONGLEFTARROW, LONGRIGHTARROW, 
    uLONGRIGHTARROW, LONGLEFRIGHTTARROW, uLONGLEFRIGHTTARROW, UPARROW, 
    uUPARROW, DOWNARROW, uDOWNARROW, UPDOWNARROW, uUPDOWNARROW, 
    NEARROW, SEARROW, SWARROW, NWARROW, MAPSTO, LONGMAPSTO, LEADSTO, 
    HOOKLEFTARROW, LEFTHARPOONUP, RIGHTHARPOONUP, LEFTHARPOONDOWN, 
    RIGHTHARPOONDOWN, RIGHTLEFTHARPOONS, 
    ALEPH, HBAR, IMATH, JMATH, ELL, WP, uRE, uIM, MHO, PRIME, EMPTYSET, NABLA,
    SURD, TOP, BOT, lOR, ANGLE, FORALL, EXISTS, NEG, FLAT, NATURAL, SHARP, 
    BACKSLASH, PARTIAL, INFTY, uBOX, uDIAMOND, TRIANGLE, CLUBSUIT, 
    DIAMONDSUIT, HEARTSUIT, SPADESUIT, SUM, PROD, COPROD, INT, OINT, BIGCAP,
    BIGCUP, BIGSQCUP, BIGVEE, BIGWEDGE, BIGDOT, BIGOTIMES, BIGOPLUS, BIGUPLUS,
    BMOD, ARCCOS, ARCSIN, ARCTAN, ARG, COS, COSH, COT, COTH, CSC, DEG, DET,
    DIM, EXP, GCD, HOM, INF, KER, LG, LIM, LIMINF, LIMSUP, LN, LOG, MAX, 
    MIN, uPR, SEC, SIN, SINH, TAN, TANH} MathSymbol;
typedef enum {
    LFLOOR, RFLOOR, LCEIL, RCELI, LANGLE, RANGLE, LCURLY, RCURLY} MathDelim;


/*============================================================================*/
/*      Prototypes of all functions                                           */
/*============================================================================*/

int             yyerror ();
void		print_lyx (FILE *fout, Node *start, Node *tree);
void		print_table (FILE *fout, Node *start, Node *t, char *ctrl);
inline void	push (int *stack, int *top, int data);
inline int	pop  (int *stack, int *top);

/****** Node manipulation routines */
Node            *push_node (Node *n);
Node            *pop_node (void);
Node            *create_node (int c);
Node            *append_node (Node *n);
Node            *insert_node (Node *n);
Node            *merge_nodes (Node *n);
Node            *build_tree (int i);
Node            *print_tree (Node *n, int d);
Node            *make_list (int token, Node *list, Node *n);
inline Node	*pack_latex_nop (int spec);
inline Node	*pack_latex_1op (Node *data1, int spec);
inline Node	*pack_latex_2op (Node *data1, Node *data2, int spec);
inline Node	*pack_latex_3op (Node *data1, Node *data2, Node *data3, int spec);
inline Node	*pack_latex_4op (Node *data1, Node *data2, Node *data3, Node *data4, 
				 int spec);



