/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** varNodeList.c
**
** based on list_template.c
**
** where T has T_equal (or change this) and T_unparse
*/

# include "lclintMacros.nf"
# include "llbasic.h"

varNodeList varNodeList_new ()
{
  varNodeList s = (varNodeList) dmalloc (sizeof (*s));

  s->nelements = 0;
  s->nspace = varNodeListBASESIZE;
  s->elements = (varNode *)
    dmalloc (sizeof (*s->elements) * varNodeListBASESIZE);

  return (s);
}

static void
varNodeList_grow (varNodeList s)
{
  int i;
  varNode *newelements; 

  s->nspace = varNodeListBASESIZE + s->nspace;
  newelements = (varNode *) dmalloc (sizeof (*newelements)
				     * (s->nelements + varNodeListBASESIZE));

  for (i = 0; i < s->nelements; i++)
    {
      newelements[i] = s->elements[i]; 
    }

  sfree (s->elements); 
  s->elements = newelements;
}

varNodeList 
varNodeList_add (varNodeList s, varNode el)
{
  if (s->nspace <= 0)
    varNodeList_grow (s);

  s->nspace--;
  s->elements[s->nelements] = el;
  s->nelements++;
  return s;
}

cstring
varNodeList_unparse (varNodeList s)
{
  int i;
  cstring st = cstring_undefined;
  bool first = TRUE;

  for (i = 0; i < s->nelements; i++)
    {
      cstring type = cstring_undefined;
      varNode current = s->elements[i];

      if (current->isObj)
	{
	  type = cstring_makeLiteral ("obj ");
	}

      if (current->type != NULL)
	{
	  type = message (": %q%q", type, lclTypeSpecNode_unparse (current->type));
	}

      if (first)
	{
	  st = type;
	  first = FALSE;
	}
      else
	{
	  st = message ("%q, %q", st, type);
	}
    }

  return st;
}

void
varNodeList_free (varNodeList s)
{
  int i;
  for (i = 0; i < s->nelements; i++)
    {
      varNode_free (s->elements[i]); 
    }

  sfree (s->elements);
  sfree (s);
}

varNodeList
varNodeList_copy (varNodeList s)
{
  varNodeList ret = varNodeList_new ();

  varNodeList_elements (s, el)
    {
      ret = varNodeList_add (ret, varNode_copy (el));
    } end_varNodeList_elements;

  return ret;
}
