/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** lsymbolList.c
**
** based on list_template.c
**
** where T has T_equal (or change this) and T_unparse
*/

# include "lclintMacros.nf"
# include "llbasic.h"

/*@only@*/ lsymbolList
lsymbolList_new ()
{
  lsymbolList s = (lsymbolList) dmalloc (sizeof (*s));
  
  s->nelements = 0;

  s->nspace = lsymbolListBASESIZE;
  s->elements = (lsymbol *) dmalloc (sizeof (*s->elements) * lsymbolListBASESIZE);

  return (s);
}

static void
lsymbolList_grow (lsymbolList s)
{
  int i;
  lsymbol *newelements;

  s->nspace = lsymbolListBASESIZE + s->nspace;
  
   newelements = (lsymbol *) dmalloc (sizeof (*newelements) * (s->nelements + lsymbolListBASESIZE));

  if (newelements == (lsymbol *) 0)
    {
      llfatalerror (cstring_makeLiteral ("lsymbolList_grow: out of memory!"));
    }

  for (i = 0; i < s->nelements; i++)
    {
      newelements[i] = s->elements[i];
    }

  sfree (s->elements);
  s->elements = newelements;
}

void 
lsymbolList_addh (lsymbolList s, lsymbol el)
{
  if (s->nspace <= 0)
    lsymbolList_grow (s);

  s->nspace--;
  s->elements[s->nelements] = el;
  s->nelements++;
}

void
lsymbolList_free (lsymbolList s)
{
  int i;
  for (i = 0; i < s->nelements; i++)
    {
     /*      lsymbol_free (s->elements[i]); */
    }

  sfree (s->elements);	     
  sfree (s);
}

