/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
/*
** sRefTable.h
**
** based on sRefSet.h
*/

# ifndef sRefTABLE_H
# define sRefTABLE_H

typedef /*@owned@*/ sRef ow_sRef;

abst_typedef /*@null@*/ struct _sRefTable
{
  int entries;
  int nspace;
  /*@reldef@*/ /*@relnull@*/ ow_sRef *elements;
} *sRefTable;

/*@constant int sRefTableBASESIZE; @*/
# define sRefTableBASESIZE HUGEBASESIZE

/*@constant null sRefTable sRefTable_undefined; @*/
# define sRefTable_undefined ((sRefTable) NULL)

extern /*@truenull@*/ bool sRefTable_isNull (sRefTable s) /*@*/ ;
extern /*@truenull@*/ bool sRefTable_isEmpty (/*@sef@*/ sRefTable s) /*@*/ ;
extern /*@unused@*/ /*@falsenull@*/ bool 
  sRefTable_isDefined (sRefTable s) /*@*/ ;

# define sRefTable_isNull(s) ((s) == sRefTable_undefined)
# define sRefTable_isDefined(s) ((!sRefTable_isNull(s)))

# define sRefTable_isEmpty(s) ((s) == sRefTable_undefined || ((s)->entries == 0))

extern /*@unused@*/ /*@only@*/ cstring sRefTable_unparse (sRefTable s) /*@*/ ;
extern void sRefTable_free (/*@only@*/ sRefTable s) /*@modifies s@*/;
extern void sRefTable_clear (sRefTable s) /*@modifies s@*/ ;
extern sRefTable 
  sRefTable_add (/*@returned@*/ sRefTable t, 
		 /*@special@*/ /*@owned@*/ sRef s)
  /*@modifies t@*/ ;

# else
# error "Multiple include"
# endif



