.\" Copyright (c) 1993-1997 Susumu Shiohara
.TH XSlideShow 1 "17-Feb-1997" "X Version 11"
.SH NAME
Xslideshow - An image viewer on the X Window System.
.SH SYNOPSIS
.B xslideshow
[-\fItoolkitoption\fP ...] [\-help] [\-debug] [\-verbose] [\-root] [\-override] [\-full] [\-resize] [\-fit] [\-maxfit] [\-zoom \fIstring\fP] [\-animate \fIstring\fP] [\-interval \fIint\fP] [\-change] [\-fname] [\-clock] [\-biff] [\-mail_spool \fIstring\fP] [\-private] [\-perfect] [\-color \fIint\fP] [\-reduce \fIstring\fP] [\-selection \fIstring\fP] [\-dest \fIstring\fP\fP] [\-confirm] [\-path \fIstring\fP\fP] [\fIfilelist]
.SH DESCRIPTION
Xslideshow is an image processing and display program. It can display an image on any workstation display running X server.
The features of Xslideshow are the animation display image files.

.SH ANIMATION
.I Xslideshow
accepts one of the following animation options. 
.TP 8
.B slide
Simple slide show.
.TP 8
.B fade
PseudoColor only.
Fade-in, Fade-out.
.TP 8
.B flush
PseudoColor only.
Flush.
.TP 8
.B monotone
PseudoColor only.
Fade-in, Monotone, Fade-out.
.TP 8
.B reverse
PseudoColor only.
Fade-in, Reverse-color, Fade-out.
.TP 8
.B coloranim
PseudoColor only.
Randomizes the color index table and sorts it by the specified sorting algorithm.
.TP 8
.B coloranim2
PseudoColor only.
Take out one color from the color index table, and put it. Repeat for all colors.
.TP 8
.B wipe
Wipe-in, Wipe-out.
.TP 8
.B wipe24
Same as wipe, except it displays a picture over a previous picture transparently.
.TP 8
.B block
Divides the image into small blocks, and shows the blocks randomly.
.TP 8
.B block24
Same as block, except it displays a picture over a previous picture transparently.
.TP 8
.B mosaic
Displays a detailed mosaic image.
.TP 8
.B shuffle
Divides the image into blocks and displays each block randomly on
the screen. The correct image is displayed by exchanging the
blocks.
.TP 8
.B puzzle
Same as shuffle, except the image is formatted by solving the sequence of the blocks as in 15 block puzzle.
.TP 8
.B slit
Slits the image and displays each slit randomly on the screen. 
The correct image is displayed by exchanging the slit using the specified sorting algorithm.
.TP 8
.B transparent
Shows the pixels sequentially or randomly and displays a picture over a previous picture transparently.
.TP 8
.B move
The image is brought into view slowly from right to left.
.TP 8
.B float24
Floats plural pictures randomly.

.SH OPTIONS
The following options affect the global operation of Xslideshow.
They may be specified anywhere on the command line.
.TP 8
.B \-root
Displays on the Root Window.
.TP 8
.B \-override
Create the override_redirect window (with no matte).
.TP 8
.B \-full
Uses the entire screen to display images.
.TP 8
.B \-resize
Uses the image size to display images.
.TP 8
.B \-fit
Fit the image which size is larger than window size to the window size keeping the X/Y aspect ratio.
If picture size is smaller than window size, then do not change picture size.
.TP 8
.B \-maxfit
Fit the image size to the window size keeping the X/Y aspect ratio.
If picture size is smaller than window size, then zoom it to window size.
.TP 8
.B \-zoom \fIstring\fP
Specify the image zooming mode, fast or slow.
The "slow" quality is better than the "fast".
Default string is "fast"
.TP 8
.B \-animate \fIstring\fP
Specifies animation mode with one of the following options:
random, slide, fade, reverse, wipe, wipe24, block, block24, mosaic, coloranim, shuffle, puzzle, slit, transparent, move, float24.

Ex. xslideshow -animate puzzle
.TP 8
.B \-interval \fIinteger\fP
Specify the interval time switching pictures.
Default value is 15 (sec).
If intervalTime is 0, Xslideshow does not change pictures until mouse click.
.TP 8
.B \-change
Force action. Do not wait until an image animation end. 
.TP 8
.B \-fname
Show a file name on the Window.
.TP 8
.B \-clock
Show a clock on the Window.
.TP 8
.B \-biff
Show a biff message on the Window.
.TP 8
.B \-mail_spool \fIstring\fP
Specify your mail spool path.  Default mail spool path is "/usr/spool/mail".
.TP 8
.B \-private
PseudoColor only.
Forces to use the private colormap and install it while displaying an image. With this option, you can allocate color cells more than current default colormap. But, some window system does not accept to use private colormap on the root window such as fvwm.
.TP 8
.B \-perfect
TrueColor only.
Allocate more than 256 color.
Use 65536 color when depth >= 16.
else follow its VisualInfo.

Note: It will take long time to allocate more than 256 color.
.TP 8
.B \-color \fIinteger\fP
Specifies the maximum number of colors to use in the image with default colormap.
This is a way to forcibly reduce the depth of an image.
.TP 8
.B \-reduce \fIstring\fP
Specify the color reduction algorithm, dither, mediancut, quantize, nquant.
Default string is "dither"
.TP 8
.B \-selection \fIstring\fP
Specify the file selection mode. (sequent, random)
Default string is "sequent".
.TP 8
.B \-dest \fIstring\fP
Specifies the destination path directory where the file is moved. 
.TP 8
.B \-confirm
Specify to do confirm when remove or move the file.
Default boolean is False.
.TP 8
.B \-path \fIstring\fP
Specifies the file path directory. 
This -path option's priority is less than the filelist option.
Ex.

xslideshow -path /foo1/foo12

xslideshow -path "/foo1/foo12 /foo2/foo22"
.TP 8
.B filelist
Specifies the list of files. If it is specifed, then -path or *pathDir is ignored.
You can use eatch file name and/or wildcard to specify the filelist.

Ex.

xslideshow foo1.jpg foo2.gif /foo3/*.jpg /foo4/*.gif

.SH X RESOURCES
\fIXslideshow\fP understands the following resources
.PP
.TP 8
.B gifAnimTicks \fR(class \fBInteger\fP)
Specify the gif-anim ticks. Switch subimage by (gifAnimTicks) micro sec.
Default value is 100000. 
.TP 8
.B color \fR(class \fBInteger\fP)
Specify the color number showing pictures with default colormap.
Default value is 256 (colors).
.TP 8
.B reduce \fR(class \fBString\fP)
Specify the color reduction algorithm, dither or mediancut or quantize or nquant.
Default string is "dither"
.TP 8
.B zoom \fR(class \fBString\fP)
Specify the image zooming mode, fast or slow.
The "slow" quality is better than the "fast".
Default string is "slow"
.TP 8
.B clock \fR(class \fBBoolean\fP)
Specify to show the clock.
Default boolean is False.
.TP 8
.B biff \fR(class \fBBoolean\fP)
Specify to show the mail Biff message.
Default boolean is False.
.TP 8
.B mail_spool \fR(class \fBString\fP)
Specify your mail spool path.  Default mail spool path is "/usr/spool/mail".
.TP 8
.B showFileName \fR(class \fBBoolean\fP)
Specify to show the file name.
Default boolean is False.
.TP 8
.B showFilePath \fR(class \fBBoolean\fP)
Specify to show the file full path name. If False, show only file name.
Default boolean is False.
.TP 8
.B font \fR(class \fBString\fP)
Specify the font name.
Default string is "-adobe-times-bold-i-normal--*-240-*-*-p-*-iso8859-1"
.TP 8
.B intervalTime \fR(class \fBTime\fP)
Specify the interval time (0 <= intervalTime ) switching pictures.
Default value is 15 (sec).
.TP 8
.B fileSelectionMode \fR(class \fBString\fP)
Specify the file selection mode. (sequent, random)
Default string is "sequent".
.TP 8
.B animate \fR(class \fBString\fP)
Specify the animation mode.
(random, slide, fade, flush, monotone, reverse, wipe, wipe24, block, block24, mosaic, coloranim, coloranim2, shuffle, puzzle, slit, transparent, move, float24)
Default string is "slide".
.TP 8
.B animateList \fR(class \fBString\fP)
Specifies animation list.
If specify animation mode "random", then animate pictures by this animate list randomly.
.TP 8
.B fadeSteps \fR(class \fBInteger\fP)
PseudoColor only.
Specify the fading steps of color intense(0 to 256).
Default value is 2.
.TP 8
.B fadeTicks \fR(class \fBInteger\fP)
PseudoColor only.
Specify the fading ticks. Change intense by (fadeTicks) micro sec.
Default value is 20000. 
.TP 8
.B wipeSteps \fR(class \fBInteger\fP)
Specify the wiping steps.
Default value is 2.
.TP 8
.B wipeTicks \fR(class \fBInteger\fP)
Specify the wiping ticks. Wipe by (wipeTicks) micro sec.
Default value is 50000. 
.TP 8
.B moveSteps \fR(class \fBInteger\fP)
Specify the moving factor. 
Default value is 2 (pixel).
.TP 8
.B moveTicks \fR(class \fBInteger\fP)
Specify the moving ticks. Move by (moveTicks) micro sec.
Default value is 100000. 
.TP 8
.B float24Steps \fR(class \fBInteger\fP)
Specify the moving factor. 
Default value is 2 (pixel).
.TP 8
.B float24Ticks \fR(class \fBInteger\fP)
Specify the moving ticks. Move by (float24Ticks) micro sec.
Default value is 100000. 
.TP 8
.B floatImageSize \fR(class \fBInteger\fP)
Specify the image size.  Default value is 100 (pixel). 
.TP 8
.B floatImageLifeTime \fR(class \fBInteger\fP)
Specify the floating image life time.  Default value is 60 (sec). 
.TP 8
.B blockSteps \fR(class \fBInteger\fP)
Specify the block size for the block animation.
Default value is 8 (pixels).
.TP 8
.B mosaicTicks \fR(class \fBInteger\fP)
Specify the mosaic ticks. Switch mosaic by (mosaicTicks) micro sec.
Default value is 1000000. 
.TP 8
.B monotoneSteps \fR(class \fBInteger\fP)
PseudoColor only.
Specify the monotone steps of color intense(0 to 256).
Default value is 2.
.TP 8
.B monotoneTicks \fR(class \fBInteger\fP)
PseudoColor only.
Specify the monotone ticks. Change intense by (monotoneTicks) micro sec.
Default value is 20000. 
.TP 8
.B flushCount \fR(class \fBInteger\fP)
PseudoColor only.
Specify the flushing count.
Default value is 1.
.TP 8
.B flushSteps \fR(class \fBInteger\fP)
PseudoColor only.
Specify the flushing steps of color intense(0 to 256).
Default value is 2.
.TP 8
.B flushTicks \fR(class \fBInteger\fP)
PseudoColor only.
Specify the flushing ticks. Change intense by (flushTicks) micro sec.
Default value is 10000. 
.TP 8
.B reverseSteps \fR(class \fBInteger\fP)
Specify the reversing steps of color intense(0 to 256).
Default value is 2.
.TP 8
.B reverseTicks \fR(class \fBInteger\fP)
PseudoColor only.
Specify the reversing ticks. Change intense by (reverseTicks) micro sec.
Default value is 20000. 
.TP 8
.B colorAnimSort \fR(class \fBString\fP)
PseudoColor only.
Specify the sorting algorithm. (bubble,shell,quick)
Default string is "quick".
.TP 8
.B colorAnimTicks \fR(class \fBInteger\fP)
PseudoColor only.
Specify the color animation ticks. Sort color map index by (colorAnimTicks) micro sec.
Default value is 10000. 
.TP 8
.B shuffleSort \fR(class \fBString\fP)
Specify the sorting algorithm. (bubble,shell,quick)
Default string is "quick".
.TP 8
.B shuffleSteps \fR(class \fBInteger\fP)
Specify the block size for the shuffle animation.
Default value is 100 (100x100 pixels).
.TP 8
.B shuffleTicks \fR(class \fBInteger\fP)
Specify the shuffle ticks. Sort block by (shuffleTicks) micro sec.
Default value is 500000. 
.TP 8
.B shuffleFade \fR(class \fBBoolean\fP)
PseudoColor only.
Specify to do fade-in fade-out when begining shuffle and ending shuffle.
Default boolean is True.
.TP 8
.B puzzleSteps \fR(class \fBInteger\fP)
Specify the block size for the puzzle animation.
Default value is 100 (100x100 pixels).
.TP 8
.B puzzleTicks \fR(class \fBInteger\fP)
Specify the puzzle ticks. Resolve puzzle by (puzzleTicks) micro sec.
Default value is 500000. 
.TP 8
.B puzzleFade \fR(class \fBBoolean\fP)
PseudoColor only.
Specify to do fade-in fade-out when begining puzzle and ending puzzle.
Default boolean is True.
.TP 8
.B slitSort \fR(class \fBString\fP)
Specify the sorting algorithm. (bubble,shell,quick)
Default string is "quick".
.TP 8
.B slitSteps \fR(class \fBInteger\fP)
Specify the slit size for the slit animation.
Default value is 20 (20 pixels height).
.TP 8
.B slitTicks \fR(class \fBInteger\fP)
Specify the slit ticks. Sort eatch slit by (slitTicks) micro sec.
Default value is 500000. 
.TP 8
.B slitFade \fR(class \fBBoolean\fP)
PseudoColor only.
Specify to do fade-in fade-out when begining slit and ending slit.
Default boolean is True.
.TP 8
.B transparentMode \fR(class \fBString\fP)
Specify the transparentMode sequent or random.
Default string is "sequent".
.TP 8
.B moveOnTheLineTicks \fR(class \fBInteger\fP)
Specify the move on the bresenham line ticks. move position by (moveOnTheLineTicks) micro sec.
Default value is 10000. 
.TP 8
.B borderWidth \fR(class \fBInteger\fP)
Specify the border width of shuffle and puzzle block windows.
Default value is 1.
If 0 is specified, no border appears.
.TP 8
.B pathDir \fR(class \fBString\fP)
Specify the file path directory. 
Default path is '.'
.TP 8
.B dest \fR(class \fBString\fP)
Specify the destination path directory where the file is moved. 
Default dest is NULL
.TP 8
.B confirm \fR(class \fBBoolean\fP)
Specify to do confirm when remove or move the file.
Default boolean is False.

.SH TRANSLATIONS
You can use following actions.

    tail_frame(): go to bottom of the frame
    head_frame(): go to top of the frame
    next_frame(): go to next frame
    prev_frame(): go to previous frame
    change_frame(): go to next or previous frame
    pause_frame(): pause
    stop(): exit xslideshow
    resize(): resize the image to the original size
    fit(): resize the image to the window size
    right(): move the image position to right in an window
    left(): move the image position to left in an window
    up(): move the image position to up in an window
    down(): move the image position to down in an window
    remove(): remove the image file
    move(): move the image file to the specified destination path


.SH HOW TO USE
With the xslideshow-control.

Exec xslideshow-control on your display.

To exec xslideshow,
click Pause(||) or Head (|<) or Prev(<) or Next(>) or Tail(>|) button.
xslideshow-control invokes the xslideshow if xslideshow is not running
on the specified display. Otherwise, Xslideshow-control communicates
to the xslideshow which is already running on the specified display. 

Pause(||) button pauses the xslideshow.

Note: Pause is toggled.

Head (|<) button sets picture index to the head of the picture list.

Prev(<)   button goes to the previous picture.

Stop(box) button terminates the xslideshow.

Next(>)   button goes to the next picture.

Tail(>|)  button sets picture index to the tail of the picture list.


"Set Target Display Name" button enables to set a remote display name.
You can control xslideshow running on a specified remote display.

Note: You should have access permission to the remote display by xhost command.

"Set Command Line Options" button enables to set command line options
when xslideshow-control invokes the xslideshow.

"Set File Path Directory" button enables to change file path directory
while running xslideshow.

"Set Interval Time (sec)" button enables to change interval time while
running xslideshow.

"Get the file list from the xslideshow" button gets the file list from
the running xslideshow. You can monitor and control files to show.

"Set selected file as the xslideshow's current file" button sets a selected
file as the xslideshow's current file, and xslideshow will show it next.

Animation mode buttons enable to change animation mode while running
xslideshow. "default" button sets animation mode to which specified
in your X-resource.

.SH HOW TO USE
With the xscreensaver (Created by Jamie Zawinski <jwz@lucid.com>,

List the GIF and JPEG file path directory names in Xslideshow.
List animateList in Xslideshow.
Set xscreensaver's resource XScreenSaver as below.

.ft B
*colorPrograms:\\
    xslideshow -root -private -animate random       \\n

.ft
Note:
If xslideshow is running on the fvwm window manager, do not specify -private.


.SH COPYRIGHT
See vroot.h, zoom.c, random.c.
The others Copyright by Susumu Shiohara.
Permission to use, copy, modify, distribute, and sell this software and
its documentation for any purposes are hereby granted without fee,
provided that the above copyright notice appears in all copies and that
both copyright and this permission notices appear in 
supporting documentation.  No representations are made about the
suitability of this software for any purposes. 
It is provided "as is" without express or implied warranty.

.SH SEE ALSO
.BR xslideshow-control (1),
.BR xv (1),
.BR xloadimage (1),
.BR xscreensaver (1)

 
.SH AUTHOR
Susumu Shiohara <shiohara@tpp.epson.co.jp>.
Please let me know if you find any bugs or make any improvements.


Thanks to Mr. Yamaoka <yamaoka@ga.sony.co.jp> for debug xslideshow.

Thanks to Mr. Suzuki <Yasuhiro.Suzuki@EBay.Sun.COM> for create SYSV patches, and this manual.

Thanks to Mr. Nakano <t-nakano@ccs.mt.nec.co.jp> for debug xslideshow.

Thanks to Mr. Sato <Shinji.Sato@sancha.ctc.citoh.co.jp> for debug xslideshow.

Thanks to Mr. Maehara <yukio@hpycla.kobe.yhp.co.jp> for debug xslideshow.

Merci Monsieur Fadi Sandakly <Fadi.Sandakly@sophia.inria.fr> for giving many suggestions.

Thanks to Dr. Eberhard W. Lisse <el@lisse.NA> for giving many suggestions.

Thanks to Mr. Peter Grina <grina@fai.com> for giving many suggestions.

Thanks to Mr. Daniel Welch <dwelch@mpd.tandem.com> for giving many suggestions.

Thanks to Mr. Jonathan G. Monsarrat <jgm@cs.brown.edu> for giving many suggestions.

Thanks to Mr. Fokke de Boer <Fokke.de.Boer@rivm.nl> for giving many suggestions.

Thanks to Mr. Brian Meyer <meyer@a19thhole.stortek.com> for giving many suggestions.

Thanks to Mr. Imai <kimai@av.crl.sony.co.jp> for debug xslideshow.

Thanks to Mr. Sakane <sakane@d4.bsd.nes.nec.co.jp> for debug xslideshow.

Thanks to Mr. Nishimura <nishimu@sdd.siznes.nec.co.jp> for debug xslideshow.

Thanks to Mr. Ichikawa <ichikawa@hv.epson.co.jp> for debug xslideshow.

Thanks to Mr. Marro <marro@teksid.com> for giving many suggestions.

Thanks to Mr. Nakagawa <nakag@yk.rim.or.jp> for debug xslideshow.

Thanks to Mr. Takayama <taka@magic.omiya.saitama.jp> for debug xslideshow.

