/*
	clock.c - clock

	Author:   Susumu Shiohara (shiohara@tpp.epson.co.jp)

		Copyright 1993-1997 by Susumu Shiohara

				All Rights Reserved

*/

#include "xslideshow.h"

#if defined(__STDC__) || defined(__cplusplus)
# define P_(s) s
#else
# define P_(s) ()
#endif

extern int XSlideshowAddWorkProc P_((void (*)(), dword, caddr_t));

static struct tm the_tm;
static int old_s,old_min,old_h;
static int old_w,old_mon,old_d;
static int pos_s,pos_min,pos_h;
static int pos_w,pos_Y,pos_S1,pos_S2;
static int is_first_time;
static int textwidth,textheight;
static int blink=True;
static int clockProcId;
typedef enum{
	LEFT=0,
	RIGHT
}ClockMoveDir;

static char *week_t[] = {
	"Sun","Mon","Tue","Wed","Thu","Fri","Sat"
};

static char *mon_t[] = {
	"Jan","Feb","Mar","Apr","May","Jun",
	"Jul","Aug","Sep","Oct","Nov","Dec"
};

static GC clockFontGC;
static GC clockEraseGC;
static Window clockWindow;

#if defined(__STDC__) || defined(__cplusplus)
void updateClock(caddr_t client_data)
#else
void updateClock(client_data)
caddr_t client_data;
#endif
{
struct timeval timeValue;
struct timezone timeZone;
int is_changed=False;
char cbuf[256];

	gettimeofday(&timeValue, &timeZone);
	the_tm = *localtime(&timeValue.tv_sec);

	if(!app_data.clockMilitary && the_tm.tm_hour > 12)
		the_tm.tm_hour -= 12;

	/* Check if time is updated */
	if(	old_w != the_tm.tm_wday
		|| old_mon != the_tm.tm_mon
		|| old_d != the_tm.tm_mday
		|| is_first_time) {

		if(	old_w != the_tm.tm_wday
			|| old_mon != the_tm.tm_mon
			|| old_d != the_tm.tm_mday)
			is_changed=True; 

		/* Erase privious string */
		sprintf(cbuf,"%s %s %2d",week_t[old_w],mon_t[old_mon],old_d);
		XDrawString(
					theDisp,
					clockWindow, 
					clockEraseGC,
					pos_w, pos_Y,
					cbuf,
					10);	/* string length */

		/* Draw new string */
		sprintf(cbuf,"%s %s %2d",week_t[the_tm.tm_wday],mon_t[the_tm.tm_mon],the_tm.tm_mday);
		XDrawString(
					theDisp,
					clockWindow, 
					clockFontGC,
					pos_w, pos_Y,
					cbuf,
					10);	/* string length */

		old_w   = the_tm.tm_wday;
		old_mon = the_tm.tm_mon;
		old_d   = the_tm.tm_mday;
	}

	if(old_h != the_tm.tm_hour || is_first_time) {
		if(old_h != the_tm.tm_hour)
			is_changed=True;

		/* Erase privious string */
		sprintf(cbuf,"%2d",old_h);
		XDrawString(
					theDisp,
					clockWindow, 
					clockEraseGC,
					pos_h, pos_Y,
					cbuf,
					2);		/* Only hour string */

		/* Draw new string */
		sprintf(cbuf,"%2d",the_tm.tm_hour);
		XDrawString(
					theDisp,
					clockWindow, 
					clockFontGC,
					pos_h, pos_Y,
					cbuf,
					2);		/* Only hour string */

		old_h = the_tm.tm_hour;
	}

	if(old_min != the_tm.tm_min || is_first_time) {
		if(old_min != the_tm.tm_min)
			is_changed=True;

		/* Erase privious string */
		sprintf(cbuf,"%02d",old_min);
		XDrawString(
					theDisp,
					clockWindow, 
					clockEraseGC,
					pos_min, pos_Y,
					cbuf,
					2);		/* Only minutes string */

		/* Draw new string */
		sprintf(cbuf,"%02d",the_tm.tm_min);
		XDrawString(
					theDisp,
					clockWindow, 
					clockFontGC,
					pos_min, pos_Y,
					cbuf,
					2);		/* Only minutes string */

		old_min = the_tm.tm_min;
	}

	/* Show seconds */
	if(app_data.clockSeconds && (old_s != the_tm.tm_sec || is_first_time)) {

		if(old_s != the_tm.tm_sec)
			is_changed=True;

		/* Erase privious string */
		sprintf(cbuf,"%02d",old_s);
		XDrawString(
					theDisp,
					clockWindow, 
					clockEraseGC,
					pos_s, pos_Y,
					cbuf, 2);

		/* Draw new string */
		sprintf(cbuf,"%02d",the_tm.tm_sec);
		XDrawString(
					theDisp,
					clockWindow, 
					clockFontGC,
					pos_s, pos_Y,
					cbuf, 2);

		old_s = the_tm.tm_sec;

	}else if(old_s != the_tm.tm_sec || is_first_time){

		if(old_s != the_tm.tm_sec)
			is_changed=True;

		/* Blink a separator */
		sprintf(cbuf,":");
		if(blink){
			XDrawString(
					theDisp,
					clockWindow, 
					clockEraseGC,
					pos_S1, pos_Y,
					cbuf, 1);
			blink=False;
		}else{
			XDrawString(
					theDisp,
					clockWindow, 
					clockFontGC,
					pos_S1, pos_Y,
					cbuf, 1);
			blink=True;
		}
	}

	if(is_first_time && is_changed) {

		/* Draw separators */
		if(app_data.clockSeconds){
			sprintf(cbuf,":");
	   		XDrawString(
					theDisp,
					clockWindow, 
					clockFontGC,
					pos_S1, pos_Y,
					cbuf, 1);

			XDrawString(
					theDisp,
					clockWindow, 
					clockFontGC,
					pos_S2, pos_Y,
					cbuf, 1);
		}

		is_first_time = False;
	}
}

void replaceClockWindow()
{
int x;

	if(clockWindow != (Window)0){
		x = (windowWidth - textwidth) / 2;
		XMoveWindow(theDisp, clockWindow, x, 0);
	}
}

void initClock()
{
int d_h,f_a,f_d,w,x;
int dateascent,datelbearing,dateWidth,dateHeight;
int timeascent,timelbearing,timeWidth,timeHeight;
int separatorascent,separatorlbearing,separatorWidth,separatorHeight;
XCharStruct overall;
XSetWindowAttributes xswa;
XGCValues gcv;
struct timeval timeValue;
struct timezone timeZone;
char cbuf[26],dateBuf[12],timeBuf[10];

	gettimeofday(&timeValue, &timeZone);
	the_tm = *localtime(&timeValue.tv_sec);
	strcpy(cbuf,asctime(&the_tm));	/* "Thu Nov 24 18:22:48 1986\n\0" (26 chars) */
	strncpy(dateBuf,&cbuf[0],11);
	strncpy(timeBuf,"77777777",8);	/* Set max text size */

	if(!app_data.clockMilitary)
		if(the_tm.tm_hour > 12)
			the_tm.tm_hour-=12;

	old_h   = the_tm.tm_hour;
	old_min = the_tm.tm_min;
	old_s   = the_tm.tm_sec;
	old_w   = the_tm.tm_wday;
	old_mon = the_tm.tm_mon;
	old_d   = the_tm.tm_mday;

	/* Get text and font information */
	XTextExtents(
				app_data.font,
				dateBuf,
				11,
				&d_h,&f_a,&f_d,&overall);
	dateascent   = overall.ascent;
	datelbearing = (overall.lbearing < 0 ? -overall.lbearing : overall.lbearing);
	dateWidth    = datelbearing + overall.rbearing;
	dateHeight   = overall.descent + overall.ascent;

	/* Get text and font information */
	XTextExtents(
				app_data.font,
				timeBuf,
				(app_data.clockSeconds ? 8 : 5),
				&d_h,&f_a,&f_d,&overall );
	timeascent   = overall.ascent;
	timelbearing = (overall.lbearing<0 ? -overall.lbearing:overall.lbearing);
	timeWidth    = timelbearing + overall.rbearing;
	timeHeight   = overall.descent + overall.ascent;

	/* Get text and font information */
	XTextExtents(
				app_data.font,
				":",
				1,
				&d_h,&f_a,&f_d,&overall);
	separatorascent   = overall.ascent;
	separatorlbearing = (overall.lbearing<0 ? -overall.lbearing:overall.lbearing);
	separatorWidth    = separatorlbearing + overall.rbearing;
	separatorHeight   = overall.descent + overall.ascent;

	textheight  = (dateHeight > timeHeight) ? dateHeight:timeHeight;
	textwidth	= dateWidth + textheight + timeWidth;

	w       = timeWidth / (app_data.clockSeconds?8:5);
	pos_w   = datelbearing;
	pos_h   = dateWidth + textheight + timelbearing;
	pos_S1  = pos_h + w*2 + (w - separatorWidth) / 2;
	pos_min = pos_h + w*3;
	pos_S2  = pos_h + w*5 + (w - separatorWidth) / 2;
	pos_s   = pos_h + w*6;
	pos_Y   = (dateascent > timeascent) ? dateascent : timeascent;
	x       = (windowWidth - textwidth) / 2;
	clockWindow = XCreateSimpleWindow(
									theDisp, theWindow,
									x, 0,
									textwidth, textheight,
									0, dbcol, dbcol);

	xswa.override_redirect = True;
	xswa.backing_store = WhenMapped;
	XChangeWindowAttributes(theDisp,clockWindow,CWOverrideRedirect | CWBackingStore,&xswa);

	XLowerWindow(theDisp,clockWindow);
	XMapWindow(theDisp,clockWindow);

	gcv.font = app_data.font->fid;

	if(dbcol == 1 && dwcol == 0)
		gcv.function = GXand;
	else if(dbcol == 0 && dwcol == 1)
		gcv.function = GXor;
	else
		gcv.function = GXcopy;

	gcv.foreground = dwcol;
	gcv.background = dbcol;
	clockFontGC = XCreateGC(
							theDisp,
							clockWindow,
							GCFont | GCFunction | GCForeground | GCBackground,
							&gcv );

	if(dbcol == 1 && dwcol == 0)
		gcv.function = GXor;
	else if(dbcol == 0 && dwcol == 1)
		gcv.function = GXand;
	else
		gcv.function = GXcopy;

	gcv.foreground = dbcol;
	clockEraseGC = XCreateGC(
							theDisp,
							clockWindow,
							GCFont | GCFunction | GCForeground | GCBackground,
							&gcv );
 
	sprintf(cbuf,"%s %s %2d",week_t[old_w],mon_t[old_mon],old_d);
	XDrawString(
				theDisp,
				clockWindow, 
				clockFontGC,
				pos_w, pos_Y,
				cbuf, 10);

	sprintf(cbuf,"%2d",old_h);
	XDrawString(
				theDisp,
				clockWindow, 
				clockFontGC,
				pos_h, pos_Y,
				cbuf, 2);

	sprintf(cbuf,":");
	XDrawString(
				theDisp,
				clockWindow, 
				clockFontGC,
				pos_S1, pos_Y,
				cbuf, 1);

	sprintf(cbuf,"%02d",old_min);
	XDrawString(
				theDisp,
				clockWindow, 
				clockFontGC,
				pos_min, pos_Y,
				cbuf, 2);

	if(app_data.clockSeconds){
		sprintf(cbuf,":");
		XDrawString(
					theDisp,
					clockWindow, 
					clockFontGC,
					pos_S2, pos_Y,
					cbuf, 1);

		sprintf(cbuf,"%02d",old_s);
		XDrawString(
					theDisp,
					clockWindow, 
					clockFontGC,
					pos_s, pos_Y,
					cbuf, 2);
	}
	is_first_time=True;
	clockProcId = XSlideshowAddWorkProc(updateClock, 1000000, 0);
}

