#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "interface.h"

#include "treedata.h"

extern tree_free();

init_trees()
{
	globals->trees=newlist();
}

tree_remove(t)
tree t;
{
	canvas_add_tree(t);
	findnode(globals->trees, t);
	rmcurr(globals->trees);
}

tree tree_add_subtree(n)
treenode n;
{
	tree newtree;

	newtree=maketree(NULL, 1);
	tree_initialize(newtree, tr_tree);
	addsubtree(newtree, n, 1.0, 1);

	startlist(globals->trees);
	addnode(globals->trees, newtree);
	return(newtree);
}

tree_add(t)
tree t;
{
	startlist(globals->trees);
	addnode(globals->trees, t);
	initialize_format_flower(t);
	initialize_format_boxed(t);
	set_tree_type(t, globals->type);
	if(formatted_tree(t))
		read_tree_comment_info(t);
	remove_format_comments_from_tree(t);
}

tree_remove_all()
{
	tree t;

	startlist(globals->trees);
	while((t=listnext(globals->trees))!=NULL)
	{
		canvas_add_tree(t);
		freesubtree(treeroot(t));
		tree_free(t, tr_tree, t_data(t));
		freetree(t);
	}
	freelist(globals->trees);
	globals->trees=newlist();
}

int number_of_trees()
{
	static list t;
	static int i;

	i=0;
	lfor(globals->trees, t)
		i++;
	return(i);
}

tree_duplicate(oldn, newn, type, olddata)
void *oldn;
void *newn;
data_type type;
void *olddata;
{
	switch(type)
	{
		case tr_tree:
			{
				treetypedata newt, oldt;
				treedata newd;

				newd=(treedata)malloc(sizeof(treedatad));
				newd->selected=tdta(oldn)->selected;
				newd->type=tdta(oldn)->type;
				if(tdta(oldn)->fmt!=NULL)
					newd->fmt=(char *)strdup(tdta(oldn)->fmt);
				else
					newd->fmt=NULL;
				newt=(treetypedata)malloc(sizeof(treetypedatad));
				oldt=tdta(oldn)->flower;
				newt->x=oldt->x;
				newt->y=oldt->y;
				newt->w=oldt->w;
				newt->h=oldt->h;
				newt->tx=oldt->tx;
				newt->ty=oldt->ty;
				newt->tscalex=oldt->tscalex;
				newt->tscaley=oldt->tscaley;
				newt->scale=oldt->scale;
				newt->dst=oldt->dst;
				newt->cvs=oldt->cvs;
				newt->showinternals=oldt->showinternals;
				newt->showterminals=oldt->showterminals;
				newt->showpct=oldt->showpct;
				newt->px=oldt->px;
				newt->plx=oldt->plx;
				newt->ply=oldt->ply;
				newt->plw=oldt->plw;
				newt->pv=oldt->pv;
				newt->room=oldt->room;
				newt->modified=oldt->modified;
				newt->c=oldt->c;
				newt->pfont=oldt->pfont;
				newt->percentisreset=oldt->percentisreset;
				newt->initialized=oldt->initialized;
				newt->boxinvalid=oldt->boxinvalid;
				newt->spacinginvalid=oldt->spacinginvalid;
				newt->formatinvalid=oldt->formatinvalid;
				newt->percent=
					(ttext)ttextcpy(oldt->percent);
				newt->gc=
					(tcontext)tcontext_copy(oldt->gc);
				newt->bt=oldt->bt;
				newd->flower=newt;
				if(tdta(oldn)->td==oldt)
					newd->td=newt;
				newt=(treetypedata)malloc(sizeof(treetypedatad));
				oldt=tdta(oldn)->boxed;
				newt->x=oldt->x;
				newt->y=oldt->y;
				newt->w=oldt->w;
				newt->h=oldt->h;
				newt->tx=oldt->tx;
				newt->ty=oldt->ty;
				newt->tscalex=oldt->tscalex;
				newt->tscaley=oldt->tscaley;
				newt->scale=oldt->scale;
				newt->dst=oldt->dst;
				newt->cvs=oldt->cvs;
				newt->showinternals=oldt->showinternals;
				newt->showterminals=oldt->showterminals;
				newt->showpct=oldt->showpct;
				newt->px=oldt->px;
				newt->plx=oldt->plx;
				newt->ply=oldt->ply;
				newt->plw=oldt->plw;
				newt->pv=oldt->pv;
				newt->room=oldt->room;
				newt->modified=oldt->modified;
				newt->c=oldt->c;
				newt->pfont=oldt->pfont;
				newt->percentisreset=oldt->percentisreset;
				newt->initialized=oldt->initialized;
				newt->boxinvalid=oldt->boxinvalid;
				newt->spacinginvalid=oldt->spacinginvalid;
				newt->formatinvalid=oldt->formatinvalid;
				newt->percent=
					(ttext)ttextcpy(oldt->percent);
				newt->gc=
					(tcontext)tcontext_copy(oldt->gc);
				newt->bt=oldt->bt;
				newd->boxed=newt;
				if(tdta(oldn)->td==oldt)
					newd->td=newt;
				tree_set_data(newn, newd);
			}
			break;
		case tr_branch:
			{
				branchtypedata newt, oldt;
				branchdata newd;

				newd=(branchdata)malloc(sizeof(branchdatad));
				newd->selected=bdta(oldn)->selected;
				if(bdta(oldn)->fmt!=NULL)
					newd->fmt=(char *)strdup(bdta(oldn)->fmt);
				else
					newd->fmt=NULL;
				newt=(branchtypedata)malloc(sizeof(branchtypedatad));
				oldt=bdta(oldn)->flower;
				newt->c=oldt->c;
				newt->thickness=oldt->thickness;
				newt->gc=
					(tcontext)tcontext_copy(oldt->gc);
				newd->flower=newt;
				if(bdta(oldn)->td==oldt)
					newd->td=newt;
				newt=(branchtypedata)malloc(sizeof(branchtypedatad));
				oldt=bdta(oldn)->boxed;
				newt->c=oldt->c;
				newt->thickness=oldt->thickness;
				newt->gc=
					(tcontext)tcontext_copy(oldt->gc);
				newd->boxed=newt;
				if(bdta(oldn)->td==oldt)
					newd->td=newt;
				tree_set_data(newn, newd);
			}
			break;
		case tr_node:
			{
				nodetypedata newt, oldt;
				nodedata newd;

				newd=(nodedata)malloc(sizeof(nodedatad));
				if(ndta(oldn)->fmt!=NULL)
					newd->fmt=(char *)strdup(ndta(oldn)->fmt);
				else
					newd->fmt=NULL;
				newd->selected=ndta(oldn)->selected;
				newd->full=ndta(oldn)->full;
				newt=(nodetypedata)malloc(sizeof(nodetypedatad));
				oldt=ndta(oldn)->flower;
				newt->x=oldt->x;
				newt->y=oldt->y;
				newt->font=oldt->font;
				newt->lx=oldt->lx;
				newt->ly=oldt->ly;
				newt->c=oldt->c;
				newt->tmp=oldt->tmp;
				newt->a1=oldt->a1;
				newt->a2=oldt->a2;
				newt->a=oldt->a;
				newt->hidden=oldt->hidden;
				newt->childrenhidden=oldt->childrenhidden;
				newt->maxthickness=oldt->maxthickness;
				newt->textisreset=oldt->textisreset;
				newt->label=
					(ttext)ttextcpy(oldt->label);
				newt->gc=
					(tcontext)tcontext_copy(oldt->gc);
				if(ndta(oldn)->td==oldt)
					newd->td=newt;
				newd->flower=newt;
				newt=(nodetypedata)malloc(sizeof(nodetypedatad));
				oldt=ndta(oldn)->boxed;
				newt->x=oldt->x;
				newt->y=oldt->y;
				newt->font=oldt->font;
				newt->lx=oldt->lx;
				newt->ly=oldt->ly;
				newt->c=oldt->c;
				newt->tmp=oldt->tmp;
				newt->a1=oldt->a1;
				newt->a2=oldt->a2;
				newt->a=oldt->a;
				newt->hidden=oldt->hidden;
				newt->childrenhidden=oldt->childrenhidden;
				newt->maxthickness=oldt->maxthickness;
				newt->textisreset=oldt->textisreset;
				newt->label=
					(ttext)ttextcpy(oldt->label);
				newt->gc=
					(tcontext)tcontext_copy(oldt->gc);
				if(ndta(oldn)->td==oldt)
					newd->td=newt;
				newd->boxed=newt;
				tree_set_data(newn, newd);
			}
			break;
		default:
			return;
	}
}

tree_free(i, type, od)
void *i;
data_type type;
void *od;
{
	if(od==NULL)
		return;
	switch(type)
	{
		case tr_tree:
			{
				treetypedata newt;
				treedata newd;

				newd=od;
				ttext_free(newd->flower->percent);
				tcontext_free(newd->flower->gc);
				ttext_free(newd->boxed->percent);
				tcontext_free(newd->boxed->gc);
				if(newd->fmt!=NULL)
					free(newd->fmt);
				free(newd->flower);
				free(newd->boxed);
				free(newd);
			}
			break;
		case tr_branch:
			{
				branchtypedata newt;
				branchdata newd;

				newd=od;
				if(newd->fmt!=NULL)
					free(newd->fmt);
				tcontext_free(newd->flower->gc);
				tcontext_free(newd->boxed->gc);
				free(newd->flower);
				free(newd->boxed);
				free(newd);
			}
			break;
		case tr_node:
			{
				nodetypedata newt;
				nodedata newd;

				newd=od;
				ttext_free(newd->flower->label);
				tcontext_free(newd->flower->gc);
				ttext_free(newd->boxed->label);
				tcontext_free(newd->boxed->gc);
				if(newd->fmt!=NULL)
					free(newd->fmt);
				free(newd->flower);
				free(newd->boxed);
				free(newd);
			}
			break;
		default:
			return;
	}
}

reset_invalid_trees(c)
tcanvas c;
{
	list t;
	lfor(globals->trees, t)
	{
		if(tdta((tree)nodeobj(t))->boxed->spacinginvalid)
			reset_even_spacing(nodeobj(t), Boxed);
		/*if(tdta((tree)nodeobj(t))->flower->spacinginvalid)*/
			/*reset_even_spacing(nodeobj(t), Flower);*/
	}
}

refit_invalid_trees(c)
tcanvas c;
{
	list t;
	lfor(globals->trees, t)
	{
		if(tdta((tree)nodeobj(t))->boxed->boxinvalid)
			refit_tree(nodeobj(t), Boxed);
		if(tdta((tree)nodeobj(t))->flower->boxinvalid)
			refit_tree(nodeobj(t), Flower);
	}
}

move_invalid_labels(c)
tcanvas c;
{
	list t;
	lfor(globals->trees, t)
	{
		if(tdta((tree)nodeobj(t))->boxed->labelsinvalid)
			tree_move_all_labels(nodeobj(t), Boxed);
		if(tdta((tree)nodeobj(t))->flower->labelsinvalid)
			tree_move_all_labels(nodeobj(t), Flower);
	}
}

recalc_invalid_trees(c)
tcanvas c;
{
	list t;
	lfor(globals->trees, t)
	{
		if(tdta((tree)nodeobj(t))->boxed->formatinvalid)
		{
			canvas_add_tree(nodeobj(t));
			choose_x_locations(treeroot((tree)nodeobj(t)));
			validate_format(nodeobj(t), Boxed);
			tree_move_all_labels(nodeobj(t), Boxed);
			canvas_add_tree(nodeobj(t));
		}
		if(tdta((tree)nodeobj(t))->flower->formatinvalid)
		{
			canvas_add_tree(nodeobj(t));
			choose_positions(treeroot((tree)nodeobj(t)));
			validate_format(nodeobj(t), Flower);
			tree_move_all_labels(nodeobj(t), Flower);
			canvas_add_tree(nodeobj(t));
		}
	}
}

draw_all_tree_boundaries(c)
tcanvas c;
{
	list t;
	lfor(globals->trees, t)
		draw_tree_boundary(nodeobj(t), c);
}

draw_all_trees(c)
tcanvas c;
{
	list t;
	lfor(globals->trees, t)
		draw_tree(nodeobj(t), c);
}

canvas_add_all_trees()
{
	list t;
	lfor(globals->trees, t)
		canvas_add_tree(nodeobj(t));
}

tree which_tree(c, x, y)
tcanvas c;
int x, y;
{
	list t;
	treetypedata td;

	lfor(globals->trees, t)
	{
		td=ttdta(nodeobj(t), NoTreeType);
		if(pt_in_rect(x, y, td->x, td->y, td->w, td->h))
			return(nodeobj(t));
	}
	return(NULL);
}

tree which_corner(c, x, y, d)
tcanvas c;
int x, y;
direction *d;
{
	list t;
	treetypedata td;
	int cx, cy;

	lfor(globals->trees, t)
	{
		td=ttdta(nodeobj(t), NoTreeType);
		get_corner(td->x, td->y, td->w, td->h, NW, &cx, &cy);
		if(in_handle(c, x, y, cx, cy, TRESIZERADIUS))
		{
			*d=NW;
			return(nodeobj(t));
		}
		get_corner(td->x, td->y, td->w, td->h, SW, &cx, &cy);
		if(in_handle(c, x, y, cx, cy, TRESIZERADIUS))
		{
			*d=SW;
			return(nodeobj(t));
		}
		get_corner(td->x, td->y, td->w, td->h, NE, &cx, &cy);
		if(in_handle(c, x, y, cx, cy, TRESIZERADIUS))
		{
			*d=NE;
			return(nodeobj(t));
		}
		get_corner(td->x, td->y, td->w, td->h, SE, &cx, &cy);
		if(in_handle(c, x, y, cx, cy, TRESIZERADIUS))
		{
			*d=SE;
			return(nodeobj(t));
		}
	}
	return(NULL);
}

treenode which_node(c, x, y)
tcanvas c;
int x, y;
{
	list t, n;
	nodetypedata nd;
	treetypedata td;
	int nx, ny;

	lfor(globals->trees, t)
		lfor(((tree)nodeobj(t))->nodes, n)
		{
			nd=tndta(nodeobj(n), NoTreeType);
			td=ttdta(nodeobj(t), NoTreeType);
			nx=nodex(nd, td);
			ny=nodey(nd, td);
			if(in_handle(c, x, y, nx, ny, NCHOOSERADIUS) && !nd->hidden)
				return(nodeobj(n));
		}
	return(NULL);
}

int select_all_nodes_in_rect(c, x, y, w, h)
tcanvas c;
int x, y, w, h;
{
	list t, n;
	nodetypedata nd;
	treetypedata td;
	int nx, ny;
	list mynodes;
	list mytrees;
	int added;

	mynodes=newlist();
	mytrees=newlist();

	lfor(globals->trees, t)
	{
		added=0;
		lfor(((tree)nodeobj(t))->nodes, n)
		{
			nd=tndta(nodeobj(n), NoTreeType);
			td=ttdta(nodeobj(t), NoTreeType);
			nx=nodex(nd, td);
			ny=nodey(nd, td);
			if(pt_in_rect(nx, ny, x, y, w, h) && !nd->hidden)
			{
				addnode(mynodes, nodeobj(n));
				added=1;
			}
		}
		if(added)
			addnode(mytrees, nodeobj(t));
	}
	do_command(AddNodeListToSelection, mynodes, mytrees, 0.0, 0.0,
		NodeSel, 0, 0, 0, 0);
	freelist(mynodes);
	freelist(mytrees);
	return(1);
}

treebranch which_branch(c, x, y, p)
tcanvas c;
int x, y;
double *p;
{
	list t, b;
	branchtypedata td;
	int nx, ny;

	lfor(globals->trees, t)
		lfor(((tree)nodeobj(t))->branches, b)
			if(near_branch(nodeobj(b), x, y, p) &&
					!tndta(((treebranch)nodeobj(b))->down, NoTreeType)->hidden)
				return(nodeobj(b));
	return(NULL);
}

treenode which_label(c, x, y)
tcanvas c;
int x, y;
{
	list t, n;
	nodetypedata td;

	lfor(globals->trees, t)
		lfor(((tree)nodeobj(t))->nodes, n)
		{
			td=tndta(nodeobj(n), NoTreeType);
			if(editablelabel(nodeobj(n), NoTreeType)
					&& pt_in_text(td->label, x, y)
					&& !tndta(nodeobj(n), NoTreeType)->hidden)
				return(nodeobj(n));
		}
	return(NULL);
}

tree which_scale_bar(c, x, y)
tcanvas c;
int x, y;
{
	list t, n;
	treetypedata td;
	int nx, ny;

	lfor(globals->trees, t)
	{
		td=ttdta(nodeobj(t), NoTreeType);
		nx=td->px;
		ny=td->py;
		if(td->showpct && in_handle(c, x, y, nx, ny, PCHOOSERADIUS))
			return(nodeobj(t));
	}
	return(NULL);
}

treenode next_node_in_order(n)
treenode n;
{
	treenode next;
	tree t;

	t=tree_get_tree(n);
	findnode(t->nodes, n);
	next=listnext(t->nodes);
	if(next==NULL)
	{
		findnode(globals->trees, t);
		t=listnext(globals->trees);
		if(t==NULL)
		{
			startlist(globals->trees);
			t=listnext(globals->trees);
		}
		startlist(t->nodes);
		next=listnext(t->nodes);
	}
	return(next);

}

treenode search_all_trees_for_node(s, last)
char *s;
treenode last;
{
	treenode n, first;
	tree t;
	int result;
	int more;

	n=last;
	if(n==NULL)
	{
		startlist(globals->trees);
		t=listnext(globals->trees);
		startlist(t->nodes);
		n=listnext(t->nodes);
	}
	else
	{
		do
		{
			n=next_node_in_order(n);
		} while(tndta(n, NoTreeType)->hidden);
	}
	first=n;

	more=1;
	while(more)
	{
		result=match_strings(s, n->name);
		if(result>=0)
			return(n);
		do
		{
			n=next_node_in_order(n);
		} while(tndta(n, NoTreeType)->hidden);
		if(n==first)
			more=0;
	}
	return(NULL);
}

extern void write_treetool_comment();

write_all_trees(f, format)
FILE *f;
file_type format;
{
	tree t;

	startlist(globals->trees);
	while((t=listnext(globals->trees))!=NULL)
	{
		switch(format)
		{
			case Treetool:
				add_format_comments_to_tree(t);
				writetree(t, f, Comments, NULL);
				break;
			case Prolog:
				writetree_prolog(t, f);
				break;
			case Newick:
				writetree(t, f, Comments, NULL);
				break;
			case NoFileType:
			default:
				break;

		}
	}
}

select_all()
{
	list t;

	add_to_selection(NULL, NoSel, 0, 0.0);
	lfor(globals->trees, t)
	{
		add_to_selection(treeroot(nodeobj(t)), SubtreeSel, 1, 0.0);
		canvas_add_tree(nodeobj(t));
	}
}

select_names_in_list(l)
list l;
{
	list t, n, name;
	list nodelist, treelist;
	int added;

	add_to_selection(NULL, NoSel, 0, 0.0);
	nodelist=newlist();
	treelist=newlist();
	lfor(globals->trees, t)
	{
		added=0;
		lfor(((tree)nodeobj(t))->nodes, n)
			if(treeleaf(nodeobj(n)))
				lfor(l, name)
					if(strcmp(nodeobj(name), ((treenode)nodeobj(n))->name)==0)
					{
						addnode(nodelist, nodeobj(n));
						added=1;
						break;
					}
		if(added)
			addnode(treelist, nodeobj(t));
	}
	add_node_list_to_selection(nodelist, treelist, 0);
	freelist(nodelist);
	freelist(treelist);
}
