#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "interface.h"

#include "treedata.h"

static tframe info;
static tpanel p;
static tpmsg bmsg, msg;
static tpcheck ckauto, ckpagelines, ckhandles, ckmerge;

int globals_setup_change_auto(c, e, v)
tpcheck c;
tevent e;
int v;
{
	if(v)
		do_command(AutoformatOn, NULL, NULL, 0.0, 0.0, 0,0,0,0,0,0);
	else
		do_command(AutoformatOff, NULL, NULL, 0.0, 0.0, 0,0,0,0,0,0);
}

int globals_setup_change_merge(c, e, v)
tpcheck c;
tevent e;
int v;
{
	if(v)
		do_command(AutomergeOn, NULL, NULL, 0.0, 0.0, 0,0,0,0,0,0);
	else
		do_command(AutomergeOff, NULL, NULL, 0.0, 0.0, 0,0,0,0,0,0);
}

int globals_setup_change_pagelines(c, e, v)
tpcheck c;
tevent e;
int v;
{
	if(v)
		canvas_show_page_lines();
	else
		canvas_hide_page_lines();
}

int globals_setup_change_handles(c, e, v)
tpcheck c;
tevent e;
int v;
{
	if(v)
		do_command(ShowHandles, NULL, NULL, 0.0,0.0,0,0,0,0,0);
	else
		do_command(HideHandles, NULL, NULL, 0.0,0.0,0,0,0,0,0);
}

int create_globals_setup_frame(parent, args)
tframe parent;
targs args;
{
	int i;

    info=tframe_new(parent, 580,100,50,50,0,1,0,
		"Treetool:Preferences", args);
    if(info==NULL)
		return(0);
    p=tframe_dialog_panel(info);
    if(p==NULL)
		return(0);

	ckauto=(tpcheck)tpcheck_new(p, 10, 10, 0, 0, NULL, NULL,
		"Automatic Formatting");
	if(globals->autoformat)
		tpcheck_set(ckauto);
	else
		tpcheck_unset(ckauto);
	tpcheck_set_event_procedure(ckauto, globals_setup_change_auto);
	ckmerge=(tpcheck)tpcheck_new(p, 10, 10, 0, 0, NULL, ckauto,
		"Automatic Node Merging");
	if(globals->automerge)
		tpcheck_set(ckmerge);
	else
		tpcheck_unset(ckmerge);
	tpcheck_set_event_procedure(ckmerge, globals_setup_change_merge);
	ckpagelines=(tpcheck)tpcheck_new(p, 10, 10, 0, 0, NULL, ckmerge,
		"Show Page Lines");
	if(globals->pagelines)
	{
		tpcheck_set(ckpagelines);
		canvas_show_page_lines();
	}
	else
	{
		tpcheck_unset(ckpagelines);
		canvas_hide_page_lines();
	}
	tpcheck_set_event_procedure(ckpagelines, globals_setup_change_pagelines);
	ckhandles=(tpcheck)tpcheck_new(p, 10, 10, 0, 0, NULL, ckpagelines,
		"Show Tree Handles");
	if(globals->handles)
		tpcheck_set(ckhandles);
	else
		tpcheck_unset(ckhandles);
	tpcheck_set_event_procedure(ckhandles, globals_setup_change_handles);
    tpanel_fit(p);
    tframe_fit(info);
    tframe_hide(info);
    return(1);
}

int show_globals_setup_frame()
{
	moveframetoloc(info);
    tframe_show(info);
}

int hide_globals_setup_frame()
{
    tframe_hide(info);
}

globals_busy()
{
	if(info!=NULL)
		tframe_set_busy(info);
}

globals_notbusy()
{
	if(info!=NULL)
		tframe_set_notbusy(info);
}
