#define NUMTOPICS 37
static char *topicnames[]={
	NULL,
	"Treetool",
	"Trees",
	"Files and File Formats",
	"Selections",
	"Clipboard",
	"Tools",
	"  The Tree Tool",
	"  The Text Tool",
	"  The Move Tool",
	"  The Flip Tool",
	"  The Hide Tool",
	"The Help Window",
	"File Menu",
	"  Load File Window",
	"  Save File Window",
	"  Print Window",
	"  Quit",
	"Edit Menu",
	"  Cut",
	"  Copy",
	"  Paste",
	"  Add",
	"  Delete",
	"Utilities Menu",
	"  Find Window",
	"  Zoom",
	"  Tree Settings Window",
	"  Node Settings Window",
	"  Branch Settings Window",
	"  Scale Bar Settings Window",
	"Extras Menu",
	"  Preferences",
	"  Selection Commands",
	"  Structure Commands",
	"  Format Commands",
	"  Hiding Commands",
	"Command Line Options"};

static char *helptopic[]={
	NULL,
"Treetool\n\n\
Treetool is an interactive tool for displaying, editing, and printing phylogenetic trees.  The tree is displayed visually on screen, in various formats, and the user is able to modify the format, structure, and characteristics of the tree.  Trees may be viewed, compared, formatted for printing, constructed from smaller trees, etc...\n\
\n\
Treetool works with Newick format tree files (Paup and Phylip compatible).  It handles multifurcating trees, branch lengths (evolutionary distances), rooted/unrooted trees, and multiple trees per file.  It can print to a PostScript printer, or output PICT graphics for Macintosh drawing programs (MacDraw).\n\
\n\
",
"Trees\n\n\
Treetool works on phylogenetic trees.  Trees consist a set of nodes connected by branches.  Each branch connects a parent node to a child node.  Each node has only one parent, and may have any number of children (normally two in a phylogenetic tree). The base node is called the root node; by definition it has no parent.  The terminal nodes in the tree, called leaf nodes, have no children.\n\
\n\
In a phylogenetic tree, the leaf nodes represent organisms, or taxa.  Each branch has a length, corresponding to the evolutionary distance between the two nodes.  The evolutionary distance between two organisms is found by adding the lengths of all the branches that lie on the path from one organism to another.\n\
\n\
Treetool operates on bifurcating (two children per node) or multifurcating (varying numbers of children per node) phylogenetic trees.  The user can modify the structure, format, and size, all on screen, and see the results instantly.  Treetool maintains the relationship between the nodes and the branch lengths and other important aspects of the tree.\n\
\n\
Treetool may operate on multiple trees at once, and allows exchanging of data between the trees.\n\
\n\
There are two display formats supported by Treetool.  One is a \"Radial\" format (also called \"Unrooted\" or \"Flower\").  In this format the branches may extend in any direction, and the evolutionary distance is indicated by the length of the branch.  The root node is not visually distinct in this format, which is why it is used to represent an a tree in which the location of the root node is not definite (an unrooted tree).\n\
\n\
 The other format is the \"Phenogram\" (also called \"Boxed\" or \"Rooted\"). In this format, the root node is on the left, and all branches extend to the right.  Evolutionary distance is indicated by the length of the horizontal portion of the branch only.  This format is useful for a tree with a known root (a rooted tree), as the location of the root node can be shown clearly.\n\
\n\
 The \"scale bar\" is a reference, basically a ruler, allowing someone viewing the tree to measure the lengths of the branches in the tree, and to compare different trees.  Typically, the scale bar line represents an evolutionary distance of 0.10 or 0.05.\n\
\n\
 The \"outgroup\" is an organism or a group of organisms relatively distantly related to the \"ingroup\", i.e., all other organisms in the tree.  The outgroup is used to establish the root of the ingroup subtree.  In a Phenogram (boxed) tree, the outgroup is placed at the bottom of the page, as a child of the root node.\n\
\n\
",
"Files and File Formats\n\n\
Treetool stores trees in files, in the Newick format (with treetool formatting comments).  Treetool output files are compatible with Paup, Phylip, and many other tree manipulation programs.  Output from Paup or Phylip may be sent directly to Treetool and displayed immediately.\n\
\n\
Treetool also outputs trees in various other formats.  They are:\n\
\n\
Treetool format.  This format is described above, it includes all information Treetool requires to display the tree in the correct format.  It is Newick compatible.\n\
\n\
Newick format.  This is the flat Newick format, without Treetool formatting comments.\n\
\n\
Prolog format.  This is a special purpose format, used by the RDP.  It is a representation of the tree in the Prolog language.\n\
\n\
PICT format.  This is the Macintosh standard picture format.  A PICT file created by Treetool may be copied to a Macintosh (when using ftp, binary mode must be used).  It may then be loaded into MacDraw, or any other Macintosh drawing program.\n\
\n\
PostScript format.  This format is a PostScript program for drawing the tree on a PostScript printer.  It is used when the PostScript file must be kept (to print the tree, just use the \"Print\" item in the \"File\" menu, there is no need to save a PostScript file).\n\
\n\
Species List format.  This format allows the user to save a selection. Later, the selection may be loaded.  To save a species list, select some organisms on the tree, and then save with this format (see \"Save File Window\" below).  The saved file will contain a list of the selected organisms.  Later, the list may be loaded.  When the list is loaded, the organisms in the list will be selected on screen.\n\
\n\
",
"Selections\n\n\
To make changes in the tree, the user must first select a part of the tree.  This is done by clicking on the part to be selected.  Once a part of the tree is selected, various operations may be performed on that part, such as: changing the font of node labels, changing the thickness of branches, etc...\n\
\n\
A single node may be selected, an branch may be selected, or an entire subtree (a node, all of its descendants, and all connecting branches) may be selected.  More than one subtree, node, or branch may be selected at once, easily allowing simultaneous changes to many parts of the tree.\n\
\n\
To learn how to select the various parts of the tree, see the topic \"Tree Tool\" below.\n\
\n\
",
"Clipboard\n\n\
The clipboard is a hidden area where trees can be temporarily stored.  When a tree or subtree is selected, it may be cut or copied to the clipboard.  It is held there, so that later it may be pasted back into a tree.  It remains on the clipboard until something else is cut or copied to the clipboard (it is not removed when pasted).\n\
\n\
The clipboard is useful when subtrees must be added to a tree, moved between trees, or extracted.  The clipboard can be used, for example, to cut a subtree from one tree and then paste it into another tree.  For information on the various cut/paste commands, see the topic \"Edit Menu\" below.\n\
\n\
 Note:  Treetool can cut (and therefore, you must select for cutting) only one subtree, for there is room on the clipboard for only a single subtree.  The clipboard cannot hold branches, or nodes by themselves (when using the \"Text\" tool, the clipboard may hold text).\n\
\n\
",
"Tools\n\n\
Each tool allows the user to perform a group of related operations.  To use a tool, press the button for the tool, and then move the pointer to the canvas to start using the tool.  Each tool has its own button, with an tool icon on it.  The tools and their uses are described in the next five sections.\n\
\n\
",
"  The Tree Tool\n\n\
The \"Tree\" tool is represented by the pine tree cursor (and button icon). This tool allows the user to move and select parts of the tree.  Click on parts of the tree to select them, and drag parts of the tree to move them.\n\
\n\
 Selecting a subtree:  click on the parent node (or label).\n\
\n\
 Selecting nodes:  click on the node (or label) with \"CTRL\" key down.\n\
\n\
Selecting branches: click on the branch; drag it to desired position.\n\
\n\
Multiple Selections:  click with \"SHIFT\" key down for all (after the first).\n\
\n\
 Moving a node:  click on the node and drag it.\n\
\n\
 Moving the scale bar:  click on its handle and drag it.\n\
\n\
 Moving a label:  click on the label and drag it.\n\
\n\
",
"  The Text Tool\n\n\
The \"Text\" tool is represented by the \"i-beam\" cursor (and button icon), and is used to edit the labels on the tree.\n\
\n\
To edit a label, click on it, and then type, using arrow keys and the delete key.\n\
\n\
To add a label to a node, click on the node, and then type text.\n\
\n\
To select text, click on the text and drag it.\n\
\n\
",
"  The Move Tool\n\n\
The \"Move\" tool is represented by the dual arrow (one pointing right, one pointing down); it is used to position the tree on the page, and to resize the tree.  When the move tool is chosen, a box appears around the tree, with squares at each corner.  This is the resize box, and it can be used to move and resize the tree.\n\
\n\
 To move the tree, click within the tree's boundary and drag.\n\
\n\
 To resize the tree, click on a resize corner and drag.\n\
\n\
",
"  The Flip Tool\n\n\
The \"Flip\" tool is represented by two spiraling arrows, and is used to exchange, or invert, the positions of the children of a node.\n\
\n\
 It is most useful on a Phenogram (Boxed) tree, to interchange the order of the children of a node.  Click on a node, and the children swap positions.\n\
\n\
",
"  The Hide Tool\n\n\
The \"Hide\" tool is represented by a circle with a slash, and is used to hide the children of a node.  Click on a node, and its children disappear.  They are still present, but no editing operations will affect them, and they will not show on screen.  A node with its children hidden is indicated on screen by a large circle around the node's handle.\n\
\n\
 To make the children reappear, click on the node again.\n\
\n\
",
"The Help Window\n\n\
The \"Help\" window provides on-line information about using treetool.  To see the help window, choose the \"Help...\" item from the \"Help\" menu. The help window has two parts.  To the left is the topic window, which displays the information about a particular topic.  To the right is the topic list, from which a topic may be selected.  To select a topic, click on the name in the topic list.  The information for the topic will be displayed in the topic window.  Use the scrollbars to display more of the topic, and to display more of the topic list.\n\
\n\
",
"File Menu\n\n\
The File menu has items for saving, loading, and printing trees, and for quitting Treetool.\n\
\n\
",
"  Load File Window\n\n\
The \"Load File\" window allows the user to choose a file to load.  When the file is chosen, the trees stored in the file will appear on screen. If there are already trees on screen, they will remain, and the new trees will appear in addition.\n\
\n\
 There are two ways to select a file: click on a name in the list and press the \"Open\" button, or double-click on the name in the list.\n\
\n\
There are four ways to change directories: press the \"Up Dir\" button to see the parent directory, type a new directory name into the \"Directory\" field, click on the directory name (indicated by a trailing slash \"/\") in the list and press the \"Open\" button, or double-click on the directory name in the list).\n\
\n\
 To load a species list (explained in the Treetool User Manual), check the \"Load Species List\" checkbox, and then choose a file to open.\n\
\n\
",
"  Save File Window\n\n\
The \"Save File\" window allows the user to save trees in a file.  When the file is chosen, the trees currently loaded will be stored in the file.\n\
\n\
 To select the filename, type it into the \"File name\" field, and then press the \"Save\" button.\n\
\n\
 To select the file type, choose one from the \"Format\" menu.  The filename will be updated to contain the right suffix (.PICT, .ps, etc.).\n\
\n\
  The current directory can be changed as described above under \"Load File Window\" (use \"Open Dir\" instead of \"Open\" to view the contents of the selected directory).\n\
\n\
",
"  Print Window\n\n\
The print window allows the user to choose a printer to which to print the trees.  Enter the name of the printer name and press \"Ok,\" or just press \"Ok.\"  Treetool usually recognizes the correct printer.\n\
\n\
",
"  Quit\n\n\
The \"Quit\" item on the \"File\" menu exits Treetool.  If the current file has not been saved since it was last modified, the user will be prompted.\n\
\n\
",
"Edit Menu\n\n\
The \"Edit\" menu allows operations to rearrange the structure of the tree.  The items in the \"Edit\" menu move data back and forth between the trees and the clipboard (see \"Clipboard\" above).\n\
\n\
 Note:  it is recommended that Automatic Formatting (see the topic \"Preferences\" below) be used when using the items in the \"Edit\" menu. If Automatic Formatting is not used, the tree will not be formatted as expected.\n\
\n\
",
"  Cut\n\n\
The \"Cut\" item removes the selected part of the tree, and places it on the clipboard (see \"Clipboard\" above).\n\
\n\
Cut may be chosen either by selecting the \"Cut\" item from the \"Edit\" menu, or by pressing the \"Cut\" key on the keyboard.  Note that the clipboard holds only one full subtree or tree, it cannot hold single nodes, branches by themselves, or groups of subtrees.\n\
\n\
 It is recommended that \"Automatic Formatting\" (see the topic \"Preferences\" below) be used when using the \"Cut\" menu item.\n\
\n\
",
"  Copy\n\n\
The \"Copy\" item places the selected part of the tree on the clipboard (see \"Clipboard\" above).  It does not remove the selected part from the tree.\n\
\n\
Copy may be chosen either by selecting the \"Copy\" item from the \"Edit\" menu, or by pressing the \"Copy\" key on the keyboard.  Note that the clipboard holds only one full subtree or tree, it cannot hold single nodes, branches by themselves, or groups of subtrees.\n\
\n\
 It is recommended that \"Automatic Formatting\" (see the topic \"Preferences\" below) be used when using the \"Copy\" menu item.\n\
\n\
",
"  Paste\n\n\
The \"Paste\" item takes the data on the clipboard (see \"Clipboard\" above) and places it in the tree.  How it is placed is dependent on what is currently selected.\n\
\n\
If nothing is selected, the subtree on the clipboard is pasted as a new tree in the upper left corner of the canvas.\n\
\n\
If a subtree is selected, the subtree on the clipboard replaces the selected subtree.  If a node is selected, it and all of its descendants will be replaced by the subtree on the clipboard (as if a subtree had been selected).\n\
\n\
If a branch point is selected, a new node is added at that point in the branch.  The subtree on the clipboard is added as a child of the new node.\n\
\n\
Paste may be chosen either by selecting the \"Paste\" item from the \"Edit\" menu, or by pressing the \"Paste\" key on the keyboard.\n\
\n\
 It is recommended that \"Automatic Formatting\" (see the topic \"Preferences\" below) be used when using the \"Paste\" menu item.\n\
\n\
",
"  Add\n\n\
The \"Add\" item takes the data from the clipboard (see \"Clipboard\" above) and places it as a child of a selected node in the tree.  Its operation depends upon whether a node or a subtree is selected.  If a node is selected, the subtree on the clipboard will be placed as a child of the node.  If a subtree is selected, the subtree on the clipboard will be added as a child of the top node in the subtree.\n\
\n\
It is recommended that \"Automatic Formatting\" (see the topic \"Preferences\" below) be used when using the \"Add\" menu item.\n\
\n\
",
"  Delete\n\n\
Delete is not currently implemented, and the menu item will always be disabled.\n\n\
The \"Delete\" menu item is used to remove a subtree from the tree without placing it on the clipboard.  This is useful when there is already something on the clipboard that will be needed after the Delete operation is performed.\n\
\n\
 It is recommended that \"Automatic Formatting\" (see the topic \"Preferences\" below) be used when using the \"Delete\" menu item.\n\
\n\
",
"Utilities Menu\n\n\
The \"Utilities\" menu contains commonly used options:\n\
\n\
",
"  Find Window\n\n\
The \"Find Node\" window allows the user to search for a node by name. When the node is found, it is automatically selected.\n\
\n\
 To find a node, type the name in the \"Node name\" field, and then press the \"Find\" button.  The next node in the tree that matches the given name will be selected.  If the whole name is not known, part of the name may be given, and the node will still be found.  For example, to find the node \"Sul.solfat,\" use any one of these search strings: \"Sul.solfat,\" \"Sul,\" \"sol,\" etc.\n\
\n\
 To find all nodes that match the specified name, press the \"Find All\" button (instead of \"Find\").  Each node that matches the node name will be selected.\n\
\n\
 When a match is found, Treetool clears the current selection and selects only the matching node.  The user loses the current selection.  This operation is modified by the \"Replace Current Selection\" checkbox.  When this box is checked, Treetool clears the current selection when a node is found.  If this box is not checked, Treetool will not clear the current selection, and the node that is found will be added to the selection.\n\
\n\
",
"  Zoom\n\n\
Zoom allows the user to look more closely at the tree, or to see more of the tree at once.  Zooming In magnifies the tree, zooming out the opposite.  The true size of the tree is unchanged, only its scaling on screen is affected.\n\
\n\
Zooming In is effective with very large trees, with many leaves.  Some operations are difficult to do on a tree of this type, since nodes may be very close together.  Zooming In shows gives greater resolution and detail, and makes feasible certain otherwise untractable operations.\n\
\n\
Note: concerning text and Zooming.  This release of treetool is not able to scale fonts during Zoom operations.  When Zooming Out, the node labels do not become smaller (even though the tree does become smaller).  Therefore, the labels tend to overlap.  This is normal, when the user Zooms In again to return the tree to its normal size, the labels will return to their normal form also.  Similar problems occur when Zooming In.\n\
\n\
",
"  Tree Settings Window\n\n\
The \"Tree Settings\" window allows the user to change global formatting information regarding the selected trees.  The format of the trees may be changed, and various options are available.  A tree is considered selected if any node, subtree, or branch in it is selected.\n\
\n\
 The tree can appear in one of two formats, \"Phenogram\" and \"Radial\" (see the topic \"Trees\" above).  To change the format, choose another format from the \"Tree Format\" menu in the \"Tree Settings\" window.  The formatting information for each format (phenogram and radial) is kept separately, so that the user may switch from phenogram to radial and back to phenogram without losing the formatting of the phenogram.  For more information on the two tree formats, see the topic \"Trees\" above.\n\
\n\
 The scale bar may be hidden by unchecking the \"Show Scale Bar\" checkbox. Internal names (names associated with nodes that are not leaf tips) may be hidden by unchecking the \"Show Internal Names\" checkbox.  Terminal names (names associated with leaf tips) may be hidden by unchecking the \"Show Terminal Names\" checkbox.\n\
\n\
",
"  Node Settings Window\n\n\
The \"Node Settings\" window allows the user to change the format of labels for selected nodes.  Color, and the font type and size may be changed.\n\
\n\
 To change the color, press the \"Change Color\" button.  The \"Choose a Node Color\" window will appear.  A color is specified by its red, green, and blue composition, or by a name.  To choose a color, drag the sliders for the red, green, and blue composition back and forth.  The large area at the bottom of the window will change color accordingly. Alternatively, type a color name (such as \"red\" or \"green4\") in the \"Choose by name\" field, and press the \"Return\" key on the keyboard. Press the \"Ok\" button to change the color of the selected nodes.\n\
\n\
 To change the font type and size, choose among the items provided by the three menus, \"Font,\" \"Style,\" and \"Size.\"  The font type and size of the selected nodes will be changed immediately.\n\
\n\
",
"  Branch Settings Window\n\n\
The \"Branch Settings\" window allows the user to change the format of selected branches.  The line width and the color may be changed.\n\
\n\
 To change the line width, drag the slider back and forth.  The line width of the selected branches will be changed immediately.\n\
\n\
 To change the color, press the \"Change Color\" button.  The \"Choose a Branch Color\" window will appear.  A color is specified by its red, green, and blue composition, or by a name.  To choose a color, drag the sliders for the red, green, and blue composition back and forth.  The large area at the bottom of the window will change color accordingly. Alternatively, type a color name (such as \"red\" or \"green4\") in the \"Choose by name\" field, and press the \"Return\" key on the keyboard. Press the \"Ok\" button to change the color of the selected branches.\n\
\n\
",
"  Scale Bar Settings Window\n\n\
The \"Scale Bar Settings\" window allows the user to change formatting information about the scale bar (see the topic \"Trees\" above) for the selected trees.  The scaling factor, percentage value, color, and font type and size may all be changed.  A tree is considered to be selected if any node, subtree, or branch in it is selected.\n\
\n\
The \"Scale for Scale Bar\" field contains the scaling factor for the scale bar.  Evolutionary distance units are normally presented on a scale from 0.0 (completely similar) to 1.0 (completely dissimilar). However, in some applications, evolutionary distance units are presented on a scale from 0.0 to 100.0.  Treetool allows the user to specify the scale so that all tree types may be handled correctly.\n\
\n\
 To change the color, press the \"Change Color\" button.  The \"Choose a Color for the Scale Bar\" window will appear.  A color is specified by its red, green, and blue composition, or by a name.  To choose a color, drag the sliders for the red, green, and blue composition back and forth.  The large area at the bottom of the window will change color accordingly.  Alternatively, type a color name (such as \"red\" or \"green4\") in the \"Choose by name\" field, and press the \"Return\" key on the keyboard.  Press the \"Ok\" button to change the color of the scale bar for the selected trees.\n\
\n\
 To change the font type and size, choose among the items provided by the three menus, \"Font,\" \"Style,\" and \"Size.\"  The font type and size of the scale bars for the selected trees will be changed immediately.\n\
\n\
",
"Extras Menu\n\n\
The \"Extras\" menu contains items for doing various tree manipulations.\n\
\n\
",
"  Preferences\n\n\
When the \"Preferences...\" item is chosen, the \"Preferences\" window appears, with four checkboxes.\n\
\n\
Automatic Formatting is used when the user wants to make structural changes to the tree.  It repositions the nodes into their default positions every time a change is made to the tree.  This is useful when cutting, pasting, adding, or deleting subtrees, and when changing the outgroup.  Since nodes are kept in their default positions, dragging nodes is not permitted while Automatic Formatting is on.\n\
\n\
Note: if nodes have been moved from their default positions, they will be moved back when Automatic Formatting is switched on.\n\
\n\
To turn on Automatic Formatting, check the \"Automatic Formatting\" checkbox in the \"Preferences\" window.\n\
\n\
  Automatic Node Merging is used when the user is cutting or deleting many subtrees from a given tree.  As subtrees are cut, nodes that have only one child may remain in the tree.  Under Automatic Node Merging, any time an operation produces a node that has a single child, that child is immediately merged.  Merging is described below under \"Structure Commands.\"\n\
\n\
  To turn on Automatic Node Merging, check the \"Automatic Node Merging\" checkbox in the \"Preferences\" window.\n\
\n\
 Treetool has the capability to display dashed lines at the edge of each page in the canvas.  This gives the user an indication of the size of each page, and helps in positioning trees, and choosing their sizes.  To make the page lines appear, check the \"Show Page Lines\" checkbox in the \"Preferences\" window.\n\
\n\
 Treetool can hide the handles that appear at every node, and on the scale bar, which allows the user to view the tree exactly as it would appear in print, since these handles are not printed.  To hide the handles, uncheck the \"Show Tree Handles\" checkbox in the \"Preferences\" window.\n\
\n\
",
"  Selection Commands\n\n\
The \"Extras\" menu has several commands for working with selections.\n\
\n\
 \"Connect Selections\" selects all branches and nodes that connect the currently selected nodes (in other words, those that lie on the path between the currently selected nodes).\n\
\n\
\"Select Common Ancestor\" selects the lowest common ancestor of all of the currently selected nodes.\n\
\n\
 \"Select All\" selects all of the nodes in all of the trees.\n\
\n\
",
"  Structure Commands\n\n\
\"Representative Tree\" is used to prune the tree.  It can be used to reduce a tree containing many organisms into one containing a selected subset thereof.  To do this, select the organisms that will be kept, and then choose \"Representative Tree\" from the \"Extras\" menu. Everything except the selected nodes and their ancestors is removed from the tree.  It is recommended that the item \"Merge Mergeable Nodes\" (described below) be used after \"Representative Tree,\" since many nodes having a single child will have been created.\n\
\n\
 \"Merge Mergeable Nodes\" removes any selected nodes that have only one child.  This process is called \"merging a node.\"  The node is removed, and the two branches (one between the node and its parent, one between the node and its child) are added together to form a single long branch.\n\
\n\
 \"Change Outgroup\" can be used restructure the tree so that a different subtree is used as the outgroup (the outgroup is discussed under the topic \"Trees\" above).  To choose an outgroup, use the \"Tree\" tool to select a branch point at which to place the new root.  Then choose the \"Change Outgroup\" item from the \"Extras\" menu.  The subtree at the child end of the selected branch becomes the new outgroup, and the break-point in that branch (on a phenogram) will appear at the selection point (thereby determining the length of the branch leading to the outgroup).\n\
\n\
",
"  Format Commands\n\n\
\"Even Spacing\" is used to return nodes to their default spacings.  It can be used when the tree has been messed up (by repeated dragging of nodes), to return the tree to a reasonable format.  It performs the same function that Automatic Formatting (see the topic \"Preferences\" above) performs, except in this case the effect is only temporary.\n\
\n\
\"Justify Selected Labels\" is used to return the labels of the selected nodes to their original positions.  In the Phenogram, the default position is immediately to the right of the node.  In the Radial tree, the default position is centered and in the direction of the node's parent branch.\n\
\n\
",
"  Hiding Commands\n\n\
Hiding is described above, under the topic \"Hide Tool.\"  The \"Extras\" menu has additional ways for hiding nodes.\n\
\n\
\"Hide Selected Nodes\" hides the children of all of the selected nodes, and \"Show Selected Nodes\" shows the children of all selected nodes.\n\
\n\
  \"Hide Level\" hides all of the nodes below the selected level in the tree.  This can be used to provide an overview of the tree.  Use \"Show Selected Nodes\" to cause those nodes to reappear.\n\
\n\
",
"Command Line Options\n\n\
Various Treetool options can be controlled from the command line:\n\
\n\
Filename option.  Specifies file to be loaded, as in \"treetool treefile.\"  More than one file may be specified, the trees in all of the files will be displayed when Treetool starts up.\n\
\n\
 \"-h\" option.  Instructs Treetool to print out a help message, describing these options.  Treetool does not start up.\n\
\n\
-phenogram (-p) [-radial (-r)]; causes Treetool to start up with Phenogram [Radial] as the initial tree format.  Default is -p.\n\
\n\
-auto [-noauto]; causes Treetool to start up with [without] Automatic Formatting on.  Default is -noauto.\n\
\n\
-merge [-nomerge]; causes Treetool to start up with [without] Automatic Node Merging on.  Default is -nomerge.\n\
\n\
Treetool also accepts the standard X-windows and Xview options.\n\
\n\
\n\
\n\
\n\
\n\
"};

