#include <stdio.h>
#include <ctype.h>

#ifdef MEMDBG
#include "memdbg.h"
#endif

#include "memory.h"

#define QUOTE '\''


char *treereadname(f)
FILE *f;
{
	char *tmp;
	int more=1;
	int quoted=0;
	int ch;

	tmp=new_string();
	if(tmp==NULL)
		return(NULL);

	ch=getc(f);
	if(ch==QUOTE)
	{
		quoted=1;
		ch=getc(f);
	}
	else
		quoted=0;
	while(more)
		switch(ch)
		{
			case QUOTE:
				ch=getc(f);
				if(ch==QUOTE)
					if(!add_char(tmp, QUOTE))
					{
						/* not enough memory */
						free(tmp);
						return(NULL);
					}
					else
						ch=getc(f);
				else
				{
					if(quoted)
					{
						/* have read whole name */
						ungetc(ch, f);
						more=0;
					}
					else
					{
						/* error reading name, quote at end of unquoted name */
						free(tmp);
						ungetc(ch, f);
						return(NULL);
					}
				}
				break;
			case ':':
			case ',':
			case ')':
			case '[':
			case ';':
				if(quoted)
				{
					if(!add_char(tmp, ch))
					{
						/* not enough memory */
						free(tmp);
						return(NULL);
					}
					else
						ch=getc(f);
				}
				else
				{
					/* have read whole name */
					ungetc(ch, f);
					more=0;
				}
				break;
			case EOF:
				if(quoted)
				{
					/* error, EOF in name */
					free(tmp);
					return(NULL);
				}
				else
				{
					/* have read whole name */
					ungetc(ch, f);
					more=0;
				}
				break;
			default:
				if(quoted)
				{
					if(!add_char(tmp, ch))
					{
						/* not enough memory */
						free(tmp);
						return(NULL);
					}
					else
						ch=getc(f);
				}
				else
					if(isspace(ch))
					{
						/* have read whole name */
						ungetc(ch, f);
						more=0;
					}
					else
					{
						if(!add_char(tmp, ch))
						{
							/* not enough memory */
							free(tmp);
							return(NULL);
						}
						else
							ch=getc(f);
					}
				break;
		}
		tmp=freeze_string(tmp);
		return(tmp);
}

int treewritename(f, n)
FILE *f;
char *n;
{
	int i;

	if(n==NULL)
	{
		putc(QUOTE, f);
		putc(QUOTE, f);
	}
	else
	{
		putc(QUOTE, f);
		for(;*n!='\0';putc(*(n++), f))
			/* if it's a quote, put two of them */
			if(*n==QUOTE)
				putc(QUOTE, f);
		putc(QUOTE, f);
	}
	return(1);
}

int treeskipspace(f)
FILE *f;
{
	static int ch;

	while(isspace(ch=getc(f)));
	return(ch);
}
