#include <stdio.h>

#include <xview/xview.h>
#include "generic.h"

typedef struct {
	ltgenericd g;
	char *name;
	tpic p;
	Menu_item mi;		/* if added to menu */
	int (*do_events)();
	} ltpitemd, *ltpitem;

void tpitem_notify(m, i)
Menu m;
Menu_item i;
{
	tpmenu pm;
	ltpitem pmi;
	int a;
	tevent te;
	Event *e;

	pmi=(ltpitem)xv_get(i, MENU_CLIENT_DATA);
	pm=(tpmenu)xv_get(m, MENU_CLIENT_DATA);

	if(pmi->do_events!=NULL)
	{
		e=(Event *)xv_get(m, MENU_FIRST_EVENT);
		if(e!=NULL)
			te=tevent_create_from_xviewevent(e, event_x(e), event_y(e), 0, 0);
		else
			te=NULL;
		a=(*pmi->do_events)(pm, pmi, te);
		if(te!=NULL)
			tevent_free(te);
	}
	return;
}

tpitem tpitem_new(name, do_events)
char *name;
int (*do_events)();
{
	ltpitem tmp;

	if(name==NULL && do_events==NULL)
		return(NULL);
	
	tmp=(ltpitem)titem_new(NULL, lt_pitem, sizeof(ltpitemd));
	if(tmp==NULL)
		return(NULL);
	
	if(name==NULL)
		tmp->name=NULL;
	else
		tmp->name=(char *)strdup(name);

	tmp->mi=xv_create(NULL, MENUITEM,
		MENU_STRING, tmp->name,
		MENU_NOTIFY_PROC, tpitem_notify,
		MENU_CLIENT_DATA, tmp,
		NULL);

	if(tmp->mi==NULL)
	{
		if(tmp->name!=NULL)
			free(tmp->name);
		titem_free(tmp);
		return(0);
	}

	tmp->do_events=do_events;
	tmp->p=NULL;

	return(tmp);
}

tpitem tpitem_new_image(p, do_events)
tpic p;
int (*do_events)();
{
	ltpitem tmp;

	if(p==NULL && do_events==NULL)
	    return(NULL);
	if(titem_type(p)!=lt_pic)
	    return(NULL);
	
	tmp=(ltpitem)titem_new(NULL, lt_pitem, sizeof(ltpitemd));
	if(tmp==NULL)
	    return(NULL);
	
	tmp->p=p;

	tmp->mi=xv_create(NULL, MENUITEM,
		MENU_IMAGE, tpic_xview(tmp->p),
		MENU_NOTIFY_PROC, tpitem_notify,
		MENU_CLIENT_DATA, tmp,
		NULL);

	if(tmp->mi==NULL)
	{
		titem_free(tmp);
		return(0);
	}

	tmp->do_events=do_events;
	tmp->name=NULL;
	return(tmp);
}

int tpitem_free(i)
ltpitem i;
{
	/* check type */
	if(i==NULL)
		return(0);
	if(titem_type(i)!=lt_pitem)
		return(0);
	
	if(i->name!=NULL)
		free(i->name);
	if(i->mi!=NULL)
		xv_destroy_safe(i->mi);
	return(titem_free(i));
}

int tpitem_set_name(i, name)
ltpitem i;
char *name;
{
	/* check type */
	if(i==NULL || name==NULL)
	    return(0);
	if(titem_type(i)!=lt_pitem)
	    return(0);
	if(i->name==NULL)
	    return(0);
	
	free(i->name);
	xv_set(i->mi, MENU_STRING, name, NULL);
	i->name=(char *)strdup(name);
	return(1);
}

char *tpitem_get_name(i)
ltpitem i;
{
	/* check type */
	if(i==NULL)
		return(0);
	if(titem_type(i)!=lt_pitem)
		return(0);
	
	if(i->name==NULL)
	    return(NULL);
	else
	    return(i->name);
}

int tpitem_set_image(i, p)
ltpitem i;
tpic p;
{
	/* check type */
	if(i==NULL || p==NULL)
	    return(0);
	if(titem_type(i)!=lt_pitem || titem_type(p)!=lt_pic)
	    return(0);
	if(i->p==NULL)
	    return(0);
	
	xv_set(i->mi, MENU_IMAGE, tpic_xview(p), NULL);
	i->p=p;
	return(1);
}

tpic tpitem_get_image(i)
ltpitem i;
{
	/* check type */
	if(i==NULL)
		return(0);
	if(titem_type(i)!=lt_pitem)
		return(0);
	
	return(i->p);
}

void *tpitem_get_event_procedure(i)
ltpitem i;
{
	/* check type */
	if(i==NULL)
		return(0);
	if(titem_type(i)!=lt_pitem)
		return(0);
	
	return((void *)(i->do_events));
}

int tpitem_set_event_procedure(i, f)
ltpitem i;
int (*f)();
{
	/* check type */
	if(i==NULL)
		return(0);
	if(titem_type(i)!=lt_pitem)
		return(0);
	
	i->do_events=f;
	return(1);
}

Menu_item tpitem_xview_item(i)
ltpitem i;
{
	/* check type */
	if(i==NULL)
		return(NULL);
	if(titem_type(i)!=lt_pitem)
		return(NULL);
		
	return(i->mi);
}

int tpitem_selected(i)
ltpitem i;
{
	/* check type */
	if(i==NULL)
		return(0);
	if(titem_type(i)!=lt_pitem)
		return(0);
	
	if(xv_get(i->mi, MENU_SELECTED))
		return(0);
	else
		return(1);
}

int tpitem_select(i)
ltpitem i;
{
	/* check type */
	if(i==NULL)
		return(0);
	if(titem_type(i)!=lt_pitem)
		return(0);
	
	xv_set(i->mi, MENU_SELECTED, TRUE, NULL);
	return(1);
}

int tpitem_unselect(i)
ltpitem i;
{
	/* check type */
	if(i==NULL)
		return(0);
	if(titem_type(i)!=lt_pitem)
		return(0);
	
	xv_set(i->mi, MENU_SELECTED, FALSE, NULL);
	return(1);
}

int tpitem_enabled(i)
ltpitem i;
{
	/* check type */
	if(i==NULL)
		return(0);
	if(titem_type(i)!=lt_pitem)
		return(0);
	
	if(xv_get(i->mi, MENU_INACTIVE))
		return(0);
	else
		return(1);
}

int tpitem_enable(i)
ltpitem i;
{
	/* check type */
	if(i==NULL)
		return(0);
	if(titem_type(i)!=lt_pitem)
		return(0);
	
	xv_set(i->mi, MENU_INACTIVE, FALSE, NULL);
	return(1);
}

int tpitem_disable(i)
ltpitem i;
{
	/* check type */
	if(i==NULL)
		return(0);
	if(titem_type(i)!=lt_pitem)
		return(0);
	
	xv_set(i->mi, MENU_INACTIVE, TRUE, NULL);
	return(1);
}

int tpitem_inverted(i)
ltpitem i;
{
	/* check type */
	if(i==NULL)
		return(0);
	if(titem_type(i)!=lt_pitem)
		return(0);
	
	if(xv_get(i->mi, MENU_INVERT))
		return(0);
	else
		return(1);
}

int tpitem_invert(i)
ltpitem i;
{
	/* check type */
	if(i==NULL)
		return(0);
	if(titem_type(i)!=lt_pitem)
		return(0);
	
	xv_set(i->mi, MENU_INVERT, TRUE, NULL);
	return(1);
}

int tpitem_normal(i)
ltpitem i;
{
	/* check type */
	if(i==NULL)
		return(0);
	if(titem_type(i)!=lt_pitem)
		return(0);
	
	xv_set(i->mi, MENU_INVERT, FALSE, NULL);
	return(1);
}

int tpitem_set_submenu(i, m)
ltpitem i;
Menu m;
{
	/* check type */
	if(i==NULL)
		return(0);
	if(titem_type(i)!=lt_pitem)
		return(0);
	
	xv_set(i->mi, MENU_PULLRIGHT, m, NULL);
	return(1);
}
