#include <stdio.h>

#include <stdio.h>

#include "generic.h"

rectintersect(cx,cy,cw,ch, ax,ay,aw,ah, bx,by,bw,bh)
/* make the intersection of a and b into c */
int *cx,*cy,*cw,*ch, ax,ay,aw,ah, bx,by,bw,bh;
{
    int x2, y2;

    *cx=(ax<bx?bx:ax);
    *cy=(ay<by?by:ay);
    x2=(ax+aw<bx+bw?ax+aw:bx+bw);
    y2=(ay+ah<by+bh?ay+ah:by+bh);
    *cw=x2-*cx;
    *ch=y2-*cy;
}

rectunion(cx,cy,cw,ch, ax,ay,aw,ah, bx,by,bw,bh)
/* make the union of a and b into c */
int *cx,*cy,*cw,*ch, ax,ay,aw,ah, bx,by,bw,bh;
{
    int x2, y2;

    *cx=(ax<bx?ax:bx);
    *cy=(ay<by?ay:by);
    x2=(ax+aw<bx+bw?bx+bw:ax+aw);
    y2=(ay+ah<by+bh?by+bh:ay+ah);
    *cw=x2-*cx;
    *ch=y2-*cy;
}

rectcpy(ax,ay,aw,ah, bx,by,bw,bh)
/* copy rect b into rect a */
int *ax,*ay,*aw,*ah, bx,by,bw,bh;
{
    *ax=bx;
    *ay=by;
    *aw=bw;
    *ah=bh;
}

get_corner(rx,ry,rw,rh, dir, x, y)
/* return the corner of rect r specified by dir */
int rx,ry,rw,rh;
direction dir;
int *x, *y;
{
    switch(dir)
    {
        case NW:
            *x=rx;
            *y=ry;
            break;
        case SW:
            *x=rx;
            *y=ry+rh;
            break;
        case NE:
            *x=rx+rw;
            *y=ry;
            break;
        case SE:
            *x=rx+rw;
            *y=ry+rh;
            break;
        case CENTER:
            *x=rx+rw/2;
            *y=ry+rh/2;
            break;
        default:
            break;
    }
}

set_corner(rx,ry,rw,rh, dir, x, y)
/* set the corner of rect r specified by dir */
int *rx,*ry,*rw,*rh;
direction dir;
int x, y;
{
    switch(dir)
    {
        case NW:
            *rw=*rw+*rx-x;
            *rx=x;
            *rh=*rh+*ry-y;
            *ry=y;
            break;
        case SW:
            *rw=*rw+*rx-x;
            *rx=x;
            *rh=y-*ry;
            break;
        case NE:
            *rw=x-*rx;
            *rh=*rh+*ry-y;
            *ry=y;
            break;
        case SE:
            *rw=x-*rx;
            *rh=y-*ry;
            break;
        default:
            break;
    }
}

move_corner(rx,ry,rw,rh, dir, x, y)
/* set the corner of rect r specified by dir */
int *rx,*ry,*rw,*rh;
direction dir;
int x, y;
{
    switch(dir)
    {
        case NW:
            *rx=x;
            *ry=y;
            break;
        case SW:
            *rx=x;
            *ry=y-*rh;
            break;
        case NE:
            *rx=x-*rw;
            *ry=y;
            break;
        case SE:
            *rx=x-*rw;
            *ry=y-*rh;
            break;
        case CENTER:
            *rx=x-*rw/2;
            *ry=y-*rh/2;
        default:
            break;
    }
}

constrain_rect_max(rx,ry,rw,rh, maxw,maxh, dir)
/* make r smaller than max by moving corner dir */
int *rx,*ry,*rw,*rh;
int maxw,maxh;
direction dir;
{
    switch(dir)
    {
        case NW:
            if(*rw>maxw && maxw>=0)
            {
                *rx+=*rw-maxw;
                *rw=maxw;
            }
            if(*rh>maxh && maxh>=0)
            {
                *ry+=*rh-maxh;
                *rh=maxh;
            }
            break;
        case SW:
            if(*rw>maxw && maxw>=0)
            {
                *rx+=*rw-maxw;
                *rw=maxw;
            }
            if(*rh>maxh && maxh>=0)
            {
                *rh=maxh;
            }
            break;
        case NE:
            if(*rw>maxw && maxw>=0)
            {
                *rw=maxw;
            }
            if(*rh>maxh && maxh>=0)
            {
                *ry+=*rh-maxh;
                *rh=maxh;
            }
            break;
        case SE:
            if(*rw>maxw && maxw>=0)
            {
                *rw=maxw;
            }
            if(*rh>maxh && maxh>=0)
            {
                *rh=maxh;
            }
            break;
        default:
            break;
    }
}

constrain_rect_min(rx,ry,rw,rh, minw,minh, dir)
/* make r bigger than min by moving corner dir */
int *rx,*ry,*rw,*rh;
int minw,minh;
direction dir;
{
    switch(dir)
    {
        case NW:
            if(*rw<minw && minw>=0)
            {
                *rx-=minw-*rw;
                *rw=minw;
            }
            if(*rh<minh && minh>=0)
            {
                *ry-=minh-*rh;
                *rh=minh;
            }
            break;
        case SW:
            if(*rw<minw && minw>=0)
            {
                *rx-=minw-*rw;
                *rw=minw;
            }
            if(*rh<minh && minh>=0)
            {
                *rh=minh;
            }
            break;
        case NE:
            if(*rw<minw && minw>=0)
            {
                *rw=minw;
            }
            if(*rh<minh && minh>=0)
            {
                *ry-=minh-*rh;
                *rh=minh;
            }
            break;
        case SE:
            if(*rw<minw && minw>=0)
            {
                *rw=minw;
            }
            if(*rh<minh && minh>=0)
            {
                *rh=minh;
            }
            break;
        default:
            break;
    }
}

int rect_in_rect(ax,ay,aw,ah, bx,by,bw,bh)
/* returns true if rect a is completely inside the rectangle b */
int ax,ay,aw,ah, bx,by,bw,bh;
{
    if(ax>=bx &&
        ax+aw<=bx+bw &&
        ay>=by &&
        ay+ah<=by+bh)
        return(1);
    else
        return(0);
}

int pt_in_rect(x, y, bx,by,bw,bh)
/* returns true if x,y is in the rectangle b */
int x,y, bx,by,bw,bh;
{
    if(x>=bx && x<=bx+bw && y>=by && y<=by+bh)
        return(1);
    else
        return(0);
}

normalize_rect(x, y, w, h)
/* normalize rectangle to positive width and height */
int *x, *y, *w, *h;
{
    if(*h<0)
    {
        *y+=*h;
        *h=-*h;
    }
    if(*w<0)
    {
        *x+=*w;
        *w=-*w;
    }
}
