#include <stdio.h>

#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/scrollbar.h>
#include <xview/win_input.h>
#include "list.h"

#include "generic.h"

#include "canvas.h"

typedef struct {
	ltgenericd g;
	char *name;
	int len;
	int grey;
	} ltlistitemd, *ltlistitem;

typedef struct {
	ltgenericd g;
	tcanvas c;	/* scrolling canvas for list */
	list items;
	tfont f;
	int cellh, cellw;
	int fhigh, fascent;
	tcontext gc, gcerase, gcgrey;
	int numitems;
	int selected;
	int (*do_events)();
	tpic grey;
	unsigned long lastkeytime;
	int charposition;
	} ltlistd, *ltlist;

#define boxon(l,n) if((n)!=-1)draw_rect((l)->c,(l)->gc,\
					0,(n)*(l)->cellh,(l)->cellw-1,(l)->cellh-1)
#define boxoff(l,n) if((n)!=-1)draw_rect((l)->c,(l)->gcerase,\
					0,(n)*(l)->cellh,(l)->cellw-1,(l)->cellh-1)

/* define stipple, just a checkerboard bitmap.  Used to draw grey'ed file
** names */
#define grey_width 16
#define grey_height 16
static char grey_bits[] = {
	0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa,
	0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa,
	0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa};

tdisplay tlist_display(l)
ltlist l;
{
	/* check types */
	if(l==NULL)
		return(0);
	if(titem_type(l)!=lt_list)
		return(0);

	return(tcanvas_display(l->c));
}

void *tlist_drawable(l)
ltlist l;
{
	/* check types */
	if(l==NULL)
		return(0);
	if(titem_type(l)!=lt_list)
		return(0);

	return((void *)tcanvas_drawable(l->c));
}

int tlist_bottom_side(l)
ltlist l;
{
	/* check types */
	if(l==NULL)
		return(0);
	if(titem_type(l)!=lt_list)
		return(0);

	return(tcanvas_bottom_side(l->c));
}

int tlist_right_side(l)
ltlist l;
{
	/* check types */
	if(l==NULL)
		return(0);
	if(titem_type(l)!=lt_list)
		return(0);

	return(tcanvas_right_side(l->c));
}

void move_item_on_screen(l, item)
ltlist l;
int item;
{
	int x,y;

	x=l->cellw/2;
	y=item*l->cellh+l->cellh/2;
	tcanvas_move_point_on_screen(l->c, x, y);
}

void get_top_and_bottom(l, t, b)
ltlist l;
int *t, *b;
{
	int x, y;

	x=0;
	y=0;
	point_to_x(l->c, &x, &y);
	*t=-y/l->cellh;
	*b=*t+tcanvas_height(l->c)/l->cellh;
}

static int dragging=0;
static int notinlist=0;

void move_list_for_selection(c)
ltcanvas c;
{
	ltlist l;
	int x, y;
	tevent e;

	if(!dragging)
		return;
	tcanvas_get_pointer(c, &x, &y, 0);

	l=titem_get_data(c);
	e=tevent_create_user(x, y);
	handle_list(c, e);
	tevent_free(e);
}

start_list_scrolling(l)
ltlist l;
{
	tcanvas_start_timer(l->c, 300, move_list_for_selection);
}

stop_list_scrolling(l)
ltlist l;
{
	tcanvas_stop_timer(l->c);
}

int tlist_find_name(l, sel, pos, ch)
ltlist l;
int sel, pos, ch;
{
	int new, last;
	int possibility;
	char *oldstr, *newstr;
	ltlistitem t;

	last=-1;
	new=-1;
	oldstr=(char *)tlist_nth_name(l, sel);
	startlist(l->items);
	for(new=0;new<l->numitems;new++)
	{
		t=(ltlistitem)listnext(l->items);
		newstr=t->name;
		possibility=1;
		if(pos>0)
		{
			/* compare start of name */
			if(strncmp(newstr, oldstr, pos)!=0)
			{
				possibility=0;
				if(last==-1)
					last=new;
			}
		}
		else if(newstr[pos]<ch)
		{
			last=new;
			possibility=0;
		}

		if(possibility)
		{
			if(newstr[pos]==ch)
			{
				break;
			}
			else
			{
				possibility=0;
				break;
			}
		}
	}
	if(new==l->numitems)
		new=last;
	return(new);
}

int handle_list(c, e)
tcanvas c;
tevent e;
{
	ltlist l;
	ltlistitem t;
	int i;
	int x, y;
	static int newitem, olditem;
	int top, bot;
	int ch;
	unsigned long newtime;

	l=titem_get_data(c);

	tevent_location(e, &x, &y);

	switch(tevent_type(e))
	{
		case te_repaint:
			if(l->numitems>0)
			{
				startlist(l->items);
				for(i=0;i<l->numitems;i++)
				{
					t=listnext(l->items);
					if(t->grey)
						draw_text(l->c, l->gcgrey, 2, i*l->cellh+l->fascent,
							t->name, t->len);
					else
						draw_text(l->c, l->gc, 2, i*l->cellh+l->fascent,
							t->name, t->len);
				}
				boxon(l, l->selected);
			}
			break;
		case te_mousedown:
			if(l->numitems>0)
			{
				dragging=1;
				notinlist=0;
				tcanvas_clipping_off(l->c);
				boxoff(l, l->selected);
				newitem=y/l->cellh;
				if(newitem<0)
					newitem=0;
				if(newitem>=l->numitems)
					newitem=l->numitems-1;
				if(tlist_item_greyed(l, newitem+1))
					newitem=-1;
				boxon(l, newitem);
			}
			break;
		case te_user:
			if(l->numitems>0)
			{
				/* dragging, initiated by timer */
				if(dragging && notinlist)
				{
					olditem=newitem;
					newitem=y/l->cellh;
					get_top_and_bottom(l, &top, &bot);
					/*printf("newitem:%d:top:%d:bot:%d\n", newitem, top, bot);*/
					if(newitem<top)
					{
						tcanvas_scroll_up(l->c);
						get_top_and_bottom(l, &top, &bot);
						newitem=top;
					}
					else if(newitem>bot)
					{
						tcanvas_scroll_down(l->c);
						get_top_and_bottom(l, &top, &bot);
						newitem=bot;
					}
					else
					{
						notinlist=0;
						stop_list_scrolling(l);
					}
					if(newitem<0)
						newitem=0;
					if(newitem>=l->numitems)
						newitem=l->numitems-1;
					tcanvas_clipping_off(l->c);
					if(tlist_item_greyed(l, newitem+1))
						newitem=-1;
					boxoff(l, olditem);
					boxon(l, newitem);
				}
			}
			break;
		case te_drag:
			if(l->numitems>0)
			{
				/* dragging, initiated by user */
				if(dragging)
				{
					olditem=newitem;
					newitem=y/l->cellh;
					get_top_and_bottom(l, &top, &bot);
					if(newitem>=top && newitem<=bot)
					{
						if(notinlist)
						{
							stop_list_scrolling(l);
							notinlist=0;
						}
						if(newitem<0)
							newitem=0;
						if(newitem>=l->numitems)
							newitem=l->numitems-1;
						tcanvas_clipping_off(l->c);
						if(tlist_item_greyed(l, newitem+1))
							newitem=-1;
						boxoff(l, olditem);
						boxon(l, newitem);
					}
					else
					{
						newitem=olditem;
						if(!notinlist)
						{
							notinlist=1;
							start_list_scrolling(l);
						}
					}
				}
			}
			break;
		case te_mouseup:
			if(l->numitems>0)
			{
				dragging=0;
				stop_list_scrolling(l);
				if(l->do_events!=NULL)
				{
					if((*l->do_events)(l, newitem+1, e))
						l->selected=newitem;
				}
				else
					l->selected=newitem;
				tcanvas_clipping_off(l->c);
				boxoff(l, newitem);
				boxon(l, l->selected);
				/*printf("%d\n", l->selected);*/
			}
			break;
		case te_keydown:
			/*get_top_and_bottom(l, &top, &bot);*/
			newitem=l->selected;
			switch(tevent_special_key(e))
			{
				case tk_down:
					if(l->selected>=0 && l->selected<l->numitems-1)
						newitem+=1;
					break;
				case tk_up:
					if(l->selected>0 && l->selected<l->numitems)
						newitem-=1;
					break;
				case tk_none:
					/* removed for efficiency considerations  :) */
					/*c=tevent_string(e)[0];*/
					/*if(isascii(c) && c!='\t' && c!='\r' && c!='\n')*/
					/*{*/
						/*int found;*/

						/*newtime=(unsigned long)tevent_time(e);*/
						/*if(newtime-l->lastkeytime>400)*/
							/* timeout, new word */
							/*l->charposition=0;*/
						/*l->lastkeytime=newtime;*/
						/*found=tlist_find_name(l,*/
							/*l->selected, l->charposition, ch);*/
						/*if(found!=-1)*/
							/*newitem=found;*/
					/*}*/
					break;
				default:
					break;
			}
			if(newitem!=l->selected)
			{
				move_item_on_screen(l, newitem);
				/*if(newitem<top)*/
					/*tcanvas_scroll_up(l->c);*/
				/*else if(newitem>bot)*/
					/*tcanvas_scroll_down(l->c);*/
				tcanvas_clipping_off(l->c);
				boxoff(l, l->selected);
				l->selected=newitem;
				boxon(l, l->selected);
			}
			(*l->do_events)(l, l->selected, e);
			break;
		default:
			if(l->do_events!=NULL)
			{
				(*l->do_events)(l, l->selected, e);
			}
			break;
	}
}

void tlist_refresh(l)
ltlist l;
{
	/* check types */
	if(l==NULL)
		return;
	if(titem_type(l)!=lt_list)
		return;

	tcanvas_add_all(l->c);
	tcanvas_paint_area(l->c);
}

tlist tlist_new(parent, x,y,w,h,right,below, f, cellh, args)
tframe parent;
int x,y,w,h;
titem right,below;
tfont f;
int cellh;
targs args;
{
	ltlist tmp;

	if(parent==NULL || f==NULL)
		return(NULL);
	if(titem_type(parent)!=lt_frame || titem_type(f)!=lt_font)
		return(NULL);
	
	tmp=(ltlist)titem_new(parent, lt_list, sizeof(ltlistd));
	if(tmp==NULL)
	{
		printf("Not enough memory for list.\n");
		return(NULL);
	}

	tmp->f=f;
	tmp->fhigh=tfont_height(f);
	tmp->fascent=tfont_ascent(f);

	if(cellh==0)
		cellh=tmp->fhigh;
	tmp->c=(tcanvas)tcanvas_new2(parent, x,y,w,h,right,below,
		w,cellh, 1,1, w, cellh, 0, 0,1, args);
	tmp->cellh=cellh;
	tmp->selected=0;
	tmp->do_events=NULL;
	if(tmp->c==NULL)
	{
		titem_free(tmp);
		return(NULL);
	}
	tcanvas_pages(tmp->c, 0);
	tcanvas_set_event_procedure(tmp->c, handle_list);
	titem_set_data(tmp->c, tmp);
	tmp->items=newlist();
	tmp->numitems=0;
	tmp->gc=tcontext_new(tmp->c, args);
	if(tmp->gc==NULL)
	{
		tcanvas_free(tmp->c);
		freelist(tmp->items);
		titem_free(tmp);
		return(NULL);
	}
	tcontext_set_font(tmp->gc, f);
	tmp->gcerase=tcontext_new(tmp->c, args);
	if(tmp->gcerase==NULL)
	{
		tcontext_free(tmp->gc);
		tcanvas_free(tmp->c);
		freelist(tmp->items);
		titem_free(tmp);
		return(NULL);
	}
	tcontext_set_foreground(tmp->gcerase, tcolor_white(tmp->c));
	tmp->gcgrey=tcontext_new(tmp->c, args);
	if(tmp->gcgrey==NULL)
	{
		tcontext_free(tmp->gcerase);
		tcontext_free(tmp->gc);
		tcanvas_free(tmp->c);
		freelist(tmp->items);
		titem_free(tmp);
		return(NULL);
	}
	tcontext_set_font(tmp->gcgrey, f);
	tcontext_set_fillstyle(tmp->gcgrey, tfill_opaquestippled);
	tmp->grey=(tpic)tpic_new(grey_bits, grey_width, grey_height);
	tcontext_set_stipple(tmp->gcgrey, tmp->grey);
	tmp->cellw=tcanvas_width(tmp->c);

	tmp->lastkeytime=0;
	tmp->charposition=0;
	return(tmp);
}

int tlist_set_event_procedure(l, do_events)
ltlist l;
int (*do_events)();
{
	/* check types */
	if(l==NULL)
		return(0);
	if(titem_type(l)!=lt_list)
		return(0);
	
	l->do_events=do_events;
	return(1);
}


void tlist_add(l, s, after, grey, data)
/* after:0=add at start, n=add after nth, -1=add at end,
	-2=add alphabetically */
ltlist l;
char *s;
int after;
int grey;
void *data;
{
	ltlistitem tmp;
	ltlistitem x;
	list t;
	int i;

	/* check types */
	if(l==NULL || s==NULL)
		return;
	if(titem_type(l)!=lt_list)
		return;

	tmp=(ltlistitem)titem_new(l, lt_listitem, sizeof(ltlistitemd));
	if(tmp==NULL)
		return;
	tmp->name=(char *)strdup(s);
	tmp->len=strlen(s);
	tmp->grey=grey;
	titem_set_data(tmp, data);
	if(after==-1)
		endlist(l->items);
	else if(after==-2)
	{
		startlist(l->items);
		lfor(l->items, t)
		{
			x=nodeobj(t);
			if(strcmp(x->name, s)>0)
				break;
			else
				listnext(l->items);
		}
	}
	else
	{
		startlist(l->items);
		for(;after>0;after--)
			listnext(l->items);
	}
	addnode(l->items, tmp);
	l->numitems++;

	if(l->selected!=-1)
	{
		startlist(l->items);
		for(i=0;i<=l->selected;i++)
			listnext(l->items);
		tmp=listcurr(l->items);
		if(tmp->grey)
			l->selected=-1;
	}

	tcanvas_set_canvas_height(l->c, l->numitems);
}

void tlist_select(l, item)
/* item: 1=first item */
ltlist l;
int item;
{
	/* check types */
	if(l==NULL)
		return;
	if(titem_type(l)!=lt_list)
		return;

	if(tlist_item_greyed(l, item))
		return;
	item--;
	if(item<0 || item>=l->numitems)
		return;
	/* erase the old rectangle */
	boxoff(l, l->selected);
	/* draw the new rectangle */
	boxon(l, item);
	l->selected=item;

	move_item_on_screen(l, item);
	tlist_refresh(l);
}

void tlist_move(l, x, y, right, below)
ltlist l;
int x,y;
titem right, below;
{
	/* check types */
	if(l==NULL)
		return;
	if(titem_type(l)!=lt_list)
		return;

	tcanvas_move(l->c, x, y, right, below);
}

void tlist_resize(l, x, y, w, h, right, below)
ltlist l;
int x,y,w,h;
titem right, below;
{
	/* check types */
	if(l==NULL)
		return;
	if(titem_type(l)!=lt_list)
		return;

	tcanvas_resize(l->c, x, y, w, h, right, below);
	l->cellw=tcanvas_width(l->c);
}

int tlist_item_greyed(l, n)
/* 1=first, -1=last */
ltlist l;
int n;
{
	ltlistitem t;

	/* check types */
	if(l==NULL)
		return;
	if(titem_type(l)!=lt_list)
		return;

	if(l->numitems==0)
		return(0);
	if(n==-1)
		endlist(l->items);
	else
	{
		startlist(l->items);
		for(;n>0;n--)
			listnext(l->items);
	}
	t=listcurr(l->items);
	return(t->grey);
}

void *tlist_nth_data(l, n)
/* 1=first, -1=last */
ltlist l;
int n;
{
	ltlistitem t;

	/* check types */
	if(l==NULL)
		return;
	if(titem_type(l)!=lt_list)
		return;

	if(l->numitems==0)
		return(NULL);
	if(n==-1)
		endlist(l->items);
	else
	{
		startlist(l->items);
		for(;n>0;n--)
			listnext(l->items);
	}
	t=listcurr(l->items);
	return((void *)titem_get_data(t));
}

char *tlist_nth_name(l, n)
/* 1=first, -1=last */
ltlist l;
int n;
{
	ltlistitem t;

	/* check types */
	if(l==NULL)
		return;
	if(titem_type(l)!=lt_list)
		return;

	if(l->numitems==0)
		return(NULL);
	if(n==-1)
		endlist(l->items);
	else
	{
		startlist(l->items);
		for(;n>0;n--)
			listnext(l->items);
	}
	t=listcurr(l->items);
	return(t->name);
}

int tlist_selected(l)
ltlist l;
{
	/* check types */
	if(l==NULL)
		return;
	if(titem_type(l)!=lt_list)
		return;

	return(l->selected+1);
}

tlist_remove_all(l)
/* removes all items in list */
ltlist l;
{
	ltlistitem t;

	startlist(l->items);
	while((t=listnext(l->items))!=NULL)
		free(t);
	freelist(l->items);
	l->items=newlist();
	l->numitems=0;
	l->selected=0;
	tcanvas_scroll_to_top(l->c);
}

Canvas tlist_xview(l)
ltlist l;
{
	/* check types */
	if(l==NULL)
		return;
	if(titem_type(l)!=lt_list)
		return;

	return(tcanvas_xview(l->c));
}

