import java.applet.Applet;
import java.awt.*;

import vrml.external.Browser;
import vrml.external.Node;
import vrml.external.field.*;
import vrml.external.exception.*;

public class ColorTest extends Applet
{
  final static int MAX = 100;
  Browser browser;
  Node color;
  EventInMFColor evcolor;
  Button b1, b2;
  int left = 0;
  int right = 1;
  float[] red = { 1, 0, 0 };
  float[] blue = { 0, 0, 1 };

  public void init ()
  {
    System.err.println ("ColorTest: init");
    for (int i = 0; i < MAX; i++)
    {
      try
      {
        browser = Browser.getBrowser (this);
        if (browser != null)
          break;
        System.err.println ("Browser not yet available. Will try again");
        Thread.sleep (500);
      }
      catch (Throwable e) { }
    }

    if (browser == null)
    {
      System.out.println ("Browser handle not available");
      return;
    }

    System.out.println ("talking to browser: " + browser.getName () + " " + browser.getVersion ());
    System.out.println ("currently viewed scene: " + browser.getWorldURL ());

    System.out.println ("trying to get node \"COLOR\"");
    try
    {
      color = browser.getNode ("COLOR");
      System.out.println ("node type: " + color.getType ());
    }
    catch (InvalidNodeException e)
    {
      System.out.println ("no such Node");
    }

    System.out.println ("trying to get EventIn \"color\"");
    try
    {
      evcolor = (EventInMFColor) color.getEventIn ("color");
    }
    catch (InvalidEventInException e)
    {
      System.out.println ("no such EventIn");
    }
    System.out.println ("Ok. it's of type " + evcolor.getType ());

    EventOutMFColor evoutcolor = null;
    System.out.println ("trying to get EventOut \"color\"");
    try
    {
      evoutcolor = (EventOutMFColor) color.getEventOut ("color");
    }
    catch (InvalidEventOutException e)
    {
      System.out.println ("no such EventOut");
    }
    System.out.println ("Ok. it's of type " + evoutcolor.getType ());
    float[][] v = evoutcolor.getValue ();
    for (int i = 0; i < v.length; i++)
      System.out.println (v[i][0] + ", " + v[i][1] + ", " + v[i][2]);

    b1 = new Button ("Left: Blue");
    add (b1);
    b2 = new Button ("Right: Red");
    add (b2);
    validate ();
  }

  public boolean action (Event e, Object arg)
  {
    if (e.target == b1)
    {
      if (left > 0)
      {
        evcolor.set1Value (0, red);
        b1.setLabel ("Left: Blue");
      }
      else
      {
        evcolor.set1Value (0, blue);
        b1.setLabel ("Left: Red");
      }
      left = 1 - left;
      return true;
    }
    if (e.target == b2)
    {
      if (right > 0)
      {
        evcolor.set1Value (1, red);
        b2.setLabel ("Right: Blue");
      }
      else
      {
        evcolor.set1Value (1, blue);
        b2.setLabel ("Right: Red");
      }
      right = 1 - right;
      return true;
    }
    return false;
  }   
}
