/*
 * <copyright>
 *
 * Copyright (c) 1997
 * Institute for Information Processing and Computer Supported New Media (IICM),
 * Graz University of Technology, Austria.
 *
 * This file is part of the VRwave Java-EAI implementation.
 *
 * </copyright>
 */
/*
 * created: kwagen, 19970801
 *
 * changed: kwagen, 19970916
 *
 * $Id: EventInSFVec3f.java,v 1.1 1997/09/17 11:52:53 kwagen Exp $
 */

package vrml.external.field;

import iicm.vrml.pw.SFVec3f;

public class EventInSFVec3f extends EventIn
{
  public void setValue (float[] value) throws IllegalArgumentException
  {
    if (!scene_.getBehavior ())
      return;

    if (value == null || value.length != 3)
      throw new IllegalArgumentException ();

    ((SFVec3f) eventin_).setValue (value[0], value[1], value[2]);

    sendEvent ();
    
    scene_.redraw ();
  }
}
