/*
 * <copyright>
 *
 * Copyright (c) 1997
 * Institute for Information Processing and Computer Supported New Media (IICM),
 * Graz University of Technology, Austria.
 *
 * This file is part of the VRwave Java-EAI implementation.
 *
 * </copyright>
 */
/*
 * created: kwagen, 19970801
 *
 * changed: kwagen, 19970916
 *
 * $Id: EventInSFImage.java,v 1.1 1997/09/17 11:52:53 kwagen Exp $
 */

package vrml.external.field;

import iicm.vrml.pw.SFImage;

public class EventInSFImage extends EventIn
{
  public void setValue (int width, int height, int numComponents, byte[] pixels) throws IllegalArgumentException
  {
    if (!scene_.getBehavior ())
      return;

    if (pixels == null || pixels.length != width * height * numComponents || numComponents < 1 || numComponents > 4)
      throw new IllegalArgumentException ();

    int[] data = new int[3 + width * height];

    data[0] = width;
    data[1] = height;
    data[2] = numComponents;

    switch (numComponents)
    {
      case 1:
        for (int i = 0; i < width * height; i++)
          data[3+i] = pixels[i];
        break;
      case 2:
        for (int i = 0; i < width * height; i++)
          data[3+i] = pixels[i*2] << 8 + pixels[i*2+1];
        break;
      case 3:
        for (int i = 0; i < width * height; i++)
          data[3+i] = pixels[i*3] << 16 + pixels[i*3+1] << 8 + pixels[i*3+2];
        break;
      case 4:
        for (int i = 0; i < width * height; i++)
          data[3+i] = pixels[i*4] << 24 + pixels[i*4+1] << 16 + pixels[i*4+2] + pixels[i*4+3];
        break;
    }

    ((SFImage) eventin_).setValue (data);

    sendEvent ();

    scene_.redraw ();
  }
}
