/*
 * PropPanel - panel dividing hspace proportionally
 *
 * created: apesen, 19961201
 * changed: mpichler, 19970807
 *
 * $Id: PropPanel.java,v 1.2 1997/08/08 09:52:20 kwagen Exp $
 */

package iicm.widgets;

import java.awt.*;
import java.util.*;


/**
 * PropPanel - panel which layouts components
 * based on PropField size requests
 */

public class PropPanel extends Panel
{
  Vector pfields_ = new Vector ();
  Component master_;  // its size determins total available size
  int height_;


  public PropPanel (Component master, int height)
  {
    master_ = master;
    setLayout (new FlowLayout (FlowLayout.LEFT, 0, 0));
    height_ = height;  // getFontMetrics (cmp.getFont()).getHeight() * 2
  }


  public void addField (Component comp, PropField pf)
  {
    pfields_.addElement (pf);
    add (comp);
  }


  public void addField (Component comp)  // in case comp itself implements PropField interface
  {
    pfields_.addElement ((PropField) comp);
    add (comp);
  }


  Dimension propComponentSize (Component cmp)
  {
    if (pfields_.isEmpty ())
      return cmp.size ();

    if (master_ == null)
      return cmp.size ();

    int n = countComponents ();
    int sumprops = 0;
    int natsum = 0;
    int cmppropwidth = 0;

    for (int i = 0;  i < n;  i++)
    {
      PropField curfield = (PropField) pfields_.elementAt (i);
      Component curcomp = getComponent (i);

      int nat = curfield.naturalWidth ();
      int curprop = curfield.propSize ();

      if (curcomp == cmp)  // it's me
      {
        cmppropwidth = curprop;
        // System.err.println ("field proportional width: " + curprop);

        if (curprop == PropField.USENATURALSIZE)
          return new Dimension (nat, height_);
      }

      if (curprop == PropField.USENATURALSIZE)
        natsum += nat;
      else
        sumprops += curprop;
    }

    Dimension msize = master_.size ();
    int width = (int) (msize.width - natsum) * cmppropwidth / sumprops;
    // System.err.println ("PropPanel component gets " + cmppropwidth + "/" + sumprops + " of " + (msize.width - natsum));

    return new Dimension (width, height_);
  } // propComponentSize

}; // PropPanel
