/*
 * Progress widget
 *
 * created: apesen, 19961201
 * changed: mpichler, 19970807
 *
 * $Id: Progress.java,v 1.2 1997/08/08 09:51:53 kwagen Exp $
 */


package iicm.widgets;

import java.awt.*;
import java.util.*;


public class Progress extends Canvas implements PropField
{
  PropPanel ppanel_;
  int psize_, natwidth_;
  private float curvalue_ = 0.0f;

  public Progress (PropPanel ppanel, int psize)
  {
    setFont (Fontify.fntLabel2);
    ppanel_ = ppanel;
    psize_ = psize;
    natwidth_ = getFontMetrics (getFont ()).stringWidth ("100 %") * 2;
  }

  /**
   * set new progress value.
   * calls repaint if percentage changes
   */

  public void setValue (float newval)
  {
    if ((int) (newval * 100 + 0.5f) != (int) (curvalue_ * 100 + 0.5f))
    {
      curvalue_ = newval;
      repaint ();
    }
  }

  public float getValue ()
  {
    return curvalue_;
  }

  public void paint (Graphics g)
  {
    Dimension d = size();
    int x, y, w, h, wp;

    x = 1;
    y = 1;
    w = d.width-2;
    wp= (int) ((w-3) * curvalue_);
    h = d.height-3;

    // background
    g.setColor (new Color (0x888888));
    g.fillRect (2, 2, w-2, h-2);

    // insets
    Color bg = getBackground ();
    g.setColor(new Color((int) (bg.getRed()/1.2), (int) (bg.getGreen()/1.2), (int) (bg.getBlue()/1.2)));
    // g.setColor (bg);
    g.draw3DRect (x, y, w, h, false);
    g.draw3DRect (x + 1, y + 1, w - 2, h - 2, false);

    // progress
    g.setColor (new Color (0x001B48));
    // g.setXORMode (Color.white);
    g.fillRect (x+2, y+2, wp, h-3);

    // label
    // g.setColor (Color.black);
    // g.setColor (Color.blue);
    g.setColor (Color.white);
    printString (g, Integer.toString ((int) (curvalue_ * 100 + 0.5f)) + " %", w, h);
  }

  private void printString (Graphics g, String msg, int w, int h)
  {
    FontMetrics metrics = g.getFontMetrics ();
    int x0 = w / 2 - metrics.stringWidth (msg) / 2;
    int y0 = h / 2 /* - metrics.getDescent () / 2 */  + metrics.getAscent () / 2;  // % labels have no descent
    g.drawString (msg, x0, y0);
  }

  public Dimension preferredSize ()
  {
    return ppanel_.propComponentSize (this);
  }

  // PropField
  public int propSize ()
  { return psize_; }

  public int naturalWidth ()
  { return natwidth_; }

}; // Progress
