/*
 * MenuBuilder - Builds up Menu from MenuDef.class 
 *
 * created: mpichler, 19961210
 *
 * changed: apesen, 19961213
 *
 * $Id: MenuBuilder.java,v 1.3 1997/01/20 15:21:57 mpichler Exp $
 */


package iicm.widgets;

import java.awt.*;

public class MenuBuilder
{
  static public final int SEPARATOR = -1;
  static public final int RADIOITEM = 1 << 31;
  static public final int TOGGLEITEM = 1 << 30;
  static final String ACCEL_PRE  = "    [";
  static final String ACCEL_POST = "]";

  static public MenuBar buildMenu (int[][][] ids, String[][] tstrings, int lang, MenuItem[] items, boolean helprightalign)
  {
    MenuBar menubar = new MenuBar ();
    Menu menu = null;  
    CheckboxGroup cbg = null;
    String label;
    int accel = tstrings[0].length -1;

    for (int i = 0;  i < ids.length;  i++)
    {
      // here at begin of new main menu pulldown
      menu = new Menu (tstrings [ids [i++][0][0]][lang]);

      for (int j = 0;  j < ids [i].length;  j++)
      {
        if (ids [i][j][0] == SEPARATOR)
        {
          cbg = null;
          menu.addSeparator ();
        }
        else if (ids [i][j].length > 1)  // pullright submenu
        {
          int id = ids[i][j][0];
          int mid = id & ~(RADIOITEM | TOGGLEITEM);
          label = tstrings [mid][lang];
          // MenuItem mitem = null;
          Menu submenu = new Menu(label);
          for (int k = 1;  k < ids [i][j].length;  k++)
          {
            if (ids [i][j][k] == SEPARATOR)
            {
              cbg = null;
              submenu.addSeparator ();
            }
            else
            {
              id = ids[i][j][k];
              mid = id & ~(RADIOITEM | TOGGLEITEM);
              if (tstrings [mid][accel] != null)
                 label = tstrings [mid][lang] + ACCEL_PRE + tstrings [mid][accel] + ACCEL_POST;
              else
                 label = tstrings [mid][lang];
              MenuItem submitem = null;
              
              if ((id & RADIOITEM) != 0)
              {
                if (cbg == null)
                   cbg = new CheckboxGroup ();  
                submitem = new RadioMenuItem(label,cbg);
              }
              else if ((id & TOGGLEITEM) != 0)
              {
                cbg = null;
                submitem = new CheckboxMenuItem (label);
              }
              else
              {
                cbg = null;
                submitem = new MenuItem (label);
              }

              if (submitem != null)
              {
                items [mid] = submitem;
                submitem.setFont (Fontify.fntSubMenuitem);
                submenu.add (submitem);
              }
            }
          } // for k (pullright submenu) 
          if (submenu != null)
          {
            submenu.setFont (Fontify.fntMenuitem);
            menu.add (submenu);
          }
          cbg = null;
        }
        else  // menu item (in pulldown menu)
        {
          int id = ids[i][j][0];
          int mid = id & ~(RADIOITEM | TOGGLEITEM);
          if (tstrings [mid][accel] != null)
            label = tstrings [mid][lang] + ACCEL_PRE + tstrings [mid][accel] + ACCEL_POST;
          else
            label = tstrings [mid][lang];
          MenuItem mitem = null;

          if ((id & RADIOITEM) != 0)
          {
            if (cbg == null)
               cbg = new CheckboxGroup ();  
            mitem = new RadioMenuItem(label,cbg);
          }
          else if ((id & TOGGLEITEM) != 0)
          {
            cbg = null;
            mitem = new CheckboxMenuItem (label);
          }
          else
          {
            cbg = null;
            mitem = new MenuItem (label);
          }

          if (mitem != null)
          {
            items [mid] = mitem;
            mitem.setFont (Fontify.fntMenuitem);
            menu.add (mitem);
          }
        }
      } // for j (submenu)
      menu.setFont (Fontify.fntMenubar);
      menubar.add (menu);
      cbg = null;
    } // for i (main menu)

    if (menu != null && helprightalign)  // last menu was Help
      menubar.setHelpMenu (menu);

    return menubar;
  } // buildMenu

} // MenuBuilder
