//
// l10n-ko.js
//
// default configuration of Netscape Korean kit.
// by cjh@freebsd.org
//

// SYNTAX HINTS:	Dashes are delimiters.  Use underscores instead. 
//			The first character after a period must be alphabetic.

config("timebomb.expiration_time",			-1);
config("timebomb.warning_time",				-1);
config("timebomb.relative_timebomb_secret_name",	"general.bproxy_cert_digest");
config("timebomb.relative_timebomb_days",		-1);
config("timebomb.relative_timebomb_warning_days",	-1);

pref("network.search.url",				"http://keyword.kr.netscape.com/");
pref("general.bproxy_cert_digest",			0);

pref("general.startup.browser",				true);
pref("general.startup.mail",				false);
pref("general.startup.message_center",		false);
pref("general.startup.news",				false);
pref("general.startup.editor",				false);
pref("general.startup.conference",			false);
pref("general.startup.calendar",			false);
pref("general.startup.netcaster",			false);

localDefPref("general.always_load_images",			true);
localDefPref("general.always_load_movies",			true);
localDefPref("general.always_load_sounds",			true);
pref("general.title_tips",				true);

pref("general.help_source.site",			1);	// 0 = Netscape, 1 = installed, 2 = custom
pref("general.help_source.url",				"");

pref("general.fullcircle_enable",			true);
pref("general.fullcircle_collect_ns_data",	false);

pref("browser.enable_style_sheets",			true);
pref("browser.startup.page",				1);	// 0 = blank, 1 = home, 2 = last
pref("browser.startup.homepage",			"http://home.kr.netscape.com/ko/");
pref("browser.startup.homepage_override",		true);
pref("browser.startup.autoload_homepage",		true);
pref("browser.startup.agreed_to_licence",		false);
pref("browser.startup.license_version",			0);
pref("browser.startup.default_window",			1);	// start up browser
localDefPref("browser.cache.disk_cache_size",			7680);
localDefPref("browser.cache.memory_cache_size",			1024);
pref("browser.cache.disk_cache_ssl",			false);
pref("browser.foreground_color",			"#000000");
pref("browser.background_color",			"#C0C0C0");
pref("browser.anchor_color",				"#0000EE");
pref("browser.visited_color",				"#551A8B");
pref("browser.chrome.show_directory_buttons",		true);
pref("browser.chrome.toolbar_style",			2);
pref("browser.chrome.advanced_toolbar",			false); 
pref("browser.chrome.show_toolbar",			true);
pref("browser.chrome.show_status_bar",			true);
pref("browser.chrome.show_url_bar",			true);
pref("browser.chrome.show_security_bar",		true);
pref("browser.chrome.button_style",			0);
pref("browser.chrome.useGuideButton",			true);

pref("browser.background_option",			0);	// DEFAULT_BACKGROUND
pref("browser.link_expiration",				9);
pref("browser.cache.check_doc_frequency",		0);

pref("browser.delay_images",				false);
pref("browser.underline_anchors",			true);
pref("browser.never_expire",				false);
pref("browser.display_while_loading",			true);
pref("browser.custom_link_color",			false);
pref("browser.custom_visited_color",			false);
pref("browser.custom_text_color",			false);
pref("browser.use_document_colors",			true);
localDefPref("browser.window_rect",				"-1,-1,-1,-1");
localDefPref("browser.prefs_window_rect",			"-1,-1,-1,-1");
localDefPref("browser.find_window_rect",			"-1,-1,-1,-1");
localDefPref("browser.bookmark_window_rect",			"-1,-1,-1,-1");
localDefPref("browser.download_window_rect",			"-1,-1,-1,-1");


pref("browser.startup_mode",				1);
localDefPref("browser.bookmark_location",			"");
localDefPref("browser.addressbook_location",			"");
localDefPref("browser.socksfile_location",			"");
localDefPref("browser.ldapfile_location",			"");
pref("browser.print_background",			false);

pref("browser.url_history.URL_1",			"");
pref("browser.url_history.URL_2",			"");
pref("browser.url_history.URL_3",			"");
pref("browser.url_history.URL_4",			"");
pref("browser.url_history.URL_5",			"");
pref("browser.url_history.URL_6",			"");
pref("browser.url_history.URL_7",			"");
pref("browser.url_history.URL_8",			"");
pref("browser.url_history.URL_9",			"");
pref("browser.url_history.URL_10",			"");
pref("browser.url_history.URL_11",			"");
pref("browser.url_history.URL_12",			"");
pref("browser.url_history.URL_13",			"");
pref("browser.url_history.URL_14",			"");
pref("browser.url_history.URL_15",			"");
pref("browser.url_history.clear", 0);


pref("browser.personal_toolbar_button.max_chars",	15);

pref("browser.PICS.ratings_enabled",			false);
pref("browser.PICS.pages_must_be_rated",		false);
pref("browser.PICS.disable_for_this_session",		false);
pref("browser.PICS.reenable_for_this_session",		false);
pref("browser.PICS.service.http___home_netscape_com_default_rating.service_enabled",	true);
pref("browser.PICS.service.http___home_netscape_com_default_rating.s",	0);

pref("browser.related.enabled",                     true);
pref("browser.related.autoload",                    1);
pref("browser.related.provider",                   "http://www-rl.kr.netscape.com/wtgn?" );
pref("browser.related.detailsProvider",            "http://cgi.kr.netscape.com/cgi-bin/rlcgi.cgi?URL=");
pref("browser.related.disabledForDomains",			"");

pref("browser.goBrowsing.enabled",					true);

localDefPref("ghist.expires.pos",				4);
localDefPref("ghist.expires.width",				1400);
localDefPref("ghist.firstvisit.pos",				2);
localDefPref("ghist.firstvisit.width",				1400);
localDefPref("ghist.lastvisit.pos",				3);
localDefPref("ghist.lastvisit.width",				1400);
localDefPref("ghist.location.pos",				1);
localDefPref("ghist.location.width",				2400);
pref("ghist.show_value",				0);
pref("ghist.sort_descending",				false);
pref("ghist.sortby",					3);	// eGH_LastDateSort
localDefPref("ghist.title.pos",					0);
localDefPref("ghist.title.width",				2400);
localDefPref("ghist.visiblecolumns",				6);
localDefPref("ghist.visitcount.pos",				5);
localDefPref("ghist.visitcount.width",				1000);
localDefPref("ghist.window_rect",				"0,0,0,0");

pref("java.applets.stop_on_iconify", false);

pref("javascript.enabled",				true);
pref("javascript.allow.mailnews",			true);
pref("javascript.allow.signing",			true);
pref("javascript.reflect_preferences",			false);	// for PE

pref("network.dnsTimout",				5000);
pref("network.dnsAttempt",              0);
pref("network.tcptimeout",				0);
pref("network.tcpbufsize",				0);
pref("network.use_async_dns",				true);
pref("network.dnsCacheExpiration",			900);	// in seconds
pref("network.enableUrlMatch",				true);
pref("network.max_connections",				4);
pref("network.speed_over_ui",				true);
pref("network.file_sort_method",			0);	// NAME 0, TYPE 1, SIZE 2, DATE 3
pref("network.hosts.smtp_server",			"mail");
pref("network.hosts.pop_server",			"mail");
pref("network.hosts.nntp_server",			"news");
pref("network.hosts.socks_server",			"");
pref("network.hosts.socks_serverport",			1080);
pref("network.hosts.socks_conf",			"");
pref("network.socket_shutdown",		3); // 0 - don't call shutdown before closing
			// 1 - flush recv queue, 2 - flush send queue, 3 - both send & recv queue

pref("network.proxy.autoconfig_url",			"");
pref("network.proxy.type",				3);	// Changed default by req of Jon Kalb
pref("network.proxy.ftp",				"");
pref("network.proxy.ftp_port",				0);
pref("network.proxy.gopher",				"");
pref("network.proxy.gopher_port",			0);
pref("network.proxy.news",				"");
pref("network.proxy.news_port",				0);
pref("network.proxy.http",				"");
pref("network.proxy.http_port",				0);
pref("network.proxy.wais",				"");
pref("network.proxy.wais_port",				0);
pref("network.proxy.ssl",				"");
pref("network.proxy.ssl_port",				0);
pref("network.proxy.no_proxies_on",			"");
localDefPref("network.online",					true);	// online/offline
pref("network.prompt_at_startup",			false);	// Ask me
pref("network.accept_cookies",				0);	// 0 = Always, 1 = warn, 2 = never
pref("network.foreign_cookies",				0);	// 0 = Accept, 1 = Don't accept
pref("network.cookie.cookieBehavior",			0);	// 0-Accept, 1-dontAcceptForeign, 2-dontUse
pref("network.cookie.warnAboutCookies",			false);
pref("network.cookie.rememberAboutCookies",             false);
pref("network.cookie.rememberAboutCookiesWithPath",     false);
pref("network.signon.rememberSignons",                  false);
pref("network.sendRefererHeader",			true);

localDefPref("li.enabled", false);
localDefPref("li.ui.enabled", true); // internal use only, not user setable
localDefPref("li.protocol","ldap");

localDefPref("li.reportchanges", true);  // internal use only, not user setable
localDefPref("li.isGuest", false);  // internal use only, not user setable

localDefPref("li.client.bookmarks", true);
localDefPref("li.client.cookies", true);
localDefPref("li.client.filters", true);
localDefPref("li.client.addressbook", true);
localDefPref("li.client.globalhistory", false);
localDefPref("li.client.liprefs", true);
localDefPref("li.client.security", false);
localDefPref("li.client.javasecurity", false);

localDefPref("li.login.name", "");
localDefPref("li.login.save_password", false);

localDefPref("li.server.http.baseURL", "");
localDefPref("li.server.ldap.url", "");
localDefPref("li.server.ldap.userbase", "");
localDefPref("li.server.ldap.idletimeoutms",300000);
localDefPref("li.server.ldap.timeoutms",480000);

pref("mcd.server.ldap.searchAuthDN",	"");
pref("mcd.server.ldap.searchAuthPW",	"");

pref("security.ask_for_fortezza",			0);
pref("security.ask_for_password",			0);
pref("security.ciphers",				"");
pref("security.default_mail_cert",			"");
pref("security.default_personal_cert",			"");
pref("security.email_as_ftp_password",			false);
pref("security.enable_java",				true);
pref("security.lower_java_network_security_by_trusting_proxies",	false);
pref("security.enable_ssl2",				true);
pref("security.enable_ssl3",				true);
pref("security.fortezza_lifetime",			30);
pref("security.password_lifetime",			30);
pref("security.submit_email_forms",			true);
pref("security.use_password",				true);
pref("security.warn_accept_cookie",			false);	// ML obsolete
pref("security.warn_entering_secure",			true);
pref("security.warn_leaving_secure",			true);
pref("security.warn_submit_insecure",			true);
pref("security.warn_viewing_mixed",			true);

pref("security.ssl2.des_ede3_192",			true);	// Domestic
pref("security.ssl2.des_64",				true);	// Domestic
pref("security.ssl2.rc2_128",				true);	// Domestic
pref("security.ssl2.rc2_40",				true);	// Export
pref("security.ssl2.rc4_40",				true);	// Export
pref("security.ssl2.rc4_128",				true);	// Domestic

pref("security.ssl3.fortezza_fortezza_sha",		true);	// Fortezza
pref("security.ssl3.fortezza_null_sha",			false);	// Fortezza
pref("security.ssl3.fortezza_rc4_sha",			true);	// Fortezza
pref("security.ssl3.rsa_fips_des_ede3_sha",		true);	
pref("security.ssl3.rsa_des_ede3_sha",			true);	// Domestic
pref("security.ssl3.rsa_fips_des_sha",			true);	
pref("security.ssl3.rsa_des_sha",			true);	// Domestic
pref("security.ssl3.rsa_null_md5",			false);	// Export
pref("security.ssl3.rsa_rc2_40_md5",			true);	// Export
pref("security.ssl3.rsa_rc4_40_md5",			true);	// Export
pref("security.ssl3.rsa_rc4_128_md5",			true);	// Domestic

pref("security.smime.des_ede3",				true);	// Domestic
pref("security.smime.des",				true);	// Domestic
pref("security.smime.rc2_40",				true);	// Export
pref("security.smime.rc2_64",				true);	// Domestic
pref("security.smime.rc2_128",				true);	// Domestic
pref("security.smime.rc5.b64r16k40",			true);
pref("security.smime.rc5.b64r16k64",			true);
pref("security.smime.rc5.b64r16k128",			true);
pref("security.smime.fortezza",				true);	// Fortezza

pref("security.canotices.VeriSignInc.notice1",
"This certificate incorporates the VeriSign Certification Practice Statement "+
"(CPS) by reference. Use of this certificate is governed by the CPS.\n\n"+
"The CPS is available in the VeriSign repository at "+
"https://www.verisign.com/repository/CPS and "+
"ftp://ftp.verisign.com/repository/CPS; by E-mail at "+
"CPS-requests@verisign.com; and by mail at VeriSign, Inc., 2593 Coast Ave., "+
"Mountain View, CA 94043 USA, Attn: Certification Services.\n\n"+
"THE CPS DISCLAIMS AND LIMITS CERTAIN LIABILITIES, INCLUDING CONSEQUENTIAL "+
"AND PUNITIVE DAMAGES. THE CPS ALSO INCLUDES CAPS ON LIABILITY RELATED TO "+
"THIS CERTIFICATE. SEE THE CPS FOR DETAILS.\n\n"+
"The CPS and this certificate are copyrighted: Copyright (c) 1997 VeriSign, "+
"Inc. All Rights Reserved.");

pref("security.canotices.VeriSignInc.notice2",
"The subject name (i.e., user name) in this VeriSign Class 1 "+
"certificate contains nonverified subscriber information.");

pref("security.canotices.VeriSignInc.notice3",
"This certificate incorporates by reference, and its use is strictly subject "+
"to, the VeriSign Certification Practice Statement (CPS), available in the "+
"VeriSign repository at: https://www.verisign.co.jp; by E-mail at "+
"CPS-requests@verisign.co.jp; or by mail at VeriSign Japan K.K, 580-16 "+
"Horikawacho, Saiwai-ku, Kawasaki  210  Japan\n\n"+
"Copyright (c)1996, 1997 VeriSign, Inc.  All Rights Reserved. CERTAIN "+
"WARRANTIES DISCLAIMED AND LIABILITY LIMITED.\n\n"+
"WARNING: THE USE OF THIS CERTIFICATE IS STRICTLY SUBJECT TO THE  VERISIGN "+
"CERTIFICATION PRACTICE STATEMENT.  THE ISSUING AUTHORITY DISCLAIMS CERTAIN "+
"IMPLIED AND EXPRESS WARRANTIES, INCLUDING WARRANTIES OF MERCHANTABILITY OR "+
"FITNESS FOR A PARTICULAR PURPOSE, AND WILL NOT BE LIABLE FOR CONSEQUENTIAL, "+
"PUNITIVE, AND CERTAIN OTHER DAMAGES. SEE THE CPS FOR DETAILS.\n\n"+
"Contents of the VeriSign registered nonverifiedSubjectAttributes extension "+
"value shall not be considered as accurate information validated by the IA.");

pref("signed.applets.DefaultTo30Security",		false);
pref("signed.applets.securityIsOn",			true);
pref("signed.applets.codebase_principal_support",	false);
pref("signed.applets.local_classes_have_30_powers",	false);
pref("signed.applets.capabilitiesDB.lock_to_current",	false);
pref("signed.applets.low_security_for_local_classes",	false);
pref("signed.applets.simulate_signatures_on_system_classes",	false);
pref("signed.applets.verbose_security_exception",	false);

pref("messages.new_window",				true);	// ML obsolete; use mailnews.message_in_thread_window

pref("news.show_pretty_names",				false);
pref("mail.wrap_long_lines",				false);
pref("news.wrap_long_lines",				false);
pref("mail.inline_attachments",				true);

// Mail server preferences, pop by default
pref("mail.server_type",				0);	// 0 pop, 1 imap, (Unix only: 2 movemail, 3 inbox)

pref("mail.auth_login",					true);
pref("mail.use_x_sender",				false);
pref("mail.imap.local_copies",				false);
pref("mail.imap.cache_fetch_responses",			true);
localDefPref("mail.imap.server_sub_directory",			"");
pref("mail.imap.delete_is_move_to_trash",		false);
pref("mail.imap.server_ssl",				false);
pref("mail.imap.ssl_port",				993);
pref("mail.imap.hard.mailbox.depth",			0);
pref("mail.imap.allow_multiple_folder_connections",		false);
pref("mail.imap.check_before_loading_message_size", 0);
pref("mail.imap.strip_slash_when_creating_online_dir", true);
pref("mail.imap.auto_subscribe_on_open",	true);
pref("mail.imap.fetch_by_chunks",			true);
pref("mail.imap.chunk_size",				6144);
pref("mail.imap.min_chunk_size_threshold",	8192);
pref("mail.imap.max_chunk_size",			81920);
pref("mail.imap.chunk_fast",				2);
pref("mail.imap.chunk_ideal",				4);
pref("mail.imap.chunk_add",					2048);
pref("mail.imap.new_mail_get_headers",		true);
pref("mail.progress_pane",					true);
pref("mail.imap.max_cached_connections",	5);
pref("mail.imap.hide_other_users",			false);
pref("mail.imap.noop_check_count",			5);
pref("mail.imap.hide_unused_namespaces",	true);
pref("mail.imap.ssl.show_insecure_images",	true);
pref("mail.imap.store_answered_forwarded_flag", 		true);

pref("mail.imap.strip_personal_namespace",	true);
pref("mail.imap.upgrade.leave_subscriptions_alone",	false);
pref("mail.imap.upgrade.auto_subscribe_to_all",		false);
pref("mail.imap.auto_unsubscribe_from_noselect_folders",	true);
pref("mail.imap.cleanup_inbox_on_exit",		true);
pref("mail.imap.expunge_threshold",			20);
pref("mail.imap.mime_parts_on_demand",		true);
pref("mail.imap.mime_parts_on_demand_threshold", 30000);
pref("mail.imap.mime_parts_on_demand_max_depth", 15);	// after depth, we kick out of MPOD mode
pref("mail.imap.io_tunnelling",				false);
pref("mail.imap.tunnelling_threshold",		400);
pref("mail.imap.optimize_header_dl",		true);
pref("mail.use_3pane", true);
pref("mail.pane_arrangement",				0);   // 0=TM right, 1=FT top
pref("mail.use_altmail",				false);
localDefPref("mail.altmail_dll",				"postal32.dll");
pref("mail.use_altmail_for_news",			true);
pref("mail.thread_mail",				false);
pref("mail.thread_without_re",			true);
pref("mail.sort_mail",					false);
pref("mail.ascend_mail",				false);
pref("mail.leave_on_server",				false);
pref("mail.delete_mail_left_on_server",	false);
pref("mail.use_default_cc",				false);
localDefPref("mail.default_cc",					"");
pref("mail.use_fcc",					true);
localDefPref("mail.default_fcc",				"");
pref("mail.use_imap_sentmail",			false);	// for backward compatible consideration we have 
localDefPref("mail.imap_sentmail_path",			"");	// to have separate default_fcc prefs for IMAP
pref("mail.check_new_mail",				false);
pref("mail.check_time",					10);
pref("mail.pop_name",					"");
pref("mail.smtp_name",					"");
pref("mail.remember_password",				false);
pref("mail.support_skey",				false);
pref("mail.pop_password",				"");
pref("mail.auto_quote",					true);
pref("mail.fixed_width_messages",			true);
pref("mail.quoted_style",				2);	// 0=plain, 1=bold, 2=italic, 3=bolditalic
pref("mail.quoted_size",				0);	// 0=normal, 1=bigger, 2=smaller
pref("mail.citation_color",				"#000000");	// quoted color
pref("mail.identity.organization",			"");
pref("mail.identity.reply_to",				"");
pref("mail.identity.username",				"");
pref("mail.identity.useremail",				"");
pref("mail.identity.useremail.aliases",		"");
pref("mail.identity.defaultdomain",			"");
pref("mail.identity.validate_addr",			true);
pref("mail.cc_self",					false);
pref("mail.limit_message_size",				false);
pref("mail.max_size",					50);	// download message size limit
pref("mail.deliver_immediately",			true);
pref("mail.strictly_mime",				false);
pref("mail.strictly_mime_headers",			true);
pref("mail.strictly_mime.parm_folding", 1); // 0 - no folding, 1 - line folding using CRLFLWSP, 2 - line folding based on RFC 2231
pref("mail.file_attach_binary",				false);
pref("mail.use_signature_file",				false);
pref("mail.show_headers",				1);	// some
pref("mail.pane_config",				0);
pref("mail.sort_by",					1);	// by date
localDefPref("mail.window_rect",				"-1,-1,-1,-1");
localDefPref("mail.compose_window_rect",			"-1,-1,-1,-1");
pref("mail.addr_book.ldap.disabled",			false);
localDefPref("mail.addr_book_window_rect",			"-1,-1,-1,-1");

pref("mail.addr_book.displayName.autoGeneration", true); 
pref("mail.addr_book.displayName.lastnamefirst", false); // generate display names in last first order
pref("mail.addr_book.version",              "");
pref("mail.addr_book.lastnamefirst",			false);
pref("mail.addr_book.sortby",				2);
pref("mail.addr_book.sort_ascending",			true);
pref("mail.addr_book.addressBook.selection",        0);  // last address book selected in the AB window
pref("mail.addr_book.addressBook.expanded",      false);  // expand/collapse state of the last selected AB in the window
pref("mail.addr_book.picker.selection",             0);  // last address book selected in the AB Picker Window
pref("mail.addr_book.picker.expanded",          false);  // expand/collapse state of the last selected AB in the window
localDefPref("mail.addr_book.name.width",			0);
localDefPref("mail.addr_book.email.width",			0);
localDefPref("mail.addr_book.nickname.width",			0);
localDefPref("mail.addr_book.locality.width",			0);
localDefPref("mail.addr_book.company.width",			0);
localDefPref("mail.addr_book.type.pos",				-1);
localDefPref("mail.addr_book.name.pos",				-1);
localDefPref("mail.addr_book.email.pos",			-1);
localDefPref("mail.addr_book.nickname.pos",			-1);
localDefPref("mail.addr_book.locality.pos",			-1);
localDefPref("mail.addr_book.company.pos",			-1);
pref("mail.attach_vcard", 				false);
pref("mail.html_compose",				true);
pref("mail.htmldomains",				"netscape.com,mcom.com,netscape.net");
pref("mail.play_sound",					true);
pref("mail.send_html",					true);
pref("mail.directory_names.first_first",		true);
pref("mail.attach_address_card",			false);
localDefPref("mail.fcc_folder",					"");
pref("mail.purge_threshhold",				100);
pref("mail.prompt_purge_threshhold", 			false);	// Ask about compacting folders
pref("mail.encrypt_outgoing_mail",	 		false);
pref("mail.crypto_sign_outgoing_mail", 			false);
pref("mail.crypto_sign_outgoing_news", 			false);
pref("mail.warn_forward_encrypted",			true);	// forward encrypted message to another warning
pref("mail.warn_reply_unencrypted",			true);	// clear reply to encrypted message warning
pref("mail.use_mapi_server", 				false);
pref("mail.match_nickname", 				false);
pref("mail.default_html_action",			0);	// 0=ask, 1=plain, 2=html, 3=both
pref("mail.selection.count",				0);	// default - 0 mail folders selected for download
pref("mail.allow_at_sign_in_user_name",		false);

// suppress generating Sender: header; Unix only
pref("mail.suppress_sender_header",			false);

// setting attachment content_disposition: type 0= auto tect, 
// 1=always attachment, 2=.txt always set to attachment else normal behaviour
pref("mail.content_disposition_type",			0);

pref("mail.mdn.report.enabled", true);       // enable sending MDN report
	// no denial mdns for not_in_to_cc, forward and outside_domain cases
	// this could eliminate potential mail traffics
pref("mail.mdn.report.not_in_to_cc", 0);      // 0: Never 1: Always 2: Ask me 
pref("mail.mdn.report.outside_domain", 2);    // 0: Never 1: Always 2: Ask me
pref("mail.mdn.report.other", 2);   // 0: Never 1: Always 2: Ask me 3: Denial
pref("mail.incorporate.return_receipt", 0); // 0: inbox/filter 1: Sent folder
pref("mail.request.return_receipt_on", false); // turn on the return receipt request
pref("mail.request.return_receipt", 2);	    // 1: DSN 2: MDN 3: Both
pref("mail.receipt.request_header_type", 0); // 0: MDN-DNT header  1: RRT header 2: Both (MC)

pref("mail.smtp.ssl",						0); // 0 = no, 1 = try, 2 = must use SSL
pref("mail.pop3_gets_new_mail",				true);

pref("mail.default_drafts", "");	// empty string use local default Drafts name; 
									// else imap:// url or mailbox:// url 
pref("mail.default_templates", "");	// empty string use local default Templates name
									// else imap:// url or mailbox:// url
pref("mail.dot_fix",	true);		// prevents a dot inside email from terminating email
pref("mail.forward_message_mode", 0);	// 0: default as attachment 1: forward as quoted 2: forward as inline with attachments
pref("mail.SpellCheckBeforeSend", false  ); // Spell check messages before sending
pref("mail.suppress_zapper_sounds", false); // Don't play sound when collapsing panes
pref("news.enabled",						true);
pref("news.use_fcc",					true);
localDefPref("news.default_fcc",					"");
pref("news.use_imap_sentmail",			false);	// for backward compatible considerations we have
localDefPref("news.imap_sentmail_path",				"");// to have separate default_fcc prefs for IMAP
pref("news.use_default_cc",				false);
localDefPref("news.default_cc",					"");
pref("news.thread_news",				true);
pref("news.cc_self",					false);
pref("news.show_headers",				2);	// some
pref("news.pane_config",				0);
pref("news.sort_by",					1);	// by date
localDefPref("news.window_rect",				"-1,-1,-1,-1");
pref("news.offline_retrieval",				1);
pref("news.article_purging",				"");
pref("news.header_purging",				"");
localDefPref("news.fcc_folder",					"");
pref("news.notify.on",					true);
pref("news.notify.size",				1000);
pref("news.max_articles",				500);
pref("news.mark_old_read",				false);
pref("news.server_is_secure",				false);
pref("news.server_port",				119);	// default non-secure port number
pref("news.use_message_center",			false);
localDefPref("news.subscribe.name_width",			-1);	// Subscribe UI cols width
localDefPref("news.subscribe.join_width",			-1);  
localDefPref("news.subscribe.post_width",			-1);  
localDefPref("news.subscribe.name_pos",				0);	// Subscribe UI cols pos
localDefPref("news.subscribe.join_pos",				1);  
localDefPref("news.subscribe.post_pos",				2);  
pref("news.send.fake_sender",				"");

// The next pref's value is irrelevant; it gets tweaked when back end needs to be called
// regarding any change to network.hosts.nntp_server, news.server_port,
// and/or news.server_is_secure.
pref("news.server_change_xaction",			0);

// Max age (in secs) of an idle NNTP connection before the client closes it.
// Note that 977bis says that servers must not close it before three minutes
pref("news.timeout", 170); 

pref("mailnews.profile_age",				0);
localDefPref("mailnews.folder_window_rect",			"-1,-1,-1,-1");
localDefPref("mailnews.thread_window_rect",			"-1,-1,-1,-1");
localDefPref("mailnews.message_window_rect",			"-1,-1,-1,-1");

localDefPref("mailnews.thread_pane_height",			-1);
localDefPref("mailnews.category_pane_width",			-1);
pref("mailnews.reuse_thread_window",			true);  // 4.0x only
pref("mailnews.reuse_thread_window2",			false); // >= 4.5 only
pref("mailnews.reuse_message_window",			true);
pref("mailnews.message_in_thread_window",		true);
pref("mailnews.remember_selected_message",		true);

pref("mailnews.wraplength",				72);
pref("mailnews.nicknames_only",				false);
pref("mailnews.nav_crosses_folders",			1);	// 0=do it, don't prompt 1=prompt, 2=don't do it, don't prompt

pref("mailnews.reply_on_top",				1); // 0=bottom 1=top 2=select+bottom 3=select+top
pref("mailnews.reply_with_extra_lines",			2);

pref("mailnews.force_ascii_search",			true);
pref("mailnews.searchServer",				true);
pref("mailnews.searchSubFolders",			true);
pref("mailnews.confirm.moveFoldersToTrash", true);
pref("mailnews.autolookup_unknown_mime_types",		true);
pref("mailnews.color_tag_attachments",		false);
pref("mailnews.send_hankaku_kana",			false);
pref("mailnews.max_header_display_length",			15);

pref("mailnews.file_buffer.paging.never", false); // yes page caching
pref("mailnews.file_buffer.page_size_kilo", 2); // 2K is 2048 bytes
pref("mailnews.file_buffer.max_pages", 256); // 256 pages at most
pref("mailnews.file_buffer.start_pages", 16); // first read 16 pages
pref("mailnews.file_buffer.grow_pages", 16); // allocate 16 at once

pref("mailnews.start_page.url", "http://messenger.kr.netscape.com/ko/bookmark/4_5/messengerstart.html");
pref("mailnews.start_page.enabled", true);

pref("intl.accept_languages",				"ko");
pref("intl.mailcharset.cyrillic",			"koi8-r");
pref("intl.mailcharset.override_1",			"");
pref("intl.mailcharset.override_2",			"");
pref("intl.mailcharset.override_3",			"");
pref("intl.mailcharset.override_4",			"");
pref("intl.mailcharset.override_5",			"");
pref("intl.mailcharset.override_6",			"");
pref("intl.mailcharset.override_7",			"");
pref("intl.mailcharset.override_8",			"");
pref("intl.mailcharset.override_9",			"");
pref("intl.mailcharset.override_10",			"");
pref("intl.accept_charsets",				"euc-kr,*,utf-8");
pref("intl.auto_detect_encoding",			true);
pref("intl.character_set",				3340);	// CS_LATIN1
pref("intl.font_encoding",				6);	// CS_MAC_ROMAN

pref("editor.html_editor",				"");
pref("editor.image_editor",				"");
pref("editor.author",					"");
pref("editor.auto_save_delay",				10);	// minutes
pref("editor.html_editor",				"");
pref("editor.image_editor",				"");
pref("editor.fontsize_mode",				0);
pref("editor.template_location",			"http://home.kr.netscape.com/ko/home/gold3.0_templates.html");
pref("editor.default_template_location",		"http://home.kr.netscape.com/ko/home/gold3.0_templates.html");
pref("editor.template_last_loc",			"");
pref("editor.template_history_0",			"");
pref("editor.template_history_1",			"");
pref("editor.template_history_2",			"");
pref("editor.template_history_3",			"");
pref("editor.template_history_4",			"");
pref("editor.template_history_5",			"");
pref("editor.template_history_6",			"");
pref("editor.template_history_7",			"");
pref("editor.template_history_8",			"");
pref("editor.template_history_9",			"");
pref("editor.template_history_10",			"");
pref("editor.template_history_11",			"");
pref("editor.template_history_12",			"");
pref("editor.template_history_13",			"");
pref("editor.template_history_14",			"");
pref("editor.template_history_15",			"");
pref("editor.template_history_16",			"");
pref("editor.template_history_17",			"");
pref("editor.template_history_18",			"");
pref("editor.template_history_19",			"");

//localDefPref("editor.html_directory",				"C:\\My Documents");
//localDefPref("editor.image_directory",				"C:\\My Documents");
pref("editor.background_image",				"");
pref("editor.last_pref_page",				0);
pref("editor.last_text_page",				0);
pref("editor.last_doc_page",				0);
pref("editor.last_table_page",				0);
pref("editor.use_custom_colors",			false);
pref("editor.use_background_image",			true);
pref("editor.publish_keep_links",			true);
pref("editor.publish_keep_images",			true);
pref("editor.show_copyright",				true);
pref("editor.show_character_toolbar",			true);
pref("editor.show_paragraph_toolbar",			true);
pref("editor.text_color",				"#000000");
pref("editor.link_color",				"#0000FF");
pref("editor.active_link_color",			"#000088");
pref("editor.followed_link_color",			"#FF0000");
pref("editor.background_color",				"#FFFFFF");
pref("editor.auto_save",				false);
pref("editor.javascript_color",				"#FF0000");
pref("editor.color_scheme",				"Netscape ⺻ ");

pref("editor.hints.bookmark",				true);
pref("editor.hints.image",				true);
pref("editor.hints.sitemanager",			true);
pref("editor.hints.copyright",				true);
pref("editor.hints.removelinks",			true);

localDefPref("editor.hrule.height",				2);
localDefPref("editor.hrule.width",				100);
pref("editor.hrule.width_percent",			true);
pref("editor.hrule.shading",				true);
pref("editor.hrule.align",				0);	// match types in edttypes.h ED_ALIGN_CENTER

pref("editor.publish_username",				"");
pref("editor.publish_password",				"");
pref("editor.publish_save_password",			false);
pref("editor.publish_location",				"");
pref("editor.publish_browse_location",			"");
pref("editor.publish_last_loc",				"");
pref("editor.publish_last_pass",			"");
pref("editor.publish_history_0",			"");
pref("editor.publish_history_1",			"");
pref("editor.publish_history_2",			"");
pref("editor.publish_history_3",			"");
pref("editor.publish_history_4",			"");
pref("editor.publish_history_5",			"");
pref("editor.publish_history_6",			"");
pref("editor.publish_history_7",			"");
pref("editor.publish_history_8",			"");
pref("editor.publish_history_9",			"");
pref("editor.publish_history_10",			"");
pref("editor.publish_history_11",			"");
pref("editor.publish_history_12",			"");
pref("editor.publish_history_13",			"");
pref("editor.publish_history_14",			"");
pref("editor.publish_history_15",			"");
pref("editor.publish_history_16",			"");
pref("editor.publish_history_17",			"");
pref("editor.publish_history_18",			"");
pref("editor.publish_history_19",			"");
pref("editor.publish_password_0",			"");
pref("editor.publish_password_1",			"");
pref("editor.publish_password_2",			"");
pref("editor.publish_password_3",			"");
pref("editor.publish_password_4",			"");
pref("editor.publish_password_5",			"");
pref("editor.publish_password_6",			"");
pref("editor.publish_password_7",			"");
pref("editor.publish_password_8",			"");
pref("editor.publish_password_9",			"");
pref("editor.publish_password_10",			"");
pref("editor.publish_password_11",			"");
pref("editor.publish_password_12",			"");
pref("editor.publish_password_13",			"");
pref("editor.publish_password_14",			"");
pref("editor.publish_password_15",			"");
pref("editor.publish_password_16",			"");
pref("editor.publish_password_17",			"");
pref("editor.publish_password_18",			"");
pref("editor.publish_password_19",			"");

localDefPref("offline.startup_mode",				0);	// 0 online work, 1 offline work, 2 ask me
localDefPref("offline.startup_state",				0);	// 0 remember previous state, 1 ask me
localDefPref("offline.send.unsent_messages",		0);	// 0 ask me, 1 Automatically send, 2 do not send
localDefPref("offline.prompt_synch_on_exit",		false);
localDefPref("offline.download.size_limit",			50);	// K
localDefPref("offline.news.download.unread_only",		true);
localDefPref("offline.news.download.by_date",			true);
localDefPref("offline.news.download.use_days",			false);
localDefPref("offline.news.download.days",			30);	// days
localDefPref("offline.news.download.increments",		3);	// 0-yesterday, 1-1 wk ago, 2-2 wk ago,
								// 3-1 month ago, 4-6 month ago, 5-1 year ago
localDefPref("offline.news.discussions_count",			0);	// select discussion count

localDefPref("offline.download_mail",				true);	// checkboxes in Synchronize dialog
localDefPref("offline.download_discussions",		true);
localDefPref("offline.download_directories",		false);
localDefPref("offline.download_messages",			true);	//			(used for "Send unsent messages")
localDefPref("offline.download_flagged",			false);
localDefPref("offline.offline_after_sync",			false);
	
pref("news.keep.method",          			0);	// 0 = all, 1 = by age, 2 = by message count
pref("news.keep.days",               			30);	// days
pref("news.keep.count",     			  	30);	// keep x newest messages
pref("news.keep.only_unread",				false);
pref("news.remove_bodies.by_age",		        false);
pref("news.remove_bodies.days",			        20);

pref("browser.enable_webfonts",				true);		
pref("browser.use_document_fonts",			2);	// 0 = never, 1 = quick, 2 = always

// -- folders (Mac: these are binary aliases.)
//localDefPref("browser.download_directory",			"");
//localDefPref("browser.cache.directory",				"");
//localDefPref("mail.signature_file",				"");
//localDefPref("mail.directory",					"");
//localDefPref("mail.cc_file",					"");
//localDefPref("news.cc_file",					"");

pref("news.fancy_listing",				true);	// obsolete	
pref("browser.blink_allowed",				true);
pref("images.dither",					"auto");
pref("images.incremental_display",			true);
localDefPref("news.directory",					"");
localDefPref("security.directory",				"");

pref("autoupdate.enabled",				true);
pref("autoupdate.confirm_install",				false);
pref("autoupdate.regpack_interval", 90);



pref("imap.io.mac.logging",				false);

pref("browser.editor.disabled",				false);

pref("ldap_1.autoComplete.interval", 650 );
pref("ldap_1.autoComplete.useAddressBooks", true);
pref("ldap_1.autoComplete.useDirectory", false);
pref("ldap_1.autoComplete.showDialogForMultipleMatches", true);
pref("ldap_1.autoComplete.skipDirectoryIfLocalMatchFound", false);

pref("ldap_1.number_of_directories",			6);

pref("ldap_1.directory1.description",			" ּҷ");
pref("ldap_1.directory1.dirType",				2);
pref("ldap_1.directory1.isOffline",				false);

pref("ldap_1.directory2.description",			"Four11 丮");
pref("ldap_1.directory2.serverName",			"ldap.four11.com");

pref("ldap_1.directory3.description",			"InfoSpace 丮");
pref("ldap_1.directory3.serverName",			"ldap.infospace.com");
pref("ldap_1.directory3.searchBase",			"c=US");

pref("ldap_1.directory4.description",			"WhoWhere 丮");
pref("ldap_1.directory4.serverName",			"ldap.whowhere.com");

pref("ldap_1.directory5.description",			"Bigfoot 丮");
pref("ldap_1.directory5.serverName",			"ldap.bigfoot.com");

pref("ldap_1.directory6.description",			"Switchboard 丮");
pref("ldap_1.directory6.serverName",			"ldap.switchboard.com");
pref("ldap_1.directory6.searchBase",			"c=US");
pref("ldap_1.directory6.attributes.telephoneNumber",	"Phone Number:homephone");
pref("ldap_1.directory6.attributes.street",		"State:st");
pref("ldap_1.directory6.filter1.repeatFilterForWords",	false);

pref("ldapList.version",										0);

pref("ldap_2.autoComplete.interval",							650);
pref("ldap_2.autoComplete.enabled",								true);
pref("ldap_2.autoComplete.useAddressBooks",						true);
pref("ldap_2.autoComplete.useDirectory",						false);
pref("ldap_2.autoComplete.showDialogForMultipleMatches",		true);
pref("ldap_2.autoComplete.skipDirectoryIfLocalMatchFound",		false);
pref("ldap_2.autoComplete.nicknameHasPrecedence",               false);
pref("ldap_2.autoComplete.numAddresBooks",						15); // number of address books to search for name completion.

pref("ldap_2.servers.pab.position",								1);
pref("ldap_2.servers.pab.description",							" ּҷ");
pref("ldap_2.servers.pab.dirType",								2);
pref("ldap_2.servers.pab.isOffline",							false);

pref("ldap_2.servers.netcenter.position",						2);
pref("ldap_2.servers.netcenter.description",					"Netcenter  丮");
pref("ldap_2.servers.netcenter.vlvDisabled",					true);
pref("ldap_2.servers.netcenter.serverName",						"memberdir.netscape.com");
pref("ldap_2.servers.netcenter.searchBase",						"ou=member_directory,o=netcenter.com");
pref("ldap_2.servers.netcenter.auth.enabled",					true);
pref("ldap_2.servers.netcenter.auth.dn",						"uid=mozilla,ou=people,o=netcenter.com");
pref("ldap_2.servers.netcenter.auth.savePassword",				true);
pref("ldap_2.servers.netcenter.auth.password",					"BPqvLvWNew==");
pref("ldap_2.servers.netcenter.customDisplayUrl",				"http://dirsearch.kr.netscape.com/ko/cgi-bin/member_lookup.cgi?dn=%s");
pref("ldap_2.servers.netcenter.replication.never",				true);

pref("ldap_2.servers.infospace.position",						3);
pref("ldap_2.servers.infospace.description",					"InfoSpace 丮");
pref("ldap_2.servers.infospace.serverName",						"ldap.infospace.com");
pref("ldap_2.servers.infospace.searchBase",						"c=US");
pref("ldap_2.servers.infospace.vlvDisabled",					true);
pref("ldap_2.servers.infospace.autoComplete.never",				true);
pref("ldap_2.servers.infospace.replication.never",				true);

pref("ldap_2.servers.verisign.position",						4);
pref("ldap_2.servers.verisign.description",						"Verisign 丮");
pref("ldap_2.servers.verisign.serverName",						"directory.verisign.com");
pref("ldap_2.servers.verisign.vlvDisabled",						true);
pref("ldap_2.servers.verisign.autoComplete.never",				true);
pref("ldap_2.servers.verisign.replication.never",				true);

// A position of zero is a special value that indicates the directory is deleted.
// These entries are provided to keep the (obsolete) Four11 directory and the
// WhoWhere, Bigfoot and Switchboard directories from being migrated.
pref("ldap_2.servers.four11.position",						0);
pref("ldap_2.servers.four11.description",						"Four11 丮");
pref("ldap_2.servers.four11.serverName",						"ldap.four11.com");

pref("ldap_2.servers.whowhere.position",						0);             
pref("ldap_2.servers.whowhere.description",						"WhoWhere 丮");
pref("ldap_2.servers.whowhere.serverName",						"ldap.whowhere.com");

pref("ldap_2.servers.bigfoot.position",							0);             
pref("ldap_2.servers.bigfoot.description",						"Bigfoot 丮");
pref("ldap_2.servers.bigfoot.serverName",                       "ldap.bigfoot.com");
                                                                                 
pref("ldap_2.servers.switchboard.position",						0);             
pref("ldap_2.servers.switchboard.description",					"Switchboard 丮");
pref("ldap_2.servers.switchboard.serverName",					"ldap.switchboard.com");

pref("ldap_2.user_id",											0);
pref("ldap_2.version",											1); /* Update kCurrentListVersion in include/dirprefs.h if you change this */

pref("autocomplete.blur_color",								"#FF0000");
pref("autocomplete.no_match_color",							"#FF0000");
pref("autocomplete.multiple_match_color",					"#0000FF");
pref("autocomplete.exact_match_color",						"#00A000");

pref("netcaster.containers.count",			"2");
pref("netcaster.containers.container1",			"-3;'Channel_Finder';'http://netcaster.netscape.com/finder/container/index.html';1440;0");
pref("netcaster.containers.container2",			"1,2;'Channels';");
pref("netcaster.channel.count",				"0");
pref("netcaster.castanet.count",			"0");
pref("netcaster.castanet.acceptCookies",		false);
pref("netcaster.castanet.loggingEnabled",		true);
pref("netcaster.castanet.profileEnabled",		true);
pref("netcaster.admin.startTime",			"9");
pref("netcaster.admin.endTime",				"17");
pref("netcaster.admin.times",				"0");
pref("netcaster.defaultChannel",			"netscape_channel");

pref("SpellChecker.DefaultLanguage",			0);
pref("SpellChecker.DefaultDialect",			0);

pref("mime.table.allow_add", true);
pref("mime.table.allow_edit", true);
pref("mime.table.allow_remove", true);

pref("profile.new_mail_user", false);

pref("autoadmin.cache_ldap_results", false);
pref("autoadmin.offline_failover", false);

// Default configuration information for the client
//

config("startup.homepage_override_url","http://home.kr.netscape.com/ko/home/first.html");
config("autoadmin.append_emailaddr",false);
config("autoadmin.failover_to_cached",true);
config("autoadmin.timeout", 30);

config("toolbar.logo.url","http://home.kr.netscape.com/ko/bookmark/4_51/tnetscape.html");
config("toolbar.logo.win_small_file","");
config("toolbar.logo.win_large_file","");
config("toolbar.logo.frames",-1);

config("mail_toolbar.logo.url","http://home.kr.netscape.com/ko/bookmark/4_51/tnetscapemessenger.html");

config("toolbar.places.default_url","http://home.netscape.com/bookmark/4_51/tstart.html");

config("toolbar.places.item_0.label","ͳ");
config("toolbar.places.item_0.url","http://home.netscape.com/computing/index.html");
config("toolbar.places.item_1.label","");
config("toolbar.places.item_1.url","http://form.netscape.com/peoplesearch/index.html");
config("toolbar.places.item_2.label","оߺ ˻");
config("toolbar.places.item_2.url","http://directory.netscape.com/World/Korean");
config("toolbar.places.item_3.label","ֽ Ʈ");
config("toolbar.places.item_3.url","http://home.kr.netscape.com/ko/netcenter/new.html?cp=ikohnnw");
config("toolbar.places.item_4.label"," Ʈ");
config("toolbar.places.item_4.url","http://home.kr.netscape.com/ko/netcenter/cool.html?cp=ikohnco");
 
config("internal_url.net_search.url","http://home.kr.netscape.com/ko/bookmark/4_51/tsearch.html");
config("internal_url.more_info_plugin.url","http://cgi.kr.netscape.com/ko/eng/mozilla/2.0/extensions/info.cgi");
config("internal_url.default_template.url","http://home.kr.netscape.com/ko/home/gold3.0_templates.html");
config("internal_url.page_from_wizard.url", "http://home.kr.netscape.com/ko/home/gold4.0_wizard.html");

config("menu.places.item_0.label","ͳ(&I)");
config("menu.places.item_0.url","http://home.netscape.com/computing/index.html");
config("menu.places.item_1.label","(&P)");
config("menu.places.item_1.url","http://form.netscape.com/peoplesearch/index.html");
config("menu.places.item_2.label","оߺ ˻(&Y)");
config("menu.places.item_2.url","http://directory.netscape.com/World/Korean");
config("menu.places.item_3.label","ֽ Ʈ(&N)");
config("menu.places.item_3.url","http://home.kr.netscape.com/ko/netcenter/new.html?cp=ikohnnw");
config("menu.places.item_4.label"," Ʈ(&C)");
config("menu.places.item_4.url","http://home.kr.netscape.com/ko/netcenter/cool.html?cp=ikohnco");

config("menu.help.item_0.label","(&H)");
config("menu.help.item_0.url","nethelp:netscape/home:start_here");
config("menu.help.item_1.label"," ̺귯(&L)");
config("menu.help.item_1.url","http://help.kr.netscape.com/ko/products/client/communicator/reflib.html");
config("menu.help.item_2.label"," (&R)");
config("menu.help.item_2.url","http://home.netscape.com/eng/mozilla/4.7/relnotes/unix-4.75.html");
config("menu.help.item_3.label","ǰ   (&P)");
config("menu.help.item_3.url","http://home.kr.netscape.com/ko/menu/prodsupp/client/");
config("menu.help.item_4.label","-");
config("menu.help.item_5.label","Ʈ (&S)");
config("menu.help.item_5.url","http://home.kr.netscape.com/ko/home/update.html");
config("menu.help.item_6.label"," (&W)");
config("menu.help.item_6.url","http://home.kr.netscape.com/ko/home/register.html");
config("menu.help.item_7.label"," (&M)");
config("menu.help.item_7.url","http://home.kr.netscape.com/ko/home/services.html");
config("menu.help.item_8.label","-");
config("menu.help.item_9.label"," (&I)");
config("menu.help.item_9.url","http://home.kr.netscape.com/ko/menu/intl/");
config("menu.help.item_10.label","(&E)"); 
config("menu.help.item_10.url","http://home.netscape.com/info/security-doc.html");
config("menu.help.item_11.label","NetWatch(&C)");
config("menu.help.item_11.url","http://home.kr.netscape.com/ko/communicator/netwatch/");
config("menu.help.item_12.label","ͳ Ű(&K)");
config("menu.help.item_12.url","http://home.netscape.com/bookmark/4_7/tinternetkeywords.html");
config("menu.help.item_13.label","-");
config("menu.help.item_14.label","÷ (&T)");
config("menu.help.item_14.url","about:plugins");
config("menu.help.item_15.label","۲ ǥñ (&D)");
config("menu.help.item_15.url","about:fonts");
config("menu.help.item_16.label","-");
config("menu.help.item_17.label","ݽ ѱ(X11) (&X)");
config("menu.help.item_17.url","http://www.kr.freebsd.org/~cjh/freetime/mozilla/netscape-ko/");

config("personal_toolbar.item_0.label","");
config("personal_toolbar.item_0.url","http://guide.kr.netscape.com/ko/");
config("personal_toolbar.item_1.label","");
config("personal_toolbar.item_1.url","http://guide.kr.netscape.com/ko/guide/whats_new.html");
config("personal_toolbar.item_2.label","");
config("personal_toolbar.item_2.url","http://guide.kr.netscape.com/ko/guide/whats_cool.html");
config("personal_toolbar.item_3.label","BizJournal");
config("personal_toolbar.item_3.url","http://home.kr.netscape.com/bookmark/4_05/ptmembers.html?t");
config("personal_toolbar.item_4.label","SmartUpdate");
config("personal_toolbar.item_4.url","http://home.kr.netscape.com/ko/bookmark/4_05/ptconnections.html?t");
config("personal_toolbar.item_5.label","Mktplace");
config("personal_toolbar.item_5.url","http://home.kr.netscape.com/ko/bookmark/4_05/ptmarketplace.html?t");

config("personal_toolbar.CreateNewToolbar", false);
//config("personal_toolbar.NewToolbarFolderName", "");
//config("personal_toolbar.ToolbarFolderVersion", "");

//
// Localization(Korean)
//
// by cjh
//
// default charset, it seems doesn't work...
config("intl.character_set", 3340);

// proposed by Won-kyu Park <wkpark@chem.skku.ac.kr>
// html editing off
config("mail.html_compose", false);
// 1 = plain text
// I set it to 0 because text editing is very unusual before
// libnsfix/libxpg4-ns usage. Now under proper input method and
// locale configuration, text editing is ok.
config("mail.default_html_action", 1);
// set name of personal toolbar folder
config("custtoolbar.personal_toolbar_folder", "  ");
// default font charset in pref.
config("intl.font_charset", "ks_c_5601-1987");
// default fontset
config("intl.font_spec_list",    "baekmuk-gulim-120-noscale-fixed-x-user-defined,baekmuk-batang-120-noscale-prop-x-user-defined,baekmuk-gulim-120-noscale-fixed-ks_c_5601-1987,baekmuk-gulim-120-noscale-prop-ks_c_5601-1987,");
