/*
 * @(#)$Id$
 *
 * @(#)ttycmd_parse: process tty command and convert input codes
 */

#include	<stdio.h>
#include	"ccode.h"
#include	"ttycmd.h"

/*
 * @(#)command states
 */
#define		STAT_CMD0	0
#define		STAT_CMD	1
#define		STAT_CMD_ESC	2
#define		STAT_QUEUE	3

#define	Getchar()	( n_read-- == 0 ? EOF : (unsigned char) *ip++ )
#define	PutQueue(c)	{ *qp++ = c; nq++; }
#define	Putchar(c)	{ *op++ = c; (*n_write)++; }

int	ttyic = TRUE;		/* input conversion ? */
int	ttyoc = TRUE;		/* output conversion ? */
int	escvi = FALSE;		/* ESC chars visible ? */

/*
 * @(#)ttycmd_parse: parse tty command and convert input stream.
 */
ttycmd_parse(buff, wbuff, icode, ocode, n_read, n_write)
char	*buff;			/* input buffer before command parsing */
char	*wbuff;			/* output buffer after command parsing */
int	icode;			/* input code */
int	ocode;			/* output code */
int	n_read;			/* no. input/read characters */
int	*n_write;		/* no. output/write characters */
{
	static char qtmp[BUFSIZ];	/* temp queue for unconverted data */
	char	*ip=buff;
	char	*op=wbuff;
	char	*qp=qtmp;		/* pointer to queue */
	int	nq = 0;

	static int state ;
	static int called = 0;
	static int c ;				/* current byte */

	if ( called == 0 ) {			/* the 1st time it is called */
		called++;
		state = STAT_CMD0;
		ttyic = TRUE;
		ttyoc = TRUE;
		escvi = FALSE;
	}

	*n_write = 0;

	while ( (c = Getchar() ) != EOF ) {
		switch (state) {
		case STAT_CMD0:
			if ( is_CRNL(c) ) {
				PutQueue(c);
				state = STAT_CMD;
			}
			else {
				PutQueue(c);
				state = STAT_CMD0;
			}
			break;
		case STAT_CMD:
			if ( c == CMD_ESC ) {
				state = STAT_CMD_ESC;
				continue;	/* !! */
			}
			if ( is_CRNL(c) ) {
				PutQueue(c);
				state = STAT_CMD;
			}
			else {
				PutQueue(c);
				state = STAT_CMD0;
			}
			break;
		case STAT_CMD_ESC:
			switch (c) {
			case 'I': toggle(ttyic);
				state = STAT_CMD;
				break;
			case 'O': toggle(ttyoc);
				state = STAT_CMD;
				break;
			case 'V': toggle(escvi);
				state = STAT_CMD;
#ifdef	TOGGLE_PROMPT
				printf("\0337\033[4m\033[24;1Hview HZ esc toggle %s\r\n\033[0m\033B", OnOff(escvi));
				/*
				putenv((escvi? "MORE -c" : "MORE -c -f"));
				*/
				/*
				 * such VT100-specific cursor addressing
				 * command should be changed
				 */
#endif
				break;
			case 'E':	/* for debugging, should be removed */
				if (tty_reset(0) <0)
				err_sys("tty_reset error");

				printf("\nBeTTY ... done\n");
				exit(0);
				break;
			default:
				PutQueue(CMD_ESC);
				PutQueue(c);
				if ( is_CRNL(c) )
					state = STAT_CMD;
				else
					state = STAT_CMD0;
				break;
			}
			break;
		default:	break;
		} /* switch */
		if ( /* state == STAT_CMD */ is_CRNL(c) && nq != 0 ) {
			if ( ttyic )
				cnvtcode(qtmp,op,icode,ocode,nq,&nq);
			else
				bcopy(qtmp,op,nq);
			op += nq;
			*n_write += nq;
			qp = qtmp;
			nq = 0;
		}
	} /* while */
	if ( nq != 0 ) {
		if ( ttyic )
			cnvtcode(qtmp,op,icode,ocode,nq,&nq);
		else
			bcopy(qtmp,op,nq);
		op += nq;
		*n_write += nq;
		qp = qtmp;
		nq = 0;
	}
	return(*n_write);
}

/*
 * History:
 *
 * $Log: b5encode.c,v $
 * Revision 1.3  1994/05/05  15:43:08  shin
 * 1. implement B5E2 proposal
 * 2. add b5e()
 *
 * Revision 1.2  1994/05/04  10:33:16  shin
 * 1. change ESC seq to HZ+S proposal
 *
 * Revision 1.1  1994/05/01  19:01:15  shin
 * Initial revision
 *
 */
