/*
 * @(#)$Id: b5decode.c,v 1.3 1994/05/05 15:44:59 shin Exp shin $
 * @(#) decode of a BIG5 text from 7-bit stream encoded by b5encode
 */

#include	<stdio.h>
#include	"hzb5.h"
#include	"ccode.h"
#ifdef	TTY_CMD
#include	"ttycmd.h"
#endif

#define		STAT_ASC	0
#define		STAT_HZ_ESC	1
#define		STAT_HZ_SO	2
#define		STAT_HZ_C0	3
#define		STAT_HZ_C1	4
#define		STAT_HZ_AMB	5

#define		is_cs94(c)	((c)>=0x21&&(c)<=0x7e)

static char	s[2];

/*
 * the 'dst' parameter is reserved for converting directly from the source to
 * a destination code. (the so is used for source code)
 *	- Big5/7 => Big5 is implemented in the following macro.
 */
#define	hzb5decode(c0,c,so,dst)				\
	if ( so != MODE_SO_HZ ) {			\
		b5d3(&c0,&c,so,dst);			\
		if ( dst == CODE_GB ) {			\
			s[0] = c0 ;			\
			s[1] = c  ;			\
			b2g(s);				\
			c0 = s[0];			\
			c  = s[1];			\
		}					\
	}						\
	else { /* hook up your hz2dst(c0,c) here */	\
		if ( dst == CODE_GB ) {			\
			c0 |= 0x80;			\
			c  |= 0x80;			\
		}					\
		else {					\
			s[0] = c0 | 0x80;		\
			s[1] = c  | 0x80;		\
			g2b(s);				\
			c0 = s[0];			\
			c  = s[1];			\
		}					\
	}						\

#define	Getchar()	( n_read-- == 0 ? EOF : *ip++ )
#define	Putchar(c)	{ *op++ = c; (*n_write)++ ; }

#ifdef	B5D_MAIN
main(argc,argv)
int	argc;
char	**argv;
{
	char	ibuff[BUFSIZ], obuff[BUFSIZ];
	int	n;
	int	dst;

	dst = CODE_BIG5;

	if ( !b5d_chkargv(argc, argv, &dst) ) {
		b5d_usage(argc, argv);
		exit(1);
	}

	while ( fgets(ibuff, BUFSIZ, stdin) != NULL ) {
		b5decode(ibuff, obuff, strlen(ibuff), &n, dst);
		obuff[n] = '\0';
		fputs(obuff, stdout);
	}
}

b5d_chkargv(argc, argv, dst)
int	argc;
char	**argv;
int	*dst;
{
	*dst = CODE_BIG5;

	if ( (argc<2) || argv[1][0] != '-' ) return(TRUE);	/* default */

	if ( argv[1][1] == 'b' )
		*dst = CODE_BIG5;
	else if (argv[1][1] == 'g')
		*dst = CODE_GB;
	else
		return(FALSE);

	return(TRUE);
}

b5d_usage(argc, argv)
int	argc;
char	**argv;
{
	printf("B5DECODE ** Rev. 1.53 ** 1994/10\n\n");

	printf("Usage: %s [-b|-g|-h] [ < infile [ > outfile]]\n", argv[0]);
	printf("-h: get this help message\n\n");

	printf("-b: input is HZ+B5E3 code, output is Big5 code (default)\n");
	printf("-g: input is HZ+B5E3 code, output is GB code\n");
}

#endif /* B5D_MAIN */

/*
 * @(#)$Id$
 *
 *	- decode 7-bit chinese characters (B5E3 and HZ) to Big5 (or GB)
 */

b5decode(buff, wbuff, n_read, n_write, dst)
char	*buff;
char	*wbuff;
int	n_read;
int	*n_write;
int	dst;		/* destination: CODE_BIG5 or CODE_GB */
{
	char	*ip=buff;
	char	*op=wbuff;
	static int state;
	static int so;
	static int called = 0;
	static int c, c0;

	if ( called == 0 ) {
		called++;
		state = STAT_ASC;
		so = 0;
	}

	*n_write = 0;

	while ( (c = Getchar() ) != EOF ) {
		if ( c == ' ' ) {		/* avoid SPACE in esc. mode */
			Putchar(c);
			continue;
		}
		if ( c == '\n' ) {
			if (state==STAT_HZ_ESC) Putchar(HZ_ESC);
			state = STAT_ASC;	/* for error recovery */
			so = 0;
			Putchar(c);
			continue;
		}
		switch (state) {
		case STAT_ASC:
			if ( c == HZ_ESC ) {
				state = STAT_HZ_ESC;
			}
			else
				Putchar(c);
			break;
		case STAT_HZ_ESC:
			switch ( c ) {
			case HZ_SO_HZ:
				so = MODE_SO_HZ;
				state = STAT_HZ_SO;
				break;
			case HZ_SO_B5_1:
				so = MODE_SO_B5_1;
				state = STAT_HZ_SO;
				break;
			case HZ_SO_B5_2:
				so = MODE_SO_B5_2;
				state = STAT_HZ_SO;
				break;
			case HZ_SI:
				state = STAT_ASC;
				break;
			default:
				Putchar(HZ_ESC);
				if ( c!= HZ_ESC )
					Putchar(c);
				state = STAT_ASC;
				break;
			}

#ifdef	TTY_CMD
			if ( escvi && (c == HZ_SO_HZ || c == HZ_SO_B5_1
			|| c == HZ_SO_B5_2 || c == HZ_SI) ) {
#ifdef	SHOW_HZ_ESC
				Putchar(HZ_ESC); Putchar(c);
#else	/* !SHOW_HZ_ESC */
				Putchar('_'); Putchar('_');
#endif	/* SHOW_HZ_ESC */
			}
#endif	/* TTY_CMD */

			break;
		case STAT_HZ_SO:
		case STAT_HZ_C1:
			c0 = c;
			if ( c == HZ_ESC )
				state = STAT_HZ_AMB;
			else
				state = STAT_HZ_C0;
			break;
		case STAT_HZ_C0:
			if (is_cs94(c0) && is_cs94(c)) {
				hzb5decode(c0,c,so,dst);
				state = STAT_HZ_C1;
			}
			else
				state = STAT_ASC;
			Putchar(c0); Putchar(c);
			break;
		case STAT_HZ_AMB:
			switch ( c ) {
			case HZ_SO_HZ:
				so = MODE_SO_HZ;
				state = STAT_HZ_SO;
				break;
			case HZ_SO_B5_1:
				so = MODE_SO_B5_1;
				state = STAT_HZ_SO;
				break;
			case HZ_SO_B5_2:
				so = MODE_SO_B5_2;
				state = STAT_HZ_SO;
				break;
			case HZ_SI:
				state = STAT_ASC;
				so = MODE_SO_ASC;
				break;
			default:
			if (is_cs94(c0) && is_cs94(c)) {
				hzb5decode(c0,c,so,dst);
				state = STAT_HZ_SO;
			}
			else
				state = STAT_ASC;
			Putchar(c0); Putchar(c);
				break;
			}

#ifdef	TTY_CMD
			if ( escvi && (c == HZ_SO_HZ || c == HZ_SO_B5_1 ||
			     c == HZ_SO_B5_2 || c == HZ_SI) ) {
#ifdef	SHOW_HZ_ESC
				Putchar(HZ_ESC); Putchar(c);
#else	/* !SHOW_HZ_ESC */
				Putchar('_'); Putchar('_');
#endif	/* SHOW_HZ_ESC */
			}
#endif	/* TTY_CMD */

			break;
		default:
			break;
		} /* switch */
	} /* while */
}

b5d1(hi,lo,so,dst)
int	*hi, *lo;
int	so;
int	dst;
{
	*hi |= 0x80;
	if (so == MODE_SO_B5_1) *lo |= 0x80;
}

b5d2(hi,lo,so,dst)
int	*hi, *lo;
int	so;
int	dst;
{
	if ( so == MODE_SO_B5_1 ) {		/* ~1 */
		b5cvt(*hi,*lo,0x21,0x48,0x21,0x7e,|=0x80,|=0x80); /* F1 */
		b5cvt(*hi,*lo,0x49,0x70,0x40,0x7e,+=0x58,|=0x00); /* F2 */
	}
	else if ( so == MODE_SO_B5_2 ) {	/* ~2 */
		b5cvt(*hi,*lo,0x49,0x7e,0x21,0x7e,|=0x80,|=0x80); /* R 1 */
		b5cvt(*hi,*lo,0x21,0x48,0x40,0x7e,+=0xa8,|=0x00); /* R 2 */
		b5cvt(*hi,*lo,0x21,0x2e,0x21,0x3f,+=0xd0,+=0x1f); /* R 3.1 */
		b5cvt(*hi,*lo,0x2f,0x3c,0x21,0x3f,+=0xc2,+=0x3e); /* R 3.2 */
		b5cvt(*hi,*lo,0x3d,0x48,0x21,0x21,+=0xb4,+=0x5d); /* R 3.3 */
		b5cvt(*hi,*lo,0x3d,0x3e,0x22,0x22,+=0xc0,+=0x5c); /* R 3.4 */
	}
	/* other non-Big5 modes ... ~{ or ~} */
}

b5d3(hi,lo,so,dst)
int	*hi, *lo;
int	so;
int	dst;
{
	if ( (so==MODE_SO_B5_1 && (*hi>=0x21 && *hi<=0x4f)) 
	  || (so==MODE_SO_B5_2 && (*hi>=0x50 && *hi<=0x7e)) ) { /* F1+/R1+ */
		*hi |= 0x80;				/* SET */
		*lo |= 0x80;				/* SET */
	}
	else
	if ( (*lo>=0x40&&*lo<=0x7e) && (*hi>=0x21&&*hi<=0x7e) )	/* F2+/R2+ */
		*hi += (so == MODE_SO_B5_1 ? 0x51 : 0xaf );	/* move */

	/* Note: the byte range checking can be made less restricted */
}

/*
 *	- Big5 code decoding with the HZ-S proposal by Steve Simpson
 *	** NOT tested **
 */
b5dhzs(p, a1, a2, b1, b2)
    int p, a1, a2, *b1, *b2;
{
    unsigned long n;
    int r;

    n = 94 * (a1 - 0x21) + (a2 - 0x21);

    *b1 = ((p == 2) ? 0xC9 : 0xA1) + (int) (n / 157);

    r = (int) n % 157;

    *b2 = ((r < 63) ? (0x40 + r) : (0xA1 + r - 63));
}

/*
 *	- Big5 decoding according to the HZ-2 proposal by Ya-Gui Wei
 *	** NOT tested **
 */
b5dhz2(a1,a2,b1,b2,so)
int	a1, a2;		/* 1st and 2nd bytes of ASCII/HZ-2 */
int	*b1, *b2;	/* 1st and 2nd bytes Big5 */
int	so;		/* current SO mode */
{
	if (so == MODE_SO_B5_1) {
        	*b1 = ((a1 - 0x21) >> 1) + 0xA1;
        	*b2 = a2 | (((a1 - 0x21) & 1) << 7);
	}
	else if (so == MODE_SO_B5_2) {
        	*b1 = ((a1 - 0x21) >> 1) + 0xD0;
        	*b2 = a2 | (((a1 - 0x21) & 1) << 7);
	} else {
		*b1 = a1;
		*b2 = a2;
	}
}

/*
 * History:
 *
 * $Log: b5decode.c,v $
 * Revision 1.3  1994/05/05  15:44:59  shin
 * 1. implement b5d() for B5E2 proposal
 *
 * Revision 1.2  1994/05/04  10:31:43  shin
 * 1. support b5encode mapping scheme for HZ+S proposal
 *
 * Revision 1.1  1994/05/01  19:02:46  shin
 * Initial revision
 *
 */

