/*******************************************/
/*  "Singing" Looped Soundfile Class,      */
/*  by Perry R. Cook, 1995-96              */ 
/*  This Object contains all that's needed */
/*  to make a pitched musical sound, like  */
/*  a simple voice or violin.  In general, */  
/*  it will not be used alone (because of  */
/*  of munchinification effects from pitch */
/*  shifting.  It will be used as an       */
/*  excitation source for other instruments*/
/*******************************************/

#if !defined(__SingWave_h)
#define __SingWave_h

extern float phonGains[32][2];
extern float phonParams[32][4][3];
extern char phonemes[32][4];

/*******************************************/
/*  Modulator Class, Perry R. Cook, 1995-96*/ 
/*  This Object combines random and        */
/*  periodic modulations to give a nice    */
/*  natural human modulation function.     */  
/*******************************************/

#include "physutil.h"
#include "clarinet.h"
#include "moog1.h"
#include "cs.h"

typedef struct SubNoise
{
     Noise	lastOutput;
     int	counter;
     int	howOften;
} SubNoise;

/* void make_SubNoise(SubNoise *); */
void make_SubNoise(SubNoise *, int subSample);
void SubNoise_setHowOften(SubNoise *, int howOft);
float SubNoise_tick(SubNoise *);

typedef struct Modulatr {
    FUNC     *wave;
    float    v_rate;
    float    v_time;
    float    v_phase;
    float    v_lastOutput;
    SubNoise noise;
    OnePole  onepole;
    float    vibAmt;
/*     float    rndAmt; */
    float    lastOutput;
} Modulatr;

void make_Modulatr(Modulatr *, float *);
void Modulatr_reset(Modulatr *);
void Modulatr_setRndAmt(Modulatr *, float rndAmount);
float Modulatr_tick(Modulatr *);
float Modulatr_lastOut(Modulatr *);

typedef struct SingWave {
    Modulatr	modulator;
    Envelope	envelope;
    Envelope	pitchEnvelope;
    FUNC	*wave;
    float	rate;
    float	sweepRate;
    float	mytime;
    float	lastOutput;
} SingWave;

void make_SingWave(SingWave *, float *, float *);
void SingWave_reset(SingWave *);
void SingWave_setFreq(SingWave *,float aFreq);    
float SingWave_tick(SingWave *);
void SingWave_print(SingWave *);

/*******************************************/
/*  4 Formant Synthesis Instrument         */
/*  by Perry R. Cook, 1995-96              */ 
/*  This instrument contains an excitation */
/*  singing wavetable (looping wave with   */
/*  random and periodic vibrato, smoothing */
/*  on frequency, etc.), excitation noise, */
/*  and four sweepable complex resonances. */
/*					   */
/*  Measured Formant data (from me) is     */
/*  included, and enough data is there to  */
/*  support either parallel or cascade     */
/*  synthesis.  In the floating point case */
/*  cascade synthesis is the most natural  */
/*  so that's what you'll find here.       */
/*					   */
/*  For right now, there's a simple command*/
/*  line score interface consisting of 3   */
/*  letter symbols for the phonemes, =xx   */
/*  sets the pitch to x, + and - add and   */
/*  subtract a half step, and ... makes it */
/*  keep doing what it's doing for longer. */
/*******************************************/

typedef struct VOICF {
    OPDS         h;
    float	*ar;                  /* Output */
    float	*amp, *frequency;
    float	*phoneme, *formant;
    float	*vibf, *vibAmt;
    float	*ifn, *ivfn;

    float	oldform;
    int		ph;
    float	basef;
    SingWave	voiced;
    Noise	noise;
    Envelope	noiseEnv;
    FormSwep    filters[4];
    OnePole	onepole;
    OneZero	onezero;
} VOICF;

void make_VoicForm(VOICF*);
void VoicForm_clear(VOICF*);
void VoicForm_setPhoneme(VOICF*, int i, float s);
void VoicForm_setVoicedUnVoiced(VOICF*, float vGain, float nGain);
void VoicForm_noteOn(VOICF*, float freq, float amp);
void VoicForm_noteOff(VOICF*);

#endif
