#include "cs.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "new-src/config.h"
static char buffer[200];
static char orcname[L_tmpnam+4];
static char sconame[L_tmpnam+4];
static char midname[L_tmpnam+4];
#ifndef TRUE
#define TRUE (1)
#define FALSE (0)
#endif

#ifdef macintosh
#define fgets getstring
char macBuffer[200];
int macBufNdx = 200;
char *getstring(char *str, int num, FILE *stream)
{	
    int bufferNdx = 0;
    size_t ourReturn;
    while (true) {
      if (macBufNdx >= 200) { /*then we must read in new buffer */
	macBufNdx = 0;
	ourReturn = fread(macBuffer, 1, num, stream);
	if (ourReturn == 0)
	  return NULL;
      }
      else {
	char c = macBuffer[macBufNdx];
	if (c == '\0' || c == '\n' || c == '\r') {
	  buffer[bufferNdx] = '\r';
	  if (bufferNdx < 199)
	    buffer[bufferNdx+1] = '\0';
	  macBufNdx++;
	  return buffer;
	}
	else {
	  buffer[bufferNdx] = c;
	  bufferNdx++;
	  macBufNdx++;
	}
      }
    }
}
#endif

static void deleteOrch(void)
{
    remove(orcname);
}

static void deleteScore(void)
{
    remove(sconame);
}

static void deleteMIDI(void)
{
    remove(midname);
}

static     char files[1000];
#if defined(HAVE_GETOPT_LONG) && HAVE_GETOPT_LONG == 1
	extern void csound_getopts(int, char **, char *, char *);
#else
	extern int argdecode(int, char**, char**, char*);
#endif /* defined(HAVE_GETOPT_LONG) && HAVE_GETOPT_LONG == 1 */


int readOptions(FILE *unf)
{
    char *p;
    int argc = 0;
    char *argv[100];
    char *filnamp = files;
    extern char *xfilename;

    while (fgets(buffer, 200, unf)!= NULL) {
      if (strstr(buffer,"</CsOptions>") == buffer) {
	return TRUE;
      }
      argc = 1;
      p = buffer;
      while (*p == ' ') p++;      /* Ignore leading spaces */
      if (*p==';' || *p=='#') continue; /* Comment line? */
      argv[1] = p;
      while (*p != '\0') {
	if (*p==' ') {
          *p++ = '\0';
#ifdef _DEBUG
          printf("argc=%d argv[%d]=%s\n", argc, argc, argv[argc]);
#endif
          while (*p == ' ') p++;
	  if (*p==';' || *p=='#') { /* Comment line? */
	    *p = '\0'; break;
	  }
          argv[++argc] = p;
        }
        else if (*p=='\n' || *p == '\r') { 
	  *p = '\0';
	  break;
	}
	p++;
      }
#ifdef _DEBUG
      printf("argc=%d argv[%d]=%s\n", argc, argc, argv[argc]);
#endif
#if defined(HAVE_GETOPT_LONG) && HAVE_GETOPT_LONG == 1
	csound_getopts(argc, argv, getenv("SFOUTYP"), xfilename);	/* See new-src/getlongopts.[ch] */
#else
	argdecode(argc, argv, &filnamp, getenv("SFOUTYP")); /* Read an argv thing */
#endif /* defined(HAVE_GETOPT_LONG) && HAVE_GETOPT_LONG == 1 */
    }
    return FALSE;
}

static int createOrchestra(FILE *unf)
{
    char *p;
    FILE *orcf;

    tmpnam(orcname);		/* Generate orchestra name */
    if ((p=strchr(orcname, '.')) != NULL) *p='\0'; /* with extention */
    strcat(orcname, ".orc");
    orcf = fopen(orcname, "w");
    printf("Creating %s (%p)\n", orcname, orcf);
    if (orcf==NULL){
      perror("Failed to create\n");
      exit(1);
    }
    while (fgets(buffer, 200, unf)!= NULL) {
      if (strstr(buffer,"</CsInstruments>") == buffer) {
	fclose(orcf);
	atexit(deleteOrch);
	return TRUE;
      }
      else fprintf(orcf, buffer);
    }
    return FALSE;
}


static int createScore(FILE *unf)
{
    char *p;
    FILE *scof;

    tmpnam(sconame);		/* Generate score name */
    if ((p=strchr(sconame, '.')) != NULL) *p='\0'; /* with extention */
    strcat(sconame, ".sco");
    scof = fopen(sconame, "w");
    while (fgets(buffer, 200, unf)!= NULL) {
      if (strstr(buffer,"</CsScore>") == buffer) {
	fclose(scof);
	atexit(deleteScore);
	return TRUE;
      }
      else fprintf(scof, buffer);
    }
    return FALSE;
}

static int createMIDI(FILE *unf)
{
    int size;
    char *p;
    FILE *midf;

    if (tmpnam(midname)==NULL) { /* Generate MIDI file name */
      printf("Cannot create temporary file for MIDI subfile\n");
      exit(1);
    }
    if ((p=strchr(midname, '.')) != NULL) *p='\0'; /* with extention */
    strcat(midname, ".mid");
    midf = fopen(midname, "wb");
    if (midf==NULL) {
      printf("Cannot open temporary file (%s) for MIDI subfile\n", midname);
      exit(1);
    }
    if (fscanf(unf, "Size = %d", &size)==0) {
      printf("Error in reading MIDI subfile -- no size read\n");
      exit(1);
    }
    for (; size > 0; size--) {
      int c = getc(unf);
      putc(c, midf);
    }
    fclose(midf);
    atexit(deleteMIDI);
    if (fgets(buffer, 200, unf)!= NULL) {
      if (strstr(buffer,"</CsMidifile>") == buffer) {
	return TRUE;
      }
    }
    return FALSE;
}

int read_unified_file(char *name, char **score, char **midi)
{
    FILE *unf = fopen(name, "rb");
    int result = TRUE;
    orcname[0] = sconame[0] = midname[0] = '\0';

#ifdef _DEBUG
    printf("Calling unified file system with %s\n", name);
#endif
    while (fgets(buffer, 200, unf)) {
      if (strstr(buffer,"<CsoundSynthesizer>") == buffer ||
	  strstr(buffer,"<CsoundSynthesiser>") == buffer) {
	printf("STARTING FILE\n");
      }
      else if (strstr(buffer,"</CsoundSynthesizer>") == buffer ||
	      strstr(buffer,"</CsoundSynthesiser>") == buffer)	{
	    strcpy(name, orcname);
	    *score = sconame;
	    *midi = midname;
	    return result;
	  }
      else if (strstr(buffer,"<CsOptions>") == buffer) {
	printf("Creating options\n");
	result = (result && readOptions(unf));
      }
/*  	  else if (strstr(buffer,"<CsFunctions>") == buffer) { */
/*  	    importFunctions(unf); */
/*  	  } */
	  else if (strstr(buffer,"<CsInstruments>") == buffer) {
	    printf("Creating orchestra\n");
	    result = (result && createOrchestra(unf));
	  }
/*  	  else if (strstr(buffer,"<CsArrangement>") == buffer) { */
/*  	    importArrangement(unf); */
/*  	  } */
	  else if (strstr(buffer,"<CsScore>") == buffer) {
	    printf("Creating score\n");
	    result = (result && createScore(unf));
	  }
/*  	  else if (strstr(buffer,"<CsTestScore>") == buffer) { */
/*  	    importTestScore(unf); */
/*  	  } */
	  else if (strstr(buffer,"<CsMidifile>") == buffer) {
	    result = (result && createMIDI(unf));
	  }
	  else {
	    printf("Unknown command :%s\n", buffer);
	  }
      }
    return result;
}
