/*
 * $Id: scheduler.c,v 1.4 1998/12/12 11:16:30 nicb Exp $
 *
 * Written by Fred Floberg <emng@geocities.com>
 *
 */
#include <sched.h>
#include <stdio.h>
#include "cs.h"
void setscheduler(void)
{
        struct sched_param sched_param;
	extern int scheduler_priority;

	if(!scheduler_priority) return; /* Check commandline option */
        if (sched_getparam(0, &sched_param)<0) {
                err_printf("Scheduler getparam failed...\n");
                return;
        }
        sched_param.sched_priority = sched_get_priority_max(SCHED_RR);
        if (!sched_setscheduler(0, SCHED_RR, &sched_param)) {
                err_printf("Scheduler set to Round Robin with priority %i...\n", sched_param.sched_priority);
                fflush(stderr);
                return;
        }
        err_printf("!!!Scheduler set to Round Robin with priority %i FAILED!!!\n", sched_param.sched_priority);
}
