;****
;**** An example of kargc, argc, kargt, argt, krtrnc,artrnc, krtrnt and artrnt opcodes
;****

	sr = 44100
	kr = 441
	ksmps = 100
	nchnls = 2

gifn	ftgen	1,0,1024,10 ,1 ,0,0,0,0,0,0,.1,0,0,0,0,0,.05,0,0,0,0,0,0,0,.01
gikfn	ftgen	2,0,1024,10 ,1

;***************************************************
	instr	1	;**** caller instrument ****
;***************************************************
iamp	ampmidi	2000
ifreq	cpsmidi

a1	oscili	iamp, ifreq, gifn
a2	oscili	iamp, ifreq*1.3, gifn
a3	oscili	iamp, ifreq*1.5555, gifn

k1	oscili	1, .5, gikfn
k2	oscili	1, 1.3, gikfn
k3	oscili	1, 2.1.5555, gikfn

	xtratim	2	;when using a-rate arguments in subroutine call,
			;you must be sure that the extra-time of the instrument
			;containing the out opcode is
			;grater or equal to that of the target instr
;//////// first instance call /////////////
	micall	2,0,4,iamp, ifreq	;call instr 2 as subroutine
	kargc	k1,k2,k3		;send k-rate arguments to instr 2
	argc	a1,a2,a3		;send a-rate arguments to instr 2

	artrnc	aout1,aout2	;receive a-signals returned by the first instance of instr 2

;//////// second instance call /////////////
	micall	2,0,4,iamp, ifreq*2.2 ;call instr 2 as subroutine
	kargc	k3,k2,k1		;send k-rate arguments to instr 2
	argc	a3,a1,a2		;send a-rate arguments to instr 2

	krtrnc	kenv		;receive k-signals returned by the second instance of instr 2
	artrnc	aout3,aout4	;receive a-signals returned by the second instance instr 2

	outs 	(aout1+aout3)*kenv, (aout2+aout4)*kenv

	endin



;***************************************************
	instr	2	;**** target instrument ****
;***************************************************
	kargt	ksig,ksig2,ksig3	;receive k-signals sent by caller arguments
	argt	asig,asig2,asig3	;receive a-signals sent by caller arguments

k1	linenr	1,p3/2,p3/2,.03
a1	oscili	p4*ksig,p5,gifn
a2 	oscili	p4*ksig2,p5*1.5,gifn
a3	oscili	p4*ksig3,p5*1.8,gifn
	krtrnt	k1
	artrnt	a1+asig2+asig3, a2+a3+asig

	endin


