#include "cs.h"		/*					AOPS.C	*/
#include "aops.h"
#include <math.h>

static	double	eipt3=8.3333333, oct;
static	double	logtwo=0.693147;

#define FZERO	0.0f

extern  double  onept, log10d20;
extern	float 	*spin, *spout;
extern  int     spoutactive;

void rassign(ASSIGN *p)
{
	*p->r = *p->a;  /* still not quite right */
}

void assign(ASSIGN *p)
{
	*p->r = *p->a;
}

void aassign(ASSIGN *p)
{
        float 	*r, *a;
	int	nsmps = ksmps;

 	r = p->r;
	a = p->a;
	if (p->XINCODE) {
		do *r++ = *a++;
		while (--nsmps);
	}
	else {
		do *r++ = *a;
		while (--nsmps);
	}
}

void init(ASSIGN *p)
{
	*p->r = *p->a;
}

void ainit(ASSIGN *p)
{
        float	*r, *a;
	int	nsmps = ksmps;

 	r = p->r;
	a = p->a;
	do  *r++ = *a;
	while (--nsmps);
}

#define	RELATN(OPNAME,OP) void OPNAME(RELAT *p) { *p->rbool = (*p->a OP *p->b) ? 1 : 0; /* printf("bool = %d\n",*p->rbool);*/ }

RELATN(gt,>)
RELATN(ge,>=)
RELATN(lt,<)
RELATN(le,<=)
RELATN(eq,==)
RELATN(ne,!=)

#define	LOGCLX(OPNAME,OP) void OPNAME(LOGCL *p) { *p->rbool = (*p->ibool OP *p->jbool) ? 1 : 0; }

LOGCLX(and,&&)
LOGCLX(or,||)

#define	KK(OPNAME,OP) void OPNAME(AOP *p) { *p->r = *p->a OP *p->b; }

KK(addkk,+)
KK(subkk,-)
KK(mulkk,*)
KK(divkk,/)

float MOD(float a, float bb)
{
    if (bb==0.0f) return 0.0f;
    else {
      float b = (bb<0 ? -bb : bb);
/*        float b100 = b*100.0f; */
/*        float b10000 = b*10000.0f; */
/*        float b1000000 = b*1000000.0f; */
/*        printf("MOD(%f,%f)=", a, b); fflush(stdout); */
/*        while (a>b1000000) a -= b1000000; */
/*        while (a>b10000) a -= b10000; */
/*        while (a>b100) a -= b100; */
/*        while (a>b) a -= b; */
/*        while (-a>b1000000) a += b1000000; */
/*        while (-a>b10000) a += b10000; */
/*        while (-a>b100) a += b100; */
/*        while (-a>b) a += b; */
      int d = (int)(a / b);
/*    printf("MOD(%f,%f)=[d=%d]", a, b, d); fflush(stdout); */
      a -= d * b;
      while (a>b) a -= b;
      while (-a>b) a += b;
/*    printf("%f\n", a); */
      return a;
    }
}

void modkk(AOP *p)
{
    *p->r = MOD(*p->a, *p->b);
}

#define KA(OPNAME,OP) void OPNAME(AOP *p) {	\
	int	nsmps = ksmps;		        \
	float	*r, a, *b;		        \
	r = p->r;				\
	a = *p->a;				\
	b = p->b;				\
	do *r++ = a OP *b++;			\
	while (--nsmps);			\
}

KA(addka,+)
KA(subka,-)
KA(mulka,*)
KA(divka,/)

void modka(AOP *p)
{
    int	nsmps = ksmps;
    float	*r, a, *b;
    r = p->r;		
    a = *p->a;		
    b = p->b;		
    do 
      *r++ = MOD(a,*b++);
    while (--nsmps);	
}

#define AK(OPNAME,OP) void OPNAME(AOP *p) {	\
	int	nsmps = ksmps;		        \
	float	*r, *a, b;		        \
	r = p->r;				\
	a = p->a;				\
	b = *p->b;				\
	do *r++ = *a++ OP b;			\
	while (--nsmps);			\
}

AK(addak,+)
AK(subak,-)
AK(mulak,*)
AK(divak,/)

void modak(AOP *p) {
    int	nsmps = ksmps;	
    float	*r, *a, b;
    r = p->r;		
    a = p->a;		
    b = *p->b;		
    do *r++ = MOD(*a++, b);
    while (--nsmps);		
}


#define AA(OPNAME,OP) void OPNAME(AOP *p) {	\
	int	nsmps = ksmps;		        \
	float	*r, *a, *b;		        \
	r = p->r;				\
	a = p->a;				\
	b = p->b;				\
	do *r++ = *a++ OP *b++;			\
	while (--nsmps);			\
}

AA(addaa,+)
AA(subaa,-)
AA(mulaa,*)
AA(divaa,/)

void modaa(AOP *p) {
    int	nsmps = ksmps;
    float	*r, *a, *b;	
    r = p->r;		
    a = p->a;		
    b = p->b;		
    do *r++ = MOD(*a++, *b++);	
    while (--nsmps);	
}

void divzkk(DIVZ *p)
{
    *p->r = (*p->b != 0.0 ? *p->a / *p->b : *p->def);
}

void divzka(DIVZ *p)
{
    int		nsmps = ksmps;
    float	*r, a, *b, def;
    r = p->r;
    a = *p->a;
    b = p->b;
    def = *p->def;
    do {
      *r++ = (*b==0 ? def : a / *b);
      b++;
    } while (--nsmps);
}

void divzak(DIVZ *p)
{
    int		nsmps = ksmps;
    float	*r, *a, b, def;
    r = p->r;
    a = p->a;
    b = *p->b;
    def = *p->def;
    if (b==0) {
      do 
	*r++ = def;
      while (--nsmps);
    }
    else {
      do
	*r++ = *a++ / b;
      while (--nsmps);
    }
}

void divzaa(DIVZ *p)
{
	int	nsmps = ksmps;
	float	*r, *a, *b, def;
	r = p->r;
	a = p->a;
	b = p->b;
	def = *p->def;
	do {
	  *r++ = (*b==0.0 ? def : *a / *b);
	  a++; b++;
	} while (--nsmps);
}

void conval(CONVAL *p)
{
	if (*p->cond)
		*p->r = *p->a;
	else *p->r = *p->b;
}

void aconval(CONVAL *p)
{
        float	*r, *s;
	int	nsmps = ksmps;

	r = p->r;
	if (*p->cond)
		s = p->a;
	else s = p->b;
	do *r++ = *s++;
	while (--nsmps);
}
	
void int1(EVAL *p)				/* returns signed whole no. */
{
	double intpart;
	modf((double)*p->a, &intpart);
	*p->r = (float)intpart;
}

void frac1(EVAL *p)				/* returns positive frac part */
{
	double intpart, fracpart;
	fracpart = modf((double)*p->a, &intpart);
	*p->r = (float)fracpart;
}

static double rndfrac = .5, rndmlt = 105.947;

void rnd1(EVAL *p)              /* returns unipolar rand(x) */
{
	double intpart;
	rndfrac = modf(rndfrac * rndmlt, &intpart);
	*p->r = *p->a * (float)rndfrac;
}

void birnd1(EVAL *p)            /* returns bipolar rand(x) */
{
	double intpart;
	rndfrac = modf(rndfrac * rndmlt, &intpart);
	*p->r = *p->a * (2.0f * (float)rndfrac - 1.0f);
}

#define LIB1(OPNAME,LIBNAME)  void OPNAME(EVAL *p)	 \
				{ *p->r = (float)LIBNAME((double)*p->a); }
LIB1(abs1,fabs)
LIB1(exp01,exp)
LIB1(log01,log)
LIB1(sqrt1,sqrt)
LIB1(sin1,sin)
LIB1(cos1,cos)
LIB1(tan1,tan)
LIB1(asin1,asin)
LIB1(acos1,acos)
LIB1(atan1,atan)
LIB1(sinh1,sinh)
LIB1(cosh1,cosh)
LIB1(tanh1,tanh)
LIB1(log101,log10)
void atan21(AOP *p) { *p->r = (float)atan2((double)*p->a, (double)*p->b); }

#define LIBA(OPNAME,LIBNAME) void OPNAME(EVAL *p) {		       \
				int	nsmps = ksmps;	               \
				float	*r, *a;		               \
				r = p->r;		               \
				a = p->a;			       \
				do *r++ = (float)LIBNAME((double)*a++);\
				while (--nsmps);		       \
				}
LIBA(absa,fabs)
LIBA(expa,exp)
LIBA(loga,log)
LIBA(sqrta,sqrt)
LIBA(sina,sin)
LIBA(cosa,cos)
LIB1(tana,tan)
LIB1(asina,asin)
LIB1(acosa,acos)
LIB1(atana,atan)
LIB1(sinha,sinh)
LIB1(cosha,cosh)
LIB1(tanha,tanh)
LIB1(log10a,log10)

void atan2aa(AOP *p) {
	int	nsmps = ksmps;
	float	*r, *a, *b;	
	r = p->r;		
	a = p->a;		
	b = p->b;		
	do *r++ = (float)atan2((double)*a++, (double)*b++);	
	while (--nsmps);	
}

void dbamp(EVAL *p)
{
	*p->r = (float)(log(fabs((double)*p->a)) / log10d20);
}

void ampdb(EVAL *p)
{
	*p->r = (float) exp((double)*p->a * log10d20);
}

void aampdb(EVAL *p)
{
	int	nsmps = ksmps;
	float	*r, *a;
	r = p->r;
	a = p->a;
	do *r++ = (float) exp((double)*a++ * log10d20);
	while (--nsmps);
}

void ftlen(EVAL *p)
{
	FUNC	*ftp;

	if ((ftp = ftnp2find(p->a)) != NULL)
          *p->r = (float)ftp->flen;
	else *p->r = -1.0f;	/* Return something */
}

void ftlptim(EVAL *p)
{
	FUNC    *ftp;
        if ((ftp = ftnp2find(p->a)) == NULL) return;
	if (ftp->loopmode1)
	    *p->r = ftp->begin1 * onedsr;
	else {
	    *p->r = 0.0f;
	    warning("non-looping sample");
	}
}

/***** nsamp by G.Maldonado ****/  /* gab-A1 */

void numsamp(EVAL *p)
{
register FUNC	*ftp;
	if ((ftp = ftfind(p->a)) != NULL)
		*p->r = (float) ftp->soundend;
}

/**** ftsr by G.Maldonado ****/	  /* gab-A1 */

void ftsr(EVAL *p)
{
register FUNC	*ftp;
	if ((ftp = ftfind(p->a)) != NULL)
		*p->r = ftp->gen01args.sample_rate;
}

/**** ftlen2 by G.Maldonado ****/	/* gab-A1 */
FUNC   *ftfind2(float*); /*declaration*/
/* SEE FGENS.C for ftfind2() function */
void ftlen2(EVAL *p)
{
register FUNC	*ftp;

	if ((ftp = ftfind2(p->a)) != NULL)
		*p->r = (float) ftp->flen;
}
/********************************/

float *cpsocint = NULL;     /* arrays & scaler for fast cpsoct conversion */
float *cpsocfrc = NULL;
float octresol = (float)OCTRES;
float *powerof2 = NULL; /* gab-A1 for fast power of two table  */
float *logbase2 = NULL; /* gab-A1 for fast log base 2 table */

void cpsoctinit(void)           /* init the arrays, called by oload */
{
	float *fp;
	long  count;

	cpsocint = (float *) mmalloc((long)NOCTS * sizeof(float));
        cpsocfrc = (float *) mmalloc((long)OCTRES * sizeof(float));
	for (fp = cpsocint, count = 0; count < NOCTS; count++)
	    *fp++ = (float) pow(2.0, (double)count);
	for (fp = cpsocfrc, count = 0; count < OCTRES; count++)
	    *fp++ = (float)(pow(2.0, (double)count / (double)OCTRES) * onept);
	/* gab-A1 for fast power of two table */
	{
		#define STEPS 32768 
		#define OCTAVES 5.
		double incr = (OCTAVES * 2.) / STEPS, exp = -OCTAVES; 
		
		powerof2 = (float *) mmalloc((long)(STEPS+1) * sizeof(float));
		fp =  powerof2;
		for	( count = 0; count <= STEPS; count++, exp += incr)	
			*fp++ = (float) pow(2.0, exp);
		powerof2 += STEPS/2;
	}
	{ /* gab-A1 for fast log base two table */
		#define INTERVAL 4.
		double incr = (INTERVAL - 1/INTERVAL) / STEPS, first = 1/INTERVAL;
		double conv = 1/(log(2.));
		logbase2  = (float *) mmalloc((long)(STEPS+1) * sizeof(float));
		fp = logbase2;

		for	( count = 0; count <= STEPS; count++, first += incr) 
					*fp++ = (float) (conv * log(first));
	}
   /* end gab-A1  */
}

void octpch(EVAL *p)
{
	double	fract;
	fract = modf((double)*p->a, &oct);
	fract *= eipt3;
	*p->r = (float) (oct + fract);
}

void pchoct(EVAL *p)
{
	double fract;
	fract = modf((double)*p->a, &oct);
	fract *= 0.12;
	*p->r = (float)(oct + fract);
}


#include <stdio.h>
void cpsoct(EVAL *p)
{
        long loct = (long)(*p->a * octresol);
	*p->r = (float)CPSOCTL(loct);
}

/* gab-A1 */
void powoftwo(EVAL *p) 	  /* by G.Maldonado */
{
	*p->r = powerof2[(int) (*p->a * (STEPS/(OCTAVES *2)) + .5)] ;
}

void logbasetwo(EVAL *p) 	/* by G.Maldonado */
{
	*p->r = logbase2[(int) ((*p->a -  (1/INTERVAL)) / (INTERVAL - 1/INTERVAL)  *  STEPS + .5)] ;
}
/* end gab-A1 */

void acpsoct(EVAL *p)
{
	float	*r, *a;
	long	loct, nsmps = ksmps;
	a = p->a;
	r = p->r;
	do {
	    loct = (long)(*a++ * octresol);
	    *r++ = CPSOCTL(loct);
	} while (--nsmps);
}

void octcps(EVAL *p)
{
	*p->r = (float)(log((double)*p->a / onept) / logtwo);
}

void cpspch(EVAL *p)
{
	double	fract;
	long   loct;

	fract = modf((double) *p->a, &oct);
	fract *= eipt3;
	loct = (long) ((oct + fract) * octresol);
	*p->r = (float)CPSOCTL(loct);
/* 	err_printf("%.2f -> %f\n", *p->a, *p->r); */
}

void cpsxpch(XENH *p)
{				/* This may be too expensive */
    double  fract;
    double  loct;
	
     err_printf("pc,et,cy,ref=%.4f,%.4f,%.4f,%.4f\n", 
  	       *p->pc, *p->et, *p->cy, *p->ref); 

    fract = modf((double)*p->pc, &loct); /* Get octave */
    if (*p->et > 0) {
      fract = pow((double)*p->cy, loct + (100.0*fract)/((double)*p->et));
      *p->r = (float)fract * *p->ref;
    }
    else {			/* Values in a table */
      float t = - *p->et;
      FUNC* ftp = ftfind(&t);
      long len;
      if (ftp == NULL) {
	printf("No tuning table %d\n", (int)(- *p->et));
	exit(1);
      }
      len = ftp->flen;
      while (fract>len) {
	fract -= len; loct++;
      }
      fract += 0.005;
      *p->r = *p->ref * *(ftp->ftable + (int)(100.0*fract)) *
        (float)pow((double)*p->cy, loct);
    }
    err_printf("....-> %.6f\n", *p->r); 
}

void cps2pch(XENH *p)
{
    double  fract;
    double  loct;
	
    fract = modf((double)*p->pc, &loct);	/* Get octave */
    if (*p->et > 0) {
      fract = pow(2.0, loct + (100.0*fract)/((double)*p->et));
      *p->r = (float)(fract * 1.02197503906); /* Refer to base frequency */
    }
    else {
      float t = - *p->et;
      FUNC* ftp = ftfind(&t);
      long len;
      if (ftp == NULL) {
	printf("No tuning table %d\n", (int)(- *p->et));
	exit(1);
      }
      len = ftp->flen;
      while (fract>len) {
	fract -= len; loct++;
      }
      fract += 0.005;
      *p->r = (float)(1.02197503906 * *(ftp->ftable +(int)(100.0*fract)) *
                      pow(2.0, loct));
    }

/*       double ref = 261.62561 / pow(2.0, 8.0); */
}

void in(IN *p)
{
	float	*sp, *ar;
	int	nsmps = ksmps;

	sp = spin;
	ar = p->ar;
	do  *ar++ = *sp++;
	while (--nsmps);
}

void ins(INS *p)
{
	float	*sp, *ar1, *ar2;
	int	nsmps = ksmps;

	sp = spin;
	ar1 = p->ar1;
	ar2 = p->ar2;
	do {
	    *ar1++ = *sp++;
	    *ar2++ = *sp++;
	}
	while (--nsmps);
}

void inq(INQ *p)
{
	float	*sp, *ar1, *ar2, *ar3, *ar4;
	int	nsmps = ksmps;

	sp = spin;
	ar1 = p->ar1;
	ar2 = p->ar2;
	ar3 = p->ar3;
	ar4 = p->ar4;
	do {
	    *ar1++ = *sp++;
	    *ar2++ = *sp++;
	    *ar3++ = *sp++;
	    *ar4++ = *sp++;
	}
	while (--nsmps);
}

void inh(INH *p)
{
	float	*sp, *ar1, *ar2, *ar3, *ar4, *ar5, *ar6;
	int	nsmps = ksmps;

	sp = spin;
	ar1 = p->ar1;
	ar2 = p->ar2;
	ar3 = p->ar3;
	ar4 = p->ar4;
	ar5 = p->ar5;
	ar6 = p->ar6;
	do {
	    *ar1++ = *sp++;
	    *ar2++ = *sp++;
	    *ar3++ = *sp++;
	    *ar4++ = *sp++;
	    *ar5++ = *sp++;
	    *ar6++ = *sp++;
	}
	while (--nsmps);
}

void ino(INO *p)
{
	float	*sp, *ar1, *ar2, *ar3, *ar4, *ar5, *ar6, *ar7, *ar8;
	int	nsmps = ksmps;

	sp = spin;
	ar1 = p->ar1;
	ar2 = p->ar2;
	ar3 = p->ar3;
	ar4 = p->ar4;
	ar5 = p->ar5;
	ar6 = p->ar6;
	ar7 = p->ar7;
	ar8 = p->ar8;
	do {
	    *ar1++ = *sp++;
	    *ar2++ = *sp++;
	    *ar3++ = *sp++;
	    *ar4++ = *sp++;
	    *ar5++ = *sp++;
	    *ar6++ = *sp++;
	    *ar7++ = *sp++;
	    *ar8++ = *sp++;
	}
	while (--nsmps);
}

void out(OUT *p)
{
	float	*sp, *ap;
	int	nsmps = ksmps;

	ap = p->asig;
	sp = spout;
        if (!spoutactive) {
	    do 	*sp++ = *ap++;
	    while (--nsmps);
	    spoutactive = 1;
	}
        else {
	    do {
	        *sp += *ap++;   sp++;
	    }
	    while (--nsmps);
	}
}

void outs(OUTS *p)
{
	float	*sp, *ap1, *ap2;
	int	nsmps = ksmps;

	ap1 = p->asig1;
	ap2 = p->asig2;
	sp = spout;
        if (!spoutactive) {
 	    do {
		*sp++ = *ap1++;
		*sp++ = *ap2++;
	    }
	    while (--nsmps);
	    spoutactive = 1;
	}
        else {
	    do {
		*sp += *ap1++;	sp++;
		*sp += *ap2++;	sp++;
	    }
	    while (--nsmps);
	}
}

void outq(OUTQ *p)
{
	float	*sp, *ap1, *ap2, *ap3, *ap4;
	int	nsmps = ksmps;

	ap1 = p->asig1;
	ap2 = p->asig2;
	ap3 = p->asig3;
	ap4 = p->asig4;
	sp = spout;
        if (!spoutactive) {
	    do {
		*sp = *ap1++;	sp++;
		*sp = *ap2++;	sp++;
		*sp = *ap3++;	sp++;
		*sp = *ap4++;	sp++;
	    }
	    while (--nsmps);
	    spoutactive = 1;
	}
        else {
	    do {
		*sp += *ap1++;	sp++;
		*sp += *ap2++;	sp++;
		*sp += *ap3++;	sp++;
		*sp += *ap4++;	sp++;
	    }
	    while (--nsmps);
	}
}

void outs1(OUT *p)
{
	float	*sp, *ap1;
	int	nsmps = ksmps;

	ap1 = p->asig;
	sp = spout;
	if (!spoutactive) {
 	    do {
		*sp = *ap1++;	sp++;
		*sp = FZERO;	sp++;
	    }
	    while (--nsmps);
	    spoutactive = 1;
	}
        else {
	    do {
		*sp += *ap1++;	sp += 2;
	    }
	    while (--nsmps);
	}
}

void outs2(OUT *p)
{
	float	*sp, *ap2;
	int	nsmps = ksmps;

	ap2 = p->asig;
	if (!spoutactive) {
	    sp = spout;
 	    do {
		*sp = FZERO;	sp++;
		*sp = *ap2++;	sp++;
	    }
	    while (--nsmps);
	    spoutactive = 1;
	}
        else {
	    sp = spout + 1;
	    do {
		*sp += *ap2++;	sp += 2;
	    }
	    while (--nsmps);
	}
}

void outs12(OUT *p)
{
	float	*sp, *ap;
	int	nsmps = ksmps;

	ap = p->asig;
	sp = spout;
        if (!spoutactive) {
 	    do {
		*sp++ = *ap;
		*sp++ = *ap++;
	    }
	    while (--nsmps);
	    spoutactive = 1;
	}
        else {
	    do {
		*sp += *ap;	sp++;
		*sp += *ap++;	sp++;
	    }
	    while (--nsmps);
	}
}

void outq1(OUT *p)
{
	float	*sp, *ap1;
	int	nsmps = ksmps;

	ap1 = p->asig;
	sp = spout;
	if (!spoutactive) {
 	    do {
		*sp = *ap1++;	sp++;
		*sp = FZERO;	sp++;
		*sp = FZERO;	sp++;
		*sp = FZERO;	sp++;
	    }
	    while (--nsmps);
	    spoutactive = 1;
	}
        else {
	    do {
		*sp += *ap1++;	sp += 4;
	    }
	    while (--nsmps);
	}
}

void outq2(OUT *p)
{
	float	*sp, *ap2;
	int	nsmps = ksmps;

	ap2 = p->asig;
	if (!spoutactive) {
	    sp = spout;
 	    do {
		*sp = FZERO;	sp++;
		*sp = *ap2++;	sp++;
		*sp = FZERO;	sp++;
		*sp = FZERO;	sp++;
	    }
	    while (--nsmps);
	    spoutactive = 1;
	}
        else {
	    sp = spout + 1;
	    do {
		*sp += *ap2++;	sp += 4;
	    }
	    while (--nsmps);
	}
}

void outq3(OUT *p)
{
	float	*sp, *ap3;
	int	nsmps = ksmps;

	ap3 = p->asig;
	if (!spoutactive) {
	    sp = spout;
 	    do {
		*sp = FZERO;	sp++;
		*sp = FZERO;	sp++;
		*sp = *ap3++;	sp++;
		*sp = FZERO;	sp++;
	    }
	    while (--nsmps);
	    spoutactive = 1;
	}
        else {
	    sp = spout + 2;
	    do {
		*sp += *ap3++;	sp += 4;
	    }
	    while (--nsmps);
	}
}

void outq4(OUT *p)
{
	float	*sp, *ap4;
	int	nsmps = ksmps;

	ap4 = p->asig;
	if (!spoutactive) {
	    sp = spout;
 	    do {
		*sp = FZERO;	sp++;
		*sp = FZERO;	sp++;
		*sp = FZERO;	sp++;
		*sp = *ap4++;	sp++;
	    }
	    while (--nsmps);
	    spoutactive = 1;
	}
        else {
	    sp = spout + 3;
	    do {
		*sp += *ap4++;	sp += 4;
	    }
	    while (--nsmps);
	}
}

void outh(OUTH *p)
{
	float	*sp, *ap1, *ap2, *ap3, *ap4, *ap5, *ap6;
	int	nsmps = ksmps;

	ap1 = p->asig1;
	ap2 = p->asig2;
	ap3 = p->asig3;
	ap4 = p->asig4;
	ap5 = p->asig5;
	ap6 = p->asig6;
	sp = spout;
        if (!spoutactive) {
	    do {
		*sp = *ap1++;	sp++;
		*sp = *ap2++;	sp++;
		*sp = *ap3++;	sp++;
		*sp = *ap4++;	sp++;
		*sp = *ap5++;	sp++;
		*sp = *ap6++;	sp++;
	    }
	    while (--nsmps);
	    spoutactive = 1;
	}
        else {
	    do {
		*sp += *ap1++;	sp++;
		*sp += *ap2++;	sp++;
		*sp += *ap3++;	sp++;
		*sp += *ap4++;	sp++;
		*sp += *ap5++;	sp++;
		*sp += *ap6++;	sp++;
	    }
	    while (--nsmps);
	}
}

void outo(OUTO *p)
{
	float	*sp, *ap1, *ap2, *ap3, *ap4, *ap5, *ap6, *ap7, *ap8;
	int	nsmps = ksmps;

	ap1 = p->asig1;
	ap2 = p->asig2;
	ap3 = p->asig3;
	ap4 = p->asig4;
	ap5 = p->asig5;
	ap6 = p->asig6;
	ap7 = p->asig7;
	ap8 = p->asig8;
	sp = spout;
        if (!spoutactive) {
	    do {
		*sp = *ap1++;	sp++;
		*sp = *ap2++;	sp++;
		*sp = *ap3++;	sp++;
		*sp = *ap4++;	sp++;
		*sp = *ap5++;	sp++;
		*sp = *ap6++;	sp++;
		*sp = *ap7++;	sp++;
		*sp = *ap8++;	sp++;
	    }
	    while (--nsmps);
	    spoutactive = 1;
	}
        else {
	    do {
		*sp += *ap1++;	sp++;
		*sp += *ap2++;	sp++;
		*sp += *ap3++;	sp++;
		*sp += *ap4++;	sp++;
		*sp += *ap5++;	sp++;
		*sp += *ap6++;	sp++;
		*sp += *ap7++;	sp++;
		*sp += *ap8++;	sp++;
	    }
	    while (--nsmps);
	}
}
