/********************************************************************************
* Copyright (c) Des Herriott 1993, 1994
*               Erik Kunze   1995 - 1999
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Authors: Des Herriott
*          Erik Kunze
*******************************************************************************/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#ifndef lint
static char rcsid[] = "$Id: util.c,v 4.26 1999/04/27 13:55:31 erik Rel $";
#endif
#include <sys/types.h>
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#ifdef HAVE_STRINGS_H
# include <strings.h>
#endif
#include <sys/time.h>
#include <ctype.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <assert.h>
#include "resource.h"
#include "main.h"
#include "util.h"
#define NELEM(a)		(sizeof(a) / sizeof(a[0]))
typedef struct _onQuitRecord {
void (*f)(void);
struct _onQuitRecord *next;
} onQuitRecord;
const char *FtExt[] = {
"sna", "z80", "slt",
"tap", "voc", "tzx",
"dat",
"dsk", "trd", "fdi",
"scl", "mgt", "img",
"mdr",
"scr", "pok"
};
static onQuitRecord *onQuitList = NULL;
FILE *
Fopen(char *name, const char *amode)
{
FILE *fp = NULL;
char *buf;
char *path, *element;
if (!name || !name[0])
{
return NULL;
}
if (name[0] == '/' || !strncmp(name, "./", 2) || !strncmp(name, "../", 3))
{
return (fopen(name, amode));
}
path = Strdup(GETCFG(libDir), "Fopen");
element = strtok(path, ":");
while (element)
{
buf = (char *)Malloc(strlen(name) + strlen(element) + 2, "Fopen");
(void)sprintf(buf, "%s/%s", element, name);
fp = fopen(buf, amode);
free(buf);
if (fp)
{
break;
}
element = strtok(NULL, ":");
}
free(path);
return fp;
}
void *
Malloc(size_t size, const char *function)
{
void *p;
if (!(p = calloc(size, 1)))
{
Msg(M_FATAL, "malloc failed in %s()", function);
}
return p;
}
char *
Strdup(const char *src, const char *function)
{
char *dst;
if (!(dst = strdup(src)))
{
Msg(M_FATAL, "strdup failed in %s()", function);
}
return dst;
}
void *
Mmap(char *fname, int regular, int *readonly, size_t *size)
{
FILE *fp;
struct stat sbuf;
void *mmp = (void *)-1;
int res;
if (!(fp = Fopen(fname, "rb")))
{
Msg(M_ERR, "couldn't open <%s> for reading", fname);
return mmp;
}
res = fstat(fileno(fp), &sbuf);
(void)fclose(fp);
if (res < 0)
{
return mmp;
}
if (regular && !S_ISREG(sbuf.st_mode))
{
Msg(M_WARN, "not a regular file");
return mmp;
}
*size = (size_t)sbuf.st_size,
*readonly = (sbuf.st_mode & S_IWRITE) == 0 ? 1 : *readonly;
if (!(fp = Fopen(fname, *readonly ? "rb" : "r+b")))
{
Msg(M_ERR, "couldn't open <%s> for %sing", fname,
*readonly ? "read" : "writ");
return mmp;
}
#ifdef DEMO
mmp = mmap(NULL, *size, PROT_READ | (*readonly ? 0 : PROT_WRITE),
MAP_PRIVATE, fileno(fp), (off_t)0);
#else
mmp = mmap(NULL, *size, PROT_READ | (*readonly ? 0 : PROT_WRITE),
MAP_SHARED, fileno(fp), (off_t)0);
#endif
if (mmp == (void *)-1)
{
Msg(M_PERR, "mmap failed");
}
(void)fclose(fp);
return mmp;
}
void
Munmap(void *start, size_t length)
{
(void)munmap(start, length);
}
void
OnQuit(void (*fn)(void))
{
onQuitRecord *p;
p = (onQuitRecord *)Malloc(sizeof(onQuitRecord), "OnQuit");
p->f = fn;
p->next = onQuitList;
onQuitList = p;
}
void
Quit(int status)
{
onQuitRecord *p = onQuitList;
while (p)
{
p->f();
p = p->next;
}
exit(status);
}
#ifdef nec_ews
void
Msg(va_alist)
va_dcl
{
va_list args;
int errorLevel;
char *fmt;
va_start(args);
errorLevel = (int)va_arg(args, int);
fmt = (char *)va_arg(args, char *);
#else
void
Msg(int errorLevel, ...)
{
va_list args;
char *fmt;
va_start(args, errorLevel);
fmt = (char *)va_arg(args, char *);
#endif
if (!GETCFG(quiet)
|| errorLevel == M_ERR || errorLevel == M_PERR || errorLevel == M_FATAL)
{
(void)fprintf(stderr, "%s: ", ProgName);
switch(errorLevel)
{
case M_WARN:
case M_PWARN:
(void)fprintf(stderr, "warning: ");
break;
case M_ERR:
case M_PERR:
(void)fprintf(stderr, "error: ");
break;
case M_FATAL:
(void)fprintf(stderr, "fatal: ");
break;
case M_DEBUG:
(void)fprintf(stderr, "debug: ");
break;
}
(void)vfprintf(stderr, fmt, args);
(void)putc('\n', stderr);
if (errorLevel == M_PWARN || errorLevel == M_PERR)
{
perror("  -> reason");
}
}
if (errorLevel == M_FATAL)
{
Quit(1);
}
}
void
IntFrequency(int ms)
{
struct itimerval itv;
itv.it_interval.tv_sec = 0;
itv.it_interval.tv_usec = ms;
itv.it_value.tv_sec = 0;
itv.it_value.tv_usec = ms;
(void)setitimer(ITIMER_REAL, &itv, NULL);
}
int
ClassifyDescriptor(int fd)
{
struct stat buf;
if (isatty(fd))
{
return FD_TTY;
}
if (!fstat(fd, &buf))
{
if (S_ISREG(buf.st_mode))
{
return FD_FILE;
}
else if (S_ISFIFO(buf.st_mode))
{
return FD_PIPE;
}
}
Msg(M_WARN, "don't know where fd %d is coming from", fd);
return FD_UNKNOWN;
}
void
SetBlocking(int fd, int mode)
{
int status;
if  ((status = fcntl(fd, F_GETFL)) != -1)
{
#ifdef O_NONBLOCK
status = mode ? status | O_NONBLOCK : status & ~O_NONBLOCK;
#else
status = mode ?	status | O_NDELAY : status & ~O_NDELAY;
#endif
if (fcntl(fd, F_SETFL, status) != -1)
{
return;
}
}
Msg(M_PERR, "couldn't make fd %d %sblocking", fd, mode ? "non" : "");
}
const char *
GetBaseName(char *filename)
{
char *s;
if (filename)
{
if ((s = strrchr(filename, '/')))
{
return ++s;
}
else
{
return filename;
}
}
return ("-none-");
}
int
GetFileType(char *fname)
{
char *p;
int i;
assert(NELEM(FtExt) == FT_UNKNOWN);
if ((p = strrchr(fname, '.')))
{
p++;
for (i = 0; i < FT_UNKNOWN; i++)
{
if (!strncasecmp(p, FtExt[i], 4))
{
return i;
}
}
}
return FT_UNKNOWN;
}
#ifndef HAVE_STRCASECMP
int
strcasecmp(const char *s1, const char *s2)
{
char c1, c2;
for ( ; *s1 && *s2; s1++, s2++)
{
c1 = isupper(*s1) ? tolower(*s1) : *s1;
c2 = isupper(*s2) ? tolower(*s2) : *s2;
if (c1 != c2)
{
return (c1 - c2);
}
}
if (*s1 || *s2)
{
return (*s1 - *s2);
}
return 0;
}
int
strncasecmp(const char *s1, const char *s2, int n)
{
int i;
char c1, c2;
for (i = 0; *s1 && *s2 && i < n; s1++, s2++, i++)
{
c1 = isupper(*s1) ? tolower(*s1) : *s1;
c2 = isupper(*s2) ? tolower(*s2) : *s2;
if (c1 != c2)
{
return (c1 - c2);
}
}
if ((i < n) && (*s1 || *s2))
{
return (*s1 - *s2);
}
return 0;
}
#endif
void
DestroyList(Llist *head, void (*pDestroy)(void *))
{
Llist *pNext;
while (head)
{
if (head->item)
{
if (pDestroy)
{
pDestroy(head->item);
}
free(head->item);
}
pNext = head->next;
free(head);
head = pNext;
}
}
Llist *
AppendElemList(Llist *head, void *item)
{
Llist **ppHead = &head;
while (*ppHead)
{
ppHead = &((*ppHead)->next);
}
*ppHead = Malloc(sizeof(Llist), "AppendElemList");
(*ppHead)->item = item;
(*ppHead)->next = NULL;
return head;
}
Llist *
PrependElemList(Llist *head, void *item)
{
Llist *pHead;
pHead = Malloc(sizeof(Llist), "PrependElemList");
pHead->item = item;
pHead->next = head;
return pHead;
}
Llist *
RemoveElemList(void *item, int (*pCompare)(void *, void *), Llist *head,
void (*pDestroy)(void *))
{
Llist **ppHead = &head;
Llist *pElem;
while (*ppHead && (*pCompare)((*ppHead)->item, item))
{
ppHead = &((*ppHead)->next);
}
if (*ppHead)
{
pElem = *ppHead;
*ppHead = (*ppHead)->next;
if (pDestroy)
{
pDestroy(pElem);
}
free(pElem);
}
return head;
}
Llist *
SortedInsertList(void *item, int (*pCompare)(void *, void *), Llist *head)
{
Llist **ppHead = &head;
Llist *pElem = Malloc(sizeof(Llist), "SortedInsertList");
pElem->item = item;
pElem->next = NULL;
while (*ppHead && (*pCompare)(item, (*ppHead)->item) >= 0)
{
ppHead = &(*ppHead)->next;
}
if (*ppHead)
{
pElem->next = *ppHead;
}
*ppHead = pElem;
return head;
}
void *
RetrieveElemList(Llist *head, unsigned int which)
{
while (head && which)
{
head = head->next;
which--;
}
return (head ? head->item : NULL);
}
