/********************************************************************************
* Copyright (c) Erik Kunze 1998 - 1999
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Author: Erik Kunze
*******************************************************************************/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#ifdef XZX_PENTAGON
#ifndef lint
static char rcsid[] = "$Id: pentagon.c,v 1.13 1999/03/30 20:08:03 erik Rel $";
#endif
#include "z80.h"
#include "debug.h"
#include "resource.h"
#include "mem.h"
#include "io.h"
#include "machine.h"
#include "util.h"
#ifdef AUDIO
#include "audio.h"
#endif
#include "emul.h"
#ifdef JOY
#include "joystick.h"
#endif
#include "keyboard.h"
#ifdef XZX_KMOUSE
#include "kmouse.h"
#endif
#include "loadsave.h"
#include "screen.h"
#include "tables.h"
#include "trdos.h"
#include "pentagon.h"
#define NELEM(a)		(sizeof(a) / sizeof(a[0]))
#ifdef DEBUG
#define DEB(x)			{ if (GETCFG(debug) & D_IO) { x } }
#else
#define DEB(x)
#endif
static uns8 pentReadOpcode(uns16);
static uns8 pentReadMem(uns16);
static void pentWriteMem(uns16, uns8);
static void pentInitPages(void);
static void pentPageIn(int, int);
static inline void pentOutBankm128(uns8);
static void pentOutPort(uns16, uns8);
static uns8 pentInPort(uns16);
void
PentInit(void)
{
int checksum, romtype;
Machines[SP_PENTAGON].name = "Pentagon";
Machines[SP_PENTAGON].basicRom = PENTROM1;
Machines[SP_PENTAGON].romType = ROM_UNKNOWN;
Machines[SP_PENTAGON].tvLines = 320;
Machines[SP_PENTAGON].tstatesPerLine = 224;
Machines[SP_PENTAGON].tstatesPerFrame = 71680;
Machines[SP_PENTAGON].intLine = 304;
Machines[SP_PENTAGON].topBorder = 64;
Machines[SP_PENTAGON].readOpcode = pentReadOpcode;
Machines[SP_PENTAGON].readMem = pentReadMem;
Machines[SP_PENTAGON].writeMem = pentWriteMem;
Machines[SP_PENTAGON].inPort = pentInPort;
Machines[SP_PENTAGON].outPort = pentOutPort;
Machines[SP_PENTAGON].initPages = pentInitPages;
Machines[SP_PENTAGON].pageIn = pentPageIn;
if (!LoadRomImage(GETCFG(pentRom), PENTROM0, 3))
{
checksum = GetRomChecksum(Machines[SP_PENTAGON].basicRom, XZX_PAGESIZE);
switch (checksum)
{
case 44809:
romtype = ROM_PENTAGON;
break;
default:
Msg(M_WARN, "unknown Pentagon ROM image - checksum %u",
checksum);
romtype = ROM_UNKNOWN;
break;
}
Machines[SP_PENTAGON].romType = romtype;
#ifndef NO_ED_TRAPS
TpPatchRom(SP_PENTAGON);
#ifdef XBELL_AUDIO
SetBeepTrap(SP_PENTAGON);
#endif
#endif
}
}
void
PentGenUlaDelay(unsigned char *ulaDelay, int size)
{
int i, j , k;
for (i = 0; i < 14335; i++)
{
ulaDelay[i] = 0x80;
}
for (j = 192; j; j --)
{
for (k = 128; k; k--)
{
ulaDelay[i++] = 0;
}
for (k = 96; k; k--)
{
ulaDelay[i++] = 0x80;
}
}
for (; i < size; i++)
{
ulaDelay[i] = 0x80;
}
}
static uns8
pentReadOpcode(uns16 addr)
{
uns8 op;
if (addr >= 0x4000)
{
if (RPAGE(0) == PENTROM2)
{
Machine->pageIn(0, Machine->basicRom);
}
}
else if ((addr & 0xff00) == 0x3d00)
{
if (RPAGE(0) == Machine->basicRom)
{
Machine->pageIn(0, PENTROM2);
}
}
op = MEM(addr);
return op;
}
static uns8
pentReadMem(uns16 addr)
{
uns8 byte;
byte = MEM(addr);
return byte;
}
static void
pentWriteMem(uns16 addr, uns8 byte)
{
int page = VPAGE(addr);
if (RealPageNumbers[page] >= RAM0)
{
TheMemory[page][addr & 0x1fff] = byte;
if (RealPageNumbers[page] == ScreenSelect)
{
if ((addr &= 0x3fff) < (uns16)PIXEL_LENGTH)
{
ScreenWrite(addr, byte);
}
else if (addr < (uns16)(PIXEL_LENGTH + ATTR_LENGTH))
{
AttrWrite(addr, byte);
}
}
}
}
static void
pentInitPages(void)
{
Machine->pageIn(0, PENTROM0);
Machine->pageIn(1, RAM5);
Machine->pageIn(2, RAM2);
Machine->pageIn(3, RAM0);
}
static void
pentPageIn(int frame, int rpage)
{
int i = frame << 1;
TheMemory[i] = RealMemory[rpage];
RealPageNumbers[i] = rpage;
i++;
TheMemory[i] = RealMemory[rpage] + XZX_PAGESIZE / 2;
RealPageNumbers[i] = rpage;
}
static inline void
pentOutBankm128(uns8 val)
{
DEB(Msg(M_DEBUG,
"bankm: RAM select %d, ROM select %d, screen %d, paging %sabled",
val & B_SELRAM, (val & B_SELROM) >> 4, (val & B_SELSCREEN) >> 3,
PAGING_DISABLED(Last0x7FFD) ? "dis" : "en"););
if (Last0x7FFD == val || PAGING_DISABLED(Last0x7FFD))
{
return;
}
ScreenSelect = val & B_SELSCREEN ? RAM7 : RAM5;
if ((val & B_SELSCREEN) != (Last0x7FFD & B_SELSCREEN))
{
ForceScreenRefresh();
}
Last0x7FFD = val;
Machine->pageIn(3, RAM0 + (val & B_SELRAM));
Machine->pageIn(0, PENTROM0 + ((val & B_SELROM) >> 4));
}
static void
pentOutPort(uns16 port, uns8 val)
{
DEB(if (LOWBYTE(port) != P_ULA)
{
Msg(M_DEBUG, "writing <%02x> to port <%04x>", val, port);
});
if (RPAGE(0) == PENTROM2)
{
TrdosOutByte(port, val);
}
if (!(port & B_ULA))
{
if (LastBorderColor != (val & B_BORDER))
{
LastBorderColor = val & B_BORDER;
SetBorderColor(LastBorderColor);
}
#ifdef SPEAKER_AUDIO
SpeakerOutByte(val);
#endif
}
if (LOWBYTE(port) == P_128)
{
if ((port & B_SNDCHIP) == (P_SNDCONTROL & B_SNDCHIP))
{
if (port & B_SNDCONTROL)
{
Last0xFFFD = val;
}
else
{
if (Last0xFFFD < NELEM(Psg))
{
Psg[Last0xFFFD] = val;
}
else
{
DEB(Msg(M_DEBUG, "writing AY register %d", Last0xFFFD););
}
if (Last0xFFFD == 14)
{
DEB(Msg(M_DEBUG, "writing AY register 14"););
}
#ifdef AYCHIP_AUDIO
else if (Last0xFFFD < 14)
{
AyOutByte(Last0xFFFD, val);
}
#endif
}
}
else
{
if ((port & B_BANK128) == (P_BANK128 & B_BANK128))
{
pentOutBankm128(val);
}
}
}
}
static uns8
pentInPort(uns16 port)
{
DEB(if (LOWBYTE(port) != P_ULA)
{
Msg(M_DEBUG, "reading from port <%04x>", port);
});
if (RPAGE(0) == PENTROM2
&& (port & 0x001f) == 0x001f
&& ((port & 0x0080) == 0x0000 || (port & 0x00f0) == 0x00f0))
{
return (TrdosInByte(port));
}
#ifdef XZX_KMOUSE
if (GETCFG(kmouseActive))
{
switch (port)
{
case P_KMOUSEB:
return KmouseButtons;
case P_KMOUSEX:
return KmouseX;
case P_KMOUSEY:
return KmouseY;
}
}
#endif
if (!(port & B_KEMPSTON))
{
#ifdef JOY
if (GETCFG(joyActive) > 0)
{
InPorts[P_KEMPSTON] = (uns8)JoyRead();
}
#endif
return (InPorts[P_KEMPSTON] &
(B_RIGHT | B_LEFT | B_DOWN | B_UP | B_FIRE));
}
if (!(port & B_ULA))
{
uns8 res = 0xbf;
if (!(port & 0x8000))
{
res &= KeyPorts[7];
}
if (!(port & 0x4000))
{
res &= KeyPorts[6];
}
if (!(port & 0x2000))
{
res &= KeyPorts[5];
}
if (!(port & 0x1000))
{
res &= KeyPorts[4];
}
if (!(port & 0x0800))
{
res &= KeyPorts[3];
}
if (!(port & 0x0400))
{
res &= KeyPorts[2];
}
if (!(port & 0x0200))
{
res &= KeyPorts[1];
}
if (!(port & 0x0100))
{
res &= KeyPorts[0];
}
res ^= TpGetNextBit();
return res;
}
if (LOWBYTE(port) == P_128)
{
if ((port & (B_SNDCHIP | B_SNDDATA)) ==
(P_SNDCONTROL & (B_SNDCHIP | B_SNDCONTROL)))
{
if (Last0xFFFD == 14)
{
DEB(Msg(M_DEBUG, "reading AY register 14"););
return (Psg[7] & 0x40 ? 0x3f & Psg[14] : 0x3f);
}
else if (Last0xFFFD < 14)
{
return (Psg[Last0xFFFD] & PsgMask[Last0xFFFD]);
}
else if (Last0xFFFD == 15)
{
return (Psg[7] & 0x80 ? Psg[15] : 0xff);
}
else
{
return 0xff;
}
}
}
if (ULA_DRAWS_SCREEN)
{
unsigned int tstatesInLine = TSTATES % Machine->tstatesPerLine;
unsigned int line = Vline - Machine->topBorder;
return (RealMemory[ScreenSelect][(tstatesInLine & 0x02 ?
Line2Attr[line] : Line2Pix[line]) +
(tstatesInLine >> 2)]);
}
return 0xff;
}
#endif
