/********************************************************************************
* Copyright (c) Erik Kunze 1995 - 1999
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Author: Erik Kunze
*******************************************************************************/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#ifndef lint
static char rcsid[] = "$Id: loadsave.c,v 4.33 1999/03/29 10:35:26 erik Rel $";
#endif
#ifndef REGISTERED
#include <X11/keysym.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <setjmp.h>
#include <assert.h>
#include "z80.h"
#include "debug.h"
#include "resource.h"
#include "mem.h"
#include "machine.h"
#include "util.h"
#include "dialog.h"
#include "screen.h"
#include "tap.h"
#include "tzx.h"
#ifdef REGISTERED
#include "voc.h"
#include "vtp.h"
#endif
#include "loadsave.h"
#define PAGE_SIZE		17U
static void tpRecordDestroy(void *);
#ifndef REGISTERED
static void tpDisplayPage(unsigned int);
#endif
static uns8 tpDummyGetNextBit(void);
static void tpCatchFault(int);
unsigned short TpState = TS_TRAPLOAD | TS_TRAPSAVE;
uns8 *TpInBegin;
uns8 *TpInEnd;
Llist *TpInBlockList = NULL;
unsigned int TpInBlockCount = 0;
unsigned int TpInBlockCurrent = 0;
uns8 (*TpGetNextBit)(void) = tpDummyGetNextBit;
static char *tpInFn = NULL;
static char *tpOutFn = NULL;
static FILE *tpOutFp;
static jmp_buf tpEnv;
#ifndef NO_ED_TRAPS
void
TpPatchRom(int model)
{
uns16 loadAddr, saveAddr;
int basicrom;
switch (Machines[model].romType)
{
case ROM_STANDARD:
case ROM_128:
case ROM_PLUS2:
#ifdef XZX_PENTAGON
case ROM_PENTAGON:
#endif
#ifdef XZX_SCORPION
case ROM_SCORPION:
#endif
loadAddr = 0x0562;
saveAddr = 0x04C2;
break;
#ifdef XZX_PLUS3
case ROM_PLUS3:
loadAddr = 0x0562;
saveAddr = 0x04C6;
break;
#endif
default:
return;
}
basicrom = Machines[model].basicRom;
RealMemory[basicrom][loadAddr] = 0xed;
RealMemory[basicrom][loadAddr + 1] = LOAD_BPT;
RealMemory[basicrom][saveAddr] = 0xed;
RealMemory[basicrom][saveAddr + 1] = SAVE_BPT;
}
#endif
#ifndef NO_ED_TRAPS
void
TpLoadBlock(void)
{
#ifdef DEBUG
if (GETCFG(debug) & D_TAPE)
{
Msg(M_DEBUG, "%s request: id = %02x, addr = %04X, length = %5d",
F1 & C_FLAG ? "load" : "verify", A1, IX, DE);
}
#endif
if (!(TpState & (TS_TAPIN | TS_TZXIN | TS_VOCIN)) || TpState & TS_ENDIN)
{
#ifdef REGISTERED
(void)TpInsertTape("Load Tape", TO_READ | TO_TAP | TO_TZX | TO_VOC);
#else
(void)TpInsertTape("Load Tape", TO_READ | TO_TAP | TO_TZX);
#endif
}
switch (TpState & (TS_TRAPLOAD | TS_TAPIN | TS_TZXIN | TS_VOCIN))
{
case TS_TRAPLOAD:
IFF1 = 1;
IFF2 = 1;
PC = 0x0552;
break;
case TS_TRAPLOAD | TS_TAPIN:
case TS_TRAPLOAD | TS_TZXIN:
if (TpState & TS_QUICKLOAD)
{
while (!(TpState & TS_PLAY))
{
ProcessEvents();
}
if (!TzxLoadBlock())
{
break;
}
}
default:
TSTATES += 11 - 8;
DEC_R();
A = Z80_IN((A << 8) | 0xfe);
break;
}
}
#endif
#ifndef NO_ED_TRAPS
void
TpSaveBlock(void)
{
#ifdef DEBUG
if (GETCFG(debug) & D_TAPE)
{
Msg(M_DEBUG, "%stape saving: addr = %04X, length = %04X",
A ? "headerless " : "",	IX, DE);
}
#endif
if (!(TpState & TS_TAPOUT))
{
(void)TpInsertTape("Save Tape", TO_WRITE | TO_TAP);
}
switch (TpState & (TS_TRAPSAVE | TS_TAPOUT))
{
case TS_TRAPSAVE:
PC = 0x0552;
break;
case TS_TRAPSAVE | TS_TAPOUT:
TapSaveBlock(tpOutFp);
break;
default:
TSTATES += 10 - 8;
DEC_R();
HL = 0x053f;
PC++;
break;
}
}
#endif
int
TpInsertTape(const char *title, int operation)
{
int types[4];
char *fname;
int readonly;
size_t size;
struct sigaction newact, oldact;
int i = 0, ret = -1;
if (operation & TO_TAP)
{
types[i++] = FT_TAP;
}
if (operation & TO_TZX)
{
types[i++] = FT_TZX;
}
#ifdef REGISTERED
if (operation & TO_VOC)
{
assert(operation & TO_READ);
types[i++] = FT_VOC;
}
#endif
types[i] = FT_END;
if (operation & TO_READ)
{
if (!(fname = FileSelector(title, 1, types)))
{
return -1;
}
TpEjectTape(TO_READ);
readonly = 1;
TpInBegin = (uns8 *)Mmap(fname, 1, &readonly, &size);
if (TpInBegin != (uns8 *)-1)
{
TpInEnd = TpInBegin + size;
tpInFn = fname;
newact.sa_handler = tpCatchFault;
(void)sigemptyset(&newact.sa_mask);
#ifdef SA_RESTART
newact.sa_flags = SA_RESTART;
#else
newact.sa_flags = 0;
#endif
(void)sigaction(SIGSEGV, &newact, &oldact);
if (!setjmp(tpEnv))
{
switch (GetFileType(fname))
{
case FT_TAP:
TpState |= TS_TAPIN;
ret = TapNewFile();
break;
case FT_TZX:
TpState |= TS_TZXIN;
ret = TzxNewFile();
break;
#ifdef REGISTERED
case FT_VOC:
TpState |= TS_VOCIN;
ret = VocNewFile();
break;
#endif
}
}
else
{
Msg(M_ERR, "corrupted input file");
ret = -1;
}
(void)sigaction(SIGSEGV, &oldact, NULL);
if (ret != 0)
{
TpState &= ~(TS_TAPIN | TS_TZXIN | TS_VOCIN);
Munmap((void *)TpInBegin, size);
free(tpInFn);
tpInFn = NULL;
DestroyList(TpInBlockList, tpRecordDestroy);
TpInBlockList = NULL;
TpInBlockCount = 0;
TpInBlockCurrent = 0;
}
}
else
{
free(fname);
}
}
else
{
if ((fname = FileSelector(title, 0, types)))
{
TpEjectTape(TO_WRITE);
if (!(tpOutFp = Fopen(fname, "wb")))
{
Msg(M_PERR, "couldn't open <%s> for writing", fname);
free(fname);
}
else
{
TpState |= TS_TAPOUT;
tpOutFn = fname;
#ifdef REGISTERED
VtpNewOutputFile();
#endif
ret = 0;
}
}
}
return ret;
}
void
TpEjectTape(int operation)
{
if (operation & TO_READ)
{
if (TpState & (TS_TAPIN | TS_TZXIN | TS_VOCIN))
{
TpGetNextBit = tpDummyGetNextBit;
TpState &= ~(TS_TAPIN | TS_TZXIN | TS_VOCIN | TS_PLAY | TS_ERRIN |
TS_ENDIN);
Munmap((void *)TpInBegin, (size_t)(TpInEnd - TpInBegin));
free(tpInFn);
tpInFn = NULL;
DestroyList(TpInBlockList, tpRecordDestroy);
TpInBlockList = NULL;
TpInBlockCount = 0;
TpInBlockCurrent = 0;
}
}
else
{
if (TpState & TS_TAPOUT)
{
TpState &= ~(TS_TAPOUT | TS_ERROUT | TS_ENDOUT);
(void)fclose(tpOutFp);
free(tpOutFn);
tpOutFn = NULL;
}
}
}
static void
tpRecordDestroy(void *entry)
{
if (((TapeRecord *)entry)->str)
{
free(((TapeRecord *)entry)->str);
}
}
char *
TpTapeName(int operation)
{
return (operation == TO_READ ? tpInFn : tpOutFn);
}
void
TpStartPlayback(void)
{
assert(TpState & (TS_TAPIN | TS_TZXIN | TS_VOCIN)
&& !(TpState & (TS_PLAY | TS_ERRIN | TS_ENDIN)));
TpState |= TS_PLAY;
switch (TpState & (TS_TAPIN | TS_TZXIN | TS_VOCIN))
{
case TS_TAPIN:
case TS_TZXIN:
TpGetNextBit = TzxGetNextBit;
TzxStartPlaying();
break;
#ifdef REGISTERED
case TS_VOCIN:
TpGetNextBit = VocGetNextBit;
VocStartPlaying();
break;
#endif
}
#ifdef REGISTERED
VtpUpdate();
#endif
}
void
TpStopPlayback(void)
{
assert(TpState & TS_PLAY);
TpState &= ~TS_PLAY;
TpGetNextBit = tpDummyGetNextBit;
#ifdef REGISTERED
VtpUpdate();
#endif
}
#ifndef REGISTERED
void
TpBrowser(void)
{
unsigned int item;
int oldInDialog;
assert(TpState & (TS_TAPIN | TS_TZXIN));
oldInDialog = EnterOSD();
{
const char *selectorText[PAGE_SIZE + 2];
int i;
selectorText[0] = "Browse Inputfile";
for (i = 1; i <= NOPTS(selectorText); i++)
{
selectorText[i] = " ";
}
selectorText[i] = NULL;
DisplayMenu(selectorText);
}
item = TpInBlockCurrent;
tpDisplayPage(item / PAGE_SIZE);
for (;;)
{
switch ((int)BrowseList(&item, TpInBlockCount, PAGE_SIZE, tpDisplayPage))
{
case XK_Return:
TpInBlockCurrent = item;
if (item == TpInBlockCount - 1)
{
TpState |= TS_ENDIN;
}
else
{
TpState &= ~TS_ENDIN;
}
case XK_Escape:
goto quit;
}
}
quit:
LeaveOSD(oldInDialog);
}
#endif
#ifndef REGISTERED
static void
tpDisplayPage(unsigned int page)
{
unsigned int cnt;
uns8 cursor_y = MENU_CURSOR_Y;
TapeRecord *tr;
uns8 attr = GetAttr();
SetAttr(MENU_SELECT_ATTR);
SetCursor(MENU_CURSOR_X + 1, cursor_y);
DrawBox(COLS - 2 * (MENU_CURSOR_X + 1), PAGE_SIZE);
for (cnt = page * PAGE_SIZE;
cnt < (page + 1) * PAGE_SIZE && cnt < TpInBlockCount;
cnt++)
{
tr = (TapeRecord *)RetrieveElemList(TpInBlockList, cnt);
assert(tr !=  NULL);
if (cnt == TpInBlockCurrent)
{
SetAttr(MENU_DISABLED_ATTR);
PrintString(tr->str);
SetAttr(MENU_SELECT_ATTR);
}
else
{
PrintString(tr->str);
}
SetCursor(MENU_CURSOR_X + 1, ++cursor_y);
}
SetAttr(attr);
}
#endif
static uns8
tpDummyGetNextBit(void)
{
return 0;
}
static void
tpCatchFault(int signo)
{
longjmp(tpEnv, -1);
}
