/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		RTPReflectorModule.h

	Contains:	Module that handles reflecting broadcasts to unicast streams.
					
	$Log: RTPReflectorModule.h,v $
	Revision 1.2  1999/02/19 23:08:25  ds
	Created
	

*/

#ifndef _RTPREFLECTORMODULE_H_
#define _RTPREFLECTORMODULE_H_

#include "RTPModule.h"
#include "SDPParser.h"
#include "RTPServerInterface.h"
#include "ReflectorSession.h"

class RTPReflectorModule : public RTPModule
{
	public:
	
		RTPReflectorModule()  : RTPModule(kRequestProcessingModule, "RTPReflectorModule") {}
		virtual ~RTPReflectorModule() {}

		virtual RTSPProtocol::RTSPStatusCode Describe(RTSPRequestInterface* inRequest, void** outCookie);

		//returns non-null error handler in the event of an error
		virtual RTSPProtocol::RTSPStatusCode NewSession(RTSPRequestInterface* inRequest,
											RTPSession* inSessionP, void* inCookie);
											
		virtual void 	DestroySession(RTPSession* inSession);
		virtual void 	DestroyCookie(void* inCookie);

		virtual RTSPProtocol::RTSPStatusCode ProcessRTSPRequest(RTSPRequestInterface* inRequest,
												RTPSession* inSession);
		
	private:
	
		char* GetSDPData(RTSPRequestInterface* inRequest, QTSS_ParamKeywords inParam,
							UInt32* outLen);
		RTSPProtocol::RTSPStatusCode DoSetup(RTSPRequestInterface* inRequest, RTPSession* inSession);
		RTSPProtocol::RTSPStatusCode DoPlay(RTSPRequestInterface* inRequest, RTPSession* inSession);

		static StrPtrLen	sSDPSuffix;
		//Reflector sessions must be shared (ie, when a new client wants to
		//view a reflection, it attaches to an existing session instead of 
		//having each client have its own session
		static OSRefTable 	sSessionMap;
};

#endif //_RTPREFLECTORMODULE_H_