/************************************************************************/
/* Module : menu.c					                */
/* Purpose: menu module				                        */
/* By     : Keith R. Davis				                */
/* Date   : 9/9/95					                */
/* Notes  : Copyright(c) 1996-99 Mutiny Bay Software	                */
/************************************************************************/

#include <Xm/Xm.h>			/* motif lib header		*/
#include <Xm/RowColumn.h>		/* row/col widget header	*/
#include <Xm/CascadeB.h>		/* cascade button widget header	*/
#include <Xm/Separator.h>               /* separator widget header      */
#include <Xm/PushB.h>		        /* push button widget header	*/
#include <Xm/ToggleB.h>                 /* toggle button widget header  */
#include <X11/xpm.h>		        /* xpm lib header		*/
#include <string.h>			/* string header		*/
#include <stdio.h>                      /* stdio header                 */
#include <help.h>                       /* help lib header              */

#include "mquel.h"                      /* mquel module header          */
#include "menu.h"			/* menu module header	        */
#include "callback.h"                   /* callback header              */
#include "search.h"                     /* search header                */

/************************************************************************/
/* Function: CreateMenuBar                                              */
/* Purpose : creates the applications menu                              */
/* Params  : parent : menu's parent widget                              */
/* Returns : menu widget                                                */
/* Notes   :                                                            */
/************************************************************************/

Widget CreateMenuBar(Widget parent)
{
    Widget	menu;		/* menu widget */

    /* create a menubar and add the additional menu panes */
    menu = XmCreateMenuBar(parent, "menu", NULL, 0);

    CreateFilePane(menu);
    CreateEditPane(menu);
    CreateSearchPane(menu);
    CreateQueryPane(menu);
    CreateOptionsPane(menu);
    CreateBufferPane(menu);
    CreateHelpPane(menu);

    XtManageChild(menu);

    return(menu);
     
}

/************************************************************************/
/* Function: CreateFilePane                                             */
/* Purpose : creates the applications file menu                         */
/* Params  : parent : menu's parent widget                              */
/* Returns : nothing                                                    */
/* Notes   :                                                            */
/************************************************************************/

void CreateFilePane(Widget parent)
{
    Widget	cascade,	/* cascade menu widget	        */
		submenu,	/* pull down menu widget	*/
		button1,	/* connect menu button	        */
		button2,	/* exit menu button		*/
                button3,        /* separator                    */
	        button4,	/* new menu button		*/
    	        button5,	/* open menu button		*/
	        button6,	/* save menu button		*/
	        button7,	/* save as menu button		*/
	        button8,	/* separator		        */
                button11,       /* delete buffer button         */
                button12,       /* separator                    */
	        button9,	/* print menu button		*/
                button10;       /* separator                    */

    /* create the pulldown part of the file menu */
    submenu = XmCreatePulldownMenu(parent, "fileSubmenu",
				    NULL, 0);

    /* add help callback for the file menu */
    XtAddCallback(submenu, XmNhelpCallback,
		  get_help, "mpsql_menu_file.html");

    /* create  the 'FILE' menu */
    cascade = XtVaCreateManagedWidget("file",
				      xmCascadeButtonWidgetClass,
				      parent,
				      XmNsubMenuId, submenu,
				      NULL);

    /*add the selections to the 'FILE' menu */
    button1 = XtCreateManagedWidget("connect",
				    xmPushButtonWidgetClass,
				    submenu, NULL, 0);

    button3 = XtCreateManagedWidget("sep1", 
				    xmSeparatorWidgetClass,
				    submenu, NULL, 0);

    button4 = XtCreateManagedWidget("new",
				    xmPushButtonWidgetClass,
				    submenu, NULL, 0);

    button5 = XtCreateManagedWidget("open",
				    xmPushButtonWidgetClass,
				    submenu, NULL, 0);

    button6 = XtCreateManagedWidget("save",
				    xmPushButtonWidgetClass,
				    submenu, NULL, 0);

    button7 = XtCreateManagedWidget("saveas",
				    xmPushButtonWidgetClass,
				     submenu, NULL, 0);

    button8 = XtCreateManagedWidget("sep2", 
				    xmSeparatorWidgetClass,
				    submenu, NULL, 0);

    button11 = XtCreateManagedWidget("deletebuffer",
				     xmPushButtonWidgetClass,
				     submenu, NULL, 0);

    button12 = XtCreateManagedWidget("sep4", 
				     xmSeparatorWidgetClass,
				     submenu, NULL, 0);

    button9 = XtCreateManagedWidget("print",
				    xmPushButtonWidgetClass,
				     submenu, NULL, 0);

    button10 = XtCreateManagedWidget("sep3", 
				    xmSeparatorWidgetClass,
				    submenu, NULL, 0);

    button2 = XtCreateManagedWidget("exit",
				    xmPushButtonWidgetClass,
				    submenu, NULL, 0);

    /* install the callback functions */
    XtAddCallback(button1, XmNactivateCallback, ConnectCallback, NULL);
    XtAddCallback(button4, XmNactivateCallback, NewCallback, NULL);
    XtAddCallback(button5, XmNactivateCallback, OpenCallback, NULL);
    XtAddCallback(button6, XmNactivateCallback, SaveCallback, NULL);
    XtAddCallback(button7, XmNactivateCallback, SaveAsCallback, NULL);
    XtAddCallback(button2, XmNactivateCallback, CloseCallback, NULL);
    XtAddCallback(button11, XmNactivateCallback, DeleteBufferCallback, NULL);
    XtAddCallback(button9, XmNactivateCallback, PrintCallback, NULL);
}

/************************************************************************/
/* Function: CreateEditPane                                             */
/* Purpose : creates the applications edit menu                         */
/* Params  : parent : menu's parent widget                              */
/* Returns : nothing                                                    */
/* Notes   :                                                            */
/************************************************************************/

void CreateEditPane(Widget parent)
{
  Widget	cascade,	/* cascade menu widget	        */
                submenu,	/* pull down menu widget	*/
		button1,	/* cut menu button	        */
		button2,	/* copy menu button	        */
                button3,        /* paste menu button            */
                sep1,           /* menu seperator               */
                button4;        /* clear result win button      */

  /* create the pulldown part of the query menu */
  submenu = XmCreatePulldownMenu(parent, "editSubmenu",
				 NULL, 0);

  /* add help callback for the edit menu */
  XtAddCallback(submenu, XmNhelpCallback,
		  get_help, "mpsql_menu_edit.html");

  /* create  the 'QUERY' menu */
  cascade = XtVaCreateManagedWidget("edit",
				    xmCascadeButtonWidgetClass,
				    parent,
				    XmNsubMenuId, submenu,
				    NULL);

  /*add the selections to the 'EDIT' menu */
  button1 = XtCreateManagedWidget("cut",
				  xmPushButtonWidgetClass,
				  submenu, NULL, 0);
  
  button2 = XtCreateManagedWidget("copy",
				  xmPushButtonWidgetClass,
				  submenu, NULL, 0);

  button3 = XtCreateManagedWidget("paste",
				  xmPushButtonWidgetClass,
				  submenu, NULL, 0);

  sep1 = XtCreateManagedWidget("sep1", 
			       xmSeparatorWidgetClass,
			       submenu, NULL, 0);

  button4 = XtCreateManagedWidget("clearresult",
				  xmPushButtonWidgetClass,
				  submenu, NULL, 0);
  
  /* install the callback functions */
  XtAddCallback(button1, XmNactivateCallback, CutCallback, NULL);
  XtAddCallback(button2, XmNactivateCallback, CopyCallback, NULL);
  XtAddCallback(button3, XmNactivateCallback, PasteCallback, NULL);
  XtAddCallback(button4, XmNactivateCallback, ClearResultCallback, NULL);
}

/************************************************************************/
/* Function: CreateSearchPane                                           */
/* Purpose : creates the applications search menu                       */
/* Params  : parent : menu's parent widget                              */
/* Returns : nothing                                                    */
/* Notes   :                                                            */
/************************************************************************/

void CreateSearchPane(Widget parent)
{
  Widget	cascade,	/* cascade menu widget	        */
                submenu,	/* pull down menu widget	*/
		button1,	/* find menu button	        */
                button2,        /* find again menu button	*/
                button3;        /* replace menu button	        */

  /* create the pulldown part of the query menu */
  submenu = XmCreatePulldownMenu(parent, "searchSubmenu",
				 NULL, 0);

  /* add help callback for the edit menu */
  XtAddCallback(submenu, XmNhelpCallback,
		  get_help, "mpsql_menu_search.html");

  /* create  the 'SEARCH' menu */
  cascade = XtVaCreateManagedWidget("search",
				    xmCascadeButtonWidgetClass,
				    parent,
				    XmNsubMenuId, submenu,
				    NULL);

  /*add the selections to the 'SEARCH' menu */
  button1 = XtCreateManagedWidget("find",
				  xmPushButtonWidgetClass,
				  submenu, NULL, 0);
  
  button2 = XtCreateManagedWidget("findagain",
				  xmPushButtonWidgetClass,
				  submenu, NULL, 0);

  button3 = XtCreateManagedWidget("replace",
				  xmPushButtonWidgetClass,
				  submenu, NULL, 0);
  
  /* install the callback functions */
  XtAddCallback(button1, XmNactivateCallback, SEARCH_FindDlg, NULL);
  XtAddCallback(button2, XmNactivateCallback, SEARCH_FindAgain, NULL);
  XtAddCallback(button3, XmNactivateCallback, SEARCH_ReplaceDlg, NULL);
}

/************************************************************************/
/* Function: CreateQueryPane                                            */
/* Purpose : creates the applications query  menu                       */
/* Params  : parent : menu's parent widget                              */
/* Returns : nothing                                                    */
/* Notes   :                                                            */
/************************************************************************/

void CreateQueryPane(Widget parent)
{
    Widget	cascade,	/* cascade menu widget	        */
		submenu,	/* pull down menu widget	*/
		button1;	/* execute qy menu button	*/

    /* create the pulldown part of the query menu */
    submenu = XmCreatePulldownMenu(parent, "querySubmenu",
				    NULL, 0);
    /* add help callback for the query menu */
    XtAddCallback(submenu, XmNhelpCallback,
		  get_help, "mpsql_menu_query.html");

    /* create  the 'QUERY' menu */
    cascade = XtVaCreateManagedWidget("query",
				      xmCascadeButtonWidgetClass,
				      parent,
				      XmNsubMenuId, submenu,
				      NULL);

    /*add the selections to the 'QUERY' menu */
    button1 = XtCreateManagedWidget("executeqy",
				    xmPushButtonWidgetClass,
				    submenu, NULL, 0);

    /* install the callback functions */
    XtAddCallback(button1, XmNactivateCallback, ExecSQLCallback, NULL);   
}

/************************************************************************/
/* Function: CreateOptionsPane                                          */
/* Purpose : creates the applications option menu                       */
/* Params  : parent : menu's parent widget                              */
/* Returns : nothing                                                    */
/* Notes   :                                                            */
/************************************************************************/

void CreateOptionsPane(Widget parent)
{
    Widget	cascade,	/* cascade menu widget	        */
		submenu,	/* pull down menu widget	*/
		button1,	/* spool file button		*/
                button2,	/* col width file button	*/
                syntaxselect,   /* syntax select menu           */
                alignselect,    /* output align select menu     */
                outtypeselect,  /* output type select menu      */
                sepselect,      /* delimtier menu button        */
                outselect,      /* output menu button           */
                syntaxmenu,     /* syntax highlight menu        */
                tabmenu,        /* tab settings menu            */
                alignmenu,      /* output alignment menu        */
                outtypemenu,    /* output type menu             */
                sepmenu,        /* delimiter menu               */
                outmenu,        /* output menu                  */
                sep1,           /* separator                    */
                sep2,           /* separator                    */
                sep3,           /* separator                    */
                button3;        /* save options button          */

    /* create the pulldown part of the option menu */
    submenu = XmCreatePulldownMenu(parent, "optionSubmenu",
				    NULL, 0);

    /* add help callback for the options menu */
    XtAddCallback(submenu, XmNhelpCallback,
		  get_help, "mpsql_menu_options.html");

    /* create  the 'OPTION' menu */
    cascade = XtVaCreateManagedWidget("options",
				      xmCascadeButtonWidgetClass,
				      parent,
				      XmNsubMenuId, submenu,
				      NULL);

    /*add the selections to the 'OPTION' menu */
    AppWidgetsPtr->spoolfile = XtCreateManagedWidget("spoolfile",
						     xmPushButtonWidgetClass,
						     submenu, NULL, 0);

    sep1 = XtCreateManagedWidget("sep1", 
				 xmSeparatorWidgetClass,
				 submenu, NULL, 0);


    syntaxselect = XmCreatePulldownMenu(submenu, "syntaxselect",
					NULL, 0);

    XtVaSetValues(syntaxselect, XmNradioBehavior, TRUE, NULL);

    syntaxmenu = XtVaCreateManagedWidget("syntaxmenu",
					 xmCascadeButtonWidgetClass,
					 submenu,
					 XmNsubMenuId, syntaxselect,
					 NULL);
    
    AppWidgetsPtr->highlight = XtVaCreateManagedWidget("highlight", xmToggleButtonWidgetClass,
						   syntaxselect,
						   XmNvisibleWhenOff, TRUE,
						   XmNindicatorSize, 15,
						   XmNfillOnSelect, TRUE,
						   NULL);

    AppWidgetsPtr->plain = XtVaCreateManagedWidget("plain", xmToggleButtonWidgetClass,
						       syntaxselect, 
						       XmNvisibleWhenOff, TRUE,
						       XmNindicatorSize, 15,
						       XmNfillOnSelect, TRUE,
						       NULL);

    tabmenu = XtVaCreateManagedWidget("tabmenu",
				      xmCascadeButtonWidgetClass,
				      submenu,
				      NULL);

    sep3 = XtCreateManagedWidget("sep3", 
				  xmSeparatorWidgetClass,
				  submenu, NULL, 0);

    sepselect = XmCreatePulldownMenu(submenu, "sepselect",
				      NULL, 0);
     
    XtVaSetValues(sepselect, XmNradioBehavior, TRUE, NULL);
     
    sepmenu = XtVaCreateManagedWidget("sepmenu",
				    xmCascadeButtonWidgetClass,
				    submenu,
				    XmNsubMenuId, sepselect,
				    NULL);

    AppWidgetsPtr->none = XtVaCreateManagedWidget("none", xmToggleButtonWidgetClass,
						  sepselect, 
						  XmNvisibleWhenOff, TRUE,
						  XmNindicatorSize, 15,
						  XmNfillOnSelect, TRUE,
						  NULL);

    
    AppWidgetsPtr->tab = XtVaCreateManagedWidget("tab", xmToggleButtonWidgetClass,
						 sepselect,
						 XmNvisibleWhenOff, TRUE,
						 XmNindicatorSize, 15,
						 XmNfillOnSelect, TRUE,
						 NULL);

    AppWidgetsPtr->space = XtVaCreateManagedWidget("space", xmToggleButtonWidgetClass,
						   sepselect, 
						   XmNvisibleWhenOff, TRUE,
						   XmNindicatorSize, 15,
						   XmNfillOnSelect, TRUE,
						   NULL);

    AppWidgetsPtr->comma = XtVaCreateManagedWidget("comma", xmToggleButtonWidgetClass,
						   sepselect, 
						   XmNvisibleWhenOff, TRUE,
						   XmNindicatorSize, 15,
						   XmNfillOnSelect, TRUE,
						   NULL);


    alignselect = XmCreatePulldownMenu(submenu, "alignselect",
				    NULL, 0);
    XtVaSetValues(alignselect, XmNradioBehavior, TRUE, NULL);


    alignmenu = XtVaCreateManagedWidget("alignmenu",
				    xmCascadeButtonWidgetClass,
				    submenu,
				    XmNsubMenuId, alignselect,
				    NULL);

    AppWidgetsPtr->align = XtVaCreateManagedWidget("align", xmToggleButtonWidgetClass,
						  alignselect, 
						  XmNvisibleWhenOff, TRUE,
						  XmNindicatorSize, 15,
						  XmNfillOnSelect, TRUE,
						  NULL);

    
    AppWidgetsPtr->standard = XtVaCreateManagedWidget("standard", xmToggleButtonWidgetClass,
						 alignselect,
						 XmNvisibleWhenOff, TRUE,
						 XmNindicatorSize, 15,
						 XmNfillOnSelect, TRUE,
						 NULL);

    AppWidgetsPtr->expand = XtVaCreateManagedWidget("expand", xmToggleButtonWidgetClass,
						   alignselect, 
						   XmNvisibleWhenOff, TRUE,
						   XmNindicatorSize, 15,
						   XmNfillOnSelect, TRUE,
						   NULL);

    outtypeselect = XmCreatePulldownMenu(submenu, "outtypeselect",
				    NULL, 0);

    XtVaSetValues(outtypeselect, XmNradioBehavior, TRUE, NULL);


    outtypemenu = XtVaCreateManagedWidget("outtypemenu",
				    xmCascadeButtonWidgetClass,
				    submenu,
				    XmNsubMenuId, outtypeselect,
				    NULL);

    AppWidgetsPtr->text = XtVaCreateManagedWidget("text", xmToggleButtonWidgetClass,
						  outtypeselect, 
						  XmNvisibleWhenOff, TRUE,
						  XmNindicatorSize, 15,
						  XmNfillOnSelect, TRUE,
						  NULL);

    
    AppWidgetsPtr->html = XtVaCreateManagedWidget("html", xmToggleButtonWidgetClass,
						 outtypeselect,
						 XmNvisibleWhenOff, TRUE,
						 XmNindicatorSize, 15,
						 XmNfillOnSelect, TRUE,
						 NULL);
   
    outselect = XmCreatePulldownMenu(submenu, "outselect",
                                    NULL, 0);


    outmenu = XtVaCreateManagedWidget("outmenu",
				    xmCascadeButtonWidgetClass,
				    submenu,
				    XmNsubMenuId, outselect,
				    NULL);

    AppWidgetsPtr->tglspool = XtVaCreateManagedWidget("spoolresults",
						      xmToggleButtonWidgetClass,
						      outselect,
						      XmNvisibleWhenOff, TRUE,
						      XmNindicatorSize, 15,
						      XmNfillOnSelect, TRUE,
						      NULL);

    AppWidgetsPtr->tglcol = XtVaCreateManagedWidget("colheadings",
						    xmToggleButtonWidgetClass,
						    outselect,
						    XmNvisibleWhenOff, TRUE,
						    XmNset, TRUE,
						    XmNindicatorSize, 15,
						    XmNfillOnSelect, TRUE, 
						    NULL);

    AppWidgetsPtr->tglecho = XtVaCreateManagedWidget("echoqy",
						     xmToggleButtonWidgetClass,
						     outselect,
						     XmNvisibleWhenOff, TRUE,
						     XmNset, TRUE,
						     XmNindicatorSize, 15,
						     XmNfillOnSelect, TRUE, 
						     NULL);

     sep1 = XtCreateManagedWidget("sep1", 
				  xmSeparatorWidgetClass,
				  submenu, NULL, 0);

     button3= XtCreateManagedWidget("saveopt",
				    xmPushButtonWidgetClass,
				    submenu, NULL, 0);


    /* install the callback functions */
    XtAddCallback(AppWidgetsPtr->spoolfile, XmNactivateCallback, SpoolCallback, NULL);
    XtAddCallback(AppWidgetsPtr->highlight, XmNvalueChangedCallback, HighlightToggleCallback, NULL);
    XtAddCallback(tabmenu, XmNactivateCallback, TabCallback, NULL);
    XtAddCallback(button3, XmNactivateCallback, SaveOptCallback, NULL);
}

/************************************************************************/
/* Function: CreateBufferPane                                           */
/* Purpose : creates the applications buffer menu                       */
/* Params  : parent : menu's parent widget                              */
/* Returns : nothing                                                    */
/* Notes   :                                                            */
/************************************************************************/

void CreateBufferPane(Widget parent)
{
   Widget	cascade;   

   /* create the pulldown part of the buffer menu */
   AppWidgetsPtr->buffermenu = XmCreatePulldownMenu(parent, "bufferSubmenu",
						    NULL, 0); 
   
   /* add help callback for the buffers menu */
    XtAddCallback(AppWidgetsPtr->buffermenu, XmNhelpCallback,
		  get_help, "mpsql_menu_buffers.html");

   /* create  the 'BUFFER' menu */
   cascade = XtVaCreateManagedWidget("buffers",
				     xmCascadeButtonWidgetClass,
				     parent,
				     XmNsubMenuId, AppWidgetsPtr->buffermenu,
				     NULL);
   
   /* install the callback function */
   XtAddCallback(cascade, XmNcascadingCallback, CascadeCallback, NULL);  
}

/************************************************************************/
/* Function: CreateHelpPane                                             */
/* Purpose : creates the applications help menu                         */
/* Params  : parent : menu's parent widget                              */
/* Returns : nothing                                                    */
/* Notes   :                                                            */
/************************************************************************/

void CreateHelpPane(Widget parent)
{
    Widget	cascade,	/* cascade menu widget	        */
		submenu,	/* pull down menu widget	*/
                sep1,           /* separator                    */
		button1,	/* app help menu button		*/
                button2,        /* about menu button            */
                button3,	/* postgres help menu button	*/
                button4;        /* SQL help menu button         */

    /* create the pulldown part of the help menu */
    submenu = XmCreatePulldownMenu(parent, "helpSubmenu",
				    NULL, 0);

    /* add help callback for the help menu */
    XtAddCallback(submenu, XmNhelpCallback,
		  get_help, "mpsql_menu_help.html");

    /* create  the 'HELP' menu */
    cascade = XtVaCreateManagedWidget("helpmenu",
				      xmCascadeButtonWidgetClass,
				      parent,
				      XmNsubMenuId, submenu,
				      NULL);

    /* make this widget the help widget for this menu bar */
    XtVaSetValues(parent, XmNmenuHelpWidget, cascade, NULL);

    /*add the selections to the 'HELP' menu */
    button1 = XtCreateManagedWidget("mpsqlhelp",
				    xmPushButtonWidgetClass,
				    submenu, NULL, 0);

    /*add the selections to the 'HELP' menu */
    button3 = XtCreateManagedWidget("pgsqlhelp",
				    xmPushButtonWidgetClass,
				    submenu, NULL, 0);

    /*add the selections to the 'HELP' menu */
    button4 = XtCreateManagedWidget("sqlhelp",
				    xmPushButtonWidgetClass,
				    submenu, NULL, 0);

    sep1 = XtCreateManagedWidget("sep1", 
				 xmSeparatorWidgetClass,
				 submenu, NULL, 0);

    /*add the selections to the 'HELP' menu */
    button2 = XtCreateManagedWidget("about",
				    xmPushButtonWidgetClass,
				    submenu, NULL, 0);


    /* install the callback functions */
    XtAddCallback(button1, XmNactivateCallback, get_help, "mpsql.html");
    XtAddCallback(button3, XmNactivateCallback, get_help, "user.html");
    XtAddCallback(button4, XmNactivateCallback, get_help, "sql-commands.html");
    XtAddCallback(button2, XmNactivateCallback, AboutCallback, NULL);
}

