.TH pspect 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
pspect - cross-spectral estimate between 2 series
.SH CALLING SEQUENCE
.nf
[sm,cwp]=pspect(sec_step,sec_leng,wtype,x,y,wpar)
.fi
.SH PARAMETERS
.TP
x
: data if vector, amount of input data if scalar
.TP
y
: data if vector, amount of input data if scalar
.TP
sec_step
: offset of each data window
.TP
sec_leng
: length of each data window
.TP
wtype
: window type \fV(re,tr,hm,hn,kr,ch)\fR
.TP
wpar
: optional parameters
 for \fVwtype='kr', wpar>0\fR
 for \fVwtype='ch', 0<wpar(1)<.5, wpar(2)>0\fR
.TP
sm
: power spectral estimate in the interval \fV[0,1]\fR
.TP
cwp
: unspecified Chebyshev window parameter
.SH DESCRIPTION
Cross-spectral estimate between \fVx\fR and \fVy\fR if both are given
and auto-spectral estimate of \fVx\fR otherwise.
Spectral estimate obtained using the modified periodogram method.
.SH EXAMPLE
.nf
rand('normal');rand('seed',0);
x=rand(1:1024-33+1);
//make low-pass filter with eqfir
nf=33;bedge=[0 .1;.125 .5];des=[1 0];wate=[1 1];
h=eqfir(nf,bedge,des,wate);
//filter white data to obtain colored data 
h1=[h 0*ones(1:maxi(size(x))-1)];
x1=[x 0*ones(1:maxi(size(h))-1)];
hf=fft(h1,-1);   xf=fft(x1,-1);yf=hf.*xf;y=real(fft(yf,1));
//plot magnitude of filter
//h2=[h 0*ones(1:968)];hf2=fft(h2,-1);hf2=real(hf2.*conj(hf2));
//hsize=maxi(size(hf2));fr=(1:hsize)/hsize;plot(fr,log(hf2));
//pspect example
sm=pspect(100,200,'tr',y);smsize=maxi(size(sm));fr=(1:smsize)/smsize;
plot(fr,log(sm));
rand('unif');
.fi
.SH SEE ALSO
cspect
.SH AUTHOR
C. B.
