.TH augment 5 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
augment - augmented plant
.SH CALLING SEQUENCE
.nf
[P,r]=augment(G)
[P,r]=augment(G,flag1)
[P,r]=augment(G,flag1,flag2)
.fi
.SH PARAMETERS
.TP
G
: linear system (\fVsyslin\fR list), the nominal plant
.TP
flag1
: one of the following (upper case) character string:
\fV 'S' \fR, \fV 'R' \fR, \fV 'T' \fR
\fV 'SR' \fR, \fV 'ST' \fR, \fV 'RT' \fR
\fV 'SRT' \fR
.TP
flag2
: one of the following character string:
\fV 'o' \fR (stands for 'output', this is the default value) or \fV'i'\fR
(stands for 'input').
.TP
P
: linear system (\fVsyslin\fR list), the ``augmented'' plant
.TP
r
: 1x2 row vector, dimension of \fVP22 = G\fR
.SH DESCRIPTION
If \fVflag1='SRT'\fR (default value), returns the "full" augmented plant
.nf
    [ I | -G]   -->'S'
    [ 0 |  I]   -->'R'
P = [ 0 |  G]   -->'T'
    [-------]
    [ I | -G]
.fi
.LP
\fV 'S' \fR, \fV 'R' \fR, \fV 'T' \fR refer to the first three (block) rows
of \fVP\fR respectively.
.LP
If one of these letters is absent in \fVflag1\fR, the corresponding
row in \fVP\fR is missing.
.LP 
If \fVG\fR is given in state-space form, the returned \fVP\fR is minimal.
\fVP\fR is calculated by: \fV[I,0,0;0,I,0;-I,0,I;I,0,0]*[I,-G;0,I;I,0]\fR.
.LP
The augmented plant associated with input sensitivity functions, namely
.nf
    [ I | -I]   -->'S'  (input sensitivity)
    [ G | -G]   -->'R'  (G*input sensitivity)
P = [ 0 |  I]   -->'T'  (K*G*input sensitivity)
    [-------]
    [ G | -G]
.fi
is obtained by the command \fV[P,r]=augment(G,flag,'i')\fR. For
state-space \fVG\fR, this \fVP\fR
is calculated by: \fV[I,-I;0,0;0,I;0,0]+[0;I;0;I]*G*[I,-I]\fR
and is thus generically minimal.
.LP
Note that weighting functions can be introduced by left-multiplying
\fVP\fR by a diagonal system of appropriate dimension, e.g.,
\fV P = sysdiag(W1,W2,W3,eye(G))*P\fR.
.LP
Sensitivity functions can be calculated by \fVlft\fR. One has:
.LP
For output sensitivity functions [P,r]=augment(P,'SRT'):
lft(P,r,K)=[inv(eye+G*K);K*inv(eye+G*K);G*K*inv(eye+G*K)];
.LP
For input sensitivity functions [P,r]=augment(P,'SRT','i'):
lft(P,r,K)=[inv(eye+K*G);G*inv(eye+K*G);K*G*inv(eye+G*K)];
.SH EXAMPLE
.nf
G=ssrand(2,3,2); //Plant
K=ssrand(3,2,2); //Compensator
[P,r]=augment(G,'T');
T=lft(P,r,K);   //Complementary sensitivity function
Ktf=ss2tf(K);Gtf=ss2tf(G);
Ttf=ss2tf(T);T11=Ttf(1,1);
Tn=Gtf*Ktf*inv(eye+Gtf*Ktf);
clean(T11-Tn(1,1));
//
[Pi,r]=augment(G,'T','i');
T1=lft(Pi,r,K);T1tf=ss2tf(T1); //Input Complementary sensitivity function
T1n=Ktf*Gtf*inv(eye+Ktf*Gtf);
clean(T1tf(1,1)-T1n(1,1))
.fi
.SH SEE ALSO
lft, sensi

