.TH lyap G "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
lyap  - Lyapunov equation
.SH CALLING SEQUENCE
.nf
[X]=lyap(A,C,'c')
[X]=lyap(A,C,'d')
.fi
.SH PARAMETERS
.TP 10
A, C
: real square matrices, \fVC\fR must be symmetric
.SH DESCRIPTION
.Vb X = lyap(A,C,flag) 
solves the continuous time or discrete time  matrix Lyapunov 
matrix equation:
.nf 
A'*X + X*A = C       ( flag='c' )
A'*X*A - X = C       ( flag='d' )
.fi
.SH EXAMPLE
.nf
A=rand(4,4);C=rand(A);C=C+C';
X=lyap(A,C,'c');
A'*X + X*A -C
X=lyap(A,C,'d');
A'*X*A - X -C
.fi
.SH SEE ALSO
sylv, ctr_gram


