.TH bessely 3 "September 1997" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
bessely -  Modified Y sub ALPHA Bessel functions of the second kind.
.SH CALLING SEQUENCE
.nf
 y = bessely(alpha,x)
.fi
.SH PARAMETERS
.TP
x
: real vector with non negative entries
.TP
alpha
: real vector with non negative entries regularly spaced with
increment equal to one \fValpha=alpha0+(n1:n2)\fR

.SH DESCRIPTION
\fVbessely(alpha,x)\fR computes K sub ALPHA modified Bessel functions of the
second kind, for real, non-negative order \fValpha\fR 
and argument \fVx\fR.  \fValpha\fR  and \fVx\fR may be vectors.
The output is \fVm\fR-by-\fVn\fR with \fVm = size(x,'*')\fR,
\fVn = size(alpha,'*')\fR whose \fV(i,j)\fR entry is
\fVbessely(alpha(j),x(i))\fR.

.SH EXAMPLE
.nf
bessely(0.5:3,1:4)
.fi
.SH SEE ALSO
besselj, besseli, besselk
