/*
 * Copyright(c) 1995-1998 by Gennady B. Sorokopud (gena@NetVision.net.il)
 *
 * This software can be freely redistributed and modified for
 * non-commercial purposes as long as above copyright
 * message and this permission notice appear in all
 * copies of distributed source code and included as separate file
 * in binary distribution.
 *
 * Any commercial use of this software requires author's permission.
 *
 * This software is provided "as is" without expressed or implied
 * warranty of any kind.
 * Under no circumstances is the author responsible for the proper
 * functioning of this software, nor does the author assume any
 * responsibility for damages incurred with its use.
 *
 */

/* $Id: pop_smtp.c,v 1.4 1999/11/07 22:27:57 xfmail Exp $
 */

#include <config.h>
#include <fmail.h>
#include <umail.h>
#include <choose_folder.h>
#include <cfgfile.h>
#include "configform.h"

extern cfgfile Config;

FD_POPacc *pacc_obj;
static FD_config_send *smtp_obj;
static FD_config_news *nntp_obj;
static FD_acc_pop *pop_acc_obj;
static int ready = 0;

void SMTP_Host_Call(FL_OBJECT * obj, long param) {
}

void NNTP_Call(FL_OBJECT * obj, long param) {
}

void POP_Call(FL_OBJECT * obj, long param) {
}

void SPOP_Call(FL_OBJECT * obj, long param) {
}

void POP_DMark_Call(FL_OBJECT * obj, long param) {
    if(fl_get_button(obj))
        fl_show_message("Warning!", "Every retrieved message",
                        "will remain be marked as unretrieved");
}

void POP_2_Call(FL_OBJECT * obj, long param) {
    if(fl_get_button(obj))
        fl_show_message("Warning!", "SmartPOP features",
                        "will not work with POP2 server");
}

void POP_APOP_Call(FL_OBJECT * obj, long param) {
    if(fl_get_button(obj))
        fl_show_message("Warning!",
                        "Make sure APOP is supported by your POP server",
                        "Don't forget to enter APOP shared secret instead of Password");
}

void SPOP_UID_Call(FL_OBJECT * obj, long param) {
    if(fl_get_button(obj))
        fl_show_message("Warning!", "This feature works only",
                        "on last 3000 messages retrieved");
}

void SPOP_XLST_Call(FL_OBJECT * obj, long param) {
    if(fl_get_button(obj))
        fl_show_message("Warning!", "This feature is not part of RFC",
                        "and most POP servers does not support it");
}
void POP_Smart_Call(FL_OBJECT * obj, long param) {
}

void SMTP_POP_Call(FL_OBJECT * obj, long param) {
    if(fl_get_button(obj))
        fl_show_message("Warning!",
                        "This feature is supported only by few",
                        "POP server implementations");
}

void SMTP_Port_Call(FL_OBJECT * obj, long param) {
}

void SMTP_Bg_Call(FL_OBJECT * obj, long param) {
    if(fl_get_button(obj))
        fl_show_message("Warning!",
                        "If background sending is enabled you will not be able",
                        "to recover from errors occured during send process");
}

void SMTP_SMTP_Call(FL_OBJECT * obj, long param) {
    if(fl_get_button(obj))
        fl_show_message("Warning!",
                        "XFMail will send mail directly to SMTP gateway",
                        "Make sure that host name is correct and the gateway is accessible from your computer");
}

void Misc_SMail_Call(FL_OBJECT * obj, long param) {
}

void POP_Host_Call(FL_OBJECT * obj, long param) {
}

void POP_Port_Call(FL_OBJECT * obj, long param) {
}

void POP_User_Call(FL_OBJECT * obj, long param) {
}

void POP_Pwd_Call(FL_OBJECT * obj, long param) {
}

void P_Call(FL_OBJECT * obj, long param) {
}

void POP_Store_Pwd_Call(FL_OBJECT * obj, long param) {
    if(fl_get_button(pop_acc_obj->Pop_Storpwd))
        fl_show_alert("WARNING", "This is very unsecure option",
                      "make sure your config file (.xfmsources) is not readable by anyone else",
                      1);
}

void NNTP_Store_Pwd_Call(FL_OBJECT * obj, long param) {
    if(fl_get_button(nntp_obj->NNTP_Store_Pwd)) {
        fl_show_alert("WARNING", "This is very unsecure option",
                      "make sure your config file (.xfmailrc) is not readable by anyone else",
                      1);
        Config.setFlags("nntpasswd", 0);
    }
}

void POP_Delete_Call(FL_OBJECT * obj, long param) {
}

void pop_acc(struct _retrieve_src *source) {
    struct _pop_src *pop;
    char buf[16];

    pop = (struct _pop_src *) source->spec;
    if(ready)
        return;
    ready = 1;
    pop_acc_obj = create_form_acc_pop();

    fl_set_input(pop_acc_obj->Pop_Host, pop->hostname);
    fl_set_input(pop_acc_obj->Pop_Port, pop->service);
    fl_set_input(pop_acc_obj->Pop_User, pop->username);
    fl_set_input(pop_acc_obj->Pop_Password, pop->password);
    sprintf(buf, "%ld", pop->maxmsg);
    fl_set_input(pop_acc_obj->Pop_Maxmsg, buf);

    fl_set_button(pop_acc_obj->Pop_POP2, (pop->flags & PSRC_POP2) ? 1 : 0);
    fl_set_button(pop_acc_obj->Pop_Delete,
                  (pop->flags & PSRC_DELETE) ? 1 : 0);
    fl_set_button(pop_acc_obj->Pop_Dmark,
                  (pop->flags & PSRC_DMARK) ? 1 : 0);
    fl_set_button(pop_acc_obj->Pop_Storpwd,
                  (pop->flags & PSRC_STOREPWD) ? 1 : 0);
    fl_set_button(pop_acc_obj->Pop_Log,
                  (pop->flags & PSRC_LOGSESSION) ? 1 : 0);
    fl_set_button(pop_acc_obj->Pop_Oheader,
                  (pop->flags & PSRC_GETHEADER) ? 1 : 0);
    fl_set_button(pop_acc_obj->Pop_Skip,
                  (pop->
                   flags & PSRC_SKIPBIG) ? 1 : ((pop->
                                                 flags & PSRC_GETHEADER) ?
                                                0 : 1));
    fl_set_button(pop_acc_obj->Pop_UID,
                  (pop->flags & PSRC_CHECKUID) ? 1 : 0);
    fl_set_button(pop_acc_obj->Pop_Status,
                  (pop->flags & PSRC_CHECKSTAT) ? 1 : 0);
    fl_set_button(pop_acc_obj->Pop_Header,
                  (pop->
                   flags & PSRC_STATHEADER) ? 1 : ((pop->
                                                    flags & PSRC_STATXLST)
                                                   ? 0 : 1));
    fl_set_button(pop_acc_obj->Pop_XLST,
                  (pop->flags & PSRC_STATXLST) ? 1 : 0);
    fl_set_button(pop_acc_obj->Pop_APOP, (pop->flags & PSRC_APOP) ? 1 : 0);

    fl_show_form(pop_acc_obj->acc_pop, FL_PLACE_CENTER, FL_TRANSIENT,
                 "POP server");
    fl_do_only_forms();

    strncpy(pop->hostname, fl_get_input(pop_acc_obj->Pop_Host),
            MAX_HOST - 1);
    pop->hostname[MAX_HOST - 1] = '\0';
    strncpy(pop->service, fl_get_input(pop_acc_obj->Pop_Port), 15);
    pop->service[15] = '\0';
    strncpy(pop->username, fl_get_input(pop_acc_obj->Pop_User), 31);
    pop->username[31] = '\0';
    strncpy(pop->password, fl_get_input(pop_acc_obj->Pop_Password), 31);
    pop->password[31] = '\0';
    pop->maxmsg = atoi((char *) fl_get_input(pop_acc_obj->Pop_Maxmsg));

    pop->flags = 0;
    if(fl_get_button(pop_acc_obj->Pop_POP2))
        pop->flags |= PSRC_POP2;
    if(fl_get_button(pop_acc_obj->Pop_Delete))
        pop->flags |= PSRC_DELETE;
    if(fl_get_button(pop_acc_obj->Pop_Dmark))
        pop->flags |= PSRC_DMARK;
    if(fl_get_button(pop_acc_obj->Pop_Storpwd))
        pop->flags |= PSRC_STOREPWD;
    if(fl_get_button(pop_acc_obj->Pop_Log))
        pop->flags |= PSRC_LOGSESSION;
    if(fl_get_button(pop_acc_obj->Pop_Oheader))
        pop->flags |= PSRC_GETHEADER;
    if(fl_get_button(pop_acc_obj->Pop_Skip))
        pop->flags |= PSRC_SKIPBIG;
    if(fl_get_button(pop_acc_obj->Pop_UID))
        pop->flags |= PSRC_CHECKUID;
    if(fl_get_button(pop_acc_obj->Pop_Status))
        pop->flags |= PSRC_CHECKSTAT;
    if(fl_get_button(pop_acc_obj->Pop_Header))
        pop->flags |= PSRC_STATHEADER;
    if(fl_get_button(pop_acc_obj->Pop_XLST))
        pop->flags |= PSRC_STATXLST;
    if(fl_get_button(pop_acc_obj->Pop_APOP))
        pop->flags |= PSRC_APOP;

    fl_hide_form(pop_acc_obj->acc_pop);
    fl_free_form(pop_acc_obj->acc_pop);
    fl_free(pop_acc_obj);
    pop_acc_obj = NULL;

    ready = 0;
    return;
}

void POP_Ok_Call(FL_OBJECT * obj, long param) {
}

void pop_account_init() {
    pacc_obj = create_form_POPacc();
}

void pop_account(struct _pop_src *pop) {

    if(ready)
        return;

    ready = 1;

    fl_set_input(pacc_obj->P_Username, pop->username);
    fl_set_input(pacc_obj->P_Password, pop->password);
    fl_set_object_label(pacc_obj->P_Server, pop->hostname);
    fl_set_object_label(pacc_obj->P_Title, "POP account on");

    fl_set_object_focus(pacc_obj->POPacc, pacc_obj->P_Password);

    fl_show_form(pacc_obj->POPacc, FL_PLACE_CENTER, FL_TRANSIENT,
                 "POP account");

    fl_do_only_forms();

    strncpy(pop->username, (char *) fl_get_input(pacc_obj->P_Username),
            31);
    pop->username[31] = '\0';
    strncpy(pop->password, (char *) fl_get_input(pacc_obj->P_Password),
            31);
    pop->password[31] = '\0';

    fl_hide_form(pacc_obj->POPacc);

    ready = 0;
    return;
}

void nntp_account() {

    if(ready)
        return;

    ready = 1;

    fl_set_input(pacc_obj->P_Username,
                 Config.getString(conf_name, "nntpuser", user_n));
    fl_set_input(pacc_obj->P_Password,
                 Config.getString(conf_name, "nntpasswd", ""));
    fl_set_object_label(pacc_obj->P_Server,
                        Config.getString(conf_name, "nntphost", "news"));
    fl_set_object_label(pacc_obj->P_Title, "NNTP authorization on");
    fl_set_object_focus(pacc_obj->POPacc, pacc_obj->P_Password);
    fl_show_form(pacc_obj->POPacc, FL_PLACE_CENTER, FL_TRANSIENT,
                 "NEWS login");

    fl_do_only_forms();

    Config.putString(conf_name, "nntpuser",
                     (char *) fl_get_input(pacc_obj->P_Username));
    Config.putString(conf_name, "nntpasswd",
                     (char *) fl_get_input(pacc_obj->P_Password));
    fl_hide_form(pacc_obj->POPacc);
    ready = 0;
    return;
}

void news_conf(int set_default, FD_config_news * form) {

    nntp_obj = form;
    fl_set_input(nntp_obj->NNTP_Host,
                 Config.getStringDefault(conf_name, "nntphost", "news",
                                         set_default));
    fl_set_input(nntp_obj->NNTP_Port,
                 Config.getStringDefault(conf_name, "nntport", "119",
                                         set_default));
    fl_set_input(nntp_obj->NNTP_Username,
                 Config.getStringDefault(conf_name, "nntpuser", user_n,
                                         set_default));
    fl_set_input(nntp_obj->NNTP_Password,
                 Config.getStringDefault(conf_name, "nntpasswd", "",
                                         set_default));
    fl_set_button(nntp_obj->NNTP_Store_Pwd,
                  Config.getIntDefault(conf_name, "nntpstorpwd", 0,
                                       set_default));
    fl_set_button(nntp_obj->NNTP_Authorize,
                  Config.getIntDefault(conf_name, "nntpauth", 0,
                                       set_default));
    fl_set_button(nntp_obj->NNTP_Log, (logging & LOG_NNTP) ? 1 : 0);
    if(fl_get_button(nntp_obj->NNTP_Store_Pwd))
        Config.setFlags("nntpasswd", CF_UNSECURE);
    else
        Config.setFlags("nntpasswd", DONT_STORE | CF_UNSECURE);
}

void handle_news_input(FD_config_news * form) {
    nntp_obj = form;
    Config.putString(conf_name, "nntphost",
                     (char *) fl_get_input(nntp_obj->NNTP_Host));
    Config.putString(conf_name, "nntport",
                     (char *) fl_get_input(nntp_obj->NNTP_Port));
    Config.putString(conf_name, "nntpuser",
                     (char *) fl_get_input(nntp_obj->NNTP_Username));
    Config.putString(conf_name, "nntpasswd",
                     (char *) fl_get_input(nntp_obj->NNTP_Password));
    Config.putInt(conf_name, "nntpstorpwd",
                  fl_get_button(nntp_obj->NNTP_Store_Pwd));
    Config.putInt(conf_name, "nntpauth",
                  fl_get_button(nntp_obj->NNTP_Authorize));
    if(fl_get_button(nntp_obj->NNTP_Log))
        logging |= LOG_NNTP;
    else
        logging &= ~LOG_NNTP;
    return;
}

void smtp_conf(int set_default, FD_config_send * form) {

    smtp_obj = form;
    fl_set_input(smtp_obj->SMTP_Host,
                 Config.getStringDefault(conf_name, "smtphost",
                                         "127.0.0.1", set_default));
    fl_set_input(smtp_obj->SMTP_Port,
                 Config.getStringDefault(conf_name, "smtport", "25",
                                         set_default));
    switch(Config.
           getIntDefault(conf_name, "smtpsend", 0, set_default)) {
        case 0:
            fl_set_button(smtp_obj->SMTP_Sendmail, 1);
            break;

        case 1:
            fl_set_button(smtp_obj->SMTP_SMTP, 1);
            break;

        case 2:
            fl_set_button(smtp_obj->SMTP_POP, 1);
            break;

        default:
            fl_set_button(smtp_obj->SMTP_Sendmail, 1);
            break;
    }

    fl_set_input(smtp_obj->SMTP_POPSRC,
                 Config.getStringDefault(conf_name, "smtppopsrc", "",
                                         set_default));
    fl_set_button(smtp_obj->SMTP_Bg,
                  Config.getIntDefault(conf_name, "smtpbg", 0,
                                       set_default));
    fl_set_button(smtp_obj->SMTP_Save,
                  Config.getIntDefault(conf_name, "smtpsave", 0,
                                       set_default));
    fl_set_button(smtp_obj->SMTP_Bcc,
                  Config.getIntDefault(conf_name, "smtpbcc", 0,
                                       set_default));
    fl_set_button(smtp_obj->SMTP_Off,
                  Config.getIntDefault(conf_name, "smtpoffl", 0,
                                       set_default));
    fl_set_button(smtp_obj->SMTP_DSN,
                  Config.getIntDefault(conf_name, "smtpdsn", 0,
                                       set_default));
    fl_set_input(smtp_obj->Misc_SMail,
                 Config.getStringDefault(conf_name, "sendmail",
                                         _PATH_SENDMAIL, set_default));
    fl_set_input(smtp_obj->Sendmail_Opt,
                 Config.getStringDefault(conf_name, "sendmailopt", "-i",
                                         set_default));
    fl_set_input(smtp_obj->Sendmail_DSN,
                 Config.getStringDefault(conf_name, "sendmaildsn",
                                         "-R hdrs -N failure,delay,success",
                                         set_default));
    fl_set_button(smtp_obj->SMTP_Log, (logging & LOG_SMTP) ? 1 : 0);
}


void handle_smtp_input(FD_config_send * form) {
    smtp_obj = form;
    Config.putString(conf_name, "smtphost",
                     (char *) fl_get_input(smtp_obj->SMTP_Host));
    Config.putString(conf_name, "smtport",
                     (char *) fl_get_input(smtp_obj->SMTP_Port));
    if(fl_get_button(smtp_obj->SMTP_Sendmail))
        Config.putInt(conf_name, "smtpsend", 0);
    else if(fl_get_button(smtp_obj->SMTP_SMTP))
        Config.putInt(conf_name, "smtpsend", 1);
    else if(fl_get_button(smtp_obj->SMTP_POP))
        Config.putInt(conf_name, "smtpsend", 2);
    else
        Config.putInt(conf_name, "smtpsend", 0);
    Config.putString(conf_name, "smtppopsrc",
                     (char *) fl_get_input(smtp_obj->SMTP_POPSRC));
    Config.putInt(conf_name, "smtpbg",
                  fl_get_button(smtp_obj->SMTP_Bg));
    Config.putInt(conf_name, "smtpsave",
                  fl_get_button(smtp_obj->SMTP_Save));
    Config.putInt(conf_name, "smtpbcc",
                  fl_get_button(smtp_obj->SMTP_Bcc));
    Config.putInt(conf_name, "smtpoffl",
                  fl_get_button(smtp_obj->SMTP_Off));
    Config.putInt(conf_name, "smtpdsn",
                  fl_get_button(smtp_obj->SMTP_DSN));
    offline = fl_get_button(smtp_obj->SMTP_Off);
    Config.putString(conf_name, "sendmail",
                     (char *) fl_get_input(smtp_obj->Misc_SMail));
    Config.putString(conf_name, "sendmailopt",
                     (char *) fl_get_input(smtp_obj->Sendmail_Opt));
    Config.putString(conf_name, "sendmaildsn",
                     (char *) fl_get_input(smtp_obj->Sendmail_DSN));
    if(fl_get_button(smtp_obj->SMTP_Log))
        logging |= LOG_SMTP;
    else
        logging &= ~LOG_SMTP;
    return;
}
