/* $Id: pop.cpp,v 1.1 1999/11/09 21:03:46 xfmail Exp $
 */

#include <config.h>
#include <fmail.h>
#include <umail.h>
#include <cfgfile.h>
#include "md5.h"

extern cfgfile Config;

class pop {

public:

#if STDC_HEADERS || defined(USE_STDARG)
    char *command(struct _pop_src *pop, char *fmt, ...)
#else
    char *command(struct _pop_src *pop, char *fmt, va_dcl
                      va_list)
#endif
    {
        va_list ap;
        static char commandln[514];

#if STDC_HEADERS || defined(USE_STDARG)
        va_start(ap, fmt);
#else
        va_start(ap);
#endif

        vsnprintf(commandln, sizeof(commandln), fmt, ap);

        if(pop->flags & PSRC_LOGSESSION) {
            if(strncasecmp(commandln, "pass ", 5))
                display_msg(MSG_LOG, "pop", "-> %-.127s", commandln);
            else
                display_msg(MSG_LOG, "pop", "-> PASS *******");
        }

        if(putline(commandln, pop->pop_out) == -1)
            return NULL;

        pop->response[0] = '\0';

        if(getline(pop->response, 513, pop->pop_in) == NULL)
            return NULL;

        if(pop->flags & PSRC_LOGSESSION)
            display_msg(MSG_LOG, "pop", "<- %-.127s", pop->response);

        if(pop->response[0] == '+')
            return pop->response;

        if(strncasecmp(fmt, "UIDL", 4)
           && !strncasecmp(pop->response, "-ERR ", 4))
             display_msg(MSG_WARN,
                                                                   "pop",
                                                                   "%-.127s",
                                                                   pop->
                                                                   response +
                                                                   4);

        return NULL;
    }

    void close(struct _pop_src *pop) {
        struct _uidl *ucache;

        host_disconnect(&pop->popsock);

        while(pop->uidlcache) {
            ucache = pop->uidlcache;
            pop->uidlcache = pop->uidlcache->next;
            free(ucache);
        }

        if((pop->pop_in != NULL) || (pop->pop_out != NULL))
            fclose(pop->pop_in);

        pop->pop_in = NULL;
        pop->pop_out = NULL;
        pop->popsock = -1;

        return;
    }

    void end(struct _pop_src *pop) {
        command(pop, "QUIT");
        close(pop);
        save_uidlist(pop);
        free_uidlist(pop);
    }

    int init(struct _pop_src *pop) {
        char buf[514], apoptstamp[512], apopdigest[40], *p, *p1;
        int logattempts = 2, i;
        unsigned char digest[16];
        MD5_CTX ctx;

        if(pop->popsock != -1) {
            display_msg(MSG_WARN, "pop", "POP busy");
            return -1;
        }

        pop->nouidl = 0;
        pop->popsock = host_connect(pop->hostname, pop->service, NULL);

        if(pop->popsock == -1)
            return -2;

        if((pop->pop_in = fdopen(pop->popsock, "r+")) == NULL) {
            display_msg(MSG_WARN, "pop", "fdopen failed");
            pop_close(pop);
            return -1;
        }

        pop->pop_out = pop->pop_in;

        if(getline(buf, 513, pop->pop_in) == NULL) {
            pop_close(pop);
            return -1;
        }

        if(buf[0] != '+') {
            display_msg(MSG_WARN, "pop", "Invalid response from pop server");
            pop_close(pop);
            return -1;
        }

        if(pop->flags & PSRC_APOP) {
            apoptstamp[0] = '\0';
            if(((p = strchr(buf, '<')) != NULL) &&
               ((p1 = strchr(p, '>')) != NULL)) {
                i = p1 - p + 1;
                strncpy(apoptstamp, p, i);
                apoptstamp[i] = '\0';
            } else
                display_msg(MSG_LOG, pop->source->name,
                            "APOP is not supported on this server");
        }

        if(supress_errors != 1) {
            if((strlen(pop->password) <= 1) && !(pop->flags & PSRC_STOREPWD))
                pop_account(pop);
        }

        while(logattempts > 0) {
            if((pop->flags & PSRC_APOP) && *apoptstamp) {
                MD5Init(&ctx);
                MD5Update(&ctx, (unsigned char *) apoptstamp,
                          strlen(apoptstamp));
                MD5Update(&ctx, (unsigned char *) pop->password,
                          strlen(pop->password));
                MD5Final(digest, &ctx);

                for(p = apopdigest, i = 0; i < 16; i++, p += 2)
                    sprintf(p, "%02x", digest[i] & 0xff);
                apopdigest[32] = '\0';

                if(pop_command(pop, "APOP %s %s", pop->username, apopdigest))
                    return 0;
            } else {
                if(pop_command(pop, "USER %s", pop->username) == NULL) {
                    pop_close(pop);
                    return -1;
                }

                if(pop_command(pop, "PASS %s", pop->password))
                    return 0;
            }

            if(strncasecmp(pop->response, "-ERR ", 4)) {
                pop_close(pop);
                return -1;
            }

            logattempts--;
            pop_account(pop);
        }

        pop_close(pop);
        return -1;
    }

    int multiline(struct _pop_src *pop) {
        char buffer[514];

        if(getline(buffer, 513, pop->pop_in) == NULL)
            return -1;

        if(buffer[0] == '.') {
            if(buffer[1] == '\0')
                return 0;
            else
                (void) strcpy(pop->response, buffer + 1);
        } else
            (void) strcpy(pop->response, buffer);

        return 1;
    }

    int
    get_msg(struct _pop_src *pop, int num, int only_header, long *realen) {
        int mnum, resplen;
        char buf[255];
        char *p, *p1;
        FILE *mfd;
        int st, pbuf;
        long rlen, acclen, tdiff;
        struct timeval tv1, tv2;
        struct _uidl *ucache;

        if((mnum = get_new_name(ftemp)) == -1) {
            display_msg(MSG_WARN, "pop", "No space in %s", FTEMP);
            return -1;
        }

        snprintf(buf, sizeof(buf), "%s/%d", ftemp->fold_path, mnum);

        if((mfd = fopen(buf, "w")) == NULL) {
            display_msg(MSG_WARN, "pop", "Can not open file %s", buf);
            return -1;
        }

        if(only_header == 1) {
            if((p = pop_command(pop, "TOP %d 0", num)) == NULL) {
                display_msg(MSG_WARN, "pop",
                            "Failed to retrieve header of message %d from server",
                            num);
                fclose(mfd);
                unlink(buf);
                return -1;
            }
        } else if(only_header == 2) {
            if((p = pop_command(pop, "TOP %d 999999", num)) == NULL) {
                display_msg(MSG_WARN, "pop",
                            "Failed to retrieve message %d from server", num);
                fclose(mfd);
                unlink(buf);
                return -1;
            }
        } else {
            if((p = pop_command(pop, "RETR %d", num)) == NULL) {
                display_msg(MSG_WARN, "pop",
                            "Failed to retrieve message %d from server", num);
                fclose(mfd);
                unlink(buf);
                return -1;
            }
        }

        rlen = -1;
        if((p = strchr(p, ' ')) != NULL) {
            while(*p == ' ')
                p++;

            rlen = strtoul(p, &p1, 10);
            if(*p1 && (*p1 != ' '))
                rlen = -1;
        }

        if(rlen <= 0) {
            ucache = pop->uidlcache;
            while(ucache && (ucache->mnum != num))
                ucache = ucache->next;

            if(ucache && (ucache->flags & POP_LENGTH))
                rlen = ucache->mlen;
        }

        if(realen) {
            if((*realen = rlen) <= 0)
                *realen = 1;
        }

        rlen = 0;
        acclen = 0;
        pbuf = 0;
        gettimeofday(&tv1, NULL);

        while((st = multiline(pop)) == 1) {
            resplen = strlen(pop->response);
            rlen += resplen + 2;
            acclen += resplen + 2;
            if((only_header != 1) && realen && (*realen > 8192)) {
                if(acclen > (*realen * 0.05)) {
                    acclen = 0;
                    gettimeofday(&tv2, NULL);
                    tdiff =
                    (tv2.tv_sec - tv1.tv_sec) * 1000000 - tv1.tv_usec +
                    tv2.tv_usec + 1;
                    display_msg(MSG_STAT, NULL,
                                "POP: retrieving message %d of %d (%d %% - %.2f kb/sec)",
                                num, pop->num_msgs, rlen * 100 / *realen,
                                (double) (((double) rlen * 1000000) /
                                          (double) tdiff / 1024));
                }
            }

            if(resplen < 1)
                pbuf++;
            else {
                while(pbuf) {
                    fputc('\n', mfd);
                    pbuf--;
                }

                if(fputs(pop->response, mfd) == EOF) {
                    if(errno == ENOSPC)
                        display_msg(MSG_WARN, "pop", "DISK FULL!");
                    else
                        display_msg(MSG_WARN, "pop", "Error writing %s", buf);
                    fclose(mfd);
                    unlink(buf);
                    errno = 0;
                    return -1;
                }
                fputc('\n', mfd);
            }
        }

        if(fclose(mfd) == EOF) {
            if(errno == ENOSPC)
                display_msg(MSG_WARN, "pop", "DISK FULL!");
            else
                display_msg(MSG_WARN, "pop", "Error writing %s", buf);
            fclose(mfd);
            unlink(buf);
            errno = 0;
            return -1;
        }

        if(st == -1) {
            display_msg(MSG_WARN, "pop",
                        "Error when retrieving message from server");
            unlink(buf);
            return -1;
        }

        return mnum;
    }

    int send_message(struct _pop_src *pop, struct _mail_msg *msg) {
        char *p;

        if(!msg)
            return -1;

        switch(pop_init(pop)) {
            case -1:
                return -1;
                break;

            case -2:
                return -1;
                break;
        }

        if((p = pop_command(pop, "XTND XMIT")) == NULL) {
            display_msg(MSG_WARN, "Transmit command failed!",
                        "Probably it's not supported on this POP server");
            pop_end(pop);
            return -1;
        }

        if(smtp_message(msg, pop->pop_out) == -1) {
            pop_end(pop);
            return -1;
        }

        if((p = pop_command(pop, ".")) == NULL) {
            display_msg(MSG_WARN, "POP Send", "Failed to send message");
            pop_end(pop);
            return -1;
        }

        pop_end(pop);
        return 0;
    }

    long get_msg_len(struct _pop_src *pop, int num) {
        int st;
        struct _uidl *ucache;
        u_long msg_len;
        int mnum;

        if((pop->uidlcache == NULL) || !(pop->uidlcache->flags & POP_LENGTH)) {
            get_popmsg_by_uidl(pop, "");
            if(pop->uidlcache == NULL) {
                if(!pop->nouidl)
                    return -2;

                if(pop_command(pop, "LIST %d", num) == NULL) {
                    display_msg(MSG_WARN, "pop",
                                "Can not determine message length!");
                    return -2;
                }

                mnum = -1;
                msg_len = 0L;
                sscanf(pop->response, "%d %lu", &mnum, &msg_len);
                if((mnum != num) || (msg_len == -1))
                    return -2;

                return msg_len;

            }

            if(pop_command(pop, "LIST") == NULL) {
                display_msg(MSG_WARN, "pop",
                            "Can not determine message length!");
                return -2;
            }

            ucache = pop->uidlcache;

            while((st = multiline(pop)) == 1) {
                mnum = -1;
                msg_len = 0L;
                sscanf(pop->response, "%d %lu", &mnum, &msg_len);

                if((mnum == -1) || (msg_len == 0L))
                    continue;

                while(ucache && (ucache->mnum != mnum))
                    ucache = ucache->next;

                if(!ucache) {
                    ucache = pop->uidlcache;
                    while(ucache && (ucache->mnum != mnum))
                        ucache = ucache->next;
                }

                if(!ucache)
                    continue;

                ucache->mlen = msg_len;
                ucache->flags |= POP_LENGTH;
                ucache = ucache->next;
            }
        }

        ucache = pop->uidlcache;
        while(ucache && (ucache->mnum != num))
            ucache = ucache->next;

        if(!ucache || !(ucache->flags & POP_LENGTH)) {
            display_msg(MSG_WARN, "pop",
                        "Can not determine message length (%d)!", num);
            return -2;
        }

        return ucache->mlen;
    }

    char *get_msg_uidl(struct _pop_src *pop, int num) {
        struct _uidl *ucache;

        if(pop->uidlcache == NULL)
            get_popmsg_by_uidl(pop, "");

        if(pop->nouidl)
            return NULL;

        ucache = pop->uidlcache;

        while(ucache) {
            if(ucache->mnum == num)
                return ucache->uidlstr;

            ucache = ucache->next;
        }

        return NULL;
    }

    struct _uidl *get_msg_by_uidl(struct _pop_src *pop, char *uidl) {
        int st;
        char muidl[MAX_UIDL];
        struct _uidl *ucache, *uidl1, *uidl2;

        if(pop->uidlcache == NULL) {
            if(pop->nouidl)
                return NULL;

            if(pop_command(pop, "UIDL") == NULL) {
                pop->nouidl = 1;
                return NULL;
            }

        } else {
            ucache = pop->uidlcache;
            while(ucache) {
                if(!strcmp(ucache->uidlstr, uidl))
                    return ucache;

                ucache = ucache->next;
            }

            return NULL;
        }

        uidl2 = NULL;

        while((st = multiline(pop)) == 1) {
            muidl[0] = '\0';
            st = 0;
            sscanf(pop->response, "%d %70s", &st, muidl);
            ucache = (struct _uidl *) malloc(sizeof(struct _uidl));
            ucache->mnum = st;
            ucache->mlen = 0;
            ucache->flags = 0;
            strcpy(ucache->uidlstr, muidl);
            ucache->next = NULL;

            if(!strcmp(muidl, uidl))
                uidl2 = ucache;

            if(pop->uidlcache == NULL)
                pop->uidlcache = ucache;
            else {
                uidl1 = pop->uidlcache;
                while(uidl1->next)
                    uidl1 = uidl1->next;

                uidl1->next = ucache;
            }
        }

        compare_uidlist(pop);
        return uidl2;
    }

    int get_msg_num(struct _pop_src *pop) {
        char *p;
        char dumb[5];
        int msgs_len = 0;

        if((p = pop_command(pop, "STAT")) == NULL)
            return -1;

        sscanf(p, "%s %d %d", dumb, &pop->num_msgs, &msgs_len);

        if(pop->num_msgs == -1) {
            display_msg(MSG_WARN, "pop", "STAT failed");
            return -1;
        }

        return pop->num_msgs;
    }

    int delmsg_by_uidl(struct _pop_src *pop, struct _mail_msg *msg) {
        int mnum;
        struct _head_field *fld;
        struct _uidl *uidl;
        int init;

        if(pop == NULL)
            return -1;

        init = (pop->popsock == -1) ? 1 : 0;

        if(!msg)
            return -1;

        if((fld = find_field(msg, XUIDL)) == NULL) {
            display_msg(MSG_WARN, "pop",
                        "This message does not have POP %s identifier", XUIDL);
            return -1;
        }

        if(init) {
            if(pop_init(pop) != 0)
                return -1;
        }

        if((uidl = get_popmsg_by_uidl(pop, fld->f_line)) == NULL) {
            if(pop->nouidl)
                display_msg(MSG_WARN, "pop",
                            "You can not use this feature\nsince your POP server does not support UIDL command");
            if(init)
                pop_end(pop);
            return -1;
        }

        mnum = uidl->mnum;

        if(mnum == 0) {
            if(init)
                pop_end(pop);
            return -1;
        }

        if(!(uidl->flags & POP_DELETED)) {
            display_msg(MSG_STAT, NULL, "POP: deleting message %d", mnum);
            pop_command(pop, "DELE %d", mnum);
            uidl->flags |= POP_DELETED;
        }

        if(init)
            pop_end(pop);

        msg->flags &= ~H_ONLY;
        delete_uidlist(pop, fld->f_line);

        return 0;
    }

    int getfull_msg(struct _pop_src *pop, struct _mail_msg *msg) {
        struct _head_field *fld;
        struct _uidl *uidl;
        int mnum, nnum, st;
        FILE *mfd, *bfd;
        char buf[255];
        char msgf[255];
        long realen;

        if(!msg || !pop)
            return -1;

        if(!(msg->flags & H_ONLY))
            return -1;

        if((fld = find_field(msg, XUIDL)) == NULL) {
            display_msg(MSG_WARN, "pop", "Message does not have %s identifier",
                        XUIDL);
            return -1;
        }

        if(pop_init(pop) != 0)
            return -1;

        if((uidl = get_popmsg_by_uidl(pop, fld->f_line)) == NULL) {
            if(pop->nouidl)
                display_msg(MSG_WARN, "pop",
                            "You can not use thise feature\nsince your POP server does not support UIDL command");
            else
                display_msg(MSG_WARN, "pop", "Failed to find message");
            pop_end(pop);
            return -1;
        }

        mnum = uidl->mnum;

        if(mnum == 0) {
            display_msg(MSG_WARN, "pop",
                        "Can not find message, probably it's no longer on the server");
            pop_end(pop);
            return -1;
        }

        if((nnum = get_pop_msg(pop, mnum, 0, &realen)) == -1) {
            pop_end(pop);
            return -1;
        }

        if(pop->flags & PSRC_DELETE)
            pop_command(pop, "DELE %d", mnum);

        snprintf(msgf, sizeof(msgf), "%s/%d", ftemp->fold_path, nnum);

        if((bfd = fopen(msgf, "r")) == NULL) {
            display_msg(MSG_WARN, "pop", "Can not open retrieved message");
            unlink(msgf);
            pop_end(pop);
            return -1;
        }

        if((mfd = fopen(msg->get_file(msg), "a")) == NULL) {
            display_msg(MSG_WARN, "pop", "Can not open message %s",
                        msg->get_file(msg));
            fclose(bfd);
            unlink(msgf);
            pop_end(pop);
            return -1;
        }

        st = 0;
        while(fgets(buf, 255, bfd)) {
            if(!st && ((buf[0] == '\n') || (buf[0] == '\r'))) {
                st = 1;
                continue;
            }

            if(st)
                fputs(buf, mfd);
        }

        fflush(mfd);
        msg->msg_len = ftell(mfd);
        fclose(mfd);
        fclose(bfd);
        unlink(msgf);

        msg->flags &= ~H_ONLY;
        replace_field(msg, XUIDL, uidl->uidlstr);
        pop_end(pop);

        return 0;
    }

    int if_msg_retr(struct _pop_src *pop, int num) {
        char *p;
        int ml, st;

        if(pop->flags & PSRC_STATXLST)
            p = pop_command(pop, "XTND XLST Status %d", num);
        else
            p = pop_command(pop, "TOP %d 0", num);

        if(!p) {
            display_msg(MSG_WARN, "pop", "Can not determine message status");
            return 0;
        }

        st = 0;
        while((ml = multiline(pop)) == 1) {
            if((p = strstr(pop->response, "Status:")) != NULL) {
                p += 7;
                if(strchr(p, 'R'))
                    st = 1;
            }
        }

        return st;
    }

    void free_uidlist(struct _pop_src *pop) {
        int i;

        if(pop->uidfirst == -2) {
            for(i = 0; i < MAX_POP_UIDS; i++)
                pop->pop_uids[i] = NULL;
        } else {
            for(i = 0; i < MAX_POP_UIDS; i++) {
                if(pop->pop_uids[i] != NULL)
                    free(pop->pop_uids[i]);
                pop->pop_uids[i] = NULL;
            }
        }
        pop->uidfirst = -1;

        return;
    }

    void load_uidlist(struct _pop_src *pop) {
        char uidfname[255];
        char uidstr[MAX_UIDL + 2];
        FILE *ufd;
        int i = 0;

        free_uidlist(pop);

        snprintf(uidfname, sizeof(uidfname), "%s/.xfmpopuid-%s", configdir,
                 pop->source->name);
        if((ufd = fopen(uidfname, "r")) == NULL) {
            pop->uidfirst = 0;
            return;
        }

        while(fgets(uidstr, MAX_UIDL - 1, ufd)) {
            strip_newline(uidstr);
            pop->pop_uids[i] = strdup(uidstr);
            if(++i >= MAX_POP_UIDS)
                break;
        }
        fclose(ufd);
        pop->uidfirst = 0;

        return;
    }

    void save_uidlist(struct _pop_src *pop) {
        FILE *ufd;
        char uidfname[255];
        int i = pop->uidfirst;

        if(pop->uidfirst < 0)
            return;

        snprintf(uidfname, sizeof(uidfname), "%s/.xfmpopuid-%s", configdir,
                 pop->source->name);
        if((ufd = fopen(uidfname, "w")) == NULL) {
            display_msg(MSG_WARN, "Message uids will not be stored",
                        "Can not open %s", uidfname);
            pop->uidfirst = -3;
            return;
        }

        do {
            if(pop->pop_uids[i]) {
                fputs(pop->pop_uids[i], ufd);
                fputc('\n', ufd);
            }

            i++;
            if(i >= MAX_POP_UIDS)
                i = 0;
        } while(i != pop->uidfirst);
        fclose(ufd);

        return;
    }

    void append_uidlist(struct _pop_src *pop, char *uidstr) {
        if(!uidstr || !*uidstr || (strlen(uidstr) >= MAX_UIDL))
            return;

        if(pop->uidfirst == -3)
            return;

        if(pop->uidfirst < 0)
            load_uidlist(pop);

        if(check_uidlist(pop, uidstr) != 0)
            return;

        pop->uidfirst--;
        if(pop->uidfirst < 0)
            pop->uidfirst = MAX_POP_UIDS - 1;
        if(pop->pop_uids[pop->uidfirst])
            free(pop->pop_uids[pop->uidfirst]);
        pop->pop_uids[pop->uidfirst] = strdup(uidstr);

        return;
    }

    int check_uidlist(struct _pop_src *pop, char *uidstr) {
        int i = 0;

        if(!uidstr || !*uidstr || (strlen(uidstr) >= MAX_UIDL))
            return 0;

        if(pop->uidfirst == -3)
            return 0;

        if(pop->uidfirst < 0)
            load_uidlist(pop);

        for(i = 0; i < MAX_POP_UIDS; i++) {
            if(pop->pop_uids[i] && !strcmp(pop->pop_uids[i], uidstr))
                return 1;
        }

        return 0;
    }

    void delete_uidlist(struct _pop_src *pop, char *uidstr) {
        int i;

        if(!uidstr || !*uidstr || (strlen(uidstr) >= MAX_UIDL))
            return;

        if(pop->uidfirst < 0)
            load_uidlist(pop);

        if(pop->uidfirst == -3)
            return;

        for(i = 0; i < MAX_POP_UIDS; i++) {
            if(pop->pop_uids[i] && !strcmp(pop->pop_uids[i], uidstr)) {
                free(pop->pop_uids[i]);
                pop->pop_uids[i] = NULL;
                break;
            }
        }

        return;
    }

    void compare_uidlist(struct _pop_src *pop) {
        int i;

        if(pop->uidlcache == NULL)
            return;

        if(pop->uidfirst < 0)
            load_uidlist(pop);

        if(pop->uidfirst == -3)
            return;

        for(i = 0; i < MAX_POP_UIDS; i++) {
            if(pop->pop_uids[i] &&
               (get_popmsg_by_uidl(pop, pop->pop_uids[i]) == NULL)) {
                free(pop->pop_uids[i]);
                pop->pop_uids[i] = NULL;
            }
        }

        return;
    }

    int if_msg_uid_cached(struct _pop_src *pop, int msg) {
        char *uid;

        if(pop->uidfirst < 0)
            load_uidlist(pop);

        if(pop->uidfirst < 0)
            return -1;

        if((uid = get_popmsg_uidl(pop, msg)) == NULL)
            return -1;

        return check_uidlist(pop, uid);
    }

    int inc(struct _retrieve_src *source, int *notify) {
        struct _pop_src *pop;
        struct _mail_msg *msg;
        int i, honly, uidcached;
        int num_msgs, retr_num;
        long popmaxmsg = -1;
        char mclen[16], *muidl;
        long realen;
        int nnum = -1;

        if(source->flags & RSRC_DISABLED)
            return 0;

        pop = (struct _pop_src *) source->spec;

        if(pop->maxmsg >= 0)
            popmaxmsg = pop->maxmsg * 1024;

        if(pop_init(pop) != 0)
            return -1;

        if((num_msgs = get_popmsg_num(pop)) == -1) {
            pop_end(pop);
            return -1;
        }

        if(num_msgs == 0) {
            free_uidlist(pop);
            pop->uidfirst = 0;
            save_uidlist(pop);
            pop_end(pop);
            return 0;
        }

        retr_num = 0;

        for(i = 1; i <= num_msgs; i++) {

            honly = 0;
            uidcached = -1;
            realen = 0;

            if(abortpressed())
                break;

            if(!(pop->flags & PSRC_POP2) &&
               ((pop->flags & PSRC_CHECKUID) ||
                (pop->flags & PSRC_CHECKSTAT))) {
                if((pop->flags & PSRC_CHECKSTAT) &&
                   (if_popmsg_retr(pop, i) > 0)) continue;

                if((pop->flags & PSRC_CHECKUID) &&
                   ((uidcached = if_popmsg_uid_cached(pop, i)) == 1))
                    continue;
            }

            if(!(pop->flags & PSRC_POP2) && (popmaxmsg >= 0)
               && ((realen = get_popmsg_len(pop, i)) >= popmaxmsg)) {

                if(realen >= popmaxmsg) {
                    if(!is_iconized()) {
                        display_msg(MSG_WARN, "pop",
                                    "Skipping Message: %luk > %luk",
                                    realen / 1024, popmaxmsg / 1024);
                    }
                }

                if(pop->flags & PSRC_SKIPBIG)
                    continue;

                if(pop->nouidl) {
                    if(!is_iconized()) {
                        display_msg(MSG_WARN,
                                    "Can not retrieve message header, skipping",
                                    "Your POP server does not support UIDL command\nIt will be impossible to match header and message left on the server later");
                    }
                    continue;
                }

                display_msg(MSG_STAT, NULL,
                            "POP: retrieving header of message %d of %d", i,
                            num_msgs);
                if((nnum = get_pop_msg(pop, i, 1, &realen)) == -1) {
                    pop_end(pop);
                    return -1;
                }

                if((msg = get_message(nnum, ftemp)) == NULL) {
                    pop_end(pop);
                    return -1;
                }

                msg->flags |= H_ONLY;

                if(realen > 0) {
                    snprintf(mclen, sizeof(mclen), "%lu", realen);
                    replace_field(msg, MIME_C_LENGTH, mclen);
                }

                honly = 1;
            } else {

                display_msg(MSG_STAT, NULL, "POP: retrieving message %d of %d",
                            i, num_msgs);
                if(
                  (nnum =
                   get_pop_msg(pop, i, (pop->flags & PSRC_DMARK) ? 2 : 0,
                               &realen)) == -1) {
                    pop_end(pop);
                    return -1;
                }

                if((msg = get_message(nnum, ftemp)) == NULL) {
                    pop_end(pop);
                    return -1;
                }

            }

            if(!(pop->flags & PSRC_POP2)) {
                if((muidl = get_popmsg_uidl(pop, i)) != NULL) {
                    replace_field(msg, XUIDL, muidl);
                    if((pop->flags & PSRC_CHECKUID) &&
                       (uidcached == 0) && (!(pop->flags & PSRC_DELETE)
                                            || honly)) append_uidlist(pop,
                                                                      muidl);
                }
            }

            set_flags_by_status(msg);
            convert_fields(msg);
            msg->folder = ftemp;
            msg->status |= (CHANGED | RECENT);
            if(source->flags & RSRC_MARKREAD)
                msg->flags &= ~UNREAD;
            replace_field(msg, "X-RDate", get_arpa_date(time(NULL)));
            replace_field(msg, SOURCE_FIELD, source->name);
            msg->header->rcv_time = time(NULL);

#ifdef FACES
            update_faces(msg);
#endif

            switch(apply_rule(msg, 0)) {
                case 0:
                    if(!(source->flags & RSRC_NONOTIFY))
                        (*notify)++;
                    break;

                case -1:
                    pop_end(pop);
                    unlink(msg->get_file(msg));
                    discard_message(msg);
                    return -1;
                    break;
            }

            retr_num++;

            if((pop->flags & PSRC_DELETE) && !honly)
                pop_command(pop, "DELE %d", i);

        }

        pop_end(pop);
        return retr_num;
    }

    void init_source(struct _retrieve_src *source) {
        struct _pop_src *pop;
        struct _uidl *ucache;
        int i;

        if(source->spec == NULL) {
            source->spec = (struct _pop_src *) malloc(sizeof(struct _pop_src));
            pop = (struct _pop_src *) source->spec;
            pop->source = source;
            strcpy(pop->hostname, "127.0.0.1");
            strcpy(pop->service, "110");
            strcpy(pop->username, user_n);
            *pop->password = '\0';
            pop->maxmsg = -1;
            pop->flags = PSRC_DELETE;
        } else {
            pop = (struct _pop_src *) source->spec;
            if(pop->popsock > 0)
                close(pop->popsock);
            if(pop->pop_in)
                fclose(pop->pop_in);
            if(pop->pop_out)
                fclose(pop->pop_out);

            while(pop->uidlcache) {
                ucache = pop->uidlcache;
                pop->uidlcache = pop->uidlcache->next;
                free(ucache);
            }

            for(i = 0; i < MAX_POP_UIDS; i++) {
                if(pop->pop_uids[i])
                    free(pop->pop_uids[i]);
                pop->pop_uids[i] = NULL;
            }
        }

        pop->popsock = -1;
        pop->pop_in = NULL;
        pop->pop_out = NULL;
        pop->uidlcache = NULL;
        pop->nouidl = 0;
        pop->num_msgs = -1;
        pop->uidfirst = -2;
        *pop->response = '\0';

        return;
    }

    void free_source(struct _retrieve_src *source) {
        if(source->spec) {
            init_pop_source(source);
            free(source->spec);
            source->spec = NULL;
        }

        return;
    }

    int load_source(struct _retrieve_src *source, FILE * fd) {
        struct _pop_src *pop;
        char buf[255], *p, *p1;

        pop = (struct _pop_src *) source->spec;
        if(!fgets(buf, 255, fd))
            return -1;
        strip_newline(buf);
        if(sscanf(buf, "%s %15s", pop->hostname, pop->service) != 2)
            return -1;

        if(!fgets(buf, 255, fd))
            return -1;
        strip_newline(buf);

        p1 = buf;
        if((p = get_quoted_str(&p1)) == NULL)
            return -1;
        strncpy(pop->username, p, 31);
        pop->username[31] = '\0';
        *pop->password = '\0';
        if((p = get_quoted_str(&p1)) != NULL) {
            strncpy(pop->password, p, 31);
            pop->password[31] = '\0';
        }

        if(!fgets(buf, 255, fd))
            return -1;
        strip_newline(buf);
        if(sscanf(buf, "%ld %d", &pop->maxmsg, &pop->flags) != 2)
            return -1;

        return 0;
    }

    int save_source(struct _retrieve_src *source, FILE * fd) {
        struct _pop_src *pop;

        pop = (struct _pop_src *) source->spec;
        fprintf(fd, "%s %s\n", pop->hostname, pop->service);

        if(strchr(pop->username, ' '))
            fprintf(fd, "\"%s\"", pop->username);
        else
            fprintf(fd, "%s", pop->username);

        if(pop->flags & PSRC_STOREPWD) {
            if(strchr(pop->password, ' '))
                fprintf(fd, " \"%s\"\n", pop->password);
            else
                fprintf(fd, " %s\n", pop->password);
        } else
            fprintf(fd, "\n");

        fprintf(fd, "%ld %d\n", pop->maxmsg, pop->flags);
        return 0;
    }

    void source(struct _retrieve_src *source) {
        init_pop_source(source);
        source->type = RSRC_POP;
        source->retrieve = pop_inc;
        source->free = free_pop_source;
        source->init = init_pop_source;
        source->load = load_pop_source;
        source->save = save_pop_source;

        return;
    }

};
