/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  int AFrdF8 (AFILE *AFp, float Fbuff[], int Nreq)

Purpose:
  Read 64-bit float data from an audio file (return float values)

Description:
  This routine reads a specified number of 64-bit float (double) samples from
  an audio file.  The data in the file is converted to float format on output.

Parameters:
  <-  int AFrdF8
      Number of data values transferred from the file.  On reaching the end of
      the file, this value may be less than Nreq.
   -> AFILE *AFp
      Audio file pointer for an audio file opened by AFopenRead
  <-  float Fbuff[]
      Array of floats to receive the samples
   -> int Nreq
      Number of samples requested.  Nreq may be zero.

Author / revision:
  P. Kabal  Copyright (C) 1997
  $Revision: 1.6 $  $Date: 1997/10/15 13:41:37 $

-------------------------------------------------------------------------*/

static char rcsid [] = "$Id: AFrdF8.c 1.6 1997/10/15 libtsp-v3r0 $";

#include <libtsp/AFdataio.h>
#include <libtsp/Xstdio.h>
#include <libtsp/AFpar.h>
#include <libtsp/UTtypes.h>

#define LW		FDL_FLOAT64
#define MINV(a, b)	(((a) < (b)) ? (a) : (b))
#define NBBUF		8192

#define FREAD(buf,size,nv,fp)	(int) fread ((char *) buf, (size_t) size, \
					     (size_t) nv, fp)


int
AFrdF8 (AFp, Fbuff, Nreq)

     AFILE *AFp;
     float Fbuff[];
     int Nreq;

{
  int is, N, i, Nr;
  double8_t Buf[NBBUF/LW];
  double8_t *B;
  unsigned char *cp;
  unsigned char t;

  for (is = 0; is < Nreq; ) {

    /* Read data from the audio file */
    N = MINV (NBBUF / LW, Nreq - is);
    Nr = FREAD (Buf, LW, N, AFp->fp);

    /* Byte swap and convert to float */
    B = Buf;
    for (i = 0; i < Nr; ++i) {
      if (AFp->Swapb == DS_SWAP) {
	cp = (unsigned char *) B;
	t = cp[7]; cp[7] = cp[0]; cp[0] = t;
	t = cp[6]; cp[6] = cp[1]; cp[1] = t;
	t = cp[5]; cp[5] = cp[2]; cp[2] = t;
	t = cp[4]; cp[4] = cp[3]; cp[3] = t;
      }
      Fbuff[is] = AFp->ScaleF * (*B);
      ++is;
      ++B;
    }
    if (Nr < N)
      break;
  }

  return is;
}
