/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgZeros.c                                                    */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:46:02 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "Zeros"
#define ERROR(e) imgError(e,PRGNAME)

int main(int argc,char **argv)
{
  it_image *in1,*out1;
  int width,height,x,y;
  int v_x,v_y,x_end,y_end,bit;
  double aa,bb,cc,dd,ee;

  IFHELP
    {
      fprintf(stderr,"img%s - Zero-crossing detector\n",PRGNAME);
      fprintf(stderr,"img%s [noborder] \n",PRGNAME);
      fprintf(stderr,"  stdin: Float\n");
      fprintf(stderr,"  stdout: pbm\n");
      fprintf(stderr,"  If the argument is present there will be no border\n");
      exit(0);
    }

  imgStart(PRGNAME);

  do {
    in1=i_read_image_file(stdin,IT_FLOAT,IM_FRAGMENT);
    if(in1==NULL)
      ERROR("can't import image file");
    width=in1->width;
    height=in1->height;

    out1=i_create_image(width,height,IT_BIT,IM_FRAGMENT);
    if(out1==NULL)
      ERROR("out of memory");

    /* Look for places where there is a zero-crossing */
    v_y=in1->valid_y+1;
    v_x=in1->valid_x+1;
    y_end=v_y+in1->valid_height-2;
    x_end=v_x+in1->valid_width-2;
    for(y=v_y;y<y_end;y++)
      for(x=v_x;x<x_end;x++)
	{
	  bit=0;
	  aa=im_float_value(in1,x,y-1);
	  bb=im_float_value(in1,x-1,y);
	  cc=im_float_value(in1,x,y);
	  dd=im_float_value(in1,x+1,y);
	  ee=im_float_value(in1,x,y+1);
	  
	  /* Do a test to see if + centre, - elsewhere */
	  if(cc>0.0 && (aa<0.0 || bb<0.0 || dd<0.0 || ee<0.0))
	    bit=1;
	  if(cc==0.0)
	    {
	      /* Do a + shaped test for -0+ or +0- sequences */
	      if(aa>0.0 && ee<0.0 || aa<0.0 && ee>0.0 ||
		 bb>0.0 && dd<0.0 || bb<0.0 && dd>0.0)
		bit=1;
	      else
		{
		  /* Do a diagonal test */
		  aa=im_float_value(in1,x-1,y+1);
		  bb=im_float_value(in1,x+1,y+1);
		  dd=im_float_value(in1,x-1,y-1);
		  ee=im_float_value(in1,x+1,y-1);
		  if(aa>0.0 && ee<0.0 || aa<0.0 && ee>0.0 ||
		     bb>0.0 && dd<0.0 || bb<0.0 && dd>0.0)
		    bit=1;
		}
	    }
	  im_put_bit_value(out1,x,y,bit);
	}

    /* Not actually needed cos you can't send this info with a bit image */
    out1->valid_x=v_x;
    out1->valid_y=v_y;
    out1->valid_width=in1->valid_width-2;
    out1->valid_height=in1->valid_height-2;

    i_destroy_image(in1);
    
    if(argc==1)
      {
	/* Draw a box */
	v_x--;
	v_y--;
	for(x=v_x;x<=x_end;x++)
	  {
	    im_put_bit_value(out1,x,v_y,1);
	    im_put_bit_value(out1,x,y_end,1);
	  }
	for(y=v_y;y<=y_end;y++)
	  {
	    im_put_bit_value(out1,v_x,y,1);
	    im_put_bit_value(out1,x_end,y,1);
	  }
      }

    i_write_image_file(stdout,out1,IF_BINARY);
    i_destroy_image(out1);
  } while(!feof(stdin));

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
