/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgFlt3ToPpm.c                                                */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:41 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "Flt3ToPpm"
#define ERROR(e) imgError(e,PRGNAME)

int main(int argc,char **argv)
{
  it_image *in[3],*out1,*byt1;
  int width,height,x,y,set_min_max,i;
  it_rgb *rgb_ptr;
  it_byte *byt_ptr;
  double min,max;

  IFHELP
    {
      fprintf(stderr,"img%s - Convert 3 x Float to ppm\n",
	      PRGNAME);
      fprintf(stderr,"img%s [min max]\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: Float\n");
      fprintf(stderr,"  stdout: ppm\n");
      fprintf(stderr,"  min/max adjust scaling by overriding the input value range\n");
      exit(0);
    }

  imgStart(PRGNAME);
  if(argc==2 || argc>3)
    ERROR("invalid arguments");

  /* Make gcc happy */
  min=max=0.0;
  width=height=0;

  set_min_max=0;
  if(argc==3)
    {
      min=atof(argv[1]);
      max=atof(argv[2]);
      set_min_max=1;
    }

  do {
    /* Read images, check sizes and work-out min/max values */
    if(!set_min_max)
      imgInitMinMax(min,max);
    for(i=0;i<3;i++)
      {
	in[i]=i_read_image_file(stdin,IT_FLOAT,IM_FRAGMENT);
	if(in[i]==NULL)
	  ERROR("can't import image file");
	if(i==0)
	  {
	    /* First image so set size */
	    width=in[i]->width;
	    height=in[i]->height;
	  }
	else if(in[i]->width!=width || in[i]->height!=height)
	  ERROR("float images are of different sizes");
	if(!set_min_max)
	  {
	    /* Work out the largest range required */
	    if(in[i]->min_value<min)
	      min=in[i]->min_value;
	    if(in[i]->max_value>max)
	      max=in[i]->max_value;
	  }
      }
    /* Set min max values */
    for(i=0;i<3;i++)
      {
	in[i]->min_value=min;
	in[i]->max_value=max;
      }

    /* Create intermediate byte image */
    byt1=i_create_image(width,height,IT_BYTE,IM_FRAGMENT);
    if(byt1==NULL)
      ERROR("out of memory");

    /* Convert RED component to byte image */
    i_float_to_byte(in[0],byt1);
    i_destroy_image(in[0]);

    out1=i_create_image(width,height,IT_RGB,IM_FRAGMENT);
    if(out1==NULL)
      ERROR("out of memory");

    /* Copy Component into RGB array */
    for(y=0;y<height;y++)
      {
	byt_ptr=im_byte_row(byt1,y);
	rgb_ptr=im_rgb_row(out1,y);
	for(x=0;x<width;x++)
	  (rgb_ptr++)->r= *byt_ptr++;
      }

    /* Do the GREEN component */
    i_float_to_byte(in[1],byt1);
    i_destroy_image(in[1]);
    for(y=0;y<height;y++)
      {
	byt_ptr=im_byte_row(byt1,y);
	rgb_ptr=im_rgb_row(out1,y);
	for(x=0;x<width;x++)
	  (rgb_ptr++)->g= *byt_ptr++;
      }

    /* Do the BLUE component */
    i_float_to_byte(in[2],byt1);
    i_destroy_image(in[2]);
    for(y=0;y<height;y++)
      {
	byt_ptr=im_byte_row(byt1,y);
	rgb_ptr=im_rgb_row(out1,y);
	for(x=0;x<width;x++)
	  (rgb_ptr++)->b= *byt_ptr++;
      }

    i_destroy_image(byt1);
    i_write_image_file(stdout,out1,IF_BINARY);
    i_destroy_image(out1);
  } while(!feof(stdin));

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
