/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgFFTSmooth.c                                                */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:40 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "FFTSmooth"
#define ERROR(e) imgError(e,PRGNAME)

int main(int argc,char **argv)
{
  it_image *im;
  int width,height,x,y,halfwidth,halfheight;
  double const1,u,v,phwc,phhc,radsqd,sigma,val;
  it_complex *cpx_ptr;

  IFHELP
    {
      fprintf(stderr,"img%s - Fourier Gaussian smoothing filter\n",
	      PRGNAME);
      fprintf(stderr,"img%s [sigma]\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: Complex\n");
      fprintf(stderr,"  stdout: Complex\n");
      fprintf(stderr,"  sigma is the radius at e^(-0.5)\n");
      exit(0);
    }
  imgStart(PRGNAME);
  
  if(argc>2)
    ERROR("too many arguments");
  sigma=1.0;
  if(argc>1)
    sigma=atof(argv[1]);

  /* Loop for all images */
  do {
    im=i_read_image_file(stdin,IT_COMPLEX,IM_FRAGMENT);
    if(im==NULL)
      ERROR("can't import image file");
    width=im->width;
    height=im->height;
    halfwidth=width/2;
    halfheight=height/2;
    phwc=M_PI/((double) halfwidth);
    phhc=M_PI/((double) halfheight);
    const1= -sigma*sigma/2.0;
    for(y=0;y<height;y++)
      {
	cpx_ptr=im_complex_row(im,y);
	for(x=0;x<width;x++,cpx_ptr++)
	  {
	    u=phwc*(double) ((x<halfwidth)?(x):(x-width));
	    v=phhc*(double) ((y<halfheight)?(y):(y-height));
	    radsqd=u*u+v*v;
	    val=exp(radsqd*const1);
	    cpx_ptr->Re*=val;
	    cpx_ptr->Im*=val;
	  }
      }
    i_write_image_file(stdout,im,IF_BINARY);
    i_destroy_image(im);
  } while(!feof(stdin));

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
