#ifndef __X11_H_
#define __X11_H_

#ifdef __X11_C_
#define EXTERN
#else
#define EXTERN extern
#endif

/*** includes ***/

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>

#ifdef x11

#ifdef USE_MITSHM
#include <sys/ipc.h>
#include <sys/shm.h>
#include <X11/extensions/XShm.h>
#endif

#endif /* ifdef x11 */

/*** variables ***/ 

EXTERN Display 		*display;
EXTERN Window		window;
EXTERN char	 	xkey[128];
EXTERN Screen 		*screen;
EXTERN Colormap		colormap;
EXTERN Visual		*xvisual;
EXTERN int		depth;
EXTERN unsigned char	*scaled_buffer_ptr;
EXTERN unsigned long 	*xpixel;           /* Pixel index values */
EXTERN int		x_palette_dirty;
EXTERN int		mode_available[X11_MODE_COUNT];
EXTERN Cursor		normal_cursor;
EXTERN Cursor		invisible_cursor;

#if defined x11 && defined USE_MITSHM
EXTERN XShmSegmentInfo 	shm_info;
#endif

#if defined x11 && defined USE_DGA
EXTERN int		xf86_dga_fix_viewport;
EXTERN int		xf86_dga_first_click;
#endif

#ifdef X11_JOYSTICK
EXTERN int devicebuttonpress;
EXTERN int devicebuttonrelease;
EXTERN int devicemotionnotify;
EXTERN int devicebuttonmotion;
#endif

/*** prototypes ***/

/* device related */
void process_x11_joy_event(XEvent *event);

#ifdef x11

/* X-videomethod dependent functions: */
unsigned long x11_mkcolor(unsigned char r,unsigned char g,unsigned char b);

/* Normal x11_window functions */
int  x11_window_create_display(void);
void x11_window_close_display(void);
void x11_window_modify_pen(int pen, unsigned char red,unsigned char green,unsigned char blue);
void x11_window_update_display(void);
void x11_window_alloc_palette(void);
void x11_window_refresh_screen(void);

/* Xf86_dga functions */
int  xf86_dga_init(void);
int  xf86_dga_create_display(void);
void xf86_dga_close_display(void);
void xf86_dga_modify_pen(int pen, unsigned char red,unsigned char green,unsigned char blue);
void xf86_dga_update_display(void);
void xf86_dga_alloc_palette(void);

/* XIL functions */
#ifdef USE_XIL
void init_xil( void );
void setup_xil_images( int, int );
void refresh_xil_screen( void );
#endif

/* DBE functions */
#ifdef USE_DBE
void setup_dbe( void );
void swap_dbe_buffers( void );
#endif

#endif /* ifdef x11 */

#undef EXTERN
#endif /* ifndef __X11_H_ */
