// $Id: utl_list.cpp,v 1.4 1998/08/03 17:40:04 gonzo Exp $

/*

COPYRIGHT

Copyright 1992, 1993, 1994 Sun Microsystems, Inc.  Printed in the United
States of America.  All Rights Reserved.

This product is protected by copyright and distributed under the following
license restricting its use.

The Interface Definition Language Compiler Front End (CFE) is made
available for your use provided that you include this license and copyright
notice on all media and documentation and the software program in which
this product is incorporated in whole or part. You may copy and extend
functionality (but may not remove functionality) of the Interface
Definition Language CFE without charge, but you are not authorized to
license or distribute it to anyone else except as part of a product or
program developed by you or with the express written consent of Sun
Microsystems, Inc. ("Sun").

The names of Sun Microsystems, Inc. and any of its subsidiaries or
affiliates may not be used in advertising or publicity pertaining to
distribution of Interface Definition Language CFE as permitted herein.

This license is effective until terminated by Sun for failure to comply
with this license.  Upon termination, you shall destroy or return all code
and documentation for the Interface Definition Language CFE.

INTERFACE DEFINITION LANGUAGE CFE IS PROVIDED AS IS WITH NO WARRANTIES OF
ANY KIND INCLUDING THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS
FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR ARISING FROM A COURSE OF
DEALING, USAGE OR TRADE PRACTICE.

INTERFACE DEFINITION LANGUAGE CFE IS PROVIDED WITH NO SUPPORT AND WITHOUT
ANY OBLIGATION ON THE PART OF Sun OR ANY OF ITS SUBSIDIARIES OR AFFILIATES
TO ASSIST IN ITS USE, CORRECTION, MODIFICATION OR ENHANCEMENT.

SUN OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL HAVE NO LIABILITY WITH
RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY
INTERFACE DEFINITION LANGUAGE CFE OR ANY PART THEREOF.

IN NO EVENT WILL SUN OR ANY OF ITS SUBSIDIARIES OR AFFILIATES BE LIABLE FOR
ANY LOST REVENUE OR PROFITS OR OTHER SPECIAL, INDIRECT AND CONSEQUENTIAL
DAMAGES, EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

Use, duplication, or disclosure by the government is subject to
restrictions as set forth in subparagraph (c)(1)(ii) of the Rights in
Technical Data and Computer Software clause at DFARS 252.227-7013 and FAR
52.227-19.

Sun, Sun Microsystems and the Sun logo are trademarks or registered
trademarks of Sun Microsystems, Inc.

SunSoft, Inc.  
2550 Garcia Avenue 
Mountain View, California  94043

NOTE:

SunOS, SunSoft, Sun, Solaris, Sun Microsystems or the Sun logo are
trademarks or registered trademarks of Sun Microsystems, Inc.

 */

// utl_list.cc
//
// Implementation of generic single-linked lists

// NOTE: This list class only works correctly because we use single public
//       inheritance, as opposed to multiple inheritance or public virtual.
//	 It relies on a type-unsafe cast from UTL_List to subclasses, which
//	 will cease to operate correctly if you use either multiple or
//	 public virtual inheritance.
//
//	 For portability reasons we have decided to provide both this and
//	 an implementation of the list classes in terms of templates. If
//	 your compiler supports templates, please use the files in the
//	 include/utl_tmpl and util/utl_tmpl directories instead of the
//	 files by the same names in the include and util directories.

#include	"idl.h"
#include	"idl_extern.h"

ACE_RCSID(util, utl_list, "$Id: utl_list.cpp,v 1.4 1998/08/03 17:40:04 gonzo Exp $")

/*
 * Constructor(s)
 */

UTL_List::UTL_List(UTL_List *c)
	: pd_cdr_data(c) 
{
}

/*
 * Private operations
 */

// Compute list length
long
UTL_List::list_length(long n)
{
  if (pd_cdr_data == NULL)
    return n;
  else
    return pd_cdr_data->list_length(n+1);
}

/*
 * Public operations
 */

// Smash last cdr with l
void
UTL_List::nconc(UTL_List *l)
{
  if (pd_cdr_data == NULL)
    pd_cdr_data = l;
  else
    pd_cdr_data->nconc(l);
}

/*
 * Override this operation to copy lists of other types
 */
// Copy a list
UTL_List *
UTL_List::copy()
{
  if (pd_cdr_data == NULL)
    return new UTL_List(NULL);
  return new UTL_List(pd_cdr_data->copy());
}

// Get next list
UTL_List *
UTL_List::tail()
{
  return pd_cdr_data;
}

// Set next list
void
UTL_List::set_tail(UTL_List *l)
{
  pd_cdr_data = l;
}

// Compute list length
long
UTL_List::length()
{
  return list_length(1);
}

/*
 * Redefinition of inherited virtual operations
 */

// UTL_List active iterator

/*
 * Constructor
 */

UTL_ListActiveIterator::UTL_ListActiveIterator(UTL_List *s)
		      : source(s)
{
}

/*
 * Private operations
 */

/*
 * Public operations
 */

// Is iterator done?
long
UTL_ListActiveIterator::is_done()
{
  return (source == NULL) ? I_TRUE : I_FALSE;
}

// Advance to next item
void
UTL_ListActiveIterator::next()
{
  if (source != NULL)
    source = source->tail();
}

/*
 * Redefinition of inherited operations
 */

