/* file: "main.c" */

/* Copyright (C) 1994-1998 by Marc Feeley, All Rights Reserved. */

/* This is the driver of the Gambit-C system */

#define ___INCLUDED_FROM_MAIN
#define ___VERSION 21
#include "gambit.h"

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>


___HIDDEN void usage_err ___P((char **argv),(argv)
char **argv;)
{
  fprintf (stderr, "Usage: %s [-:OPT,OPT...] ...\n", argv[0]);
  fprintf (stderr, "  where OPT can be one of:\n");
  fprintf (stderr, "    kSTACK_CACHE_SIZE_IN_KILOBYTES\n");
  fprintf (stderr, "    mMIN_HEAP_SIZE_IN_KILOBYTES\n");
  fprintf (stderr, "    hMAX_HEAP_SIZE_IN_KILOBYTES\n");
  fprintf (stderr, "    lPERCENT_LIVE_AFTER_GC\n");
  fprintf (stderr, "    s\n");
  fprintf (stderr, "    d[level]\n");
  fprintf (stderr, "    t\n");
  fprintf (stderr, "    u\n");
  fprintf (stderr, "    c\n");
  fprintf (stderr, "    1\n");
  fprintf (stderr, "    8\n");
  exit (1);
}


___EXP_FUNC(int,___main)
  ___P((int argc,
        char **argv,
        ___mod_or_lnk (*linker)(___global_state_struct*)),
       (argc, argv, linker)
int argc;
char **argv;
___mod_or_lnk (*linker)();)
{
  unsigned long stack_cache_len, min_heap_len, max_heap_len;
  int live_percent;
  int default_io_encoding;
  int standard;
  int debug_level;
  int force_tty;
  int force_unbuffered_io;

  /* handle arguments to runtime */

  stack_cache_len = 0;
  min_heap_len = 0;
  max_heap_len = 0;
  live_percent = 0;
  default_io_encoding = ___DEFAULT_IO_ENCODING;
  standard = 0;
  debug_level = 0;
  force_tty = 0;
  force_unbuffered_io = 0;

  if (argc > 1)
    {
      char *s, *arg = argv[1];
      if (*arg++ == '-' && *arg++ == ':')
        {
          do
            {
              s = arg++;
              switch (*s)
                {
                case 'm':
                case 'h':
                case 'k':
                case 'l':
                case 'd':
                  {
                    char temp;
                    int argval;
                    while (*arg >= '0' && *arg <= '9') arg++;
                    temp = *arg;
                    *arg = '\0';
                    if (arg == s+1 && *s == 'd')
                      argval = 1;
                    else
                      argval = atoi (s+1);
                    *arg = temp;
                    switch (*s)
                      {
                      case 'k': stack_cache_len = (unsigned long)argval<<10;
                                break;
                      case 'm': min_heap_len = (unsigned long)argval<<10;
                                break;
                      case 'h': max_heap_len = (unsigned long)argval<<10;
                                break;
                      case 'l': live_percent = argval;
                                break;
                      case 'd': debug_level = argval;
                                break;
                      }
                    break;
                  }
                case 's':
                  standard = 1;
                  break;
                case 't':
                  force_tty = 1;
                  break;
                case 'u':
                  force_unbuffered_io = 1;
                  break;
                case 'c':
                  default_io_encoding = ___IO_CHAR_ENCODING;
                  break;
                case '1':
                  default_io_encoding = ___IO_LATIN1_ENCODING;
                  break;
                case '8':
                  default_io_encoding = ___IO_UTF8_ENCODING;
                  break;
                default:
                  usage_err (argv);
                }
            }
          while (*arg++ == ',');
          if (*--arg != '\0')
            usage_err (argv);
          argv[1] = argv[0];
          argc--;
          argv++;
        }
    }

#ifdef FORCE_MAX_HEAP
  if (max_heap_len == 0 || max_heap_len > FORCE_MAX_HEAP<<10)
    max_heap_len = FORCE_MAX_HEAP<<10;
#endif

  /* Setup program, run it and perform any cleanup necessary. */

  {
    ___setup_params_struct setup_params;

    setup_params.argc                = argc;
    setup_params.argv                = argv;
    setup_params.stack_cache         = stack_cache_len;
    setup_params.min_heap            = min_heap_len;
    setup_params.max_heap            = max_heap_len;
    setup_params.live_percent        = live_percent;
    setup_params.gc_hook             = 0;
    setup_params.fatal_error         = 0;
    setup_params.standard            = standard;
    setup_params.debug_level         = debug_level;
    setup_params.default_io_encoding = default_io_encoding;
    setup_params.force_tty           = force_tty;
    setup_params.force_unbuffered_io = force_unbuffered_io;
    setup_params.linker              = linker;

    ___setup (&setup_params);

    ___cleanup ();
  }

  /* Exit program. */

  exit (0);

  return 0; /* satisfy some compilers */
}
