(module prefix (main main2))

(define (run-benchmark name count run ok?)
  (if (not (ok? (run-bench name count run ok?)))
    (begin
      (display "*** wrong result ***")
      (newline))))

(define (run-bench name count run ok?)
  (let loop ((i 0) (result (list 'undefined)))
    (if (< i count)
      (loop (+ i 1) (run))
      result)))

(define (fatal-error . args)
  (for-each display args)
  (newline)
  (exit 1))

(define (main2 args)
  (main))

(define-macro (call-with-current-continuation . lst)
  `(call/cc ,@lst))

(define-macro (FLOATvector-const . lst)   `',(list->vector lst))
(define-macro (FLOATvector? x)            `(vector? ,x))
(define-macro (FLOATvector . lst)         `(vector ,@lst))
(define-macro (FLOATmake-vector n . init) `(make-vector ,n ,@init))
(define-macro (FLOATvector-ref v i)       `(vector-ref ,v ,i))
(define-macro (FLOATvector-set! v i x)    `(vector-set! ,v ,i ,x))
(define-macro (FLOATvector-length v)      `(vector-length ,v))

(define-macro (nuc-const . lst)
  `',(list->vector lst))

(define-macro (FLOAT+ . lst)
  (cond ((null? lst)       `0.0)
        ((null? (cdr lst)) (car lst))
        (else              `(+fl ,(car lst) (FLOAT+ ,@(cdr lst))))))

(define-macro (FLOAT- . lst)
  (cond ((null? lst)       (fatal-error "FLOAT- needs at least 1 argument"))
        ((null? (cdr lst)) `(negfl ,(car lst)))
        (else              `(-fl ,(car lst) (FLOAT+ ,@(cdr lst))))))

(define-macro (FLOAT* . lst)
  (cond ((null? lst)       `1.0)
        ((null? (cdr lst)) (car lst))
        (else              `(*fl ,(car lst) (FLOAT* ,@(cdr lst))))))

(define-macro (FLOAT/ . lst)
  (cond ((null? lst)       (fatal-error "FLOAT/ needs at least 1 argument"))
        ((null? (cdr lst)) `(/fl 1.0 ,(car lst)))
        (else              `(/fl ,(car lst) (FLOAT* ,@(cdr lst))))))

(define-macro (FLOAT= x y) `(=fl ,x ,y))
(define-macro (FLOAT< x y) `(<fl ,x ,y))
(define-macro (FLOAT<= x y) `(<=fl ,x ,y))
(define-macro (FLOAT> x y) `(>fl ,x ,y))
(define-macro (FLOAT>= x y) `(>=fl ,x ,y))

(define-macro (FLOATnegative? x) `(negative? ,x))
(define-macro (FLOATpositive? x) `(positive? ,x))
(define-macro (FLOATzero? x) `(zero? ,x))

(define-macro (FLOATabs x) `(absfl ,x))
(define-macro (FLOATsin x) `(sinfl ,x))
(define-macro (FLOATcos x) `(cosfl ,x))
(define-macro (FLOATatan x) `(atanfl ,x))
(define-macro (FLOATsqrt x) `(sqrtfl ,x))
(define-macro (FLOATmin x y) `(minfl ,x ,y))
(define-macro (FLOATmax x y) `(maxfl ,x ,y))
(define-macro (FLOATround x) `(roundfl ,x))
(define-macro (FLOATinexact->exact x) `(inexact->exact ,x))

(define-macro (bitwise-or x y) `(bit-or ,x ,y))
(define-macro (bitwise-and x y) `(bit-and ,x ,y))
(define-macro (bitwise-not x) `(bit-not ,x))

(define (ANGLE . args)
  (fatal-error "ANGLE is not implemented"))
(define (DENOMINATOR . args)
  (fatal-error "IMAG-PART is not implemented"))
(define (IMAG-PART . args)
  (fatal-error "IMAG-PART is not implemented"))
(define (MAGNITUDE . args)
  (fatal-error "MAGNITUDE is not implemented"))
(define (MAKE-POLAR . args)
  (fatal-error "MAKE-POLAR is not implemented"))
(define (MAKE-RECTANGULAR . args)
  (fatal-error "MAKE-RECTANGULAR is not implemented"))
(define (NUMERATOR . args)
  (fatal-error "NUMERATOR is not implemented"))
(define (RATIONALIZE . args)
  (fatal-error "RATIONALIZE is not implemented"))
(define (REAL-PART . args)
  (fatal-error "REAL-PART is not implemented"))
