package biss.awt;

import biss.Command;
import biss.CommandQueue;
import java.awt.Window;

/**
 * command class for controlling toplevel window stacking order (e.g. for
 * TopWindow overlays or popups). Command is executed (async) via the global
 * biss.CommandQueue. It reschedules itself several times to make sure that
 * the windowmanager does not override the stacking order
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
public class ToFrontCmd
  implements Command
{
	Window Target;
	int Count;

public ToFrontCmd ( Window target ) {
	Target = target;
	Count = 8;

	Target.toFront();
}

public ToFrontCmd ( Window target, int count ) {
	Target = target;
	Count = count;

	Target.toFront();
}

public boolean execute () {
	if ( Target.isShowing() ) {
		Target.toFront();

		// since we don't know about the focus behavior of the real Target class,
		// we have to rely on toFront() reimplementations to set a propper focus
		// (e.g. DialogWindow.toFront())

		if ( --Count > 0 ){
			CommandQueue.appendUnique( this);
			try { Thread.sleep( 80); }
			catch ( Exception x ) { x.printStackTrace(); }
		}
	}

	return true;
}
}
