package biss.awt;

import biss.PackageProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;

/**
 * package class for biss.awt package, initialized from property file biss.awt
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class Awt
{
	public static int BorderWidth;
	public static Color ButtonAlertBackClr;
	public static Color ButtonAlertForeClr;
	public static Color ButtonBackClr;
	public static Font ButtonFont;
	public static Color ButtonForeClr;
	public static int CursorWidth;
	public static Toolkit DefToolkit;
	public static Font FixedFont;
	public static Color FocusClr;
	public static Color InactiveClr;
	public static Color MenuBackClr;
	public static Font MenuFont;
	public static Color MenuForeClr;
	public static Color ScrollBarClr;
	public static int ScrollBarWidth;
	public static int SplitBarWidth;
	public static int ScreenWidth;
	public static int ScreenHeight;
	public static Color SelBackClr;
	public static Color SelForeClr;
	public static Color ShadowBrightClr;
	public static Color ShadowDarkClr;
	public static Color StaticBackClr;
	public static Font StaticFont;
	public static Color StaticForeClr;
	public static Font SysFont;
	public static int SysFontDesc;
	public static int SysFontHeight;
	public static int SysFontWidth;
	public static int TabWidth;
	public static PackageProperties Values = new PackageProperties( "biss.awt");
	public static Color WindowBackClr;
	public static int ScreenSize;
	public static int XResolution;
	public static int YResolution;
	public static int DlgXUnit;
	public static int DlgYUnit;
	public static int GlobalKeyMod;
	public static Color EntryBackClr;
	public static Color EntryForeClr;
	public static Font BookTabFont;
	public static Font BookSmallFont;
	public static Font ButtonImageFont;
	public static int SpinDelay;
	final public static int TK_MOTIF = 0;
	final public static int TK_WIN = 1;
	final public static int TK_OS2 = 2;
	final public static int TK_OTHER = 3;
	public static int AwtToolkit;
	public static String[] GifPaths;
	public static Color ListExpandClr;
	public static int FocusMarkWidth;
	public static int FilterPaints;
	public static Color ShadowMedBrightClr;
	public static Color ShadowMedDarkClr;
	public static Color CheckboxSetClr;
	public static Color CheckboxUnsetClr;
	public static int CheckboxWidth;
	public static boolean SoftScroll;
	public static boolean PlainBook;
	public static int RoundsPerMilli;
	public static int SoftScrollDelay;
	public static Color CursorClr;
	public static int ActionCursor;

static {
	DefToolkit = Toolkit.getDefaultToolkit();

	ScreenWidth  = DefToolkit.getScreenSize().width;
	ScreenHeight = DefToolkit.getScreenSize().height;

	SpinDelay = Values.getInt( "SpinDelay", 50);
	GifPaths = Values.getPaths( "GifPaths", ".");

	// toolkit section
	String tk = DefToolkit.getClass().getName();
	if ( tk.equals( "sun.awt.motif.MToolkit")){
		AwtToolkit   = TK_MOTIF;
		GlobalKeyMod = Values.getInt( "GlobalKeyMod", Event.META_MASK | Event.ALT_MASK);
	}
	else if ( tk.equals( "sun.awt.win32.MToolkit")){
		AwtToolkit   = TK_WIN;
		GlobalKeyMod = Values.getInt( "GlobalKeyMod", Event.SHIFT_MASK | Event.CTRL_MASK);
	}	
	else if ( tk.equals( "sun.awt.os2.MToolkit")) {
		AwtToolkit   = TK_OS2;
		GlobalKeyMod = Values.getInt( "GlobalKeyMod", Event.ALT_MASK);
	}
	else {
		AwtToolkit   = TK_OTHER;
		GlobalKeyMod = Values.getInt( "GlobalKeyMod", Event.META_MASK | Event.ALT_MASK);
	}

	//color section
	ButtonBackClr     = Values.getColor( "ButtonBackClr", Color.lightGray);
	ButtonForeClr     = Values.getColor( "ButtonForeClr", Color.darkGray);
	ButtonAlertBackClr= Values.getColor( "ButtonAlertBackClr", Color.red);
	ButtonAlertForeClr= Values.getColor( "ButtonAlertForeClr", Color.yellow);

	ShadowBrightClr   = Values.getColor( "ShadowBrightClr", Color.white);
	ShadowDarkClr	    = Values.getColor( "ShadowDarkClr", Color.darkGray);
	ShadowMedDarkClr  = Values.getColor( "ShadowMedDarkClr", Color.gray);
	ShadowMedBrightClr= Values.getColor( "ShadowMedBrightClr", Color.lightGray);	

	FocusClr	    = Values.getColor( "FocusClr", Color.red);

	EntryForeClr = Values.getColor( "EntryForeClr", Color.black);
	EntryBackClr = Values.getColor( "EntryBackClr", Color.white);

	SelForeClr = Values.getColor( "SelForeClr", Color.white);
	SelBackClr = Values.getColor( "SelBackClr", Color.black);

	InactiveClr 	= Values.getColor( "InactiveClr", Color.gray);
	WindowBackClr = Values.getColor( "WindowBackClr", Color.lightGray);

	MenuBackClr = Values.getColor( "MenuBackClr", Color.lightGray);
	MenuForeClr = Values.getColor( "MenuForeClr", Color.black);

	StaticBackClr = Values.getColor( "StaticBackClr", Color.lightGray);
	StaticForeClr = Values.getColor( "StaticForeClr", Color.darkGray);

	ScrollBarClr = Values.getColor( "ScrollBarClr", Color.gray);
	CheckboxSetClr = Values.getColor( "CheckBtnSetClr", Color.yellow);
	CheckboxUnsetClr = Values.getColor( "CheckBtnUnsetClr", Color.white);

	ListExpandClr = Values.getColor( "ListExpandClr", Color.cyan);

	initFonts();

	// computed values
	FontMetrics fm = DefToolkit.getFontMetrics( SysFont);
	SysFontHeight  = fm.getHeight();
	SysFontWidth   = fm.charWidth( 'n');
	SysFontDesc    = fm.getDescent();

	DlgXUnit = SysFontHeight;
	DlgYUnit = SysFontHeight;

	// dimension section
	BorderWidth		= Values.getInt( "BorderWidth", 2);
	ScrollBarWidth= Values.getInt( "ScrollBarWidth", 3*SysFontHeight/4+1);
	SplitBarWidth = Values.getInt( "SplitBarWidth", 3);

	int inch10;
	if ( ScreenWidth < 800 )       inch10 = 110;   // in 1/10 inches
	else if ( ScreenWidth < 1024 ) inch10 = 150;
	else if ( ScreenWidth < 1280 ) inch10 = 170;
	else                           inch10 = 210;

	ScreenSize  = Values.getInt( "ScreenSize", inch10);
	XResolution = (int)((double)ScreenWidth  *10 / ( 0.8 * ScreenSize));  // in dpi
	YResolution = (int)((double)ScreenHeight *10 / ( 0.6 * ScreenSize));  // in dpi

	// just in case we know it better
	XResolution = Values.getInt( "XResolution", XResolution);
	YResolution = Values.getInt( "YResolution", YResolution);	

	TabWidth			= Values.getInt( "TabWidth", 4);
	CursorWidth		= Values.getInt( "CursorWidth", 2);
	CursorClr		= Values.getColor( "CursorClr", Color.blue);

	FocusMarkWidth = Values.getInt( "FocusMarkWidth", SysFontHeight / 3);
	CheckboxWidth = Values.getInt( "CheckBtnWidth", (SysFontHeight -2) & 0xfe);

	FilterPaints = Values.getInt( "FilterPaints", 200);
	SoftScroll = Values.getBoolean( "SoftScroll", true);
	PlainBook = Values.getBoolean( "PlainBook", false);

	RoundsPerMilli = Values.getInt( "RoundsPerMilli", measureRoundsPerMillis());
	SoftScrollDelay = Values.getInt( "SoftScrollDelay", 20) * RoundsPerMilli;

	ActionCursor = Values.getInt( "ActionCursor", 
	  (AwtToolkit==TK_WIN || AwtToolkit==TK_OS2)? Frame.DEFAULT_CURSOR : Frame.HAND_CURSOR);
}

public static Point getDesktopLocation ( Component comp, int xRel, int yRel ){
	Point pt = new Point( xRel, yRel);

	for ( ; comp!= null; comp = comp.getParent() ) {
		Point loc = comp.location();
		pt.x += loc.x;
		pt.y += loc.y;

		if ( comp instanceof Container ) {
			if ( AwtToolkit == TK_MOTIF) {
				Insets ic = ((Container)comp).insets();
				pt.x -= ic.left;
				pt.y -= ic.top;
			}
		}

	}

	return pt;
}

public static FontMetrics getFontMetrics ( Font fnt ){
	return DefToolkit.getFontMetrics( fnt);
}

public static Image getImage (String filename) {
	File gf = new File( filename);
	if ( gf.exists() )    
		return DefToolkit.getImage( gf.getAbsolutePath() );

	for ( int i=0; i<GifPaths.length; i++){
		gf = new File( GifPaths[i] + File.separator + filename);
		if ( gf.exists() )
			return DefToolkit.getImage( gf.getAbsolutePath() );
	}
	return null;
}

static void initFonts () {
	String def = "Helvetica PLAIN 12";

	String sysFnt = def, fixedFnt = def, buttonFnt = def;
	String menuFnt = def, staticFnt = def;
	String bookTabFnt = def, bookSmallFnt = def, buttonImgFnt = def;

	switch ( AwtToolkit ) {
	case TK_MOTIF:
	case TK_OTHER:
		if ( ScreenWidth < 1024 ) {
			sysFnt       = "Helvetica" + ' ' + "BOLD" + ' ' + 12;
			fixedFnt     = "Symbol"    + ' ' + "BOLD" + ' ' + 12;
			buttonFnt    = "Helvetica" + ' ' + "BOLD" + ' ' + 11;
			menuFnt      = buttonFnt;
			staticFnt    = buttonFnt;
			bookTabFnt   = buttonFnt;
			bookSmallFnt = "Helvetica" + ' ' + "PLAIN" + ' ' + 11;
			buttonImgFnt = "Helvetica" + ' ' + "PLAIN" + ' ' + 10;
		}
		else {
			sysFnt       = "Helvetica" + ' ' + "BOLD" + ' ' + 14;
			fixedFnt     = "Courier"    + ' ' + "BOLD" + ' ' + 14;
			buttonFnt    = "Helvetica" + ' ' + "BOLD" + ' ' + 12;
			menuFnt      = buttonFnt;
			staticFnt    = buttonFnt;
			bookTabFnt   = buttonFnt;
			bookSmallFnt = "Helvetica" + ' ' + "PLAIN" + ' ' + 12;
			buttonImgFnt = "Helvetica" + ' ' + "PLAIN" + ' ' + 11;
		}
		break;

	case TK_WIN:
		if ( ScreenWidth < 1024 ) {
			sysFnt       = "Helvetica" + ' ' + "BOLD"  + ' ' + 12;
			fixedFnt     = "Courier"   + ' ' + "PLAIN" + ' ' + 12;
			buttonFnt    = "Helvetica" + ' ' + "PLAIN" + ' ' + 11;
			menuFnt      = buttonFnt;
			staticFnt    = buttonFnt;
			bookTabFnt   = buttonFnt;
			bookSmallFnt = "Helvetica" + ' ' + "PLAIN" + ' ' + 10;
			buttonImgFnt = "Helvetica" + ' ' + "PLAIN" + ' ' + 10;
		}
		else {
			sysFnt       = "Helvetica" + ' ' + "BOLD" + ' ' + 16;
			fixedFnt     = "Courier"   + ' ' + "BOLD" + ' ' + 14;
			buttonFnt    = "Helvetica" + ' ' + "BOLD" + ' ' + 14;
			menuFnt      = buttonFnt;
			staticFnt    = buttonFnt;
			bookTabFnt   = buttonFnt;
			bookSmallFnt = "Helvetica" + ' ' + "PLAIN" + ' ' + 12;
			buttonImgFnt = "Helvetica" + ' ' + "PLAIN" + ' ' + 11;
		}
		break;

	case TK_OS2:
		if ( ScreenWidth < 1024 ) {
			sysFnt       = "Dialog"  + ' ' + "BOLD"  + ' ' + 18;
			fixedFnt     = "Courier" + ' ' + "PLAIN" + ' ' + 18;
			buttonFnt    = "Dialog"  + ' ' + "PLAIN" + ' ' + 17;
			menuFnt      = buttonFnt;
			staticFnt    = buttonFnt;
			bookTabFnt   = buttonFnt;
			bookSmallFnt = "Dialog"  + ' ' + "PLAIN" + ' ' + 14;
			buttonImgFnt = bookSmallFnt;
		}
		else {
			sysFnt       = "Helvetica" + ' ' + "BOLD" + ' ' + 18;
			fixedFnt     = "Courier"   + ' ' + "BOLD" + ' ' + 18;
			buttonFnt    = "Helvetica" + ' ' + "BOLD" + ' ' + 11;
			menuFnt      = buttonFnt;
			staticFnt    = buttonFnt;
			bookTabFnt   = buttonFnt;
			bookSmallFnt = "Helvetica" + ' ' + "PLAIN" + ' ' + 11;
			buttonImgFnt = "Helvetica" + ' ' + "PLAIN" + ' ' + 11;
		}
		break;
	}	

	FixedFont       = Values.getFont( "FixedFont", fixedFnt);
	ButtonFont      = Values.getFont( "ButtonFont", buttonFnt);
	SysFont         = Values.getFont( "SysFont", sysFnt);
	MenuFont        = Values.getFont( "MenuFont", menuFnt);
	StaticFont      = Values.getFont( "StaticFont", staticFnt);
	BookTabFont     = Values.getFont( "BookTabFont", bookTabFnt);
	BookSmallFont   = Values.getFont( "BookSmallFont", bookSmallFnt);
	ButtonImageFont = Values.getFont( "ButtonImageFont", buttonImgFnt);
}

public static void insertGifPath ( String pathName) {
	String[] np = new String[ GifPaths.length + 1];
	np[0] = pathName;
	for ( int idx = 1; idx < np.length; idx++)
		np[idx] = GifPaths[idx - 1];
	GifPaths = np;
}

public static void insertGifPaths ( String[] pathNames) {
	int nl      = GifPaths.length + pathNames.length;
	int idx     = 0;
	String[] np = new String[ nl];

	for ( ; idx < pathNames.length; idx++)
		np[idx] = pathNames[idx];
	for ( ; idx < nl; idx++)
		np[idx] = GifPaths[idx - pathNames.length];

	GifPaths = np;
}

static int measureRoundsPerMillis () {
	int i, j, d, r = 0, m=50000;
	long t;

	for ( j=0; j<1; j++ ) {
		while ( true ) {
			t = System.currentTimeMillis();
			for ( i=0; i<m; i++ );
			d = (int) (System.currentTimeMillis() - t);
			if ( d > 0 ) {
				r = (r > 0) ? (r + (j-1)*(m/d)) / j : (m/d);
				break;
			}
			m *= 2;
		}
	}

	return r;	
}
}
